/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tdm.formplugin.datacompare;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tdm.common.util.LowTimer;
import kd.taxc.tdm.common.util.ObjectUtils;
import org.apache.commons.collections.CollectionUtils;

public class VoucherReportQueryPlugin
extends AbstractReportListDataPlugin {
    private static final Log logger = LogFactory.getLog(VoucherReportQueryPlugin.class);
    private static final String SELECT_FIELDS = "id,org.number orgnumber,org.name orgname,periodnumber,accountbookstype,accountnumber,accountname,debitbegin_src,creditbegin_src,debitbegin_dest,creditbegin_dest,state,source_count,tar_count";

    public DataSet query(ReportQueryParam reportQueryParam, Object o) throws Throwable {
        logger.info("\u3010\u6d89\u7a0e\u6570\u636e\u6bd4\u5bf9\u3011\u51ed\u8bc1\u6c47\u603b\u6bd4\u5bf9\u8be6\u60c5\u62a5\u8868\u67e5\u8be2\u5f00\u59cb");
        LowTimer lowTimer = new LowTimer();
        List<QFilter> qFilters = this.getFilters(reportQueryParam);
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)VoucherReportQueryPlugin.class.getName(), (String)"tdm_dc_vouchersum", (String)SELECT_FIELDS, (QFilter[])qFilters.toArray(new QFilter[qFilters.size()]), null);
        dataSet = dataSet.orderBy(new String[]{"orgnumber", "periodnumber", "accountbookstype", "accountnumber"});
        logger.info("\u3010\u6d89\u7a0e\u6570\u636e\u6bd4\u5bf9\u3011\u51ed\u8bc1\u6c47\u603b\u6bd4\u5bf9\u8be6\u60c5\u62a5\u8868\u67e5\u8be2\u8017\u8d39\u65f6\u95f4\uff1a" + lowTimer.msValue());
        return dataSet;
    }

    private List<QFilter> getFilters(ReportQueryParam reportQueryParam) {
        Long resultid;
        Map customParam;
        String states;
        Date endperiod;
        Date startperiod;
        String booktypes;
        List accounts;
        FilterInfo filterInfo = reportQueryParam.getFilter();
        List orgs = (List)filterInfo.getFilterItem("org").getValue();
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        if (CollectionUtils.isNotEmpty((Collection)orgs)) {
            List orgIds = orgs.stream().map(o -> o.getLong("id")).collect(Collectors.toList());
            qFilters.add(new QFilter("org", "in", orgIds));
        }
        if (CollectionUtils.isNotEmpty((Collection)(accounts = (List)filterInfo.getFilterItem("account").getValue()))) {
            List billNos = accounts.stream().map(o -> o.getString("number")).collect(Collectors.toList());
            qFilters.add(new QFilter("accountnumber", "in", billNos));
        }
        if (StringUtils.isNotBlank((CharSequence)(booktypes = (String)filterInfo.getFilterItem("booktype").getValue()))) {
            qFilters.add(new QFilter("accountbookstype", "in", (Object)booktypes.split(",")));
        }
        if ((startperiod = (Date)filterInfo.getFilterItem("startperiod").getValue()) != null) {
            qFilters.add(new QFilter("periodnumber", ">=", (Object)Integer.valueOf(DateUtils.format((Date)startperiod, (String)DateUtils.YYYYMM))));
        }
        if ((endperiod = (Date)filterInfo.getFilterItem("endperiod").getValue()) != null) {
            qFilters.add(new QFilter("periodnumber", "<=", (Object)Integer.valueOf(DateUtils.format((Date)endperiod, (String)DateUtils.YYYYMM))));
        }
        if (StringUtils.isNotBlank((CharSequence)(states = (String)filterInfo.getFilterItem("statelist").getValue()))) {
            qFilters.add(new QFilter("state", "in", (Object)states.split(",")));
        }
        if ((customParam = reportQueryParam.getCustomParam()) != null && ObjectUtils.isNotEmpty((Object)(resultid = ObjectUtils.toLong(customParam.get("resultid"))))) {
            qFilters.add(new QFilter("resultid", "=", (Object)resultid));
        }
        return qFilters;
    }
}

