/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tdm.formplugin.dataintegration.ierp.action;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.taxc.tdm.common.util.EmptyCheckUtils;
import kd.taxc.tdm.formplugin.dataintegration.ierp.entity.DataSyncTypeEnum;
import kd.taxc.tdm.formplugin.dataintegration.ierp.entity.InputQueryFilterModel;
import kd.taxc.tdm.formplugin.dataintegration.ierp.handler.AbstractExecuteSyncHandler;
import kd.taxc.tdm.formplugin.dataintegration.ierp.handler.BatchExecuteSyncHandler;
import kd.taxc.tdm.formplugin.dataintegration.ierp.handler.DefaultExecuteSyncHandler;
import kd.taxc.tdm.formplugin.dataintegration.ierp.handler.StreamingScriptExecuteSyncHandler;
import kd.taxc.tdm.formplugin.dataintegration.ierp.util.DataSyncUtils;

public abstract class AbstractBuildFilterAction {
    private static Log logger = LogFactory.getLog(AbstractBuildFilterAction.class);

    public InputQueryFilterModel buildFilterByInputParams(DynamicObjectCollection orgs, Date period, Long selectedDepreuse, List<Long> depreuse) {
        List<Long> orgList = this.prepareOrgList(orgs);
        List<Long> peridBase = this.preparePeriodList(period);
        Map<String, Long> collect = this.prepareAssetBookMapping(orgList, selectedDepreuse);
        ArrayList<Long> assetBook = new ArrayList<Long>(collect.values());
        return this.buildInputQueryFilterBatch(orgList, period, depreuse, assetBook, collect);
    }

    private List<Long> prepareOrgList(DynamicObjectCollection orgs) {
        return DataSyncUtils.prepareOrgList(orgs);
    }

    private List<Long> preparePeriodList(Date period) {
        return DataSyncUtils.preparePeriodList(period);
    }

    private Map<String, Long> prepareAssetBookMapping(List<Long> orgList, Long selectedDepreuse) {
        return DataSyncUtils.prepareAssetBookMapping(orgList, selectedDepreuse);
    }

    private InputQueryFilterModel buildInputQueryFilterBatch(List<Long> org, Date period, List<Long> depreuse, List<Long> assetBook, Map<String, Long> assetBookMapping) {
        InputQueryFilterModel filterModel = new InputQueryFilterModel();
        filterModel.setOrg(org);
        filterModel.setPeriod(period);
        filterModel.setAssetbook(assetBook);
        filterModel.setDepreuse(depreuse);
        filterModel.setAssetBookMapping(assetBookMapping);
        return filterModel;
    }

    private InputQueryFilterModel buildInputQueryFilter(List<Long> org, Date period, List<Long> depreuse, List<Long> assetBook) {
        InputQueryFilterModel filterModel = new InputQueryFilterModel();
        filterModel.setOrg(org);
        filterModel.setPeriod(period);
        filterModel.setAssetbook(assetBook);
        filterModel.setDepreuse(depreuse);
        return filterModel;
    }

    private List<Long> getAssetBooksByMapping(Map<String, Long> collect, List<Long> org, Long depreuse) {
        ArrayList<Long> assetBooks = new ArrayList<Long>();
        if (EmptyCheckUtils.isNotEmpty(org)) {
            org.stream().filter(k -> EmptyCheckUtils.isNotEmpty(collect.get(k + String.valueOf(depreuse)))).forEach(v -> assetBooks.add((Long)collect.get(v + String.valueOf(depreuse))));
        }
        return assetBooks;
    }

    public void asyncExecuteServiceFlow(InputQueryFilterModel value, DataSyncTypeEnum dataSyncTypeEnum, Long selectedDepreuse, List<Long> dynamicParams) {
        if (value.getOrg().size() > dataSyncTypeEnum.getBatchSize()) {
            logger.info("partition org execute begin:");
            List partition = Lists.partition(value.getOrg(), (int)dataSyncTypeEnum.getBatchSize());
            partition.forEach(org -> {
                List<Long> assetBooks = this.getAssetBooksByMapping(value.getAssetBookMapping(), (List<Long>)org, selectedDepreuse);
                InputQueryFilterModel queryFilter = this.buildInputQueryFilter((List<Long>)org, value.getPeriod(), value.getDepreuse(), assetBooks);
                this.doBizAction(dataSyncTypeEnum, queryFilter, dynamicParams);
            });
        } else {
            logger.info("all org execute begin:");
            this.doBizAction(dataSyncTypeEnum, value, dynamicParams);
        }
    }

    private void doBizAction(DataSyncTypeEnum dataSyncTypeEnum, InputQueryFilterModel queryFilter, List<Long> dynamicParams) {
        this.setCustomParams(queryFilter, dynamicParams);
        queryFilter.setType(DataSyncTypeEnum.getExecuteType(dataSyncTypeEnum.getType()));
        this.executeServiceFlow(dataSyncTypeEnum, queryFilter);
    }

    private void executeServiceFlow(DataSyncTypeEnum dataSyncTypeEnum, InputQueryFilterModel queryFilter) {
        AbstractExecuteSyncHandler handler = this.determineHandlerByEnum(dataSyncTypeEnum);
        logger.info("determineHandlerByEnum:" + handler.getClass().getName());
        String serviceFlowNumber = handler.getServiceFlowNumber();
        logger.info("getServiceFlowNumber:" + serviceFlowNumber);
        List<Object> paramsList = handler.buildParamsList(queryFilter, dataSyncTypeEnum);
        logger.info("executeServiceFlow input params:" + SerializationUtils.toJsonString(paramsList));
        handler.execute(serviceFlowNumber, paramsList);
    }

    private AbstractExecuteSyncHandler determineHandlerByEnum(DataSyncTypeEnum dataSyncTypeEnum) {
        AbstractExecuteSyncHandler handler = new DefaultExecuteSyncHandler();
        if (dataSyncTypeEnum.getBatchConcurrentExecuteByScript()) {
            handler = new StreamingScriptExecuteSyncHandler();
        } else if (dataSyncTypeEnum.getBatchExecute()) {
            handler = new BatchExecuteSyncHandler();
        }
        return handler;
    }

    protected abstract void setCustomParams(InputQueryFilterModel var1, List<Long> var2);
}

