/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tdm.formplugin.dataintegration.ierp.plugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Button;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.taxc.tdm.common.util.EmptyCheckUtils;
import kd.taxc.tdm.formplugin.dataintegration.ierp.cache.DistributeCacheHelper;
import kd.taxc.tdm.formplugin.dataintegration.ierp.entity.DataSyncTypeEnum;
import kd.taxc.tdm.formplugin.dataintegration.ierp.servicehelper.ServiceFlowServiceHelper;
import kd.taxc.tdm.formplugin.dataintegration.ierp.util.DataSyncUtils;

public class FaAssetDataSyncPlugin
extends AbstractFormPlugin {
    private static Log logger = LogFactory.getLog(FaAssetDataSyncPlugin.class);
    private static final String BTNOK = "btnok";
    private static final String ORG = "org";
    private static final String PERIOD = "period";
    private static final String DEPREUSE = "depreuse";
    private static final String ACCONTDEPREUSE = "accontdepreuse";
    private static final String DEPREUSEVALUE = "depreusevalue";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{BTNOK});
    }

    public void afterCreateNewData(EventObject e) {
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        String formId = (String)showParameter.getCustomParam("srcform");
        String srcSystem = (String)showParameter.getCustomParam("asset_datasrc");
        this.getPageCache().put("asset_datasrc", srcSystem);
        if ("eas".equals(srcSystem)) {
            DataSyncUtils.prepareDepreuseComboItemsForEas(this.getModel(), (ComboEdit)this.getControl(DEPREUSE), formId);
            this.getView().setEnable(Boolean.FALSE, new String[]{DEPREUSE});
            return;
        }
        ArrayList<Long> depreuseList = new ArrayList<Long>();
        ArrayList<Long> accountDepreuseList = new ArrayList<Long>();
        DataSyncUtils.prepareDepreuseComboItems(this.getModel(), (ComboEdit)this.getControl(DEPREUSE), depreuseList, accountDepreuseList, formId);
        this.getModel().setValue(ACCONTDEPREUSE, (Object)SerializationUtils.toJsonString(accountDepreuseList));
        this.getModel().setValue(DEPREUSEVALUE, (Object)SerializationUtils.toJsonString(depreuseList));
        if (StringUtils.equals((CharSequence)"tdm_asset_data", (CharSequence)formId)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{DEPREUSE});
            return;
        }
    }

    public void click(EventObject evt) {
        Object source = evt.getSource();
        if (source instanceof Button && BTNOK.equals(((Button)source).getKey())) {
            String formId = (String)this.getView().getFormShowParameter().getCustomParam("srcform");
            DynamicObjectCollection orgs = (DynamicObjectCollection)this.getModel().getValue(ORG);
            Date period = (Date)this.getModel().getValue(PERIOD);
            String depreuse = (String)this.getModel().getValue(DEPREUSE);
            String srcSystem = this.getPageCache().get("asset_datasrc");
            if ("eas".equals(srcSystem)) {
                ServiceFlowServiceHelper.startServiceFlow(formId, orgs, period, this.getView());
                return;
            }
            if (EmptyCheckUtils.isNotEmpty((Object)depreuse)) {
                DistributeCacheHelper.getDistributeSessionlessCache().put(DataSyncUtils.getCacheKey(formId), (Object)depreuse);
            }
            Map<Long, List<Long>> selectedDepreuseAndDynammicParams = DataSyncUtils.prepareSelectedDepreuseAndDynammicParams(depreuse, this.getModel().getValue(ACCONTDEPREUSE));
            List dynamicParams = selectedDepreuseAndDynammicParams.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
            Long selectedDepreuse = new ArrayList<Long>(selectedDepreuseAndDynammicParams.keySet()).get(0);
            List depreuseList = SerializationUtils.fromJsonStringToList((String)((String)this.getModel().getValue(DEPREUSEVALUE)), Long.class);
            if (EmptyCheckUtils.isEmpty((Object)formId)) {
                Arrays.stream(DataSyncTypeEnum.values()).sorted(Comparator.comparing(DataSyncTypeEnum::getExecuteOrder)).filter(e -> DataSyncUtils.isMatchExecuteConditions(e, depreuseList)).forEach(v -> ServiceFlowServiceHelper.startServiceFlow(orgs, period, dynamicParams, selectedDepreuse, depreuseList, v, this.getView(), true));
            } else {
                Arrays.stream(DataSyncTypeEnum.values()).filter(v -> StringUtils.equals((CharSequence)v.getFormId(), (CharSequence)formId)).findFirst().ifPresent(v -> ServiceFlowServiceHelper.startServiceFlow(orgs, period, dynamicParams, selectedDepreuse, depreuseList, v, this.getView(), false));
            }
        }
    }
}

