/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tdm.formplugin.dataintegration.ierp.servicehelper;

import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.ImportLogger;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.tdm.formplugin.utils.TaxTimePointUtils;

public class FcsImportService {
    public static final String TAX_TIME_POINT = "taxtimepoint";
    public static final String TAX_PAY_LIMIT = "taxpaylimit";

    public static void checkDataByTaxPayLimit(Map<String, Object> data, List<ImportLogger.ImportLog> importlogs, String taxpaylimit) {
        String fieldMatchCommonMsg = ResManager.loadKDString((String)"%1$s\u5339\u914d\u4e0d\u5230\u4e0b\u62c9\u9009\u9879\uff1a%2$s\u3002", (String)"FcsImportService_1", (String)"taxc-tdm-formplugin", (Object[])new Object[0]);
        if (!TaxTimePointUtils.TAX_PAY_LIMIT_LIST.contains(taxpaylimit)) {
            String fieldName = ResManager.loadKDString((String)"\u7eb3\u7a0e\u671f\u9650", (String)"FcsImportService_2", (String)"taxc-tdm-formplugin", (Object[])new Object[0]);
            importlogs.add(new ImportLogger.ImportLog(String.format(fieldMatchCommonMsg, fieldName, taxpaylimit)));
        } else {
            String taxTimePoint = (String)data.get(TAX_TIME_POINT);
            List<String> taxTimePointList = TaxTimePointUtils.getTaxTimePointsByPayLimit(taxpaylimit);
            if (!taxTimePointList.contains(taxTimePoint)) {
                String timeTypeName = TaxTimePointUtils.getTimeTypeNameByType(taxpaylimit);
                String fieldNameCh = TaxTimePointUtils.getTaxTimePointNameByValue(taxTimePoint);
                importlogs.add(new ImportLogger.ImportLog(String.format(ResManager.loadKDString((String)"\u5f53\u7eb3\u7a0e\u671f\u9650=\u6309%1$s\u7533\u62a5\u65f6\uff0c\u7eb3\u7a0e\u65f6\u70b9\u5e94\u5f53\u9009\u62e9%1$s\u5ea6\u7ec8\u4e86\u524d\u6216\u8005%1$s\u5ea6\u7ec8\u4e86\u540e\uff0c\u8bf7\u4fee\u6539\u3010%2$s\u3011\u540e\u91cd\u65b0\u5f15\u5165\u3002", (String)"FcsSourceInfoImportPlugin_10", (String)"taxc-tdm-formplugin", (Object[])new Object[0]), timeTypeName, fieldNameCh)));
            } else {
                String firstquartermonth = (String)data.get("firstquartermonth");
                String secondquartermonth = (String)data.get("secondquartermonth");
                String thirdquartermonth = (String)data.get("thirdquartermonth");
                String fourthquartermonth = (String)data.get("fourthquartermonth");
                String fieldNameCh = TaxTimePointUtils.getTimeTypeNameByType("month");
                if ("season".equals(taxpaylimit) && "seasonbefore".equals(taxTimePoint)) {
                    String fieldName;
                    if (!TaxTimePointUtils.FIRSTQUARTER_MONTH_LIST.contains(firstquartermonth)) {
                        fieldName = ResManager.loadKDString((String)"\u4e00\u5b63\u5ea6\u7533\u62a5\u6708\u4efd", (String)"FcsImportService_3", (String)"taxc-tdm-formplugin", (Object[])new Object[0]);
                        importlogs.add(new ImportLogger.ImportLog(String.format(fieldMatchCommonMsg, fieldName, StringUtil.isBlank((CharSequence)firstquartermonth) ? "" : firstquartermonth + fieldNameCh)));
                    }
                    if (!TaxTimePointUtils.SECONDQUARTER_MONTH_LIST.contains(secondquartermonth)) {
                        fieldName = ResManager.loadKDString((String)"\u4e8c\u5b63\u5ea6\u7533\u62a5\u6708\u4efd", (String)"FcsImportService_4", (String)"taxc-tdm-formplugin", (Object[])new Object[0]);
                        importlogs.add(new ImportLogger.ImportLog(String.format(fieldMatchCommonMsg, fieldName, StringUtil.isBlank((CharSequence)secondquartermonth) ? "" : secondquartermonth + fieldNameCh)));
                    }
                    if (!TaxTimePointUtils.THIRDQUARTER_MONTH_LIST.contains(thirdquartermonth)) {
                        fieldName = ResManager.loadKDString((String)"\u4e09\u5b63\u5ea6\u7533\u62a5\u6708\u4efd", (String)"FcsImportService_5", (String)"taxc-tdm-formplugin", (Object[])new Object[0]);
                        importlogs.add(new ImportLogger.ImportLog(String.format(fieldMatchCommonMsg, fieldName, StringUtil.isBlank((CharSequence)thirdquartermonth) ? "" : thirdquartermonth + fieldNameCh)));
                    }
                    if (!TaxTimePointUtils.FOURTHQUARTER_MONTH_LIST.contains(fourthquartermonth)) {
                        fieldName = ResManager.loadKDString((String)"\u56db\u5b63\u5ea6\u7533\u62a5\u6708\u4efd", (String)"FcsImportService_6", (String)"taxc-tdm-formplugin", (Object[])new Object[0]);
                        importlogs.add(new ImportLogger.ImportLog(String.format(fieldMatchCommonMsg, fieldName, StringUtil.isBlank((CharSequence)fourthquartermonth) ? "" : fourthquartermonth + fieldNameCh)));
                    }
                } else {
                    data.put("firstquartermonth", "");
                    data.put("secondquartermonth", "");
                    data.put("thirdquartermonth", "");
                    data.put("fourthquartermonth", "");
                }
                String endmonth = (String)data.get("endmonth");
                if ("year".equals(taxpaylimit) && "yearbefore".equals(taxTimePoint)) {
                    if (!TaxTimePointUtils.YEAR_MONTH_LIST.contains(endmonth)) {
                        String endmonthFieldNameCh = ResManager.loadKDString((String)"\u4e2a\u6708", (String)"FcsImportService_0", (String)"taxc-tdm-formplugin", (Object[])new Object[0]);
                        String fieldName = ResManager.loadKDString((String)"\u7ec8\u4e86\u524d\u6708\u4efd\u6570", (String)"FcsImportService_7", (String)"taxc-tdm-formplugin", (Object[])new Object[0]);
                        importlogs.add(new ImportLogger.ImportLog(String.format(fieldMatchCommonMsg, fieldName, StringUtil.isBlank((CharSequence)endmonth) ? "" : endmonth + endmonthFieldNameCh)));
                    }
                } else {
                    data.put("endmonth", "");
                }
                String firsthalfmonth = (String)data.get("firsthalfmonth");
                String secondhalfmonth = (String)data.get("secondhalfmonth");
                if ("halfyear".equals(taxpaylimit) && "halfyearbefore".equals(taxTimePoint)) {
                    String fieldName;
                    if (!TaxTimePointUtils.FIRST_HALFYEAR_MONTH_LIST.contains(firsthalfmonth)) {
                        fieldName = ResManager.loadKDString((String)"\u4e0a\u534a\u5e74\u7533\u62a5\u6708\u4efd\u6570", (String)"FcsImportService_8", (String)"taxc-tdm-formplugin", (Object[])new Object[0]);
                        importlogs.add(new ImportLogger.ImportLog(String.format(fieldMatchCommonMsg, fieldName, StringUtil.isBlank((CharSequence)firsthalfmonth) ? "" : firsthalfmonth + fieldNameCh)));
                    }
                    if (!TaxTimePointUtils.SECOND_HALFYEAR_MONTH_LIST.contains(secondhalfmonth)) {
                        fieldName = ResManager.loadKDString((String)"\u4e0b\u534a\u5e74\u7533\u62a5\u6708\u4efd\u6570", (String)"FcsImportService_9", (String)"taxc-tdm-formplugin", (Object[])new Object[0]);
                        importlogs.add(new ImportLogger.ImportLog(String.format(fieldMatchCommonMsg, fieldName, StringUtil.isBlank((CharSequence)secondhalfmonth) ? "" : secondhalfmonth + fieldNameCh)));
                    }
                } else {
                    data.put("firsthalfmonth", "");
                    data.put("secondhalfmonth", "");
                }
            }
        }
    }
}

