/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tdm.formplugin.dataintegration.ierp.servicehelper;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.taxc.tdm.common.helper.InvokeBizServiceHelper;
import kd.taxc.tdm.common.util.EmptyCheckUtils;
import kd.taxc.tdm.formplugin.dataintegration.ierp.action.AbstractBuildFilterAction;
import kd.taxc.tdm.formplugin.dataintegration.ierp.cache.DistributeCacheHelper;
import kd.taxc.tdm.formplugin.dataintegration.ierp.entity.DataSyncTypeEnum;
import kd.taxc.tdm.formplugin.dataintegration.ierp.entity.DataSyncTypeForEasEnum;
import kd.taxc.tdm.formplugin.dataintegration.ierp.entity.InputQueryFilterModel;
import kd.taxc.tdm.formplugin.dataintegration.ierp.plugin.FaAssetDataSyncPlugin;
import kd.taxc.tdm.formplugin.dataintegration.ierp.util.DataSyncUtils;

public class ServiceFlowServiceHelper {
    private static Log logger = LogFactory.getLog(FaAssetDataSyncPlugin.class);

    private static void startServiceFlow(DynamicObjectCollection orgs, Date period, List<Long> dynamicParams, Long selectedDepreuse, List<Long> depreuseList, DataSyncTypeEnum dataSyncTypeEnum, IFormView view) {
        AbstractBuildFilterAction buildFilterAction = (AbstractBuildFilterAction)TypesContainer.createInstance((String)DataSyncTypeEnum.getInstanceNameByType(dataSyncTypeEnum.getType()));
        InputQueryFilterModel queryFilterModel = buildFilterAction.buildFilterByInputParams(orgs, period, selectedDepreuse, depreuseList);
        Optional.ofNullable(queryFilterModel).filter(filterModel -> DataSyncUtils.checkQueryFilterMeetExecuteConditions(filterModel, view, true)).ifPresent(value -> {
            try {
                buildFilterAction.asyncExecuteServiceFlow((InputQueryFilterModel)value, dataSyncTypeEnum, selectedDepreuse, dynamicParams);
                view.showSuccessNotification(ResManager.loadKDString((String)"\u5df2\u89e6\u53d1\u540e\u53f0\u6570\u636e\u540c\u6b65\u3002", (String)"ServiceFlowServiceHelper_0", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
            }
            catch (Exception e) {
                logger.error("execute error:" + e);
                view.showErrorNotification("execute error:" + e.getMessage());
            }
        });
    }

    public static void startServiceFlow(DynamicObjectCollection orgs, Date period, List<Long> dynamicParams, Long selectedDepreuse, List<Long> depreuseList, DataSyncTypeEnum dataSyncTypeEnum, IFormView view, boolean executeAll) {
        Long tempValue;
        String value;
        if (executeAll && EmptyCheckUtils.isNotEmpty((Object)(value = (String)DistributeCacheHelper.getDistributeSessionlessCache().get(DataSyncUtils.getCacheKey(dataSyncTypeEnum.getFormId())))) && depreuseList.contains(tempValue = Long.valueOf(Long.parseLong(value)))) {
            dynamicParams = Collections.singletonList(tempValue);
            selectedDepreuse = tempValue;
        }
        ServiceFlowServiceHelper.startServiceFlow(orgs, period, dynamicParams, selectedDepreuse, depreuseList, dataSyncTypeEnum, view);
    }

    public static void startServiceFlow(String formId, DynamicObjectCollection orgs, Date period, IFormView view) {
        Map<String, Object> paramMap = DataSyncUtils.packageParams(formId, orgs, period);
        String flowNumber = DataSyncTypeForEasEnum.getServiceFlowNumber(formId);
        if (StringUtils.isEmpty((CharSequence)flowNumber)) {
            logger.info("startServiceFlow fail: serviceFlowNumber is empty.");
        }
        String methodName = DataSyncTypeForEasEnum.getMethodName(formId);
        try {
            Map resultmap;
            String resultmsg;
            ArrayList<Map<String, Object>> params = new ArrayList<Map<String, Object>>();
            params.add(paramMap);
            Object resultobj = InvokeBizServiceHelper.invokeIscService((String)methodName, (String)flowNumber, params);
            if (resultobj != null && StringUtils.isNotBlank((CharSequence)(resultmsg = (String)((Map)(resultmap = (Map)JSONObject.parseObject((String)JSONObject.toJSONString((Object)resultobj), HashMap.class)).get("output")).get("resultmsg"))) && !"success".equals(resultmsg)) {
                view.showTipNotification(resultmsg);
                return;
            }
            view.showSuccessNotification(ResManager.loadKDString((String)"\u5df2\u89e6\u53d1\u540e\u53f0\u6570\u636e\u540c\u6b65\u3002", (String)"ServiceFlowServiceHelper_0", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
        }
        catch (Exception ex) {
            logger.error("startServiceFlow error:", (Throwable)ex);
            view.showErrorNotification(String.format(ResManager.loadKDString((String)"\u540c\u6b65\u5931\u8d25\uff1a%s\u3002", (String)"ServiceFlowServiceHelper_1", (String)"taxc-tdm-formplugin", (Object[])new Object[0]), ex.getMessage()));
        }
    }
}

