/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tdm.formplugin.dataintegration.ierp.util;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class ConverterUtils
extends StringUtils {
    private static Log logger = LogFactory.getLog(ConverterUtils.class);
    private static Pattern humpPattern = Pattern.compile("[A-Z]");

    public static String humpToLine2(String str) {
        Matcher matcher = humpPattern.matcher(str);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(sb, "_" + matcher.group(0).toLowerCase());
        }
        matcher.appendTail(sb);
        sb.deleteCharAt(0);
        return sb.toString();
    }

    public static Map<String, Object> bean2map(Object bean) {
        try {
            PropertyDescriptor[] pds;
            TreeMap<String, Object> map = new TreeMap<String, Object>(Comparator.naturalOrder());
            BeanInfo b = Introspector.getBeanInfo(bean.getClass(), Object.class);
            for (PropertyDescriptor pd : pds = b.getPropertyDescriptors()) {
                String propertyName = pd.getName().substring(0, 1).toUpperCase() + pd.getName().substring(1);
                Method m = pd.getReadMethod();
                Object properValue = m.invoke(bean, new Object[0]);
                if (properValue == null) continue;
                propertyName = ConverterUtils.humpToLine2(propertyName);
                map.put(propertyName, properValue);
            }
            return map;
        }
        catch (Exception e) {
            logger.error("params convert fail" + e.getMessage());
            return null;
        }
    }
}

