/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tdm.formplugin.dataintegration.ierp.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.Tips;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.tdm.common.util.DateUtils;
import kd.taxc.tdm.common.util.EmptyCheckUtils;
import kd.taxc.tdm.common.util.StringUtil;
import kd.taxc.tdm.formplugin.dataintegration.ierp.cache.DistributeCacheHelper;
import kd.taxc.tdm.formplugin.dataintegration.ierp.entity.DataSyncTypeEnum;
import kd.taxc.tdm.formplugin.dataintegration.ierp.entity.FrontEndTypeEnum;
import kd.taxc.tdm.formplugin.dataintegration.ierp.entity.FrontEndTypeForEasEnum;
import kd.taxc.tdm.formplugin.dataintegration.ierp.entity.InputQueryFilterModel;
import kd.taxc.tdm.formplugin.dataintegration.ierp.util.ConverterUtils;

public class DataSyncUtils {
    private static Log logger = LogFactory.getLog(DataSyncUtils.class);
    private static final String FBASEDATAID = "fbasedataid";
    private static final String ID = "id";
    private static final String ORG = "org";
    private static final String NUMBER = "number";
    private static final String DEPREUSE = "depreuse";
    private static final String NAME = "name";
    private static final String BILLSTATUS = "billstatus";
    private static final String ISMAINBOOK = "ismainbook";
    private static final String BEGINDATE = "begindate";
    private static final String ENDDATE = "enddate";
    private static final String PERIODTYPE_NUMBER = "periodtype.number";
    private static final String DATE_FORMAT = "yyyyMM";
    private static final String BILL_STATUS_AUDITED = "C";
    private static final String MAINBOOK_VALUE = "1";
    private static final String FA_DEPREUSE_SELECT_FIELDS = "id,number,name";
    private static final String FA_CARD_FIN_SELECT_FIELDS = "org";
    private static final String BD_PERIOD_SELECT_FIELDS = "id,number";
    private static final String FA_ASSETBOOK_SELECT_FIELDS = "id,org,depreuse";
    private static final String ASSETBOOK = "assetbook";
    private static final String PERIOD = "bizperiod";
    private static final Integer DURATION = 5000;

    public static void prepareDepreuseComboItems(IDataModel model, ComboEdit comboEdit, List<Long> depreuseList, List<Long> accountDepreuseList, String formId) {
        DynamicObjectCollection depreuseObjects = QueryServiceHelper.query((String)"fa_depreuse", (String)FA_DEPREUSE_SELECT_FIELDS, null);
        if (EmptyCheckUtils.isNotEmpty((Object)depreuseObjects)) {
            List comboItems = depreuseObjects.stream().map(v -> {
                ComboItem item = new ComboItem();
                item.setId(String.valueOf(v.getString(ID)));
                depreuseList.add(Long.parseLong(item.getId()));
                item.setCaption(new LocaleString(v.getString(NAME)));
                item.setValue(String.valueOf(v.getString(ID)));
                if ("01".equals(v.getString(NUMBER))) {
                    accountDepreuseList.add(Long.parseLong(item.getId()));
                }
                return item;
            }).collect(Collectors.toList());
            comboEdit.setComboItems(comboItems);
            Tips tips = new Tips("text", new LocaleString(FrontEndTypeEnum.getTipTitleByForm(formId)), new LocaleString(FrontEndTypeEnum.getTipMessageByForm(formId)), false, null);
            comboEdit.addTips(tips);
            if (StringUtils.equals((CharSequence)"tdm_asset_data", (CharSequence)formId) && accountDepreuseList.size() > 0) {
                model.setValue(DEPREUSE, (Object)accountDepreuseList.get(0));
                return;
            }
            String value = (String)DistributeCacheHelper.getDistributeSessionlessCache().get(DataSyncUtils.getCacheKey(formId));
            if (EmptyCheckUtils.isNotEmpty((Object)value)) {
                model.setValue(DEPREUSE, (Object)value);
            }
        }
    }

    public static void prepareDepreuseComboItemsForEas(IDataModel model, ComboEdit comboEdit, String formId) {
        String name = FrontEndTypeForEasEnum.getNameByForm(formId);
        if (StringUtil.isNotBlank((CharSequence)name)) {
            ArrayList<ComboItem> items = new ArrayList<ComboItem>();
            ComboItem item = new ComboItem();
            item.setId(formId);
            item.setCaption(new LocaleString(name));
            item.setValue(formId);
            items.add(item);
            comboEdit.setComboItems(items);
            Tips tips = new Tips("text", new LocaleString(FrontEndTypeForEasEnum.getTipTitleByForm(formId)), new LocaleString(FrontEndTypeForEasEnum.getTipMessageByForm(formId)), false, null);
            comboEdit.addTips(tips);
            model.setValue(DEPREUSE, (Object)formId);
        }
    }

    public static String getCacheKey(String formId) {
        RequestContext requestContext = RequestContext.get();
        return formId + requestContext.getOrgId() + requestContext.getCurrUserId();
    }

    public static Map<Long, List<Long>> prepareSelectedDepreuseAndDynammicParams(Object value, Object accountDepreuseValue) {
        Long selectedDepreuse;
        List dynamicParams;
        if (EmptyCheckUtils.isEmpty((Object)value) && EmptyCheckUtils.isNotEmpty((Object)accountDepreuseValue)) {
            dynamicParams = SerializationUtils.fromJsonStringToList((String)((String)accountDepreuseValue), Long.class);
            selectedDepreuse = (Long)dynamicParams.get(0);
        } else {
            dynamicParams = Collections.singletonList(Long.parseLong((String)value));
            selectedDepreuse = Long.parseLong((String)value);
        }
        HashMap<Long, List<Long>> result = new HashMap<Long, List<Long>>(16);
        result.put(selectedDepreuse, dynamicParams);
        return result;
    }

    public static List<Long> prepareOrgList(DynamicObjectCollection orgs) {
        List<Long> orgList;
        if (EmptyCheckUtils.isNotEmpty((Object)orgs)) {
            orgList = orgs.stream().map(v -> v.getDynamicObject(FBASEDATAID).getLong(ID)).collect(Collectors.toList());
        } else {
            DynamicObjectCollection collection = QueryServiceHelper.query((String)"fa_card_fin", (String)"org", (QFilter[])new QFilter[]{new QFilter(BILLSTATUS, "=", (Object)BILL_STATUS_AUDITED)});
            orgList = collection.stream().map(v -> v.getLong("org")).distinct().collect(Collectors.toList());
        }
        return orgList;
    }

    public static List<Long> preparePeriodList(Date period) {
        List peridBase = null;
        if (EmptyCheckUtils.isNotEmpty((Object)period)) {
            String periodStr = DateUtils.getFirstDateOfMonthStr((Date)period, (String)DATE_FORMAT);
            Date endDate = DateUtils.getLastDateOfMonth((Date)period);
            QFilter periodFilter = new QFilter(BEGINDATE, ">=", (Object)period).and(new QFilter(ENDDATE, "<=", (Object)endDate));
            QFilter numberFilter = new QFilter(NUMBER, "=", (Object)periodStr);
            periodFilter = periodFilter.or(numberFilter);
            QFilter typeFilter = new QFilter(PERIODTYPE_NUMBER, "=", (Object)"FA001");
            DynamicObject[] periods = BusinessDataServiceHelper.load((String)"bd_period", (String)BD_PERIOD_SELECT_FIELDS, (QFilter[])new QFilter[]{periodFilter, typeFilter});
            if (EmptyCheckUtils.isNotEmpty((Object)periods)) {
                peridBase = Arrays.stream(periods).filter(v -> !ConverterUtils.endsWith((CharSequence)v.getString(NUMBER), (CharSequence)"T")).map(v -> v.getLong(ID)).collect(Collectors.toList());
            }
        }
        return peridBase;
    }

    public static Map<String, Long> prepareAssetBookMapping(List<Long> orgList, Long selectedDepreuse) {
        DynamicObjectCollection assetBooks = QueryServiceHelper.query((String)"fa_assetbook", (String)FA_ASSETBOOK_SELECT_FIELDS, (QFilter[])new QFilter[]{new QFilter("org", "in", orgList), new QFilter(DEPREUSE, "=", (Object)selectedDepreuse), new QFilter(ISMAINBOOK, "=", (Object)MAINBOOK_VALUE)});
        Map<String, Long> collect = assetBooks.stream().collect(Collectors.toMap(k -> k.getString("org") + k.getString(DEPREUSE), v -> v.getLong(ID), (k1, k2) -> k2));
        return collect;
    }

    public static boolean checkQueryFilterMeetExecuteConditions(InputQueryFilterModel queryFilterModel, IFormView view, boolean isNeedShowMessage) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean flag = true;
        if (EmptyCheckUtils.isEmpty(queryFilterModel.getOrg())) {
            stringBuilder.append(ResManager.loadKDString((String)"\u6ca1\u6709\u6ee1\u8db3\u6761\u4ef6\u7684\u6838\u7b97\u7ec4\u7ec7\uff0c\u8bf7\u524d\u5f80\u201c\u8d22\u52a1\u4e91>\u56fa\u5b9a\u8d44\u4ea7>\u65e5\u5e38\u6838\u7b97>\u8d22\u52a1\u5361\u7247\u201d\u4e2d\u68c0\u67e5\u662f\u5426\u5b58\u5728\u5df2\u5ba1\u6838\u7684\u6570\u636e\u3002", (String)"DataSyncUtils_2", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
            flag = false;
        }
        if (EmptyCheckUtils.isEmpty(queryFilterModel.getDepreuse())) {
            stringBuilder.append(ResManager.loadKDString((String)"\u201c\u8d22\u52a1\u4e91>\u56fa\u5b9a\u8d44\u4ea7>\u6298\u65e7\u7528\u9014\u201d\u4e2d\u7684\u6570\u636e\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"DataSyncUtils_1", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
            flag = false;
        }
        if (EmptyCheckUtils.isEmpty(queryFilterModel.getAssetbook())) {
            // empty if block
        }
        if (EmptyCheckUtils.isNotEmpty((Object)stringBuilder.toString()) && isNeedShowMessage) {
            view.showTipNotification(stringBuilder.toString(), DURATION);
        }
        return flag;
    }

    public static boolean isMatchExecuteConditions(DataSyncTypeEnum typeEnum, List<Long> depreuseList) {
        String value = (String)DistributeCacheHelper.getDistributeSessionlessCache().get(DataSyncUtils.getCacheKey(typeEnum.getFormId()));
        return !EmptyCheckUtils.isEmpty((Object)value) && depreuseList.contains(Long.parseLong(value));
    }

    public static List<Long> getResultSetId(InputQueryFilterModel value) {
        return Collections.emptyList();
    }

    private static List<QFilter> parseFilter(InputQueryFilterModel value) {
        return Collections.emptyList();
    }

    public static Map<String, Object> packageParams(String formId, DynamicObjectCollection orgs, Date period) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        List orgList = orgs.stream().map(e -> e.getDynamicObject(FBASEDATAID).getString(ID)).collect(Collectors.toList());
        paramMap.put("org", orgList);
        paramMap.put("formid", formId);
        if (period == null) {
            paramMap.put("period", "");
            paramMap.put("startdate", "");
            paramMap.put(ENDDATE, "");
        } else {
            Date stratDate = DateUtils.getFirstDateOfMonth((Date)period);
            Date endDate = DateUtils.getLastDateOfMonth((Date)period);
            ArrayList<String> periodList = new ArrayList<String>(1);
            periodList.add(DateUtils.getFirstDateOfMonthStr((Date)period, (String)"yyyy-MM-dd"));
            paramMap.put("period", periodList);
            paramMap.put("startdate", DateUtils.format((Date)stratDate, (String)"yyyy-MM-dd HH:mm:ss"));
            paramMap.put(ENDDATE, DateUtils.format((Date)endDate, (String)"yyyy-MM-dd HH:mm:ss"));
        }
        return paramMap;
    }
}

