/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tdm.formplugin.declaration;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.BeforeImportDataEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.mvc.bill.BillView;
import kd.bos.orm.query.QFilter;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.bastax.taxcorg.TaxcOrgDataServiceHelper;
import kd.taxc.bdtaxr.common.helper.bd.currency.CurrencyDataServiceHelper;
import kd.taxc.tdm.business.declaration.algorithm.ExportDeclarationAlgorithmForForm;
import kd.taxc.tdm.common.constant.ExportDeclarationConstant;
import kd.taxc.tdm.common.util.DateUtils;
import kd.taxc.tdm.common.util.StringUtil;

public class ExportDeclarationFormPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final String SAVE = "save";
    private static final String SUBMIT = "submit";
    private static final String AUDIT = "audit";
    private static final String DATASOURCE = "datasource";
    private static final String ENTRYENTITY = "entryentity";
    private static final String ENTRY_WRITEOFFQTY = "writeoffqty";
    private static final String ENTRY_UNWRITEOFFQTY = "unwriteoffqty";
    private static final String ENTRY_TRADEQTY = "tradeqty";

    public void afterCreateNewData(EventObject e) {
        DynamicObject currency = this.getCurrency(ExportDeclarationConstant.USD_CURRENCY_ID);
        this.getModel().setValue("mylajcurrency", (Object)currency);
    }

    private DynamicObject getCurrency(Long id) {
        TaxResult taxResult = CurrencyDataServiceHelper.querySingleCurrencyById((Long)id);
        if (taxResult != null && taxResult.isSuccess()) {
            DynamicObject data = (DynamicObject)taxResult.getData();
            return data;
        }
        return null;
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addF7SelectListener("hscode");
    }

    private void addF7SelectListener(String ... f7Keys) {
        for (String f7Key : f7Keys) {
            BasedataEdit periodCol = (BasedataEdit)this.getControl(f7Key);
            if (periodCol == null) continue;
            periodCol.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key = e.getProperty().getName();
        ListShowParameter f7List = (ListShowParameter)e.getFormShowParameter();
        if ("hscode".equals(key)) {
            Date declarationdate = this.getModel().getDataEntity().getDate("declarationdate");
            if (declarationdate == null) {
                return;
            }
            ArrayList<QFilter> filters = new ArrayList<QFilter>();
            filters.add(new QFilter("startdate", "<=", (Object)declarationdate));
            filters.add(new QFilter("enddate", ">=", (Object)declarationdate));
            f7List.getListFilterParameter().setQFilters(filters);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        Date declarationdate;
        super.beforeDoOperation(args);
        FormOperate source = (FormOperate)args.getSource();
        String key = source.getOperateKey();
        if (SAVE.equals(key) || SUBMIT.equals(key) || AUDIT.equals(key)) {
            source.getOption().setVariableValue("extendParam", "1");
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            if (org != null && !((Boolean)TaxcOrgDataServiceHelper.isTaxcOrgExistByOrgId((Long)org.getLong("id")).getData()).booleanValue()) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7a0e\u52a1\u7ec4\u7ec7\u4e0d\u53ef\u7528\uff0c\u65e0\u6cd5\u6267\u884c\u5f53\u524d\u64cd\u4f5c\u3002", (String)"ExportDeclarationFormPlugin_0", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
        } else if ("newentry".equals(key) && (declarationdate = this.getModel().getDataEntity().getDate("declarationdate")) == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7533\u62a5\u65e5\u671f", (String)"ExportDeclarationFormPlugin_1", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        super.afterDeleteRow(e);
        new ExportDeclarationAlgorithmForForm(this.getView(), this.getModel()).calByDeleteRow();
    }

    public void afterBindData(EventObject e) {
        BillView billView = (BillView)e.getSource();
        OperationStatus status = billView.getFormShowParameter().getStatus();
        if (OperationStatus.VIEW.equals((Object)status)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"tb_new", "tb_del", "tb_up", "tb_down"});
        }
        super.afterBindData(e);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName = e.getProperty().getName();
        ChangeData changeData = e.getChangeSet()[0];
        if ("itemno".equals(propertyName)) {
            String itemNo = (String)changeData.getNewValue();
            int rowIndex = changeData.getRowIndex();
            if (StringUtil.isNotBlank((CharSequence)itemNo)) {
                int itemNum;
                if (itemNo.matches("^[0-9]+$") && (itemNum = Integer.parseInt(itemNo)) > 0 && itemNum <= 99) {
                    this.getModel().setValue("itemno", (Object)String.format("%02d", itemNum), rowIndex);
                    return;
                }
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165[01...99]\u4e2d\u7684\u6574\u6570\u3002", (String)"ExportDeclarationFormPlugin_2", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
                this.getModel().setValue("itemno", null, rowIndex);
            }
        } else if ("declarationdate".equals(propertyName)) {
            if (changeData.getNewValue() == null) {
                return;
            }
            Date declarationdate = (Date)changeData.getNewValue();
            DynamicObjectCollection entries = this.getModel().getDataEntity(true).getDynamicObjectCollection(ENTRYENTITY);
            DynamicObject entry = null;
            DynamicObject hscode = null;
            ArrayList<Integer> errorRows = new ArrayList<Integer>(10);
            ArrayList<Integer> errorSn = new ArrayList<Integer>(10);
            int size = entries.size();
            for (int i = 0; i < size; ++i) {
                entry = (DynamicObject)entries.get(i);
                hscode = entry.getDynamicObject("hscode");
                if (hscode == null || !declarationdate.before(hscode.getDate("startdate")) && !declarationdate.after(hscode.getDate("enddate"))) continue;
                errorRows.add(i);
                errorSn.add(i + 1);
            }
            if (errorRows.size() > 0) {
                HashMap<String, Object> customValueMap = new HashMap<String, Object>(2);
                customValueMap.put("errorRows", errorRows);
                customValueMap.put("oldValue", changeData.getOldValue());
                String msg = String.format(ResManager.loadKDString((String)"\u4fee\u6539\u7533\u62a5\u65e5\u671f\u4f1a\u5bfc\u81f4\u5b58\u5728\u5931\u6548\u6d77\u5173\u5546\u54c1\u7684\u5206\u5f55\u884c\u88ab\u5220\u9664\uff0c\u786e\u8ba4\u8981\u4fee\u6539\u5417\uff1f", (String)"ExportDeclarationFormPlugin_3", (String)"taxc-tdm-formplugin", (Object[])new Object[0]), new Object[0]);
                StringBuilder detailMsg = new StringBuilder();
                String entryMsg = null;
                int size2 = errorSn.size();
                for (int i = 0; i < size2; ++i) {
                    entryMsg = String.format(ResManager.loadKDString((String)"\u5206\u5f55\u884c%s", (String)"ExportDeclarationFormPlugin_4", (String)"taxc-tdm-formplugin", (Object[])new Object[0]), errorSn.get(i));
                    detailMsg.append(entryMsg).append("\n");
                }
                HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>(2);
                btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u786e\u8ba4", (String)"ExportDeclarationFormPlugin_5", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
                btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u53d6\u6d88", (String)"ExportDeclarationFormPlugin_6", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
                this.getView().showConfirm(msg, detailMsg.toString(), MessageBoxOptions.OKCancel, ConfirmTypes.Save, new ConfirmCallBackListener("DELETE_ENTRYROW_COMFIRM", (IFormPlugin)this), btnNameMaps, SerializationUtils.toJsonString(customValueMap));
            }
        }
        new ExportDeclarationAlgorithmForForm(this.getView(), this.getModel()).calByChange(e);
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        String callBackId = e.getCallBackId();
        if ("DELETE_ENTRYROW_COMFIRM".equals(callBackId)) {
            if (e.getResult().equals((Object)MessageBoxResult.Yes)) {
                Map customValueMap = (Map)SerializationUtils.fromJsonString((String)e.getCustomVaule(), Map.class);
                List errorRows = (List)customValueMap.get("errorRows");
                int[] rows = errorRows.stream().mapToInt(Integer::intValue).toArray();
                this.getModel().deleteEntryRows(ENTRYENTITY, rows);
            } else {
                Map customValueMap = (Map)SerializationUtils.fromJsonString((String)e.getCustomVaule(), Map.class);
                String oldValue = (String)customValueMap.get("oldValue");
                Date declarationdate = !StringUtil.isEmpty((CharSequence)oldValue) ? DateUtils.stringToDate((String)oldValue) : null;
                this.getModel().beginInit();
                this.getModel().setValue("declarationdate", (Object)declarationdate);
                this.getModel().endInit();
                this.getView().updateView("declarationdate");
            }
        }
    }

    public void beforeImportData(BeforeImportDataEventArgs e) {
        super.beforeImportData(e);
        Map sourceData = e.getSourceData();
        sourceData.put(DATASOURCE, "2");
    }

    public void afterCopyData(EventObject e) {
        super.afterCopyData(e);
        this.getModel().setValue(DATASOURCE, (Object)"1");
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRYENTITY);
        for (DynamicObject entry : entryEntity) {
            entry.set(ENTRY_WRITEOFFQTY, (Object)0);
            entry.set(ENTRY_UNWRITEOFFQTY, entry.get(ENTRY_TRADEQTY));
        }
    }
}

