/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tdm.formplugin.declaration;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.util.StringUtils;
import kd.taxc.bdtaxr.common.helper.bos.perm.PermDataServiceHelper;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.tdm.business.integration.supplier.dzka.helper.DzkaHelper;
import kd.taxc.tdm.common.util.DateUtils;

public class ExportDeclarationListPlugin
extends AbstractListPlugin {
    private static final String COLLECT = "collect";
    private static final String SUBMIT = "submit";
    private static final String AUDIT = "audit";
    private static final String BTN_COLLECTDATA = "collectdata";
    private static final String BTN_COLLECT_CONFIG = "collect_config";
    private static final String BTN_COLLECT_MONITOR = "collect_monitor";
    private static final String OP_COLLECT = "op_collectdata";
    private static final String OP_COLLECTMONITOR = "op_collectmonitor";

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate source = (FormOperate)args.getSource();
        String key = source.getOperateKey();
        if (SUBMIT.equals(key) || AUDIT.equals(key)) {
            source.getOption().setVariableValue("extendParam", "1");
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String key = args.getOperateKey();
        if (StringUtil.equalsIgnoreCase((CharSequence)"calmylaj", (CharSequence)key)) {
            if (args.getOperationResult().isSuccess()) {
                this.getView().invokeOperation("refresh");
            }
        } else if (COLLECT.equals(key)) {
            if (!DzkaHelper.supportDzka()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u914d\u7f6e\u5357\u65b9\u7535\u5b50\u53e3\u5cb8\u4fe1\u606f\uff0c\u6682\u4e0d\u652f\u6301\u91c7\u96c6\u529f\u80fd", (String)"ExportDeclarationListPlugin_0", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
                return;
            }
            this.openDzka();
        } else if (OP_COLLECT.equals(key)) {
            if (args.getOperationResult().isSuccess()) {
                if (!DzkaHelper.supportDzka()) {
                    this.openDownload();
                } else {
                    this.openDzka();
                }
            }
        } else if (OP_COLLECTMONITOR.equals(key)) {
            this.openMonitor();
        }
    }

    private void openDzka() {
        FormShowParameter params = new FormShowParameter();
        params.setCaption(ResManager.loadKDString((String)"\u5357\u65b9\u7535\u5b50\u53e3\u5cb8", (String)"ExportDeclarationListPlugin_1", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
        params.setFormId("tdm_dzka_window");
        params.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm(params);
    }

    private void openDownload() {
        Map<String, Object> customParams = this.buildDownloadParams();
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("tsate_export_form_cms");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCustomParams(customParams);
        this.getView().showForm(parameter);
    }

    public Map<String, Object> buildDownloadParams() {
        HashMap<String, Object> customParams = new HashMap<String, Object>(8);
        Date nowDate = new Date();
        Date oneWeekAgo = DateUtils.addDay((Date)nowDate, (int)-6);
        customParams.put("startUpdateDate", oneWeekAgo);
        customParams.put("endUpdateDate", nowDate);
        Long userId = RequestContext.get().getCurrUserId();
        Long currentOrgId = RequestContext.get().getOrgId();
        List hasPermOrgIds = (List)PermDataServiceHelper.getAllPermOrgs((Long)userId, (String)"tdm", (String)"tdm_export_declaration", (String)"47156aff000000ac", (String)"40").getData();
        customParams.put("hasPremOrgIds", hasPermOrgIds);
        if (hasPermOrgIds.isEmpty()) {
            return customParams;
        }
        Long defaultOrgId = currentOrgId;
        List orgFilter = ((IListView)this.getView()).getControlFilters().getFilter("org.id");
        if (orgFilter == null || orgFilter.isEmpty() || orgFilter.size() == 1 && StringUtils.isEmpty((String)((String)orgFilter.get(0)))) {
            defaultOrgId = hasPermOrgIds.contains(currentOrgId) ? currentOrgId : (Long)hasPermOrgIds.get(0);
        } else {
            defaultOrgId = null;
            ArrayList<Long> selectedOrgList = new ArrayList<Long>(orgFilter.size());
            for (Object selectOrgStr : orgFilter) {
                Long selectOrgId = Long.parseLong(String.valueOf(selectOrgStr));
                if (currentOrgId.equals(selectOrgId) && hasPermOrgIds.contains(selectOrgId)) {
                    defaultOrgId = currentOrgId;
                    break;
                }
                selectedOrgList.add(selectOrgId);
            }
            if (defaultOrgId == null) {
                for (Long aLong : selectedOrgList) {
                    if (!hasPermOrgIds.contains(aLong)) continue;
                    defaultOrgId = aLong;
                    break;
                }
            }
        }
        customParams.put("defaultOrgId", defaultOrgId);
        return customParams;
    }

    private void openMonitor() {
        ListShowParameter param = new ListShowParameter();
        param.setFormId("bos_list");
        param.setBillFormId("tsate_declare_record");
        param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        HashMap<String, String> customeParams = new HashMap<String, String>(4);
        customeParams.put("tasktype.number", "CKBGDXZ");
        param.setCustomParams(customeParams);
        this.getView().showForm((FormShowParameter)param);
    }
}

