/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tdm.formplugin.declaration;

import java.util.EventObject;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.control.Button;
import kd.bos.form.control.IFrame;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.tdm.business.integration.helper.SupplierSettingHelper;
import kd.taxc.tdm.business.integration.supplier.dzka.DzkaServiceImpl;
import kd.taxc.tdm.business.integration.supplier.dzka.bean.TokenInfo;

public class UrlWindowPlugin
extends AbstractFormPlugin {
    private static final String CJ = "cj";
    private static final String CJQUERY = "cjquery";
    private static final String REAUTH = "reauth";

    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{CJ, CJQUERY, REAUTH});
    }

    public void click(EventObject evt) {
        Button bt = (Button)evt.getSource();
        if (bt != null) {
            String key = bt.getKey();
            if (CJ.equals(key)) {
                String url = SupplierSettingHelper.getSetting((String)"DZKA_URL_CJ");
                this.openUrl(url);
            } else if (CJQUERY.equals(key)) {
                String url = SupplierSettingHelper.getSetting((String)"DZKA_URL_CJQUERY");
                this.openUrl(url);
            } else if (REAUTH.equals(key)) {
                this.auth();
                String url = SupplierSettingHelper.getSetting((String)"DZKA_URL_CJ");
                this.openUrl(url);
            }
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        if (!this.auth()) {
            return;
        }
        String url = SupplierSettingHelper.getSetting((String)"DZKA_URL_CJ");
        this.openUrl(url);
    }

    private boolean auth() {
        Long orgId = RequestContext.get().getOrgId();
        TaxResult result = DzkaServiceImpl.getAuthInfo((Long)orgId);
        if (!result.isSuccess()) {
            this.getView().showErrorNotification(result.getMessage());
            return false;
        }
        String token = ((TokenInfo)result.getData()).getToken();
        this.getPageCache().put("token", token);
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6388\u6743\u6210\u529f", (String)"UrlWindowPlugin_0", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
        return true;
    }

    private void openUrl(String url) {
        String token = this.getPageCache().get("token");
        if (token == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u8bbe\u7f6e\u6b63\u786e\u7684\u7f51\u9875\u5730\u5740\u3002", (String)"UrlWindowPlugin_1", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
        }
        IFrame frame = (IFrame)this.getView().getControl("iframeap");
        StringBuilder realUrl = new StringBuilder();
        realUrl.append(url).append("?token=").append(token);
        frame.setSrc(realUrl.toString());
    }
}

