/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tdm.formplugin.depreciationAmortization;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.filter.FilterColumn;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.form.JobForm;
import kd.bos.schedule.form.JobFormInfo;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.tdm.business.assettaxcard.AssetTaxCardTaskClick;
import kd.taxc.tdm.business.assettaxcard.AssetTaxCardTaskUtils;
import kd.taxc.tdm.business.depreciation.AutoGenerateAssetCardService;
import kd.taxc.tdm.business.depreciation.task.AutoGenerateTask;
import org.apache.commons.collections4.CollectionUtils;

public class AssetCardListPlugin
extends AbstractListPlugin {
    private static String accountOrgId;

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"new"});
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        List columnList = args.getCommonFilterColumns();
        for (FilterColumn filterColumn : columnList) {
            List defaultValues;
            String fieldName = filterColumn.getFieldName();
            if (!StringUtils.equals((CharSequence)fieldName, (CharSequence)"accountorg.name") || (defaultValues = filterColumn.getDefaultValues()).size() != 1) continue;
            accountOrgId = String.valueOf(defaultValues.get(0));
        }
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        Map filterValues = args.getSearchClickEvent().getFilterValues();
        List customFiterList = (List)filterValues.get("customfilter");
        if (customFiterList != null) {
            for (int i = customFiterList.size() - 1; i >= 0; --i) {
                List value;
                String name;
                Map customFiter = (Map)customFiterList.get(i);
                List fieldNames = (List)customFiter.get("FieldName");
                if (fieldNames == null || fieldNames.isEmpty() || !StringUtils.equals((CharSequence)(name = (String)fieldNames.get(0)), (CharSequence)"accountorg.id") || (value = (List)customFiter.get("Value")).size() != 1) continue;
                accountOrgId = String.valueOf(value.get(0));
            }
        }
        super.filterContainerSearchClick(args);
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        if ("tblnew".equals(itemKey)) {
            this.getView().getFormShowParameter().setCustomParam("accountorg", (Object)accountOrgId);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        List pkIds;
        FormOperate source = (FormOperate)args.getSource();
        String operateKey = source.getOperateKey();
        OperationResult operationResult = args.getOperationResult();
        if (operationResult != null) {
            String operateName;
            OperationResult operateResult;
            List errorMsgList;
            Map validateMap;
            String caption;
            String name;
            List successPkIds = operationResult.getSuccessPkIds();
            List allErrorOrValidateInfo = operationResult.getAllErrorOrValidateInfo();
            List<String> errorList = allErrorOrValidateInfo.stream().map(IOperateInfo::getMessage).collect(Collectors.toList());
            if ("policy".equals(operateKey) && CollectionUtils.isNotEmpty((Collection)successPkIds)) {
                this.policyConfirmationHandle(successPkIds);
            }
            if ("cancelpolicy".equals(operateKey) && CollectionUtils.isNotEmpty((Collection)successPkIds)) {
                this.cancelPolicyconfirmationhandle(successPkIds);
            }
            if ("identifygeneralpolicy".equals(operateKey) && CollectionUtils.isNotEmpty((Collection)successPkIds)) {
                source.getOption().setVariableValue("isshowmessage", "false");
                if (successPkIds.size() > 1000) {
                    name = ResManager.loadKDString((String)"\u4e00\u822c\u653f\u7b56\u8bc6\u522b\u4efb\u52a1\u8fdb\u5ea6", (String)"AssetCardListPlugin_3", (String)"taxc-tdm-formplugin", (Object[])new Object[0]);
                    caption = ResManager.loadKDString((String)"\u8d44\u4ea7\u7a0e\u52a1\u5361\u7247\u4e00\u822c\u653f\u7b56\u8bc6\u522b\u4efb\u52a1\u8fdb\u5ea6", (String)"AssetCardListPlugin_4", (String)"taxc-tdm-formplugin", (Object[])new Object[0]);
                    this.dispatch(successPkIds, errorList, "general", name, caption, "identifygeneralpolicy");
                } else {
                    validateMap = AutoGenerateAssetCardService.identifyGeneralPolicy((List)successPkIds);
                    errorMsgList = (List)validateMap.get("errorMsgList");
                    errorMsgList.addAll(errorList);
                    operateResult = AutoGenerateAssetCardService.getGeneralOperationResult((int)(successPkIds.size() + errorList.size()), (Map)validateMap);
                    operateName = ResManager.loadKDString((String)"\u4e00\u822c\u653f\u7b56\u8bc6\u522b", (String)"AssetCardListPlugin_7", (String)"taxc-tdm-formplugin", (Object[])new Object[0]);
                    if (operateResult.isSuccess()) {
                        this.getView().showSuccessNotification(operateResult.getMessage());
                    } else {
                        this.getView().showOperationResult(operateResult, operateName);
                    }
                }
            }
            if ("identifyaccelerationpolicy".equals(operateKey) && CollectionUtils.isNotEmpty((Collection)successPkIds)) {
                source.getOption().setVariableValue("isshowmessage", "false");
                if (successPkIds.size() > 1000) {
                    name = ResManager.loadKDString((String)"\u52a0\u901f\u6298\u65e7\u653f\u7b56\u8bc6\u522b\u4efb\u52a1\u8fdb\u5ea6", (String)"AssetCardListPlugin_5", (String)"taxc-tdm-formplugin", (Object[])new Object[0]);
                    caption = ResManager.loadKDString((String)"\u8d44\u4ea7\u7a0e\u52a1\u5361\u7247\u52a0\u901f\u6298\u65e7\u653f\u7b56\u8bc6\u522b\u4efb\u52a1\u8fdb\u5ea6", (String)"AssetCardListPlugin_6", (String)"taxc-tdm-formplugin", (Object[])new Object[0]);
                    this.dispatch(successPkIds, errorList, "acceleration", name, caption, "identifyaccelerationpolicy");
                } else {
                    validateMap = AutoGenerateAssetCardService.identifyAccelerationPolicy((List)successPkIds);
                    errorMsgList = (List)validateMap.get("errorMsgList");
                    errorMsgList.addAll(errorList);
                    operateResult = AutoGenerateAssetCardService.getAccelerationOperationResult((int)(successPkIds.size() + errorList.size()), (Map)validateMap);
                    operateName = ResManager.loadKDString((String)"\u52a0\u901f\u6298\u65e7\u653f\u7b56\u8bc6\u522b", (String)"AssetCardListPlugin_8", (String)"taxc-tdm-formplugin", (Object[])new Object[0]);
                    if (operateResult.isSuccess()) {
                        this.getView().showSuccessNotification(operateResult.getMessage());
                    } else {
                        this.getView().showOperationResult(operateResult, operateName);
                    }
                }
            }
        }
        if ("autonew".equals(operateKey)) {
            FormShowParameter parameter = new FormShowParameter();
            parameter.setCustomParam("orgid", (Object)accountOrgId);
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            parameter.setFormId("tdm_generate_assettaxcard");
            parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "autonew"));
            this.getView().showForm(parameter);
        }
        if ("calcdepreciation".equals(operateKey)) {
            pkIds = args.getOperationResult().getSuccessPkIds();
            if (EmptyCheckUtils.isNotEmpty((Object)pkIds)) {
                AssetTaxCardTaskUtils.dispatchCalc((IFormView)this.getView(), (List)pkIds);
            }
        } else if ("confirmdepreciation".equals(operateKey)) {
            pkIds = args.getOperationResult().getSuccessPkIds();
            if (EmptyCheckUtils.isNotEmpty((Object)pkIds)) {
                AssetTaxCardTaskUtils.dispatchConfirm((IFormView)this.getView(), (List)pkIds);
            }
        } else if ("canceldepreciation".equals(operateKey)) {
            BillList billlist = (BillList)this.getControl("billlistap");
            billlist.refresh();
            boolean success = args.getOperationResult().isSuccess();
            if (success) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u53d6\u6d88\u6298\u65e7\u786e\u8ba4\u6210\u529f", (String)"AssetCardListPlugin_2", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        if ("dispatchCalc".equals(evt.getActionId())) {
            String operateName = ResManager.loadKDString((String)"\u8ba1\u7b97\u6298\u65e7", (String)"AssetCardListPlugin_0", (String)"taxc-tdm-formplugin", (Object[])new Object[0]);
            this.closeCallBack(evt, operateName);
        } else if ("dispatchConfirm".equals(evt.getActionId())) {
            String operateName = ResManager.loadKDString((String)"\u786e\u8ba4\u6298\u65e7", (String)"AssetCardListPlugin_1", (String)"taxc-tdm-formplugin", (Object[])new Object[0]);
            this.closeCallBack(evt, operateName);
        } else if ("autonew".equals(evt.getActionId())) {
            String operateName = ResManager.loadKDString((String)"\u81ea\u52a8\u751f\u6210", (String)"AssetCardListPlugin_9", (String)"taxc-tdm-formplugin", (Object[])new Object[0]);
            this.closeCallBack(evt, operateName);
        } else if ("identifygeneralpolicy".equals(evt.getActionId())) {
            String operateName = ResManager.loadKDString((String)"\u4e00\u822c\u653f\u7b56\u8bc6\u522b", (String)"AssetCardListPlugin_7", (String)"taxc-tdm-formplugin", (Object[])new Object[0]);
            this.closeCallBack(evt, operateName);
        } else if ("identifyaccelerationpolicy".equals(evt.getActionId())) {
            String operateName = ResManager.loadKDString((String)"\u52a0\u901f\u6298\u65e7\u653f\u7b56\u8bc6\u522b", (String)"AssetCardListPlugin_8", (String)"taxc-tdm-formplugin", (Object[])new Object[0]);
            this.closeCallBack(evt, operateName);
        }
    }

    private void closeCallBack(ClosedCallBackEvent evt, String operateName) {
        if (EmptyCheckUtils.isNotEmpty((Object)evt.getReturnData())) {
            TaskInfo taskInfo;
            Map result;
            String taskInfoStr;
            Object returnData = evt.getReturnData();
            if (returnData instanceof Map && StringUtil.isNotBlank((CharSequence)(taskInfoStr = (String)(result = (Map)returnData).get("taskinfo"))) && (taskInfo = (TaskInfo)SerializationUtils.fromJsonString((String)taskInfoStr, TaskInfo.class)).isTaskEnd()) {
                String data = taskInfo.getData();
                Map customs = (Map)SerializationUtils.fromJsonString((String)data, Map.class);
                String operateResult = (String)customs.get("operateResult");
                OperationResult o = (OperationResult)SerializationUtils.fromJsonString((String)operateResult, OperationResult.class);
                if (o.isSuccess()) {
                    this.getView().showSuccessNotification(o.getMessage());
                } else {
                    this.getView().showOperationResult(o, operateName);
                }
            }
            BillList billlist = (BillList)this.getControl("billlistap");
            billlist.refresh();
        }
    }

    private void policyConfirmationHandle(List<Object> successPkIds) {
        DynamicObject[] objects;
        for (DynamicObject object : objects = BusinessDataServiceHelper.load((Object[])successPkIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"tdm_asset_taxc_card"))) {
            BigDecimal assetsvalue = object.getBigDecimal("assetsvalue");
            BigDecimal taxbase = object.getBigDecimal("taxbase");
            String accdepreciationmethod = object.getString("accdepreciationmethod");
            DynamicObject taxdepreciation = object.getDynamicObject("taxdepreciation");
            String taxdepreciationName = "";
            taxdepreciationName = taxdepreciation == null ? taxdepreciationName : taxdepreciation.getString("name");
            int accamortizationperiods = object.getInt("accamortizationperiods");
            int taxamortizationperiods = object.getInt("taxamortizationperiods");
            if (assetsvalue.compareTo(taxbase) != 0 || !taxdepreciationName.equals(accdepreciationmethod) || accamortizationperiods != taxamortizationperiods) {
                object.set("booktaxdifferent", (Object)"1");
            } else {
                object.set("booktaxdifferent", (Object)"0");
            }
            String booktaxdifferenttype = ",";
            if (assetsvalue.compareTo(taxbase) != 0) {
                booktaxdifferenttype = "0,";
            }
            if (accamortizationperiods != taxamortizationperiods) {
                booktaxdifferenttype = booktaxdifferenttype + "1,";
            }
            if (!taxdepreciationName.equals(accdepreciationmethod)) {
                booktaxdifferenttype = booktaxdifferenttype + "2,";
            }
            object.set("booktaxdifferenttype", (Object)booktaxdifferenttype);
        }
        SaveServiceHelper.save((DynamicObject[])objects);
    }

    private void cancelPolicyconfirmationhandle(List<Object> successPkIds) {
        DynamicObject[] objects;
        for (DynamicObject object : objects = BusinessDataServiceHelper.load((Object[])successPkIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"tdm_asset_taxc_card"))) {
            object.set("booktaxdifferenttype", (Object)"");
            object.set("booktaxdifferent", (Object)"");
            object.set("depreciationstatus", (Object)"0");
            object.set("taxdepreciatedperiods", (Object)0);
            object.set("taxsurplusdepperiods", (Object)0);
            object.set("taxcurrentdepamount", (Object)BigDecimal.ZERO);
            object.set("taxthisyeardepamount", (Object)BigDecimal.ZERO);
            object.set("taxaccumulateddepamount", (Object)BigDecimal.ZERO);
        }
        SaveServiceHelper.save((DynamicObject[])objects);
    }

    private void dispatch(List<Object> successPkIds, List<String> errorList, String method, String name, String caption, String callback) {
        HashMap<String, Object> params = new HashMap<String, Object>(16);
        params.put("successPkIds", successPkIds);
        params.put("errorList", errorList);
        params.put("method", method);
        this.dispatch(params, name, caption, callback);
    }

    private void dispatch(Map<String, Object> customParams, String name, String caption, String callback) {
        String appId = this.getView().getFormShowParameter().getAppId();
        JobInfo jobInfo = new JobInfo();
        jobInfo.setAppId(appId);
        jobInfo.setRunByUserId(RequestContext.get().getCurrUserId());
        jobInfo.setJobType(JobType.REALTIME);
        jobInfo.setName(name);
        jobInfo.setId(UUID.randomUUID().toString());
        jobInfo.setTaskClassname(AutoGenerateTask.class.getName());
        jobInfo.setParams(customParams);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, callback);
        JobFormInfo jobFormInfo = new JobFormInfo(jobInfo);
        jobFormInfo.setCaption(caption);
        jobFormInfo.setCloseCallBack(closeCallBack);
        jobFormInfo.setCanBackground(true);
        jobFormInfo.setClickClassName(AssetTaxCardTaskClick.class.getName());
        JobForm.dispatch((JobFormInfo)jobFormInfo, (IFormView)this.getView());
    }
}

