/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tdm.formplugin.depreciationAmortization;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.bos.orgrelation.OrgRelationDataServiceHelper;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.util.date.DateUtils;

public class AssetCardPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private String ACCOUNTORG = "accountorg";
    private String TAXORG = "taxorg";
    private String ASSETDATA = "assetdata";
    private String ASSETSVALUE = "assetsvalue";
    private String TAXBASE = "taxbase";
    private String TAXATIONSYS = "taxationsys";
    private String TAXAREA = "taxarea";
    private String TAXASSETCLASS = "taxassetclass";
    private String QUICKTAXASSETCLASS = "quicktaxassetclass";
    private String ACCDEPRECIATIONMETHOD = "accdepreciationmethod";
    private String TAXDEPRECIATION = "taxdepreciation";
    private String ACCAMORTIZATIONPERIODS = "accamortizationperiods";
    private String TAXAMORTIZATIONPERIODS = "taxamortizationperiods";
    private String POLICYCONFIRMATION = "policyconfirmation";
    private String CANCELPOLICYCONFIRMATION = "cancelpolicyconfirmation";

    public void registerListener(EventObject e) {
        BasedataEdit accountorgEdit = (BasedataEdit)this.getView().getControl(this.ACCOUNTORG);
        BasedataEdit assetdataEdit = (BasedataEdit)this.getView().getControl(this.ASSETDATA);
        BasedataEdit taxorgEdit = (BasedataEdit)this.getView().getControl(this.TAXORG);
        BasedataEdit taxationsysEdit = (BasedataEdit)this.getView().getControl(this.TAXATIONSYS);
        BasedataEdit taxareaEdit = (BasedataEdit)this.getView().getControl(this.TAXAREA);
        BasedataEdit taxassetclassEdit = (BasedataEdit)this.getView().getControl(this.TAXASSETCLASS);
        BasedataEdit quicktaxassetclassEdit = (BasedataEdit)this.getView().getControl(this.QUICKTAXASSETCLASS);
        taxassetclassEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        quicktaxassetclassEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        accountorgEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        assetdataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        taxorgEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        taxationsysEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        taxareaEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        this.addItemClickListeners(new String[]{"policyconfirmationbtn", "cancelpolicyconfirmation", this.POLICYCONFIRMATION, this.CANCELPOLICYCONFIRMATION});
        this.addClickListeners(new String[]{"policyconfirmationbtn", "cancelpolicyconfirmation", this.POLICYCONFIRMATION, this.CANCELPOLICYCONFIRMATION});
    }

    public void afterCreateNewData(EventObject e) {
        Object accountorg = this.getView().getFormShowParameter().getCustomParam("SELECT_ORG_ID");
        if (Objects.nonNull(accountorg)) {
            this.getModel().setValue(this.ACCOUNTORG, (Object)Long.parseLong(String.valueOf(accountorg)));
        }
        Date date = DateUtils.addMonth((Date)DateUtils.getFirstDateOfMonth((Date)new Date()), (int)-1);
        this.getModel().setValue("accountingperiod", (Object)date);
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        QFilter depreciationclassFilter;
        QFilter accountOrgFilter;
        QFilter enableFilter;
        long accountOrgId;
        Object accountOrg;
        String name = evt.getProperty().getName();
        if (this.TAXORG.equals(name)) {
            accountOrg = this.getModel().getValue(this.ACCOUNTORG);
            if (Objects.isNull(accountOrg)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"AssetCardPlugin_0", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            accountOrgId = ((DynamicObject)accountOrg).getLong("id");
            TaxResult taxcOrgIdByAccountingOrgIds = OrgRelationDataServiceHelper.getTaxcOrgIdByAccountingOrgId((Long)accountOrgId);
            List ids = (List)taxcOrgIdByAccountingOrgIds.getData();
            if (!taxcOrgIdByAccountingOrgIds.isSuccess() && CollectionUtils.isEmpty((Collection)ids)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u59d4\u6258\u7684\u7a0e\u52a1\u7ec4\u7ec7\u3002", (String)"AssetCardPlugin_3", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            QFilter enableFilter2 = new QFilter("enable", "=", (Object)"1");
            QFilter accountOrgFilter2 = new QFilter("id", "in", (Object)ids);
            evt.setCustomQFilters(Arrays.asList(enableFilter2, accountOrgFilter2));
        }
        if (this.ASSETDATA.equals(name)) {
            accountOrg = this.getModel().getValue(this.ACCOUNTORG);
            if (Objects.isNull(accountOrg)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"AssetCardPlugin_0", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            accountOrgId = ((DynamicObject)accountOrg).getLong("id");
            enableFilter = new QFilter("enable", "=", (Object)"1");
            accountOrgFilter = new QFilter("taxorg", "=", (Object)accountOrgId);
            evt.setCustomQFilters(Arrays.asList(enableFilter, accountOrgFilter));
        }
        if (this.TAXATIONSYS.equals(name)) {
            Object taxOrg = this.getModel().getValue(this.TAXORG);
            if (Objects.isNull(taxOrg)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7a0e\u52a1\u7ec4\u7ec7\u3002", (String)"AssetCardPlugin_1", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            long taxOrgId = ((DynamicObject)taxOrg).getLong("id");
            this.getTaxationsysIdsByOrgId(taxOrgId);
            enableFilter = new QFilter("enable", "=", (Object)"1");
            accountOrgFilter = new QFilter("id", "in", this.getTaxationsysIdsByOrgId(taxOrgId));
            evt.setCustomQFilters(Arrays.asList(enableFilter, accountOrgFilter));
        }
        if (this.TAXAREA.equals(name)) {
            Object taxationsys = this.getModel().getValue(this.TAXATIONSYS);
            if (Objects.isNull(taxationsys)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7a0e\u6536\u5236\u5ea6\u3002", (String)"AssetCardPlugin_2", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            Object taxOrg = this.getModel().getValue(this.TAXORG);
            if (Objects.isNull(taxOrg)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7a0e\u52a1\u7ec4\u7ec7\u3002", (String)"AssetCardPlugin_1", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            long taxOrgId = ((DynamicObject)taxOrg).getLong("id");
            long taxationsysId = ((DynamicObject)taxationsys).getLong("id");
            QFilter enableFilter3 = new QFilter("enable", "=", (Object)"1");
            QFilter accountOrgFilter3 = new QFilter("id", "in", this.getTaxareIdsByTaxationsysIdAndOrgId(taxOrgId, taxationsysId));
            evt.setCustomQFilters(Arrays.asList(enableFilter3, accountOrgFilter3));
        }
        if (this.TAXASSETCLASS.equals(name)) {
            depreciationclassFilter = new QFilter("depreciationclass", "=", (Object)"ybzj");
            evt.setCustomQFilters(Collections.singletonList(depreciationclassFilter));
        }
        if (this.QUICKTAXASSETCLASS.equals(name)) {
            depreciationclassFilter = new QFilter("depreciationclass", "=", (Object)"jszj");
            evt.setCustomQFilters(Collections.singletonList(depreciationclassFilter));
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        ChangeData changeData = e.getChangeSet()[0];
        Object newValue = changeData.getNewValue();
        if (this.ACCOUNTORG.equals(name)) {
            if (newValue == null) {
                this.getModel().setValue(this.TAXORG, null);
            } else {
                long accountOrgId = ((DynamicObject)newValue).getLong("id");
                Map orgRelationAccountToTax = OrgRelationDataServiceHelper.getOrgRelationAccountToTax((Long)accountOrgId, (boolean)true);
                List orglist = (List)orgRelationAccountToTax.get("data");
                Long taxOrgId = null;
                if (!CollectionUtils.isEmpty((Collection)orglist)) {
                    Optional<HashMap> first = orglist.stream().filter(o -> (Boolean)o.get("isDefault")).findFirst();
                    if (first.isPresent()) {
                        HashMap orgObj = first.get();
                        taxOrgId = (Long)orgObj.get("orgId");
                    } else {
                        taxOrgId = (Long)((HashMap)orglist.get(0)).get("orgId");
                    }
                } else {
                    taxOrgId = accountOrgId;
                }
                TaxResult taxcMainByOrgIdAndIsTaxpayer = TaxcMainDataServiceHelper.isTaxcMainByOrgIdAndIsTaxpayer((Long)taxOrgId);
                if (taxcMainByOrgIdAndIsTaxpayer.isSuccess() && ((Boolean)taxcMainByOrgIdAndIsTaxpayer.getData()).booleanValue()) {
                    this.getModel().setValue(this.TAXORG, (Object)taxOrgId);
                }
            }
            this.getModel().setValue(this.ASSETDATA, null);
        }
        if (this.TAXORG.equals(name)) {
            this.getModel().setValue(this.TAXATIONSYS, null);
            this.getModel().setValue(this.TAXAREA, null);
        }
        if (this.TAXATIONSYS.equals(name)) {
            this.getModel().setValue(this.TAXAREA, null);
        }
    }

    private List<Long> getTaxareIdsByTaxationsysIdAndOrgId(long taxOrgId, long taxationsysId) {
        DynamicObject object = BusinessDataServiceHelper.loadSingle((String)"bastax_taxorg", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)taxOrgId), new QFilter("entryentity.entry_taxationsys", "=", (Object)taxationsysId)});
        Optional<DynamicObject> taxationsys = object.getDynamicObjectCollection("entryentity").stream().filter(e -> e.getDynamicObject("entry_taxationsys").getLong("id") == taxationsysId).findFirst();
        return taxationsys.map(dynamicObject -> dynamicObject.getDynamicObjectCollection("entry_taxarea").stream().map(e -> e.getLong("fbasedataid_id")).collect(Collectors.toList())).orElseGet(ArrayList::new);
    }

    private List<Long> getTaxationsysIdsByOrgId(long taxOrgId) {
        DynamicObjectCollection query = QueryServiceHelper.query((String)"bastax_taxorg", (String)"entryentity.entry_taxationsys as taxationsys", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)taxOrgId)});
        return query.stream().map(e -> e.getLong("taxationsys")).collect(Collectors.toList());
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        FormOperate source = (FormOperate)args.getSource();
        String operateKey = source.getOperateKey();
        if (args.getOperationResult().isSuccess() && "policy".equals(operateKey)) {
            this.policyConfirmationHandle();
        }
        if (args.getOperationResult().isSuccess() && "cancelpolicy".equals(operateKey)) {
            this.cancelPolicyconfirmationhandle();
        }
    }

    private void policyConfirmationHandle() {
        BigDecimal assetsvalue = (BigDecimal)this.getModel().getValue(this.ASSETSVALUE);
        BigDecimal taxbase = (BigDecimal)this.getModel().getValue(this.TAXBASE);
        String accdepreciationmethod = (String)this.getModel().getValue(this.ACCDEPRECIATIONMETHOD);
        DynamicObject taxdepreciation = (DynamicObject)this.getModel().getValue(this.TAXDEPRECIATION);
        String taxdepreciationName = "";
        taxdepreciationName = taxdepreciation == null ? taxdepreciationName : taxdepreciation.getString("name");
        int accamortizationperiods = (Integer)this.getModel().getValue(this.ACCAMORTIZATIONPERIODS);
        int taxamortizationperiods = (Integer)this.getModel().getValue(this.TAXAMORTIZATIONPERIODS);
        if (assetsvalue.compareTo(taxbase) != 0 || !taxdepreciationName.equals(accdepreciationmethod) || accamortizationperiods != taxamortizationperiods) {
            this.getModel().setValue("booktaxdifferent", (Object)"1");
        } else {
            this.getModel().setValue("booktaxdifferent", (Object)"0");
        }
        String booktaxdifferenttype = ",";
        if (assetsvalue.compareTo(taxbase) != 0) {
            booktaxdifferenttype = "0,";
        }
        if (accamortizationperiods != taxamortizationperiods) {
            booktaxdifferenttype = booktaxdifferenttype + "1,";
        }
        if (!taxdepreciationName.equals(accdepreciationmethod)) {
            booktaxdifferenttype = booktaxdifferenttype + "2,";
        }
        this.getModel().setValue("booktaxdifferenttype", (Object)booktaxdifferenttype);
        Object id = this.getModel().getValue("id");
        DynamicObject object = BusinessDataServiceHelper.loadSingle((Object)id, (String)"tdm_asset_taxc_card");
        object.set("booktaxdifferenttype", this.getModel().getValue("booktaxdifferenttype"));
        object.set("booktaxdifferent", this.getModel().getValue("booktaxdifferent"));
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{object});
        this.getModel().setDataChanged(false);
    }

    private void cancelPolicyconfirmationhandle() {
        Object id = this.getModel().getValue("id");
        DynamicObject object = BusinessDataServiceHelper.loadSingle((Object)id, (String)"tdm_asset_taxc_card");
        object.set("booktaxdifferenttype", (Object)"");
        object.set("booktaxdifferent", (Object)"");
        object.set("depreciationstatus", (Object)"0");
        object.set("taxdepreciatedperiods", (Object)0);
        object.set("taxsurplusdepperiods", (Object)0);
        object.set("taxcurrentdepamount", (Object)BigDecimal.ZERO);
        object.set("taxthisyeardepamount", (Object)BigDecimal.ZERO);
        object.set("taxaccumulateddepamount", (Object)BigDecimal.ZERO);
        this.getModel().setValue("booktaxdifferenttype", (Object)"");
        this.getModel().setValue("booktaxdifferent", (Object)"");
        this.getModel().setValue("depreciationstatus", (Object)"0");
        this.getModel().setValue("taxdepreciatedperiods", (Object)0);
        this.getModel().setValue("taxsurplusdepperiods", (Object)0);
        this.getModel().setValue("taxcurrentdepamount", (Object)BigDecimal.ZERO);
        this.getModel().setValue("taxthisyeardepamount", (Object)BigDecimal.ZERO);
        this.getModel().setValue("taxaccumulateddepamount", (Object)BigDecimal.ZERO);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{object});
        this.getModel().setDataChanged(false);
    }
}

