/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tdm.formplugin.depreciationAmortization;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.form.plugin.impt.BatchImportPlugin;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.tdm.common.util.DateUtils;
import kd.taxc.tdm.common.util.StringUtil;

public class AssetDataImportPlugin
extends BatchImportPlugin {
    private static Log log = LogFactory.getLog(AssetDataImportPlugin.class);
    private static final String ASSET_LIST_DATA = "tdm_asset_data";
    private List<String> orgAssetPeriodCodeList = new ArrayList<String>();

    public String getDefaultKeyFields() {
        return "org,assetcode,accountingperiod";
    }

    public String getBillFormId() {
        return super.getBillFormId();
    }

    public String getDefaultImportType() {
        return super.getDefaultImportType();
    }

    protected ApiResult save(List<ImportBillData> datas, ImportLogger importlogs) {
        Map option = this.ctx.getOption();
        String importtype = option.get("importtype").toString();
        if (!importtype.equals("new")) {
            boolean selectFields;
            String keyFields = option.get("KeyFields").toString();
            boolean bl = selectFields = keyFields.contains("org") && keyFields.contains("assetcode") && keyFields.contains("accountingperiod");
            if (!selectFields) {
                return this.mockResult(String.format(ResManager.loadKDString((String)"\u201c\u66f4\u65b0\u5df2\u6709\u6570\u636e\u201d\u3001\u201c\u66f4\u65b0\u5df2\u6709\u6570\u636e\u5e76\u6dfb\u52a0\u65b0\u6570\u636e\u201d\u65f6\uff0c\u201c\u6570\u636e\u66ff\u6362\u89c4\u5219\u201d\u7684\u552f\u4e00\u503c\u4e0b\u62c9\u9009\u9879\u4e2d\u201c\u6838\u7b97\u7ec4\u7ec7\u201d\u3001\u201c\u8d44\u4ea7\u7f16\u7801\u201d\u3001\u201c\u4f1a\u8ba1\u671f\u95f4\u201d\u4e3a\u5fc5\u9009\u9879\u3002", (String)"AssetDataImportPlugin_0", (String)"taxc-tdm-formplugin", (Object[])new Object[0]), new Object[0]));
            }
        }
        if (null == datas) {
            return this.mockResult(String.format(ResManager.loadKDString((String)"\u8d44\u4ea7\u6e05\u5355 \u6570\u636e\u4e3a\u7a7a\uff0c\u8bf7\u7ef4\u62a4\u6570\u636e\u3002", (String)"AssetDataImportPlugin_1", (String)"taxc-tdm-formplugin", (Object[])new Object[0]), new Object[0]));
        }
        Iterator<ImportBillData> it = datas.iterator();
        while (it.hasNext()) {
            QFilter pFilter;
            QFilter qFilter;
            DynamicObject obj;
            ImportBillData data = it.next();
            String orgNumber = "";
            String assetcode = "";
            String accountingPeriodStr = "";
            try {
                orgNumber = (String)((Map)data.getData().get((Object)"org")).get("number");
                assetcode = data.getData().getString("assetcode");
                accountingPeriodStr = data.getData().getString("accountingperiod");
                accountingPeriodStr = DateUtils.format((Date)DateUtils.getFirstDateOfMonth((Date)DateUtils.stringToDate((String)accountingPeriodStr)), (String)"yyyy-MM-dd");
                data.getData().put("accountingperiod", (Object)accountingPeriodStr);
            }
            catch (Exception e) {
                log.error("Illigal Params: " + e);
            }
            if (StringUtil.isEmpty((CharSequence)orgNumber)) {
                importlogs.log(Integer.valueOf(data.getStartIndex()), String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u7ec4\u7ec7\u7f16\u7801\u201d\u3002", (String)"AssetDataImportPlugin_2", (String)"taxc-tdm-formplugin", (Object[])new Object[0]), new Object[0])).fail();
                it.remove();
                continue;
            }
            if (StringUtil.isEmpty((CharSequence)assetcode)) {
                importlogs.log(Integer.valueOf(data.getStartIndex()), String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u8d44\u4ea7\u7f16\u7801\u201d\u3002", (String)"AssetDataImportPlugin_3", (String)"taxc-tdm-formplugin", (Object[])new Object[0]), new Object[0])).fail();
                it.remove();
                continue;
            }
            if (StringUtil.isEmpty((CharSequence)accountingPeriodStr)) {
                importlogs.log(Integer.valueOf(data.getStartIndex()), String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u4f1a\u8ba1\u671f\u95f4\u201d\u3002", (String)"AssetDataImportPlugin_4", (String)"taxc-tdm-formplugin", (Object[])new Object[0]), new Object[0])).fail();
                it.remove();
                continue;
            }
            Long orgId = null;
            QFilter orgFilter = new QFilter("number", "=", (Object)orgNumber);
            DynamicObject org = QueryServiceHelper.queryOne((String)"bos_org", (String)"id", (QFilter[])new QFilter[]{orgFilter});
            if (org != null) {
                orgId = org.getLong("id");
            }
            if ((obj = QueryServiceHelper.queryOne((String)ASSET_LIST_DATA, (String)"id, assetname", (QFilter[])new QFilter[]{qFilter = new QFilter("taxorg", "=", (Object)orgId), pFilter = new QFilter("assetcode", "=", (Object)assetcode)})) == null || obj.get("id") == null) {
                importlogs.log(Integer.valueOf(data.getStartIndex()), String.format(ResManager.loadKDString((String)"\u8d44\u4ea7\u6e05\u5355\u4e0d\u5b58\u5728\u7ec4\u7ec7\u4e3a\u201c%1$s\u201d\uff0c\u8d44\u4ea7\u7f16\u7801\u4e3a\u201c%2$s\u201d\u7684\u8d44\u4ea7\uff0c\u8bf7\u5148\u7ef4\u62a4\u8d44\u4ea7\u6e05\u5355\u3002", (String)"AssetDataImportPlugin_5", (String)"taxc-tdm-formplugin", (Object[])new Object[0]), orgNumber, assetcode)).fail();
                it.remove();
                continue;
            }
            String uniqCode = orgNumber + "," + assetcode + "," + accountingPeriodStr;
            if (this.orgAssetPeriodCodeList.contains(uniqCode)) {
                importlogs.log(Integer.valueOf(data.getStartIndex()), String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u7f16\u7801+\u8d44\u4ea7\u7f16\u7801+\u4f1a\u8ba1\u671f\u95f4\u91cd\u590d\u3002", (String)"AssetDataImportPlugin_6", (String)"taxc-tdm-formplugin", (Object[])new Object[0]), new Object[0])).fail();
                it.remove();
                continue;
            }
            this.orgAssetPeriodCodeList.add(uniqCode);
            data.getData().put("assetname", (Object)obj.getString("assetname"));
            data.getData().put("modifytime", (Object)new Date());
            data.getData().put("modifier", (Object)RequestContext.get().getCurrUserId());
            if ("new".equals(importtype)) {
                data.getData().put("datasource", (Object)"import");
                continue;
            }
            if (!"overridenew".equals(importtype)) continue;
            try {
                QFilter oFilter = new QFilter("org", "=", (Object)orgId);
                QFilter periodFilter = new QFilter("accountingperiod", "=", (Object)DateUtils.stringToDate((String)accountingPeriodStr));
                boolean exists = QueryServiceHelper.exists((String)"tdm_account_depreciation", (QFilter[])new QFilter[]{oFilter, pFilter, periodFilter});
                if (exists) continue;
                data.getData().put("datasource", (Object)"import");
            }
            catch (Throwable e) {
                log.error("overridenew datasource field handle error" + e.getMessage());
            }
        }
        return super.save(datas, importlogs);
    }

    private ApiResult mockResult(String resultData) {
        ApiResult result = new ApiResult();
        result.setMessage(resultData);
        result.setSuccess(false);
        return result;
    }
}

