/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tdm.formplugin.depreciationAmortization;

import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.form.plugin.impt.BatchImportPlugin;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.taxc.tdm.common.util.StringUtil;

public class AssetListImportPlugin
extends BatchImportPlugin {
    private static Log log = LogFactory.getLog(AssetListImportPlugin.class);
    private static final String ORG_CODE = "taxorg";
    private static final String ASSET_CODE = "assetcode";

    public String getDefaultKeyFields() {
        return "taxorg,assetcode";
    }

    protected ApiResult save(List<ImportBillData> datas, ImportLogger importlogs) {
        Map option = this.ctx.getOption();
        if (!option.get("importtype").toString().equals("new")) {
            boolean selectFields;
            String keyFields = option.get("KeyFields").toString();
            boolean bl = selectFields = keyFields.contains(ORG_CODE) && keyFields.contains(ASSET_CODE);
            if (!selectFields) {
                return this.mockResult(String.format(ResManager.loadKDString((String)"\u201c\u66f4\u65b0\u5df2\u6709\u6570\u636e\u201d\u3001\u201c\u66f4\u65b0\u5df2\u6709\u6570\u636e\u5e76\u6dfb\u52a0\u65b0\u6570\u636e\u201d\u65f6\uff0c\u201c\u6570\u636e\u66ff\u6362\u89c4\u5219\u201d\u7684\u552f\u4e00\u503c\u4e0b\u62c9\u9009\u9879\u4e2d\u201c\u6838\u7b97\u7ec4\u7ec7\u201d\u3001\u201c\u8d44\u4ea7\u7f16\u7801\u201d\u4e3a\u5fc5\u9009\u9879\u3002", (String)"AssetListImportPlugin_0", (String)"taxc-tdm-formplugin", (Object[])new Object[0]), new Object[0]));
            }
        }
        if (null == datas) {
            return this.mockResult(String.format(ResManager.loadKDString((String)"\u5f15\u5165\u6570\u636e\u4e3a\u7a7a\uff0c\u8bf7\u7ef4\u62a4\u6570\u636e\u3002", (String)"AssetListImportPlugin_1", (String)"taxc-tdm-formplugin", (Object[])new Object[0]), new Object[0]));
        }
        for (ImportBillData data : datas) {
            String orgNumber = "";
            String assetcode = "";
            try {
                orgNumber = (String)((Map)data.getData().get((Object)ORG_CODE)).get("number");
                assetcode = (String)data.getData().get((Object)ASSET_CODE);
            }
            catch (Exception e) {
                log.error("Illigal Params: " + e);
            }
            if (StringUtil.isEmpty((CharSequence)orgNumber)) {
                return this.mockResult(String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u7ec4\u7ec7\u7f16\u7801\u201d\u3002", (String)"AssetListImportPlugin_2", (String)"taxc-tdm-formplugin", (Object[])new Object[0]), new Object[0]));
            }
            if (!StringUtil.isEmpty((CharSequence)assetcode)) continue;
            return this.mockResult(String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u8d44\u4ea7\u7f16\u7801\u201d\u3002", (String)"AssetListImportPlugin_3", (String)"taxc-tdm-formplugin", (Object[])new Object[0]), new Object[0]));
        }
        return super.save(datas, importlogs);
    }

    private ApiResult mockResult(String resultData) {
        ApiResult result = new ApiResult();
        result.setMessage(resultData);
        result.setSuccess(false);
        return result;
    }
}

