/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tdm.formplugin.depreciationAmortization;

import com.alibaba.fastjson.JSONObject;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.BeforeImportDataEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Save;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.util.CollectionUtils;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.bastax.taxarea.TaxcAreaDataServiceHelper;
import kd.taxc.bdtaxr.common.helper.tpo.depreciation.TpoDepreciationServiceHelper;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tdm.business.depreciation.AssetTypeMappingServiceHelper;

public class AssetTypeMappingPlugin
extends AbstractBasePlugIn
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit taxarea = (BasedataEdit)this.getControl("taxarea");
        taxarea.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit taxassettype = (BasedataEdit)this.getControl("taxassettype");
        taxassettype.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        QFilter idQFilter;
        String name = beforeF7SelectEvent.getProperty().getName();
        ListShowParameter listShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        DynamicObject taxationsys = (DynamicObject)this.getModel().getValue("taxationsys");
        DynamicObject taxarea = (DynamicObject)this.getModel().getValue("taxarea");
        if ("taxarea".equals(name)) {
            if (taxationsys != null) {
                List areaGroupIds;
                TaxResult listTaxResult = TaxcAreaDataServiceHelper.loadTaxcAreaByCountryId((Long)taxationsys.getLong("countryid.id"));
                if (listTaxResult != null && !CollectionUtils.isEmpty((Collection)((Collection)listTaxResult.getData())) && !CollectionUtils.isEmpty(areaGroupIds = ((List)listTaxResult.getData()).stream().map(o -> o.getLong("group.id")).collect(Collectors.toList()))) {
                    idQFilter = new QFilter("id", "in", areaGroupIds);
                    listShowParameter.getListFilterParameter().setFilter(idQFilter);
                }
            } else {
                List areaAvailableGroupIds;
                TaxResult taxareaTaxResult = TaxcAreaDataServiceHelper.loadTaxcAreaAvailable();
                if (taxareaTaxResult != null && !CollectionUtils.isEmpty((Collection)((Collection)taxareaTaxResult.getData())) && !CollectionUtils.isEmpty(areaAvailableGroupIds = ((List)taxareaTaxResult.getData()).stream().map(o -> o.getLong("group.id")).collect(Collectors.toList()))) {
                    idQFilter = new QFilter("id", "in", areaAvailableGroupIds);
                    listShowParameter.getListFilterParameter().setFilter(idQFilter);
                }
            }
        }
        if ("taxassettype".equals(name)) {
            if (taxationsys != null && taxarea != null) {
                TaxResult ybDepreciationEnableTaxResult = TpoDepreciationServiceHelper.loadTpoYbDepreciationEnable((Long)taxationsys.getLong("id"), (Long)taxarea.getLong("id"));
                if (ybDepreciationEnableTaxResult != null && !CollectionUtils.isEmpty((Collection)((Collection)ybDepreciationEnableTaxResult.getData()))) {
                    List ybDepreciationEnableIds = ((List)ybDepreciationEnableTaxResult.getData()).stream().map(o -> o.getLong("id")).collect(Collectors.toList());
                    if (!CollectionUtils.isEmpty(ybDepreciationEnableIds)) {
                        idQFilter = new QFilter("id", "in", ybDepreciationEnableIds);
                        listShowParameter.getListFilterParameter().setFilter(idQFilter);
                    }
                } else {
                    QFilter idQFilter2 = new QFilter("id", "=", (Object)0L);
                    listShowParameter.getListFilterParameter().setFilter(idQFilter2);
                }
            } else {
                beforeF7SelectEvent.setCancel(true);
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7a0e\u6536\u5236\u5ea6\u548c\u7a0e\u6536\u8f96\u533a\u3002", (String)"AssetTypeMappingPlugin_5", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        ChangeData changeData = changeSet[0];
        if ("startdate".equals(name) || "enddate".equals(name)) {
            int rowIndex = changeData.getRowIndex();
            Date startdate = (Date)this.getModel().getValue("startdate", rowIndex);
            Date enddate = (Date)this.getModel().getValue("enddate", rowIndex);
            this.checkDate(startdate, enddate);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        if (args.getSource() instanceof Save) {
            DynamicObject taxationsys = (DynamicObject)this.getModel().getValue("taxationsys");
            DynamicObject taxarea = (DynamicObject)this.getModel().getValue("taxarea");
            if (taxationsys != null && taxarea != null) {
                String number;
                String entity = this.getModel().getDataEntityType().getName();
                boolean isexist = AssetTypeMappingServiceHelper.isExistMapping((String)entity, (String)(number = (String)this.getModel().getValue("number")), (Long)taxationsys.getLong("id"), (Long)taxarea.getLong("id"));
                if (isexist) {
                    this.getModel().setValue("enable", (Object)"0");
                } else {
                    this.getModel().setValue("enable", (Object)"1");
                }
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        String enable;
        FormOperate operate = (FormOperate)evt.getSource();
        String key = evt.getOperateKey();
        if ("save".equals(key) && evt.getOperationResult().isSuccess() && "0".equals(enable = (String)this.getModel().getValue("enable"))) {
            operate.getOption().setVariableValue("isshowmessage", "fasle");
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u4fdd\u5b58\u6210\u529f\uff0c\u4f46\u76f8\u540c\u7a0e\u5236\u548c\u8f96\u533a\u5df2\u5b58\u5728\u53ef\u7528\u7684\u8d44\u4ea7\u7c7b\u522b\u6620\u5c04\u5173\u7cfb\uff0c\u6682\u5b58\u4e3a\u7981\u7528\u72b6\u6001\u3002", (String)"AssetTypeMappingPlugin_0", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
        }
    }

    public void beforeImportData(BeforeImportDataEventArgs args) {
        boolean isexist;
        String entity = this.getModel().getDataEntityType().getName();
        Map sourceData = args.getSourceData();
        String enable = (String)sourceData.get("enable");
        String name = (String)((Map)sourceData.get("name")).get("zh_CN");
        JSONObject taxationsys = (JSONObject)sourceData.get("taxationsys");
        JSONObject taxarea = (JSONObject)sourceData.get("taxarea");
        if (("1".equals(enable) || enable == null) && taxationsys != null && taxarea != null && (isexist = AssetTypeMappingServiceHelper.isExistMapping((String)entity, (String)name, (String)taxationsys.getString("name"), (String)taxarea.getString("name")))) {
            sourceData.put("enable", "0");
        }
    }

    private boolean checkDate(Date skssqq, Date skssqz) {
        if (skssqq == null) {
            return false;
        }
        int dayOfDate = DateUtils.getDayOfDate((Date)skssqq);
        if (dayOfDate != 1) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6709\u6548\u671f\u8d77\u5fc5\u987b\u662f\u6708\u521d\u3002", (String)"AssetTypeMappingPlugin_1", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (skssqz != null) {
            int dayOfDate2;
            int dayOfDate1 = DateUtils.getDayOfDate((Date)DateUtils.getLastDateOfMonth((Date)skssqz));
            if (dayOfDate1 != (dayOfDate2 = DateUtils.getDayOfDate((Date)skssqz))) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6709\u6548\u671f\u6b62\u5fc5\u987b\u662f\u6708\u672b\u3002", (String)"AssetTypeMappingPlugin_2", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
                return false;
            }
            if (skssqq.after(skssqz)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6709\u6548\u671f\u8d77\u4e0d\u80fd\u5927\u4e8e\u6709\u6548\u671f\u6b62\u3002", (String)"AssetTypeMappingPlugin_3", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
                return false;
            }
        }
        return true;
    }
}

