/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tdm.formplugin.depreciationAmortization;

import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.CloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.form.JobForm;
import kd.bos.schedule.form.JobFormInfo;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.tdm.business.assettaxcard.AssetTaxCardTaskClick;
import kd.taxc.tdm.business.depreciation.task.AutoGenerateTask;

public class AutoGenerateAssetCardPlugin
extends AbstractFormPlugin {
    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"btnok"});
        this.addClickListeners(new String[]{"btnok"});
    }

    public void afterCreateNewData(EventObject e) {
        String orgid = (String)this.getView().getFormShowParameter().getCustomParam("orgid");
        if (StringUtil.isNotBlank((CharSequence)orgid)) {
            this.getModel().setValue("accountorgs", (Object)new Object[]{Long.parseLong(orgid)});
        }
        this.getModel().setValue("accountingperiod", (Object)DateUtils.addMonth((Date)DateUtils.getFirstDateOfMonth((Date)new Date()), (int)-1));
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        String confirm = "confirm";
        String operateKey = evt.getOperateKey();
        if (confirm.equals(operateKey) && evt.getOperationResult().isSuccess()) {
            DynamicObjectCollection accountorgs = (DynamicObjectCollection)this.getModel().getValue("accountorgs");
            Date accountingpreiod = (Date)this.getModel().getValue("accountingperiod");
            Map<String, String> accountorgMap = accountorgs.stream().collect(Collectors.toMap(k -> k.getString("fbasedataid_id"), v -> v.getDynamicObject("fbasedataid").getString("name"), (k1, k2) -> k1));
            this.dispatch(DateUtils.format((Date)accountingpreiod), accountorgMap);
        }
    }

    private void dispatch(String startdate, Map<String, String> accountorgMap) {
        HashMap<String, Object> params = new HashMap<String, Object>(16);
        params.put("orgmap", accountorgMap);
        params.put("accountingperiod", startdate);
        params.put("method", "auto");
        this.dispatch(params);
    }

    private void dispatch(Map<String, Object> customParams) {
        String appId = this.getView().getFormShowParameter().getAppId();
        JobInfo jobInfo = new JobInfo();
        jobInfo.setAppId(appId);
        jobInfo.setRunByUserId(RequestContext.get().getCurrUserId());
        jobInfo.setJobType(JobType.REALTIME);
        jobInfo.setName(ResManager.loadKDString((String)"\u81ea\u52a8\u751f\u6210\u4efb\u52a1\u8fdb\u5ea6", (String)"AutoGenerateAssetCardPlugin_0", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
        jobInfo.setId(UUID.randomUUID().toString());
        jobInfo.setTaskClassname(AutoGenerateTask.class.getName());
        jobInfo.setParams(customParams);
        jobInfo.setRunByLang(Lang.get());
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "taskcloseback");
        JobFormInfo jobFormInfo = new JobFormInfo(jobInfo);
        jobFormInfo.setCaption(ResManager.loadKDString((String)"\u7a0e\u52a1\u8d44\u4ea7\u5361\u7247\u6570\u636e\u8ba1\u7b97\u8fdb\u5ea6", (String)"AutoGenerateAssetCardPlugin_1", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
        jobFormInfo.setCloseCallBack(closeCallBack);
        jobFormInfo.setCanBackground(true);
        jobFormInfo.setClickClassName(AssetTaxCardTaskClick.class.getName());
        JobForm.dispatch((JobFormInfo)jobFormInfo, (IFormView)this.getView());
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        if (EmptyCheckUtils.isNotEmpty((Object)evt.getReturnData())) {
            Object returnData = evt.getReturnData();
            this.getView().returnDataToParent(returnData);
            this.getView().close();
        }
    }
}

