/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tdm.formplugin.element;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.container.Tab;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectListener;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.taxc.tdm.common.helper.ElementSqlServiceHelper;
import kd.taxc.tdm.common.helper.FormulaModifyHelper;
import kd.taxc.tdm.common.util.EmptyCheckUtils;
import kd.taxc.tdm.formplugin.element.enums.EleBizCheckListboxEnum;
import kd.taxc.tdm.formplugin.element.util.ElementUtil;

public class EleBizCheckPlugin
extends AbstractListPlugin
implements BeforeFilterF7SelectListener,
TabSelectListener,
TreeNodeClickListener {
    private static final String KEY_TABAP = "tabap";
    private static final String KEY_BILLLIST = "billlistap";
    private static final String KEY_TREEVIEWAP = "treeviewap";
    private static final String CACHE_ELE_ID = "cache_ele_id";
    private static final String CACHE_TAB_ID = "cache_tab_id";

    public void beforeF7Select(BeforeFilterF7SelectEvent beforeFilterF7SelectEvent) {
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        for (EleBizCheckListboxEnum value : EleBizCheckListboxEnum.values()) {
            BillList billList = (BillList)this.getView().getControl(value.getBillKey());
            billList.addSetFilterListener(this::setFilter);
        }
        TreeView treeView = (TreeView)this.getView().getControl(KEY_TREEVIEWAP);
        treeView.addTreeNodeClickListener((TreeNodeClickListener)this);
        Tab tab = (Tab)this.getView().getControl(KEY_TABAP);
        tab.addTabSelectListener((TabSelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        this.constructorData();
    }

    private void constructorData() {
        TreeView tv1 = (TreeView)this.getView().getControl(KEY_TREEVIEWAP);
        String rootId = "0";
        TreeNode rootNode = new TreeNode(null, "0", ResManager.loadKDString((String)"\u5168\u90e8", (String)"EleBizCheckPlugin_0", (String)"taxc-tdm-formplugin", (Object[])new Object[0]), false);
        rootNode.setIsOpened(true);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (EmptyCheckUtils.isNotEmpty((Object)customParams) && EmptyCheckUtils.isNotEmpty(customParams.get("ids"))) {
            DynamicObject[] dynamicObject;
            for (DynamicObject ele : dynamicObject = BusinessDataServiceHelper.load((String)"tdm_element_group", (String)"id,name", (QFilter[])new QFilter[]{new QFilter("id", "in", customParams.get("ids"))})) {
                TreeNode tn = new TreeNode("0", ele.getString("id"), ele.getString("name"));
                rootNode.addChild(tn);
            }
            this.getPageCache().put(CACHE_ELE_ID, dynamicObject[0].getString("id"));
        }
        this.getPageCache().put(CACHE_TAB_ID, EleBizCheckListboxEnum.CHECK_UNQ.getKey());
        tv1.addNode(rootNode);
        TreeNode treeNode = rootNode.getTreeNode(this.getPageCache().get(CACHE_ELE_ID), 100);
        tv1.focusNode(treeNode);
        tv1.treeNodeClick(treeNode.getParentid(), treeNode.getId());
        tv1.getTreeState().setKey(treeNode.getId());
        tv1.setRootVisible(false);
        EleBizCheckListboxEnum tabEnum = EleBizCheckListboxEnum.getEnumByCode(this.getPageCache().get(CACHE_TAB_ID));
        BillList billList = (BillList)this.getControl(tabEnum.getBillKey());
        billList.addSetFilterListener(this::setFilter);
        billList.refresh();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
    }

    private void addQFiltersByUp(List<QFilter> qFilters, DynamicObject ele) {
        QFilter qFilter = new QFilter("json_tag", "like", (Object)("%" + ele.getString("number") + "%"));
        QFilter qFilter2 = new QFilter("enable", "=", (Object)"1");
        Integer subtimedeviationtype = EmptyCheckUtils.isEmpty((Object)ele.get("timedeviationtype")) ? 1 : ele.getInt("timedeviationtype");
        DynamicObject[] tdm_element_groups = BusinessDataServiceHelper.load((String)"tdm_element_group", (String)"id,timedeviationtype", (QFilter[])new QFilter[]{qFilter, qFilter2});
        ArrayList<Long> ids = new ArrayList<Long>(10);
        for (DynamicObject dynamicObject : tdm_element_groups) {
            if (subtimedeviationtype >= dynamicObject.getInt("timedeviationtype") || ids.contains(dynamicObject.getLong("id"))) continue;
            ids.add(dynamicObject.getLong("id"));
        }
        if (EmptyCheckUtils.isEmpty(ids)) {
            qFilters.add(new QFilter("id", "=", (Object)-1L));
        } else {
            qFilters.add(new QFilter("id", "in", ids));
        }
    }

    private void addQFiltersByLow(List<QFilter> qFilters, DynamicObject ele) {
        Boolean bottom = ele.getBoolean("bottom");
        if (bottom.booleanValue()) {
            qFilters.add(new QFilter("id", "=", (Object)-1L));
        } else {
            String json_tag = ele.getString("json_tag");
            if (EmptyCheckUtils.isEmpty((Object)json_tag)) {
                qFilters.add(new QFilter("id", "=", (Object)-1L));
            } else {
                String json = (String)((Map)SerializationUtils.fromJsonString((String)json_tag, Map.class)).get("formula");
                List subEles = FormulaModifyHelper.getFormulaElementInfo((String)json).stream().map(p -> p.split("\\|")[1]).collect(Collectors.toList());
                Map code2EleInfoMap = ElementSqlServiceHelper.queryAllEnableEleInfoMap();
                Integer parenttimedeviationtype = EmptyCheckUtils.isEmpty((Object)ele.get("timedeviationtype")) ? 1 : ele.getInt("timedeviationtype");
                ArrayList<Long> ids = new ArrayList<Long>(10);
                for (String subEle : subEles) {
                    DynamicObject dynamicObject = (DynamicObject)code2EleInfoMap.get(subEle);
                    boolean filter = !"+-*/()<><=>=abs(".contains(subEle) && !ElementUtil.isConstantNumber(subEle, code2EleInfoMap) && EmptyCheckUtils.isNotEmpty((Object)dynamicObject);
                    if (!filter || parenttimedeviationtype <= dynamicObject.getInt("timedeviationtype") || ids.contains(dynamicObject.getLong("id"))) continue;
                    ids.add(dynamicObject.getLong("id"));
                }
                if (EmptyCheckUtils.isEmpty(ids)) {
                    qFilters.add(new QFilter("id", "=", (Object)-1L));
                } else {
                    qFilters.add(new QFilter("id", "in", ids));
                }
            }
        }
    }

    private void addQFiltersByUK(List<QFilter> qFilters, DynamicObject dynamicObject) {
        Boolean bottom = dynamicObject.getBoolean("bottom");
        qFilters.add(new QFilter("timedeviationtype", "=", dynamicObject.get("timedeviationtype")));
        String jsonTag = dynamicObject.getString("json_tag");
        if (bottom.booleanValue()) {
            Map eleInfoMap = ElementSqlServiceHelper.queryAllEnableEleInfoMap();
            if (EmptyCheckUtils.isEmpty((Object)eleInfoMap)) {
                qFilters.add(new QFilter("id", "=", (Object)-1L));
            } else {
                List<Long> ids = ElementUtil.checkBottomUk(dynamicObject);
                if (EmptyCheckUtils.isEmpty(ids)) {
                    qFilters.add(new QFilter("id", "=", (Object)-1L));
                } else {
                    qFilters.add(new QFilter("id", "in", ids));
                }
            }
        } else {
            qFilters.add(new QFilter("json_tag", "=", (Object)jsonTag));
        }
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        if (EmptyCheckUtils.isNotEmpty((Object)this.getPageCache().get(CACHE_TAB_ID))) {
            String itemId = this.getPageCache().get(CACHE_TAB_ID);
            EleBizCheckListboxEnum enumByCode = EleBizCheckListboxEnum.getEnumByCode(itemId);
            if (null == enumByCode) {
                throw new KDBizException("TAB itemId=" + itemId + " not found");
            }
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)this.getPageCache().get(CACHE_ELE_ID), (String)"tdm_element_group");
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>(10);
            qFilters.add(new QFilter("id", "!=", dynamicObject.get("id")));
            qFilters.add(new QFilter("enable", "=", (Object)"1"));
            switch (enumByCode) {
                case CHECK_UNQ: {
                    this.addQFiltersByUK(qFilters, dynamicObject);
                    break;
                }
                case CHECK_LOW: {
                    this.addQFiltersByLow(qFilters, dynamicObject);
                    break;
                }
                case CHECK_UP: {
                    this.addQFiltersByUp(qFilters, dynamicObject);
                    break;
                }
            }
            if (EmptyCheckUtils.isEmpty(qFilters)) {
                qFilters.add(new QFilter("id", "=", (Object)-1L));
            }
            QFilter qFilter = (QFilter)qFilters.get(0);
            if (null != qFilters && qFilters.size() > 1) {
                for (int i = 1; i < qFilters.size(); ++i) {
                    qFilter.and((QFilter)qFilters.get(i));
                }
            }
            List qFilters2 = e.getQFilters();
            qFilters2.add(qFilter);
        }
    }

    public void treeNodeClick(TreeNodeEvent arg0) {
        String id = (String)arg0.getNodeId();
        if ("0".equalsIgnoreCase(id)) {
            return;
        }
        this.getPageCache().put(CACHE_ELE_ID, id);
        EleBizCheckListboxEnum tabEnum = EleBizCheckListboxEnum.getEnumByCode(this.getPageCache().get(CACHE_TAB_ID));
        BillList billList = (BillList)this.getControl(tabEnum.getBillKey());
        billList.addSetFilterListener(this::setFilter);
        billList.refresh();
    }

    public void tabSelected(TabSelectEvent event) {
        String subTabKey = event.getTabKey();
        this.getPageCache().put(CACHE_TAB_ID, subTabKey);
        EleBizCheckListboxEnum tabEnum = EleBizCheckListboxEnum.getEnumByCode(subTabKey);
        BillList billList = (BillList)this.getControl(tabEnum.getBillKey());
        billList.addSetFilterListener(this::setFilter);
        billList.refresh();
    }
}

