/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tdm.formplugin.element;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.taxc.tdm.common.helper.EleCalDailogHelper;
import kd.taxc.tdm.common.util.AppLogUtils;
import kd.taxc.tdm.common.util.DateUtils;
import kd.taxc.tdm.common.util.PermissionUtils;

public class ElementCalDialogPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static Log logger = LogFactory.getLog(ElementCalDialogPlugin.class);
    private static final String BTN_CAL = "btnok";
    private static final String KEY_START = "caldate_startdate";
    private static final String KEY_END = "caldate_enddate";
    private static final String KEY_RUNORG = "org";
    private static final String KEY_ELEMENT = "elements";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{BTN_CAL});
        MulBasedataEdit org = (MulBasedataEdit)this.getView().getControl(KEY_RUNORG);
        org.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if (BTN_CAL.equals(key)) {
            this.confirmMsg();
        }
    }

    public void confirmMsg() {
        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(BTN_CAL, (IFormPlugin)this);
        HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>();
        btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u53d6\u6d88", (String)"ElementCalDialogPlugin_0", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
        btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u786e\u8ba4", (String)"ElementCalDialogPlugin_1", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
        MessageBoxOptions options = MessageBoxOptions.OKCancel;
        String msg = ResManager.loadKDString((String)"\u624b\u52a8\u8ba1\u7b97\u4f1a\u8986\u76d6\u5143\u7d20\u7684\u5386\u53f2\u7ed3\u679c\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"ElementCalDialogPlugin_2", (String)"taxc-tdm-formplugin", (Object[])new Object[0]);
        this.getView().showConfirm(msg, "", options, ConfirmTypes.Save, confirmCallBacks, btnNameMaps);
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        if (BTN_CAL.equals(messageBoxClosedEvent.getCallBackId()) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            this.calculate();
        }
    }

    private void calculate() {
        DynamicObject orgs;
        Date start = (Date)this.getModel().getValue(KEY_START);
        Date end = (Date)this.getModel().getValue(KEY_END);
        Object orgObject = this.getModel().getValue(KEY_RUNORG);
        ArrayList<String> orgids = new ArrayList<String>();
        if (orgObject instanceof DynamicObject) {
            orgs = (DynamicObject)orgObject;
            orgids.add(orgs.getString("id"));
        } else {
            orgs = (DynamicObjectCollection)orgObject;
            for (DynamicObject dynamicObject : orgs) {
                orgids.add(dynamicObject.getDynamicObject("fbasedataid").getString("id"));
            }
        }
        DynamicObjectCollection elements = (DynamicObjectCollection)this.getModel().getValue(KEY_ELEMENT);
        String startDate = DateUtils.format((Date)start, (String)"yyyy-MM-dd");
        String endDate = DateUtils.format((Date)end, (String)"yyyy-MM-dd");
        ArrayList<String> codes = new ArrayList<String>();
        for (DynamicObject dynamicObject : elements) {
            codes.add(dynamicObject.getDynamicObject("fbasedataid").getString("number"));
        }
        EleCalDailogHelper.calculateElement(codes, orgids, (Date)start, (Date)end);
        String opName = ResManager.loadKDString((String)"\u5143\u7d20\u8ba1\u7b97\u3002", (String)"ElementCalDialogPlugin_4", (String)"taxc-tdm-formplugin", (Object[])new Object[0]);
        String opDesc = ResManager.loadKDString((String)"\u8ba1\u7b97\u6210\u529f\u3002", (String)"ElementCalDialogPlugin_3", (String)"taxc-tdm-formplugin", (Object[])new Object[0]);
        AppLogUtils.addLog((String)"tdm_element_result", (String)opName, (String)opDesc);
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u8ba1\u7b97\u6210\u529f\u3002", (String)"ElementCalDialogPlugin_3", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        HasPermOrgResult hasPermOrgResult = PermissionUtils.getAllPermOrgs((IFormView)this.getView().getParentView());
        if (!hasPermOrgResult.hasAllOrgPerm()) {
            List orgList = hasPermOrgResult.getHasPermOrgs();
            QFilter filters = new QFilter("id", "in", (Object)orgList);
            ListShowParameter formShowParameter = (ListShowParameter)event.getFormShowParameter();
            formShowParameter.getListFilterParameter().setFilter(filters);
        }
    }
}

