/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tdm.formplugin.element;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.SelectRowsEventListener;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.tdm.common.util.EmptyCheckUtils;
import kd.taxc.tdm.formplugin.element.EleIndexViewTreeNode;
import kd.taxc.tdm.formplugin.element.enums.EleIndexDataTypeEnum;
import kd.taxc.tdm.formplugin.element.enums.RiskTypeEnum;

public class ElementIndexViewPlugin
extends AbstractFormPlugin
implements SelectRowsEventListener,
RowClickEventListener {
    private static final String CARD_ENTITY = "t_tdm_element_info";
    private static final String LINE = "-";
    private static final String RISK_DEFINITION = "tctrc_risk_definition";
    private static final String ELEMENT_INDEX = "elementindex";

    public void registerListener(EventObject e) {
        CardEntry incomecardList = (CardEntry)this.getView().getControl(CARD_ENTITY);
        incomecardList.addSelectRowsListener((SelectRowsEventListener)this);
        incomecardList.addRowClickListener((RowClickEventListener)this);
        this.addClickListeners(new String[]{ELEMENT_INDEX});
    }

    public void customEvent(CustomEventArgs e) {
        String args = e.getEventArgs();
        if (EmptyCheckUtils.isEmpty((Object)args)) {
            return;
        }
        Map datamap = (Map)SerializationUtils.fromJsonString((String)args, Map.class);
        if (EmptyCheckUtils.isEmpty((Object)datamap)) {
            return;
        }
        String id = (String)datamap.get("id");
        String dataType = (String)datamap.get("dataType");
        if (EleIndexDataTypeEnum.ELEMENT.getCode().equalsIgnoreCase(dataType)) {
            String formid = "tdm_element_group";
            this.showBill(id, formid);
        } else {
            QFilter qFilter = new QFilter("id", "=", (Object)Long.parseLong(id));
            DynamicObject result = QueryServiceHelper.queryOne((String)RISK_DEFINITION, (String)"id,risktype", (QFilter[])new QFilter[]{qFilter});
            if (EmptyCheckUtils.isEmpty((Object)result)) {
                return;
            }
            String risktype = result.getString("risktype");
            String formid = RiskTypeEnum.getEnumByKey(risktype).getFormid();
            this.showBill(id, formid);
        }
    }

    private void showBill(String id, String formid) {
        BillShowParameter parameter = new BillShowParameter();
        parameter.setFormId(formid);
        parameter.setPkId((Object)id);
        parameter.setPageId(id);
        parameter.setStatus(OperationStatus.VIEW);
        parameter.setBillStatus(BillOperationStatus.VIEW);
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)parameter);
    }

    public void entryRowClick(RowClickEvent evt) {
        int row = evt.getRow();
        String elementid = ((DynamicObject)this.getModel().getEntryEntity(CARD_ENTITY).get(row)).getString("idcard");
        CustomControl s = (CustomControl)this.getControl(ELEMENT_INDEX);
        EleIndexViewTreeNode tree = this.createTree(elementid);
        if (EmptyCheckUtils.isEmpty((Object)tree) || EmptyCheckUtils.isEmpty(tree.getChildren())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5143\u7d20\u672a\u88ab\u5f15\u7528", (String)"ElementIndexViewPlugin_0", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
            if (EmptyCheckUtils.isNotEmpty((Object)this.getPageCache().get("lastSelectCard")) && !String.valueOf(row).equalsIgnoreCase(this.getPageCache().get("lastSelectCard"))) {
                CardEntry elementCard = (CardEntry)this.getControl(CARD_ENTITY);
                elementCard.selectCard(Integer.valueOf(Integer.parseInt(this.getPageCache().get("lastSelectCard"))));
            }
            return;
        }
        this.getPageCache().put("lastSelectCard", String.valueOf(evt.getRow()));
        HashMap<String, Object> downward = new HashMap<String, Object>();
        downward.put("direction", "downward");
        downward.put("name", "origin");
        downward.put("rootname", tree.getEleName());
        downward.put("rootnumber", tree.getEleNumber());
        downward.put("rootid", tree.getPkid());
        downward.put("children", tree.getChildren());
        HashMap<String, HashMap<String, Object>> data = new HashMap<String, HashMap<String, Object>>();
        data.put("downward", downward);
        s.setData(data);
    }

    private void initLeftCard(List<Map<String, String>> eleList) {
        this.getModel().beginInit();
        this.getModel().deleteEntryData(CARD_ENTITY);
        for (Map<String, String> eleMap : eleList) {
            int row = this.getModel().createNewEntryRow(CARD_ENTITY);
            this.getModel().setValue("indexcard", (Object)(row + 1), row);
            this.getModel().setValue("namecard", (Object)eleMap.get("name"), row);
            this.getModel().setValue("idcard", (Object)eleMap.get("id"), row);
            this.getModel().setValue("numbercard", (Object)eleMap.get("number"), row);
        }
        this.getModel().endInit();
        this.getView().updateView(CARD_ENTITY);
    }

    public void afterCreateNewData(EventObject e) {
        String elementindex = (String)this.getView().getFormShowParameter().getCustomParam(ELEMENT_INDEX);
        if (EmptyCheckUtils.isNotEmpty((Object)elementindex)) {
            List list = SerializationUtils.fromJsonStringToList((String)elementindex, Map.class);
            this.initLeftCard(list);
        }
    }

    public void afterBindData(EventObject e) {
        String elementindex = (String)this.getView().getFormShowParameter().getCustomParam(ELEMENT_INDEX);
        if (EmptyCheckUtils.isNotEmpty((Object)elementindex)) {
            CardEntry elementCard = (CardEntry)this.getControl(CARD_ENTITY);
            elementCard.selectCard(Integer.valueOf(0));
            this.getPageCache().put("lastSelectCard", "0");
        }
    }

    public DynamicObject queryEleById(String elementid) {
        QFilter codeFilter = new QFilter("id", "=", (Object)Long.parseLong(elementid));
        DynamicObject element = QueryServiceHelper.queryOne((String)"tdm_element_group", (String)"id,name,number,json_tag,bottom,timedeviationcount,timedeviationtype,timedeviationdirection,autorefresh,isvariable,describe,datatype", (QFilter[])new QFilter[]{codeFilter});
        return element;
    }

    public DynamicObject queryEleByNO(String number) {
        QFilter codeFilter = new QFilter("number", "=", (Object)number);
        DynamicObject element = QueryServiceHelper.queryOne((String)"tdm_element_group", (String)"id,name,number,json_tag,bottom,timedeviationcount,timedeviationtype,timedeviationdirection,autorefresh,isvariable,describe,datatype", (QFilter[])new QFilter[]{codeFilter});
        return element;
    }

    private EleIndexViewTreeNode createTree(String elementid) {
        EleIndexViewTreeNode tree = this.doCreateTree(elementid, null);
        return tree;
    }

    private EleIndexViewTreeNode doCreateTree(String elementid, EleIndexViewTreeNode parentNode) {
        if (elementid == null) {
            return new EleIndexViewTreeNode();
        }
        DynamicObject element = this.queryEleById(elementid);
        if (EmptyCheckUtils.isEmpty((Object)element)) {
            return new EleIndexViewTreeNode();
        }
        EleIndexViewTreeNode curNode = new EleIndexViewTreeNode();
        curNode.setId(EmptyCheckUtils.isEmpty((Object)parentNode) ? elementid : parentNode.getId() + LINE + element.getString("id"));
        List<EleIndexViewTreeNode> children = this.prepareChildrenData(element, curNode);
        curNode.setChildren(children);
        this.fillBaseInfoByEle(element, curNode);
        return curNode;
    }

    private void fillBaseInfoByEle(DynamicObject element, EleIndexViewTreeNode curNode) {
        curNode.setEleName(element.getString("name"));
        curNode.setEleNumber(element.getString("number"));
        curNode.setPkid(element.getString("id"));
        curNode.setDataType(EleIndexDataTypeEnum.ELEMENT.getCode());
        curNode.setName(curNode.getEleName());
        curNode.setExpand(true);
    }

    private List<EleIndexViewTreeNode> prepareChildrenData(DynamicObject element, EleIndexViewTreeNode parentNode) {
        QFilter filter = new QFilter("json_tag", "like", (Object)("%" + element.get("number") + "%"));
        QFilter filter2 = new QFilter("bottom", "=", (Object)"0");
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"tdm_element_group", (String)"id,number,name,bottom", (QFilter[])new QFilter[]{filter, filter2});
        if (EmptyCheckUtils.isEmpty((Object)dynamicObjects)) {
            return this.prepareRiskChildrenData(element, parentNode);
        }
        String parentid = element.getString("id");
        List<EleIndexViewTreeNode> children = dynamicObjects.stream().map(ele -> this.prepareEleChildrenData(ele.getString("number"), parentNode)).filter(v -> EmptyCheckUtils.isNotEmpty((Object)v)).peek(v -> {
            v.setParentId(parentid);
            v.setId(parentNode.getId() + LINE + v.getPkid());
            v.setDataType(EleIndexDataTypeEnum.ELEMENT.getCode());
        }).collect(Collectors.toList());
        children.addAll(this.prepareRiskChildrenData(element, parentNode));
        return children;
    }

    private List<EleIndexViewTreeNode> prepareRiskChildrenData(DynamicObject element, EleIndexViewTreeNode parentNode) {
        DynamicObjectCollection dynamicObjects;
        QFilter qFilter = new QFilter("json", "like", (Object)("%" + element.getString("number") + "%"));
        QFilter qFilter2 = new QFilter("entryentity.explain", "like", (Object)("%${" + element.getString("name") + "%"));
        qFilter.or(qFilter2);
        QFilter qFilter3 = new QFilter("entryentity.text", "like", (Object)("%" + element.getString("number") + "%"));
        QFilter qFilter4 = new QFilter("risklevelentryentity.explain", "like", (Object)("%${" + element.getString("name") + "%"));
        qFilter3.or(qFilter4);
        DynamicObjectCollection bds = QueryServiceHelper.query((String)"tctrc_element_verify", (String)"id", (QFilter[])new QFilter[]{qFilter3});
        if (EmptyCheckUtils.isNotEmpty((Object)bds)) {
            List bdids = bds.stream().map(v -> v.getLong("id")).distinct().collect(Collectors.toList());
            QFilter qFilter5 = new QFilter("id", "in", bdids);
            qFilter.or(qFilter5);
        }
        QFilter qFilter5 = new QFilter("risklevelentryentity.explain", "like", (Object)("%${" + element.getString("name") + "%"));
        DynamicObjectCollection dynamicObject2s = QueryServiceHelper.query((String)"tctrc_risk_sampling", (String)"id", (QFilter[])new QFilter[]{qFilter5});
        if (EmptyCheckUtils.isNotEmpty((Object)dynamicObject2s)) {
            List bdids = bds.stream().map(v -> v.getLong("id")).distinct().collect(Collectors.toList());
            QFilter qFilter6 = new QFilter("id", "in", bdids);
            qFilter.or(qFilter6);
        }
        if (EmptyCheckUtils.isEmpty((Object)(dynamicObjects = QueryServiceHelper.query((String)RISK_DEFINITION, (String)"id,name,number,risktype", (QFilter[])new QFilter[]{qFilter})))) {
            return new ArrayList<EleIndexViewTreeNode>();
        }
        return dynamicObjects.stream().map(v -> this.createRiskNode((DynamicObject)v, element, parentNode)).collect(Collectors.toList());
    }

    private EleIndexViewTreeNode createRiskNode(DynamicObject risk, DynamicObject element, EleIndexViewTreeNode parentNode) {
        EleIndexViewTreeNode riskNode = new EleIndexViewTreeNode();
        riskNode.setRiskName(risk.getString("name"));
        riskNode.setRiskNumber(risk.getString("number"));
        riskNode.setRiskType(RiskTypeEnum.getEnumByKey(risk.getString("risktype")).getTitle());
        riskNode.setName(riskNode.getRiskName());
        riskNode.setPkid(risk.getString("id"));
        riskNode.setParentId(element.getString("id"));
        riskNode.setId(parentNode.getId() + LINE + riskNode.getPkid());
        riskNode.setDataType(EleIndexDataTypeEnum.RISK.getCode());
        riskNode.setChildren(new ArrayList<EleIndexViewTreeNode>());
        return riskNode;
    }

    private EleIndexViewTreeNode prepareEleChildrenData(String eleNumber, EleIndexViewTreeNode curNode) {
        DynamicObject element = this.queryEleByNO(eleNumber);
        if (EmptyCheckUtils.isEmpty((Object)element)) {
            return null;
        }
        return this.doCreateTree(element.getString("id"), curNode);
    }
}

