/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tdm.formplugin.element;

import java.text.DecimalFormat;
import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.column.AbstractColumnDesc;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.taxc.tdm.formplugin.showpage.PageShowCommon;

public class ElementResultListPlugin
extends AbstractListPlugin {
    private static final String TRUE_STRING = "true";
    private static final String NAME = "name";
    private static final String VALUE = "value";
    private static final String CAL_DIALOG_ENTITY = "tdm_calculate_dialog";

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void setFilter(SetFilterEvent e) {
        String str;
        Object val;
        String valStr;
        super.setFilter(e);
        List qFilters = e.getQFilters();
        QFilter qFilter = qFilters.stream().filter(v -> v.getProperty().equalsIgnoreCase(VALUE)).findFirst().orElse(null);
        if (null != qFilter && (valStr = String.valueOf(val = qFilter.getValue())).contains(str = this.getFormatNoValueString())) {
            qFilter.__setValue((Object)valStr.replace(str, "null"));
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        if (args.getOperationResult() != null && args.getOperationResult().isSuccess() && "donothingcalculate".equals(args.getOperateKey())) {
            this.showCalDialog();
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String key = evt.getItemKey();
        if ("calculate".equals(key)) {
            // empty if block
        }
    }

    private void showCalDialog() {
        PageShowCommon.showForm(ShowType.Modal, CAL_DIALOG_ENTITY, this.getView(), null, (IFormPlugin)this);
    }

    public void packageData(PackageDataEvent e) {
        AbstractColumnDesc columnDesc = (AbstractColumnDesc)e.getSource();
        if (columnDesc.getKey().equals(VALUE)) {
            DynamicObject d = e.getRowData();
            String rateTypeValue = d.getString("elementdef.typevalue");
            String value = d.getString(VALUE);
            String isEmptyField = d.getString("isemptyfield");
            if ("null".equalsIgnoreCase(value)) {
                e.setFormatValue((Object)this.getFormatNoValueString());
                return;
            }
            if (TRUE_STRING.equals(rateTypeValue) && !TRUE_STRING.equals(isEmptyField)) {
                DecimalFormat df = new DecimalFormat("#0.00");
                String str = df.format(Double.parseDouble(value) * 100.0);
                e.setFormatValue((Object)(str + "%"));
            }
            if (TRUE_STRING.equals(isEmptyField)) {
                e.setFormatValue((Object)this.getFormatNoValueString());
            }
        } else if (columnDesc.getKey().equals(NAME)) {
            DynamicObject d = e.getRowData();
            e.setFormatValue((Object)StringUtils.trim((String)d.getString(NAME)));
        }
    }

    private String getFormatNoValueString() {
        return ResManager.loadKDString((String)"\u65e0\u6570\u636e", (String)"ElementResultListPlugin_0", (String)"taxc-tdm-formplugin", (Object[])new Object[0]);
    }
}

