/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tdm.formplugin.element.util;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.taxc.tdm.common.helper.ElementSqlServiceHelper;
import kd.taxc.tdm.common.util.DateUtils;
import kd.taxc.tdm.common.util.EmptyCheckUtils;
import org.apache.commons.lang.math.NumberUtils;

public class ElementUtil {
    public static final List<Map<String, String>> parseJson(String json) {
        ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>();
        if (EmptyCheckUtils.isNotEmpty((Object)json)) {
            try {
                List map = SerializationUtils.fromJsonStringToList((String)json, Map.class);
                list.addAll(map);
            }
            catch (Exception e) {
                Map map = (Map)SerializationUtils.fromJsonString((String)json, Map.class);
                list.add(map);
            }
        }
        return list;
    }

    public static final List<Long> checkBottomUk(DynamicObject source) {
        String jsonTag = source.getString("json_tag");
        List<Map<String, String>> ruleList = ElementUtil.parseJson(jsonTag);
        Map eleInfoMap = ElementSqlServiceHelper.queryAllEnableEleInfoMap();
        ArrayList<Long> resultIDs = new ArrayList<Long>(10);
        String datatype = source.getString("datatype");
        String timedeviationcount = source.getString("timedeviationcount");
        for (Map.Entry eleEntry : eleInfoMap.entrySet()) {
            List<Map<String, String>> compareEleRuleList;
            String compareEleJsonTag;
            DynamicObject compareEle = (DynamicObject)eleEntry.getValue();
            if (null == compareEle || !compareEle.getBoolean("bottom") || compareEle.getString("id").equalsIgnoreCase(source.getString("id")) || !datatype.equalsIgnoreCase(compareEle.getString("datatype")) || !timedeviationcount.equalsIgnoreCase(compareEle.getString("timedeviationcount")) || EmptyCheckUtils.isEmpty((Object)(compareEleJsonTag = compareEle.getString("json_tag"))) || EmptyCheckUtils.isEmpty(compareEleRuleList = ElementUtil.parseJson(compareEleJsonTag)) || ruleList.size() != compareEleRuleList.size()) continue;
            boolean isSame = true;
            for (Map<String, String> compareEleMap : compareEleRuleList) {
                String compareEleDatasourcedStr = compareEleMap.get("datasoucejson");
                if (EmptyCheckUtils.isEmpty((Object)compareEleDatasourcedStr)) continue;
                List<Map<String, String>> compareEleDataSourceMapList = ElementUtil.parseJson(compareEleDatasourcedStr);
                boolean isExistSameRule = true;
                for (Map<String, String> compareEleDataSourceMap : compareEleDataSourceMapList) {
                    String compareEleTableidd = compareEleDataSourceMap.get("tableidd");
                    String compareEleFieldidd = compareEleDataSourceMap.get("fieldidd");
                    String compareEleFfilterjsond = compareEleDataSourceMap.get("filterjsond");
                    Map compareEleFfilterjsonMap = (Map)SerializationUtils.fromJsonString((String)compareEleFfilterjsond, Map.class);
                    List compareEleFilterRowMap = SerializationUtils.fromJsonStringToList((String)SerializationUtils.toJsonString(compareEleFfilterjsonMap.get("FilterRow")), Map.class);
                    boolean isExistSameDataSource = false;
                    block3: for (Map<String, String> map : ruleList) {
                        String datasourced = map.get("datasoucejson");
                        List<Map<String, String>> dataSourceMapList = ElementUtil.parseJson(datasourced);
                        for (Map<String, String> dataSourceMap : dataSourceMapList) {
                            String tableidd = dataSourceMap.get("tableidd");
                            String fieldidd = dataSourceMap.get("fieldidd");
                            if (!compareEleTableidd.equalsIgnoreCase(tableidd) || !compareEleFieldidd.equalsIgnoreCase(fieldidd)) continue;
                            Map filterjsonMap = (Map)SerializationUtils.fromJsonString((String)dataSourceMap.get("filterjsond"), Map.class);
                            List filterRowMap = SerializationUtils.fromJsonStringToList((String)SerializationUtils.toJsonString(filterjsonMap.get("FilterRow")), Map.class);
                            if (compareEleFilterRowMap.size() != filterRowMap.size()) continue;
                            boolean isAllRowSame = true;
                            for (Map sourceFilterRow : compareEleFilterRowMap) {
                                List filterRowValueMapList = SerializationUtils.fromJsonStringToList((String)SerializationUtils.toJsonString(sourceFilterRow.get("Value")), Map.class);
                                boolean isExistSameRow = false;
                                block6: for (Map filterRow : filterRowMap) {
                                    if (!String.valueOf(sourceFilterRow.get("FieldName")).equalsIgnoreCase(String.valueOf(filterRow.get("FieldName"))) || !String.valueOf(sourceFilterRow.get("Logic")).equalsIgnoreCase(String.valueOf(filterRow.get("Logic"))) || !String.valueOf(sourceFilterRow.get("SimpleFilterRow")).equalsIgnoreCase(String.valueOf(filterRow.get("SimpleFilterRow"))) || !String.valueOf(sourceFilterRow.get("RightBracket")).equalsIgnoreCase(String.valueOf(filterRow.get("RightBracket"))) || !String.valueOf(sourceFilterRow.get("LeftBracket")).equalsIgnoreCase(String.valueOf(filterRow.get("LeftBracket"))) || !String.valueOf(sourceFilterRow.get("CompareType")).equalsIgnoreCase(String.valueOf(filterRow.get("CompareType")))) continue;
                                    List filterRowValueMapList2 = SerializationUtils.fromJsonStringToList((String)SerializationUtils.toJsonString(filterRow.get("Value")), Map.class);
                                    if (filterRowValueMapList.size() != filterRowValueMapList2.size()) continue;
                                    for (Map row : filterRowValueMapList) {
                                        if (!ElementUtil.isRp(row, filterRowValueMapList2)) continue;
                                        isExistSameRow = true;
                                        continue block6;
                                    }
                                }
                                if (!isExistSameRow) {
                                    isAllRowSame = false;
                                    break;
                                }
                                isAllRowSame = true;
                            }
                            if (!isAllRowSame) continue;
                            isExistSameDataSource = true;
                            continue block3;
                        }
                    }
                    if (isExistSameDataSource) continue;
                    isExistSameRule = false;
                    break;
                }
                if (isExistSameRule) continue;
                isSame = false;
            }
            if (!isSame) continue;
            resultIDs.add(compareEle.getLong("id"));
        }
        return resultIDs;
    }

    private static boolean isRp(Map row, List<Map> filterRowValueMapList2) {
        for (Map tempRow : filterRowValueMapList2) {
            if (!String.valueOf(tempRow.get("Value")).equalsIgnoreCase(String.valueOf(row.get("Value")))) continue;
            return true;
        }
        return false;
    }

    public static List<Map<String, String>> findNewRule(String json_tag, String orgid, Date startDate, Date endDate, Date dataSourceDate) {
        ArrayList<Map<String, String>> resList = new ArrayList<Map<String, String>>(10);
        List<Map<String, String>> ruleList = ElementUtil.parseJson(json_tag);
        boolean isSingleRule = null != dataSourceDate;
        boolean isDefaultRule = ruleList.size() == 1;
        String defaultname = ResManager.loadKDString((String)"\u9ed8\u8ba4\u89c4\u5219", (String)"ElementUtil_0", (String)"taxc-tctb-tctrc-common", (Object[])new Object[0]);
        Map<String, String> defaultRuleMap = null;
        for (Map<String, String> ruleMap : ruleList) {
            String rulename = ruleMap.get("rulename");
            if (defaultname.equalsIgnoreCase(rulename)) {
                defaultRuleMap = ruleMap;
            }
            String datasourcestr = ruleMap.get("datasoucejson");
            if (!isDefaultRule && (isDefaultRule || !EmptyCheckUtils.isNotEmpty((Object)ruleMap.get("orgs")) || ruleMap.get("orgs").indexOf(orgid) <= -1)) continue;
            return ElementUtil.getMaps(startDate, endDate, dataSourceDate, resList, isSingleRule, rulename, datasourcestr);
        }
        if (null != defaultRuleMap) {
            String datasourcestr = (String)defaultRuleMap.get("datasoucejson");
            return ElementUtil.getMaps(startDate, endDate, dataSourceDate, resList, isSingleRule, defaultname, datasourcestr);
        }
        return null;
    }

    protected static List<Map<String, String>> getMaps(Date startDate, Date endDate, Date dataSourceDate, List<Map<String, String>> resList, boolean isSingleRule, String rulename, String datasourcestr) {
        List<Map<String, String>> dataSourceMapList = ElementUtil.parseJson(datasourcestr);
        for (Map<String, String> dataSourceMap : dataSourceMapList) {
            if (isSingleRule) {
                if (!ElementUtil.doFindNewRuleBySingleDate(dataSourceDate, rulename, dataSourceMap)) continue;
                resList.add(dataSourceMap);
                return resList;
            }
            if (!ElementUtil.doFindNewRule(startDate, endDate, rulename, dataSourceMap)) continue;
            resList.add(dataSourceMap);
        }
        return EmptyCheckUtils.isEmpty(resList) ? null : resList;
    }

    private static boolean doFindNewRule(Date startDate, Date endDate, String rulename, Map<String, String> dataSourceMap) {
        Date ruleStartDate = DateUtils.getFirstDateOfMonth((Date)DateUtils.stringToDate((String)dataSourceMap.get("startdated")));
        Date ruleEndDate = EmptyCheckUtils.isEmpty((Object)dataSourceMap.get("enddated")) ? DateUtils.getLastDateOfMonth((Date)DateUtils.stringToDate((String)"2099-12-31")) : DateUtils.getLastDateOfMonth((Date)DateUtils.stringToDate((String)dataSourceMap.get("enddated")));
        dataSourceMap.put("rulename", rulename);
        if (DateUtils.isEffectiveDate((Date)startDate, (Date)endDate, (Date)ruleStartDate, (Date)ruleEndDate)) {
            dataSourceMap.put("isNeedChangeQueryDate", "0");
            return true;
        }
        if (DateUtils.isEffectiveDate((Date)ruleStartDate, (Date)ruleEndDate, (Date)startDate, (Date)endDate)) {
            dataSourceMap.put("isNeedChangeQueryDate", "1");
            dataSourceMap.put("querystartdate", DateUtils.format((Date)ruleStartDate));
            dataSourceMap.put("queryenddate", DateUtils.format((Date)ruleEndDate));
            return true;
        }
        if (DateUtils.isEffectiveDate((Date)startDate, (Date)ruleStartDate, (Date)ruleEndDate)) {
            dataSourceMap.put("isNeedChangeQueryDate", "1");
            dataSourceMap.put("querystartdate", DateUtils.format((Date)startDate));
            dataSourceMap.put("queryenddate", DateUtils.format((Date)ruleEndDate));
            return true;
        }
        if (DateUtils.isEffectiveDate((Date)endDate, (Date)ruleStartDate, (Date)ruleEndDate)) {
            dataSourceMap.put("isNeedChangeQueryDate", "1");
            dataSourceMap.put("querystartdate", DateUtils.format((Date)ruleStartDate));
            dataSourceMap.put("queryenddate", DateUtils.format((Date)endDate));
            return true;
        }
        return false;
    }

    private static boolean doFindNewRuleBySingleDate(Date endDate, String rulename, Map<String, String> dataSourceMap) {
        Date ruleEndDate;
        Date ruleStartDate = DateUtils.getFirstDateOfMonth((Date)DateUtils.stringToDate((String)dataSourceMap.get("startdated")));
        Date date = ruleEndDate = EmptyCheckUtils.isEmpty((Object)dataSourceMap.get("enddated")) ? DateUtils.getLastDateOfMonth((Date)DateUtils.stringToDate((String)"2099-12-31")) : DateUtils.getLastDateOfMonth((Date)DateUtils.stringToDate((String)dataSourceMap.get("enddated")));
        if (DateUtils.isEffectiveDate((Date)endDate, (Date)ruleStartDate, (Date)ruleEndDate)) {
            dataSourceMap.put("isNeedChangeQueryDate", "0");
            dataSourceMap.put("rulename", rulename);
            return true;
        }
        return false;
    }

    public static boolean isConstantNumber(String number, Map<String, DynamicObject> code2EleInfoMap) {
        return null == code2EleInfoMap.get(number) && NumberUtils.isNumber((String)number);
    }

    public static String getFormula(DynamicObject ele) {
        return null == ele ? null : ele.getString("formula");
    }

    public static List<String> getUnBottomNextLevelEles(DynamicObject ele, Map<String, DynamicObject> code2InfoMap) {
        String formula;
        ArrayList<String> eleCodes = new ArrayList<String>(10);
        if (!ele.getBoolean("bottom") && EmptyCheckUtils.isNotEmpty((Object)(formula = ElementUtil.getFormula(ele)))) {
            String[] formulas;
            for (String f : formulas = formula.split(" ")) {
                if ("+-*/()<><=>=abs(".contains(f) || ElementUtil.isConstantNumber(f, code2InfoMap)) continue;
                eleCodes.add(f);
            }
        }
        return eleCodes.stream().distinct().collect(Collectors.toList());
    }
}

