/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tdm.formplugin.elementsetting;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DcBinder;
import kd.bos.dataentity.serialization.DcJsonSerializer;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.botp.FormulaEditHelper;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.entity.operate.Save;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.SelectRowsEvent;
import kd.bos.form.control.events.SelectRowsEventListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.metadata.domainmodel.DomainModelBinder;
import kd.bos.metadata.domainmodel.DomainModelType;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.service.ITimeService;
import kd.bos.service.IUserService;
import kd.bos.service.TimeService;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.user.UserService;
import kd.taxc.bdtaxr.common.constant.EntityV3Constant;
import kd.taxc.bdtaxr.common.refactor.formula.cal.eval.Parser;
import kd.taxc.tdm.business.customdatasource.CustomDatasourceBusiness;
import kd.taxc.tdm.business.customdatasource.CustomDatasourceDao;
import kd.taxc.tdm.business.element.ElementBusiness;
import kd.taxc.tdm.common.enums.BooleanEnum;
import kd.taxc.tdm.common.helper.FormulaModifyHelper;
import kd.taxc.tdm.common.helper.OrgServiceHelper;
import kd.taxc.tdm.common.util.DateUtils;
import kd.taxc.tdm.common.util.EmptyCheckUtils;
import kd.taxc.tdm.common.util.OrgUtils;
import kd.taxc.tdm.common.util.PermissionUtils;
import kd.taxc.tdm.formplugin.constant.InvoiceTypeEnum;
import kd.taxc.tdm.formplugin.element.TimeDeviatedEnum;
import kd.taxc.tdm.formplugin.element.util.ElementUtil;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.ObjectUtils;

public class ElementEditPlugin
extends AbstractFormPlugin
implements SelectRowsEventListener,
BeforeFilterF7SelectListener,
RowClickEventListener {
    private static final String KEY_FILTER_GRID_AP = "filtergridap";
    private static final String KEY_DEL_BTN = "delbtn";
    private static final String KEY_ORGS = "orgs";
    private static final String KEY_FETCH_RULE_FLEX = "datasource";
    private static final String KEY_ELEMENT_CONFIG_FLEX = "flexeleconfig";
    private static final String KEY_TYPE_VALUE = "typevalue";
    private static final String KEY_TABLE = "table";
    private static final String KEY_CARD_ENTRY_ENTITY = "entryentity";
    private static final String KEY_TABLE_CONFIG_ENTRY_ENTITY = "entryentity1";
    private static final String KEY_AMOUNT_FIELD = "amountfield";
    private static final String KEY_BASE_DATA_TYPE = "basedatatype";
    private static final String SELECTED_ORG_LIST = "orgs";
    private static final String ORGS_BY_ALL = "orgsbyall";
    private static final String CACHE_DATASOURCE_PREF = "datasouce_";
    private static final String CACHE_MAX_ID_CARD = "maxidcard";
    private static final String CACHE_CURRENT_ROW_INDEX = "currentrowindex";
    private static final String CACHE_TABLE_ENTRY_ENTITY_CURRENT_ROW = "tableentryentitycurrentrow";
    private static final String EXPRESSION_ELEMENT_PREFIX = "${";
    private static final String EXPRESSION_ELEMENT_SUFFIX = "}";
    private static final String EXPRESSION_ELEMENT_NAME_CODE_DELIMITER = "|";
    private static final String EXPRESSION_ELEMENT_NAME_CODE_DELIMITER_SPIT = "\\|";
    private static final Map<String, String> OPERATOR = new HashMap<String, String>(7);
    private static final String RISK_ASSIGN_ORG = "tctrc_risk_assign_org";
    private static final String ELEMENT_SELECT = "selectelement";
    private static final String EXPRESS_CONSTANT = "tdm_exp_constant";
    private static String invoiceType = "";

    public void initialize() {
        for (ExpressionBtnEnum value : ExpressionBtnEnum.values()) {
            Button expressionButton = (Button)this.getControl(value.getButtonKey());
            expressionButton.addClickListener((ClickListener)this);
        }
        BasedataEdit amountField = (BasedataEdit)this.getControl(KEY_AMOUNT_FIELD);
        amountField.addBeforeF7SelectListener(this::beforeAmountF7SelectEvent);
        FilterGrid filterGrid = (FilterGrid)this.getControl(KEY_FILTER_GRID_AP);
        filterGrid.addBeforeF7SelectListener((BeforeFilterF7SelectListener)this);
        CardEntry cardEntry = (CardEntry)this.getView().getControl(KEY_CARD_ENTRY_ENTITY);
        cardEntry.addSelectRowsListener((SelectRowsEventListener)this);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(KEY_TABLE_CONFIG_ENTRY_ENTITY);
        if (null != entryGrid) {
            entryGrid.addRowClickListener((RowClickEventListener)this);
            entryGrid.addSelectRowsListener((SelectRowsEventListener)this);
        }
    }

    private void beforeAmountF7SelectEvent(BeforeF7SelectEvent evt) {
        String fieldName = evt.getProperty().getName();
        if (!KEY_AMOUNT_FIELD.equals(fieldName)) {
            return;
        }
        int curRowIndex = this.getModel().getEntryCurrentRowIndex(KEY_TABLE_CONFIG_ENTRY_ENTITY);
        DynamicObject tableObject = (DynamicObject)this.getModel().getValue(KEY_TABLE, curRowIndex);
        if (tableObject == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6570\u636e\u6e90\u3002", (String)"RuleTemplateBusiness_0", (String)"taxc-tctsa-business", (Object[])new Object[0]));
            evt.setCancel(true);
            return;
        }
        ListShowParameter formShowParameter = (ListShowParameter)evt.getFormShowParameter();
        String entityName = tableObject.getString("entityname");
        if (EntityV3Constant.ENTITY_V3.containsKey(entityName)) {
            formShowParameter.setCaption(ResManager.loadKDString((String)"\u5217\u7ef4\u6210\u5458\u9009\u62e9", (String)"RuleTemplateBusiness_1", (String)"taxc-tctsa-business", (Object[])new Object[0]));
        } else {
            QFilter filter = new QFilter("tableid", "=", tableObject.get("id")).and("state", "=", (Object)"1").and("isamount", "=", (Object)"1");
            formShowParameter.getListFilterParameter().setFilter(filter);
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"buttonap", "flexnumber-12", "flexnumber-11", "flexnumber-10", "flexnumber-09", "flexnumber-08", "flexnumber-07", "flexnumber-06", "flexnumber-05", "flexnumber-04", "flexnumber-03", "flexnumber-02", "flexnumber-01", "flexnumber-00", "flexnumber+01", "flexnumber+02", "flexnumber+03", "flexnumber+04", "flexnumber+05", "flexnumber+06", "flexnumber+07", "flexnumber+08", "flexnumber+09", "flexnumber+10", "flexnumber+11", "flexnumber+12", "radiofield", "radiofield1", "radiofield2", "radiofield3", "viewselectorgbtn", "viewselectorgbtnflex", "viewselectorgbtnvp", "selectorgbtn", "selectorgbtnflex", "selectorgbtnvp", "selectdatasource", "selectdatasourceflex", "selectdatasourcevp", "addrulebtn", "addrulebtnjiahao", KEY_DEL_BTN});
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void afterBindData(EventObject e) {
        Boolean bottom = (Boolean)this.getModel().getValue("bottom");
        this.getView().setVisible(Boolean.valueOf(bottom == false), new String[]{KEY_ELEMENT_CONFIG_FLEX, KEY_TYPE_VALUE});
        this.getView().setVisible(bottom, new String[]{KEY_FETCH_RULE_FLEX, "autorefresh"});
        this.setPageContentValue(bottom);
        this.getModel().setDataChanged(false);
    }

    private void setPageContentValue(Boolean isBottom) {
        Long id = (Long)this.getModel().getValue("id");
        if (id == 0L) {
            DynamicObject elementGroup = (DynamicObject)this.getModel().getValue("group");
            if (elementGroup == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u67d0\u4e2a\u5143\u7d20\u5206\u7c7b(\u8282\u70b9)\u540e\u518d\u65b0\u589e\u5143\u7d20", (String)"ElementAddPlugin_2", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
                return;
            }
            this.initFetchRuleCard(new ArrayList<Map<String, String>>(0));
            this.selectFetchRuleCard();
        } else {
            DynamicObject elementObject = BusinessDataServiceHelper.loadSingle((Object)id, (String)"tdm_element_group");
            this.getModel().setValue("id", (Object)id);
            this.getModel().setValue("number", elementObject.get("number"));
            this.getModel().setValue("describe", elementObject.get("describe"));
            this.getModel().setValue("bottom", elementObject.get("bottom"));
            this.getModel().setValue(KEY_TYPE_VALUE, elementObject.get(KEY_TYPE_VALUE));
            this.getModel().setValue("timedeviationdirection", elementObject.get("timedeviationdirection"));
            this.getModel().setValue("timedeviationcount", elementObject.get("timedeviationcount"));
            this.getModel().setValue("timedeviationtype", elementObject.get("timedeviationtype"));
            String json = elementObject.getString("json_tag");
            if (isBottom.booleanValue()) {
                List<Map<String, String>> ruleCards = ElementUtil.parseJson(json);
                this.initFetchRuleCard(ruleCards);
                this.selectFetchRuleCard();
            } else {
                Map map = (Map)SerializationUtils.fromJsonString((String)json, Map.class);
                this.getModel().setValue("formula", map.get("formula"));
            }
        }
    }

    private void initFetchRuleCard(List<Map<String, String>> ruleCards) {
        Map<String, String> defaultCardValue = this.getDefaultCardValue(ruleCards);
        this.getModel().beginInit();
        this.getModel().deleteEntryData(KEY_CARD_ENTRY_ENTITY);
        int rowIndex = this.getModel().createNewEntryRow(KEY_CARD_ENTRY_ENTITY);
        this.initCardValue(defaultCardValue, rowIndex);
        ArrayList orgList = new ArrayList();
        CardEntry elementCard = (CardEntry)this.getControl(KEY_CARD_ENTRY_ENTITY);
        if (ruleCards != null) {
            for (Map<String, String> ruleCard : ruleCards) {
                if (BooleanEnum.YES.getCode().equals(ruleCard.get("isdefaultrule"))) continue;
                rowIndex = this.getModel().createNewEntryRow(KEY_CARD_ENTRY_ENTITY);
                this.initCardValue(ruleCard, rowIndex);
                elementCard.setChildVisible(false, rowIndex, new String[]{"vectordefault"});
                if (!EmptyCheckUtils.isNotEmpty((Object)ruleCard.get("orgs"))) continue;
                orgList.addAll(Arrays.stream(ruleCard.get("orgs").split(",")).collect(Collectors.toList()));
            }
        }
        this.getModel().endInit();
        this.getView().updateView(KEY_CARD_ENTRY_ENTITY);
        String orgsByAll = orgList.stream().collect(Collectors.joining(","));
        if (EmptyCheckUtils.isNotEmpty((Object)orgsByAll)) {
            this.getPageCache().put(ORGS_BY_ALL, orgsByAll);
        }
    }

    private Map<String, String> getDefaultCardValue(List<Map<String, String>> ruleCards) {
        Integer maxIdCard = 0;
        if (CollectionUtils.isEmpty(ruleCards)) {
            this.getPageCache().put(CACHE_MAX_ID_CARD, String.valueOf(maxIdCard));
            return this.getInitDefaultCardValue();
        }
        Map<Object, Object> result = new HashMap(16);
        if (1 == ruleCards.size()) {
            result = ruleCards.get(0);
            result.putAll(this.getInitDefaultCardValue());
            this.getPageCache().put(this.getDataSourceRuleKey("0"), SerializationUtils.toJsonString(result));
        } else {
            for (Map<String, String> ruleMap : ruleCards) {
                if (BooleanEnum.YES.getCode().equalsIgnoreCase(ruleMap.get("isdefaultrule")) || this.getDefaultRuleName().equalsIgnoreCase(ruleMap.get("rulename"))) {
                    result = ruleMap;
                }
                this.getPageCache().put(this.getDataSourceRuleKey(String.valueOf(maxIdCard)), SerializationUtils.toJsonString(ruleMap));
                Integer n = maxIdCard;
                Integer n2 = maxIdCard = Integer.valueOf(maxIdCard + 1);
            }
        }
        this.getPageCache().put(CACHE_MAX_ID_CARD, String.valueOf(maxIdCard));
        return result;
    }

    private String getDefaultRuleName() {
        return ResManager.loadKDString((String)"\u9ed8\u8ba4\u89c4\u5219", (String)"ElementAddPlugin_0", (String)"taxc-tdm-formplugin", (Object[])new Object[0]);
    }

    private Map<String, String> getInitDefaultCardValue() {
        HashMap<String, String> result = new HashMap<String, String>(3);
        result.put("isdefaultrule", BooleanEnum.YES.getCode());
        result.put("idcard", "0");
        result.put("rulename", this.getDefaultRuleName());
        return result;
    }

    private String getDataSourceRuleKey(String idCard) {
        return CACHE_DATASOURCE_PREF + idCard;
    }

    private void initCardValue(Map<String, String> cardValue, int rowIndex) {
        this.getModel().setValue("rulenamecard", (Object)cardValue.get("rulename"), rowIndex);
        this.getModel().setValue("idcard", (Object)rowIndex, rowIndex);
        this.getPageCache().put(CACHE_MAX_ID_CARD, "0");
    }

    private void selectFetchRuleCard() {
        CardEntry cardEntry = (CardEntry)this.getControl(KEY_CARD_ENTRY_ENTITY);
        cardEntry.selectRows(0);
        cardEntry.selectRowsChanged(Collections.singletonList(0), null);
        this.getPageCache().put(CACHE_CURRENT_ROW_INDEX, "0");
        cardEntry.setChildVisible(false, 0, new String[]{KEY_DEL_BTN});
        cardEntry.setChildVisible(true, 0, new String[]{"vectordefault"});
    }

    public void selectRowsChange(SelectRowsEvent evt) {
        Object source = evt.getSource();
        if (!(source instanceof EntryGrid)) {
            return;
        }
        EntryGrid entryGrid = (EntryGrid)source;
        String entryGridKey = entryGrid.getEntryKey();
        List oldRows = evt.getOldRows();
        List newRows = evt.getNewRows();
        if (KEY_TABLE_CONFIG_ENTRY_ENTITY.equalsIgnoreCase(entryGridKey)) {
            if (EmptyCheckUtils.isNotEmpty((Object)oldRows)) {
                this.saveDatasourceRowFilterValue((Integer)oldRows.get(0));
            }
            this.getPageCache().put(CACHE_TABLE_ENTRY_ENTITY_CURRENT_ROW, String.valueOf(newRows.get(0)));
            this.setDatasourceRowValue((Integer)newRows.get(0));
        } else {
            if (EmptyCheckUtils.isNotEmpty((Object)oldRows)) {
                this.saveFetchRuleRow((Integer)oldRows.get(0));
            }
            if (EmptyCheckUtils.isEmpty((Object)newRows)) {
                return;
            }
            int row = (Integer)newRows.get(0);
            String ruleName = ((DynamicObject)this.getModel().getEntryEntity(KEY_CARD_ENTRY_ENTITY).get(row)).getString("rulenamecard");
            ruleName = 0 == row ? this.getDefaultRuleName() : ruleName;
            String idCard = ((DynamicObject)this.getModel().getEntryEntity(KEY_CARD_ENTRY_ENTITY).get(row)).getString("idcard");
            String ruleJson = this.getPageCache().get(this.getDataSourceRuleKey(idCard));
            this.getPageCache().put(CACHE_TABLE_ENTRY_ENTITY_CURRENT_ROW, "0");
            this.initFetchRule(ruleJson, ruleName);
            this.getPageCache().put(CACHE_CURRENT_ROW_INDEX, String.valueOf(row));
            this.getModel().setValue("rulename", (Object)ruleName);
        }
    }

    private void saveDatasourceRowFilterValue(int rowIndex) {
        DynamicObject[] dynamicObjects = ((EntryGrid)this.getView().getControl(KEY_TABLE_CONFIG_ENTRY_ENTITY)).getEntryData().getDataEntitys();
        if (EmptyCheckUtils.isEmpty((Object)dynamicObjects) || rowIndex + 1 > dynamicObjects.length) {
            return;
        }
        this.getModel().setValue("filterjsond", (Object)this.getTableFilterJson(), rowIndex);
        DynamicObject currentObject = dynamicObjects[rowIndex];
        if (EmptyCheckUtils.isNotEmpty((Object)currentObject.getString("fieldidd"))) {
            DynamicObject tableObject = (DynamicObject)this.getModel().getValue(KEY_TABLE, rowIndex);
            String filterText = this.getFilterText(currentObject.getString("fieldidd"), tableObject.getString("entityname"));
            this.getModel().setValue("filtertextd", (Object)filterText, rowIndex);
        }
    }

    private int getTableCurrentSelectRow() {
        String row = this.getPageCache().get(CACHE_TABLE_ENTRY_ENTITY_CURRENT_ROW);
        return EmptyCheckUtils.isEmpty((Object)row) ? 0 : Integer.parseInt(String.valueOf(row));
    }

    private String getTableFilterJson() {
        FilterCondition filterCondition = this.getTableEntryEntityFilterCondition();
        DomainModelBinder binder = new DomainModelBinder(DomainModelType.getDomainModelType((String)"DynamicFormModel", (boolean)false));
        DcJsonSerializer ser = new DcJsonSerializer((DcBinder)binder);
        Map filterConditionMap = ser.serializeToMap((Object)filterCondition, null);
        String filterJson = SerializationUtils.toJsonString((Object)filterConditionMap);
        return filterJson;
    }

    private FilterCondition getTableEntryEntityFilterCondition() {
        FilterGrid filterGrid = (FilterGrid)this.getControl(KEY_FILTER_GRID_AP);
        return filterGrid.getFilterGridState().getFilterCondition();
    }

    private String getFilterText(String fieldId, String entityName) {
        FilterCondition filterCondition = this.getTableEntryEntityFilterCondition();
        if (EntityV3Constant.ENTITY_V3.containsKey(entityName)) {
            return this.getFilterExpressionAfterParse(entityName, filterCondition);
        }
        if (StringUtils.isEmpty((CharSequence)fieldId)) {
            return null;
        }
        String entity = CustomDatasourceBusiness.getFieldActualEntityName((Long)Long.parseLong(fieldId));
        if (StringUtils.isEmpty((CharSequence)entity)) {
            return null;
        }
        return this.getFilterExpressionAfterParse(entity, filterCondition);
    }

    private String getFilterExpressionAfterParse(String entityName, FilterCondition filterCondition) {
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)entityName);
        FilterBuilder filterBuilder = new FilterBuilder(type, filterCondition);
        filterBuilder.setUserService((IUserService)new UserService());
        filterBuilder.setTimeService((ITimeService)new TimeService());
        filterBuilder.buildFilter(false);
        return filterBuilder.getFilterObject().getFilter();
    }

    private void setDatasourceRowValue(int rowIndex) {
        DynamicObject[] dynamicObjects = ((EntryGrid)this.getView().getControl(KEY_TABLE_CONFIG_ENTRY_ENTITY)).getEntryData().getDataEntitys();
        if (EmptyCheckUtils.isEmpty((Object)dynamicObjects)) {
            return;
        }
        this.clearFilterGrid();
        DynamicObject datasourceObject = dynamicObjects[rowIndex];
        String entityName = "";
        if (datasourceObject.get(KEY_TABLE) != null) {
            entityName = datasourceObject.getDynamicObject(KEY_TABLE).getString("entityname");
        }
        this.doSetDatasourceRowValue(datasourceObject.getLong("fieldidd"), datasourceObject.getLong("tableidd"), entityName, datasourceObject.getString("filterjsond"), rowIndex);
    }

    private void clearFilterGrid() {
        FilterGrid filterGrid = (FilterGrid)this.getControl(KEY_FILTER_GRID_AP);
        FilterCondition filterCondition = filterGrid.getFilterGridState().getFilterCondition();
        filterCondition.getFilterRow().clear();
        filterGrid.SetValue(filterCondition);
        this.getView().updateView(KEY_FILTER_GRID_AP);
        this.getView().setVisible(Boolean.FALSE, new String[]{KEY_FILTER_GRID_AP});
    }

    private void doSetDatasourceRowValue(Long fieldId, Long tableId, String entityName, String filterJson, int rowIndex) {
        if (fieldId == 0L) {
            return;
        }
        if (tableId != 0L) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{KEY_FILTER_GRID_AP});
        }
        if (StringUtils.isNotEmpty((CharSequence)entityName) && EntityV3Constant.ENTITY_V3.containsKey(entityName)) {
            DynamicObject tableObject = (DynamicObject)this.getModel().getValue(KEY_TABLE, rowIndex);
            DynamicObject fieldObject = (DynamicObject)this.getModel().getValue(KEY_AMOUNT_FIELD, rowIndex);
            if (EmptyCheckUtils.isNotEmpty((Object)tableObject) && EmptyCheckUtils.isNotEmpty((Object)fieldObject)) {
                this.getModel().setValue("datasourced", (Object)(tableObject.getString("bizname") + "." + fieldObject.getLocaleString("name").getLocaleValue()), rowIndex);
            }
            this.initDeclareModelDatasourceFilterCondition(entityName, tableId);
            if (StringUtils.isNotEmpty((CharSequence)filterJson)) {
                this.setDataFilter(filterJson);
            }
            this.getModel().setValue("tableidd", (Object)tableId, rowIndex);
            this.getModel().setValue("fieldidd", (Object)fieldId, rowIndex);
        } else {
            QFilter filter = new QFilter("entryentity.id", "=", (Object)fieldId);
            DynamicObject datasourceObject = CustomDatasourceDao.queryOneDatasource((QFilter[])new QFilter[]{filter}, (String)"id,bizname,entityname,name,subname,ischild,entryentity.id,entryentity.bizsubname");
            if (null == datasourceObject) {
                return;
            }
            this.getModel().setValue("datasourced", (Object)(datasourceObject.getString("bizname") + "." + datasourceObject.getString("entryentity.bizsubname")), rowIndex);
            String name = datasourceObject.getString("entityname");
            invoiceType = InvoiceTypeEnum.getEnumByEntityId(name);
            long id = datasourceObject.getLong("id");
            this.initDatasourceFilterCondition(id, datasourceObject.getString("ischild"), name, datasourceObject.getString("subname"));
            if (id == tableId && StringUtils.isNotEmpty((CharSequence)filterJson)) {
                this.setDataFilter(filterJson);
            }
            this.getModel().setValue("tableidd", (Object)id, rowIndex);
            this.getModel().setValue("fieldidd", (Object)fieldId, rowIndex);
        }
    }

    private void initDeclareModelDatasourceFilterCondition(String entityName, Long tableId) {
        List filterColumns = ElementBusiness.getDeclareModelDatasourceFilterColumns((String)entityName, (Long)tableId);
        this.setFilterGripValue(filterColumns, entityName);
    }

    private void setFilterGripValue(List<Map<String, Object>> filterColumns, String entityName) {
        FilterGrid filterGrid = (FilterGrid)this.getControl(KEY_FILTER_GRID_AP);
        FilterCondition filterCondition = filterGrid.getFilterGridState().getFilterCondition();
        filterGrid.setFilterColumns(filterColumns);
        filterGrid.setEntityNumber(entityName);
        filterGrid.SetValue(filterCondition);
        this.getView().updateView(KEY_FILTER_GRID_AP);
    }

    private void setDataFilter(String dataFilter) {
        Map filterConditionMap = (Map)SerializationUtils.fromJsonString((String)dataFilter, Map.class);
        ArrayList<IDataEntityType> dataEntityTypes = new ArrayList<IDataEntityType>();
        dataEntityTypes.add(OrmUtils.getDataEntityType(FilterCondition.class));
        dataEntityTypes.add(OrmUtils.getDataEntityType(SimpleFilterRow.class));
        DcJsonSerializer ser = new DcJsonSerializer(dataEntityTypes);
        FilterCondition filterCondition = (FilterCondition)ser.deserializeFromMap(filterConditionMap, null);
        FilterGrid filterGrid = (FilterGrid)this.getControl(KEY_FILTER_GRID_AP);
        filterGrid.SetValue(filterCondition);
    }

    private void initDatasourceFilterCondition(Long id, String isChild, String entityName, String subEntityName) {
        QFilter filter = new QFilter("id", "=", (Object)id).and("entryentity.wherestate", "=", (Object)"1");
        DynamicObjectCollection collection = CustomDatasourceDao.queryDatasource((QFilter[])new QFilter[]{filter}, (String)"entryentity.id,entryentity.fieldsubname,entryentity.fieldname,entryentity.bizsubname");
        List filterColumns = ElementBusiness.getDatasourceFilterColumns((DynamicObjectCollection)collection, (String)isChild, (String)entityName, (String)subEntityName);
        String actualEntityName = Boolean.FALSE.toString().equals(isChild) && StringUtils.isNotEmpty((CharSequence)subEntityName) ? subEntityName : entityName;
        this.setFilterGripValue(filterColumns, actualEntityName);
    }

    private void saveFetchRuleRow(Integer rowIndex) {
        if (rowIndex == null || rowIndex < 0) {
            return;
        }
        int tableCurrentSelectRowIndex = this.getTableCurrentSelectRow();
        this.saveDatasourceRowFilterValue(tableCurrentSelectRowIndex);
        this.doSaveFetchRuleRow(rowIndex);
    }

    private void doSaveFetchRuleRow(Integer rowIndex) {
        List<String> oldAllOrgs;
        String cardIndex = ((DynamicObject)this.getModel().getEntryEntity(KEY_CARD_ENTRY_ENTITY).get(rowIndex.intValue())).getString("idcard");
        String ruleJson = this.getPageCache().get(this.getDataSourceRuleKey(String.valueOf(cardIndex)));
        List<String> oldOrgs = null;
        if (EmptyCheckUtils.isNotEmpty((Object)ruleJson)) {
            Map oldMap = (Map)SerializationUtils.fromJsonString((String)ruleJson, Map.class);
            oldOrgs = this.strToListByDelimiter((String)oldMap.get("orgs"), ",");
        }
        if (EmptyCheckUtils.isNotEmpty(oldAllOrgs = this.strToListByDelimiter(this.getPageCache().get(ORGS_BY_ALL), ",")) && EmptyCheckUtils.isNotEmpty(oldOrgs)) {
            List<String> finalOldOrgs = oldOrgs;
            oldAllOrgs.removeIf(v -> finalOldOrgs.contains(v));
        }
        String orgs = String.valueOf(this.getModel().getValue("orgs"));
        String lastOrgsByAll = EmptyCheckUtils.isNotEmpty(oldAllOrgs) ? Stream.concat(oldAllOrgs.stream(), this.strToListByDelimiter(orgs, ",").stream()).distinct().collect(Collectors.joining(",")) : orgs;
        this.getPageCache().put(ORGS_BY_ALL, lastOrgsByAll);
        HashMap<String, String> ruleMap = new HashMap<String, String>(4);
        String datasourceJson = this.getCurrentDatasourceJson();
        ruleMap.put("datasoucejson", datasourceJson);
        ruleMap.put("rulename", String.valueOf(this.getModel().getValue("rulename")));
        ruleMap.put("isdefaultrule", this.getDefaultRuleName().equalsIgnoreCase(String.valueOf(this.getModel().getValue("rulename"))) ? BooleanEnum.YES.getCode() : BooleanEnum.NO.getCode());
        ruleMap.put("orgs", orgs);
        this.getPageCache().put(this.getDataSourceRuleKey(String.valueOf(cardIndex)), SerializationUtils.toJsonString(ruleMap));
    }

    private String getCurrentDatasourceJson() {
        DynamicObject[] datasourceObjects = ((EntryGrid)this.getView().getControl(KEY_TABLE_CONFIG_ENTRY_ENTITY)).getEntryData().getDataEntitys();
        if (EmptyCheckUtils.isEmpty((Object)datasourceObjects)) {
            return null;
        }
        ArrayList dataSourceMapList = new ArrayList(datasourceObjects.length);
        for (DynamicObject datasourceObject : datasourceObjects) {
            HashMap<String, String> map = new HashMap<String, String>(16);
            map.put("datasourced", datasourceObject.getString("datasourced"));
            map.put("startdated", DateUtils.format((Date)DateUtils.getFirstDateOfMonth((Date)datasourceObject.getDate("startdated"))));
            map.put("enddated", DateUtils.format((Date)DateUtils.getLastDateOfMonth((Date)datasourceObject.getDate("enddated"))));
            map.put("tableidd", datasourceObject.getString("tableidd"));
            map.put("fieldidd", datasourceObject.getString("fieldidd"));
            map.put("filtertextd", datasourceObject.getString("filtertextd"));
            map.put("filterjsond", datasourceObject.getString("filterjsond"));
            map.put("entityname", datasourceObject.getDynamicObject(KEY_TABLE) == null ? null : datasourceObject.getDynamicObject(KEY_TABLE).getString("entityname"));
            dataSourceMapList.add(map);
        }
        return SerializationUtils.toJsonString(dataSourceMapList);
    }

    private List<String> strToListByDelimiter(String str, String delimiter) {
        return EmptyCheckUtils.isEmpty((Object)str) ? Collections.EMPTY_LIST : Arrays.stream(str.split(delimiter)).collect(Collectors.toList());
    }

    private void initFetchRule(String ruleJson, String ruleName) {
        Boolean isDefaultRule = this.getDefaultRuleName().equalsIgnoreCase(ruleName);
        this.getView().setVisible(Boolean.valueOf(isDefaultRule == false), new String[]{"selectorgbtnflex", "viewselectorgbtnflex"});
        this.getView().setEnable(Boolean.valueOf(isDefaultRule == false), new String[]{"rulename"});
        if (EmptyCheckUtils.isNotEmpty((Object)ruleJson)) {
            Map map = (Map)SerializationUtils.fromJsonString((String)ruleJson, Map.class);
            String datasourceJson = (String)map.get("datasoucejson");
            if (EmptyCheckUtils.isEmpty((Object)datasourceJson)) {
                this.clearFilterGrid();
            } else {
                List datasourceMapList = SerializationUtils.fromJsonStringToList((String)datasourceJson, Map.class);
                if (EmptyCheckUtils.isNotEmpty((Object)datasourceMapList)) {
                    this.initDataSourceEntry(datasourceMapList);
                }
            }
            this.getModel().setValue("orgs", map.get("orgs"));
        } else {
            EntryGrid entryGrid = (EntryGrid)this.getControl(KEY_TABLE_CONFIG_ENTRY_ENTITY);
            this.clearFilterGrid();
            entryGrid.getModel().deleteEntryData(KEY_TABLE_CONFIG_ENTRY_ENTITY);
            entryGrid.getModel().createNewEntryRow(KEY_TABLE_CONFIG_ENTRY_ENTITY);
            this.getModel().setValue("orgs", null);
        }
    }

    private void initDataSourceEntry(List<Map<String, String>> datasourceMapList) {
        EntryGrid entryGrid = (EntryGrid)this.getControl(KEY_TABLE_CONFIG_ENTRY_ENTITY);
        entryGrid.getModel().beginInit();
        entryGrid.getModel().deleteEntryData(KEY_TABLE_CONFIG_ENTRY_ENTITY);
        for (Map<String, String> datasourceMap : datasourceMapList) {
            int newEntryRow = entryGrid.getModel().createNewEntryRow(KEY_TABLE_CONFIG_ENTRY_ENTITY);
            if (0 == newEntryRow && StringUtils.isNotEmpty((CharSequence)datasourceMap.get("tableidd"))) {
                this.doSetDatasourceRowValue(Long.parseLong(datasourceMap.get("fieldidd")), Long.parseLong(datasourceMap.get("tableidd")), datasourceMap.get("entityname"), datasourceMap.get("filterjsond"), newEntryRow);
                this.getView().setVisible(Boolean.TRUE, new String[]{KEY_FILTER_GRID_AP});
            }
            entryGrid.getModel().setValue("datasourced", (Object)datasourceMap.get("datasourced"), newEntryRow);
            entryGrid.getModel().setValue("startdated", (Object)DateUtils.stringToDate((String)datasourceMap.get("startdated")), newEntryRow);
            entryGrid.getModel().setValue("enddated", (Object)DateUtils.stringToDate((String)datasourceMap.get("enddated")), newEntryRow);
            entryGrid.getModel().setValue("tableidd", (Object)datasourceMap.get("tableidd"), newEntryRow);
            entryGrid.getModel().setValue("fieldidd", (Object)datasourceMap.get("fieldidd"), newEntryRow);
            entryGrid.getModel().setValue("filtertextd", (Object)datasourceMap.get("filtertextd"), newEntryRow);
            entryGrid.getModel().setValue("filterjsond", (Object)datasourceMap.get("filterjsond"), newEntryRow);
            entryGrid.getModel().setValue(KEY_TABLE, (Object)datasourceMap.get("tableidd"), newEntryRow);
            this.setBaseDataTypeValue(datasourceMap.get("entityname"), newEntryRow);
            entryGrid.getModel().setValue(KEY_AMOUNT_FIELD, (Object)datasourceMap.get("fieldidd"), newEntryRow);
        }
        entryGrid.getModel().endInit();
        entryGrid.getView().updateView(KEY_TABLE_CONFIG_ENTRY_ENTITY);
    }

    private void setBaseDataTypeValue(String entityName, int rowIndex) {
        if (EntityV3Constant.ENTITY_V3.containsKey(entityName)) {
            this.getModel().setValue(KEY_BASE_DATA_TYPE, (Object)"tpo_col_member", rowIndex);
        } else {
            this.getModel().setValue(KEY_BASE_DATA_TYPE, (Object)"tctb_datasource_entry", rowIndex);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName = e.getProperty().getName();
        if ("bottom".equals(propertyName)) {
            Boolean bottom = (Boolean)this.getModel().getValue("bottom");
            this.getView().setVisible(bottom, new String[]{KEY_FETCH_RULE_FLEX, "autorefresh"});
            this.getView().setVisible(Boolean.valueOf(bottom == false), new String[]{KEY_ELEMENT_CONFIG_FLEX, KEY_TYPE_VALUE});
        } else if ("rulename".equals(propertyName)) {
            String newRuleName = String.valueOf(e.getChangeSet()[0].getNewValue());
            String oldRuleName = String.valueOf(e.getChangeSet()[0].getOldValue());
            if (EmptyCheckUtils.isEmpty((Object)newRuleName)) {
                this.getModel().setValue("rulename", (Object)oldRuleName);
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u89c4\u5219\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ElementAddPlugin_3", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
                return;
            }
            String index = this.getPageCache().get(CACHE_CURRENT_ROW_INDEX);
            if ("0".equals(index)) {
                this.getModel().setValue("rulename", (Object)this.getDefaultRuleName());
                return;
            }
            if (this.getDefaultRuleName().equals(newRuleName) && !"0".equals(index)) {
                this.getModel().setValue("rulename", (Object)oldRuleName);
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u201c\u89c4\u5219\u540d\u79f0\u201d\u4e0d\u80fd\u4e0e\u9ed8\u8ba4\u89c4\u5219\u7684\u540d\u79f0\u91cd\u590d\u3002", (String)"ElementAddPlugin_4", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
                return;
            }
            if (EmptyCheckUtils.isNotEmpty((Object)index)) {
                this.getModel().setValue("rulenamecard", (Object)newRuleName, Integer.parseInt(index));
            }
        } else if (KEY_TABLE.equals(propertyName)) {
            int rowIndex = this.getModel().getEntryCurrentRowIndex(KEY_TABLE_CONFIG_ENTRY_ENTITY);
            this.getModel().setValue(KEY_AMOUNT_FIELD, null, rowIndex);
            DynamicObject newValue = (DynamicObject)e.getChangeSet()[0].getNewValue();
            if (newValue != null) {
                String entityName = newValue.getString("entityname");
                this.setBaseDataTypeValue(entityName, rowIndex);
            }
            this.clearFilterGrid();
        } else if (KEY_AMOUNT_FIELD.equals(propertyName)) {
            DynamicObject newValue = (DynamicObject)e.getChangeSet()[0].getNewValue();
            if (ObjectUtils.isEmpty((Object)newValue)) {
                return;
            }
            this.changeDatasourceFilter(newValue.getString("id"));
        }
    }

    private void changeDatasourceFilter(String fieldId) {
        EntryGrid datasourceEntry = (EntryGrid)this.getControl(KEY_TABLE_CONFIG_ENTRY_ENTITY);
        int focusRow = datasourceEntry.getEntryState().getFocusRow();
        if (StringUtils.isEmpty((CharSequence)fieldId)) {
            fieldId = this.getModel().getValue("fieldid", focusRow).toString();
        }
        if (StringUtils.isEmpty((CharSequence)fieldId)) {
            return;
        }
        DynamicObject obj = (DynamicObject)this.getModel().getValue(KEY_TABLE, focusRow);
        int rowIndex = this.getModel().getEntryCurrentRowIndex(KEY_TABLE_CONFIG_ENTRY_ENTITY);
        DynamicObject tableObj = (DynamicObject)this.getModel().getValue(KEY_TABLE, rowIndex);
        this.doSetDatasourceRowValue(Long.parseLong(fieldId), obj.getLong("id"), tableObj.getString("entityname"), this.getTableFilterJson(), rowIndex);
        this.getView().setVisible(Boolean.TRUE, new String[]{KEY_FILTER_GRID_AP});
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        if (args.getSource() instanceof Save) {
            this.removeElementNameWhitespace();
            String elementName = String.valueOf(this.getModel().getValue("name"));
            if (!this.verifyElementCodeBeforeSaveElement(elementName, args).booleanValue()) {
                return;
            }
            this.getModel().setValue("modifier", (Object)RequestContext.get().getCurrUserId());
            Boolean isBottom = (Boolean)this.getModel().getValue("bottom");
            if (isBottom.booleanValue()) {
                this.saveFetchRuleRow(EmptyCheckUtils.isEmpty((Object)this.getPageCache().get(CACHE_CURRENT_ROW_INDEX)) ? null : Integer.valueOf(Integer.parseInt(this.getPageCache().get(CACHE_CURRENT_ROW_INDEX))));
                this.verifyBottomElementBeforeSaveElement();
                this.setBottomElementJsonTag();
            } else {
                String formula;
                block10: {
                    formula = (String)this.getModel().getValue("formula");
                    if (StringUtils.isEmpty((CharSequence)formula)) {
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5143\u7d20\u914d\u7f6e\u91cc\u7684\u8868\u8fbe\u5f0f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ElementAddPlugin_9", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
                        args.setCancel(true);
                        return;
                    }
                    String cycleReferenceCurElementName = this.getCycleReferenceCurElementName(formula, (String)this.getModel().getValue("number"), this.getPageCache().get("name"));
                    if (StringUtils.isNotEmpty((CharSequence)cycleReferenceCurElementName)) {
                        this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u8868\u8fbe\u5f0f\u5185\u7684\u5143\u7d20\u201c%s\u201d\u5f15\u7528\u4e86\u5f53\u524d\u6b63\u5728\u914d\u7f6e\u7684\u5143\u7d20\uff0c\u4e0d\u53ef\u4ee5\u5faa\u73af\u8c03\u7528\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u5143\u7d20\u3002", (String)"ElementAddPlugin_11", (String)"taxc-tdm-formplugin", (Object[])new Object[0]), cycleReferenceCurElementName));
                        args.setCancel(true);
                        return;
                    }
                    String verifyFormulaElementResult = this.verifyFormulaElement(formula);
                    if (StringUtils.isNotEmpty((CharSequence)verifyFormulaElementResult)) {
                        this.getView().showErrorNotification(verifyFormulaElementResult);
                        args.setCancel(true);
                        return;
                    }
                    try {
                        if (!this.verifyFormula(formula).booleanValue()) {
                            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u8868\u8fbe\u5f0f\u3002", (String)"ElementAddPlugin_30", (String)"taxc-tdm-formplugin", (Object[])new Object[0]), new Object[0]));
                            args.setCancel(true);
                            return;
                        }
                    }
                    catch (Exception e) {
                        if ("/ by zero".equals(e.getMessage())) break block10;
                        this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u8868\u8fbe\u5f0f\u3002", (String)"ElementAddPlugin_30", (String)"taxc-tdm-formplugin", (Object[])new Object[0]), new Object[0]));
                        args.setCancel(true);
                        return;
                    }
                }
                HashMap<String, String> map = new HashMap<String, String>(1);
                map.put("formula", formula);
                this.getModel().setValue("json_tag", (Object)SerializationUtils.toJsonString(map));
                this.setNewElementDefaultValue();
                this.setTimeDeviationDesc();
            }
        }
    }

    private void removeElementNameWhitespace() {
        OrmLocaleValue name = (OrmLocaleValue)this.getModel().getValue("name");
        name.setItem("zh_CN", StringUtils.trim((String)String.valueOf(name.get((Object)"zh_CN"))));
        name.setItem("en_US", StringUtils.trim((String)String.valueOf(name.get((Object)"en_US"))));
        name.setItem("zh_TW", StringUtils.trim((String)String.valueOf(name.get((Object)"zh_TW"))));
        this.getModel().setValue("name", (Object)name);
    }

    private Boolean verifyElementCodeBeforeSaveElement(String elementName, BeforeDoOperationEventArgs args) {
        if (elementName.indexOf("$") > -1 || elementName.indexOf("{") > -1 || elementName.indexOf(EXPRESSION_ELEMENT_NAME_CODE_DELIMITER) > -1 || elementName.indexOf(EXPRESSION_ELEMENT_SUFFIX) > -1) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5143\u7d20\u540d\u79f0\u4e0d\u80fd\u5305\u542b\u201c_\u201d\u3001\u201c{\u201d\u3001\u201c}\u201d\u3001\u201c$\u201d\u7b49\u7279\u6b8a\u7b26\u53f7\u3002", (String)"ElementAddPlugin_8", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return false;
        }
        return true;
    }

    private void verifyBottomElementBeforeSaveElement() {
        DynamicObjectCollection tableObjectCollection = this.getModel().getEntryEntity(KEY_TABLE_CONFIG_ENTRY_ENTITY);
        if (CollectionUtils.isEmpty((Collection)tableObjectCollection)) {
            return;
        }
        ArrayList entityNameList = new ArrayList(16);
        tableObjectCollection.stream().filter(p -> p.get(KEY_TABLE) != null).collect(Collectors.toList()).forEach(tableObject -> entityNameList.add(tableObject.getDynamicObject(KEY_TABLE).getString("entityname")));
        int cardRowIndex = this.getModel().getEntryCurrentRowIndex(KEY_CARD_ENTRY_ENTITY);
        DynamicObjectCollection cardObjectCollection = this.getModel().getEntryEntity(KEY_CARD_ENTRY_ENTITY);
        ArrayList<String> ruleNameList = new ArrayList<String>(cardObjectCollection.size());
        for (int i = 0; i < cardObjectCollection.size(); ++i) {
            DynamicObject cardObject = (DynamicObject)cardObjectCollection.get(i);
            String ruleName = cardObject.getString("rulenamecard");
            if (StringUtils.isEmpty((CharSequence)ruleName)) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u89c4\u5219\u540d\u79f0\u4e3a\u7a7a\u3002", (String)"ElementAddPlugin_16", (String)"taxc-tdm-formplugin", (Object[])new Object[0]), i + 1));
            }
            if (ruleNameList.contains(ruleName)) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u89c4\u5219\u540d\u79f0\u201c%s\u201d\u4e0d\u80fd\u91cd\u590d\u3002", (String)"ElementAddPlugin_26", (String)"taxc-tdm-formplugin", (Object[])new Object[0]), ruleName));
            }
            ruleNameList.add(ruleName);
            String ruleIndex = cardObject.getString("idcard");
            if (EmptyCheckUtils.isEmpty((Object)ruleIndex)) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5361\u7247\u552f\u4e00\u7d22\u5f15\u4e3a\u7a7a%s", (String)"ElementAddPlugin_12", (String)"taxc-tdm-formplugin", (Object[])new Object[0]), i));
            }
            String ruleJson = this.getPageCache().get(this.getDataSourceRuleKey(ruleIndex));
            if (StringUtils.isEmpty((CharSequence)ruleJson)) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u89c4\u5219\u540d\u79f0\u201c%s\u201d\u7684\u89c4\u5219\u4fe1\u606f\u4e3a\u7a7a\uff0c\u8bf7\u8865\u5145\u89c4\u5219\u4fe1\u606f\u3002", (String)"ElementAddPlugin_18", (String)"taxc-tdm-formplugin", (Object[])new Object[0]), ruleName));
            }
            Map map = (Map)SerializationUtils.fromJsonString((String)ruleJson, Map.class);
            if (MapUtils.isEmpty((Map)map)) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u89c4\u5219\u540d\u79f0\u201c%s\u201d\u7684\u89c4\u5219\u4fe1\u606f\u4e3a\u7a7a\uff0c\u8bf7\u8865\u5145\u89c4\u5219\u4fe1\u606f\u3002", (String)"ElementAddPlugin_18", (String)"taxc-tdm-formplugin", (Object[])new Object[0]), ruleName));
            }
            String datasourceJson = (String)map.get("datasoucejson");
            if (StringUtils.isEmpty((CharSequence)datasourceJson)) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u89c4\u5219\u540d\u79f0\u201c%s\u201d\u6570\u636e\u6e90\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ElementAddPlugin_19", (String)"taxc-tdm-formplugin", (Object[])new Object[0]), ruleName));
            }
            List datasourceMapList = SerializationUtils.fromJsonStringToList((String)datasourceJson, Map.class);
            this.verifyFetchRuleDatasource(datasourceMapList, ruleName);
            if (!ruleName.equals(ResManager.loadKDString((String)"\u9ed8\u8ba4\u89c4\u5219", (String)"ElementAddPlugin_0", (String)"taxc-tdm-formplugin", (Object[])new Object[0])) && StringUtils.isEmpty((CharSequence)((CharSequence)map.get("orgs")))) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u89c4\u5219\u540d\u79f0\u201c%s\u201d\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ElementAddPlugin_25", (String)"taxc-tdm-formplugin", (Object[])new Object[0]), ruleName));
            }
            if (i == cardRowIndex) continue;
            datasourceMapList.forEach(p -> entityNameList.add(p.get("entityname")));
        }
        if (entityNameList.stream().anyMatch(p -> EntityV3Constant.ENTITY_V3.containsKey(p))) {
            DynamicObject taxType = (DynamicObject)this.getModel().getValue("taxtype");
            String draftPurpose = (String)this.getModel().getValue("draftpurpose");
            if (taxType == null || draftPurpose == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u5143\u7d20\u8bbe\u7f6e\u7a0e\u79cd\u548c\u5e95\u7a3f\u7528\u9014\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ElementAddPlugin_29", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private void verifyFetchRuleDatasource(List<Map<String, String>> datasourceMapList, String ruleName) {
        int index = 1;
        ArrayList rangeDateListList = new ArrayList(datasourceMapList.size());
        for (Map<String, String> datasourceMap : datasourceMapList) {
            Date endDate;
            if (EmptyCheckUtils.isEmpty((Object)datasourceMap.get("tableidd"))) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u89c4\u5219\u540d\u79f0\u201c%1$s\u201d\u7b2c%2$s\u884c\u6570\u636e\u6e90\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ElementAddPlugin_20", (String)"taxc-tdm-formplugin", (Object[])new Object[0]), ruleName, index));
            }
            if (EmptyCheckUtils.isEmpty((Object)datasourceMap.get("startdated"))) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u89c4\u5219\u540d\u79f0\u201c%1$s\u201d\u7b2c%2$s\u884c\u9002\u7528\u65f6\u95f4\u8d77\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ElementAddPlugin_21", (String)"taxc-tdm-formplugin", (Object[])new Object[0]), ruleName, index));
            }
            Date startDate = DateUtils.getFirstDateOfMonth((Date)DateUtils.stringToDate((String)String.valueOf(datasourceMap.get("startdated"))));
            Date date = endDate = EmptyCheckUtils.isNotEmpty((Object)datasourceMap.get("enddated")) ? DateUtils.getLastDateOfMonth((Date)DateUtils.stringToDate((String)String.valueOf(datasourceMap.get("enddated")))) : DateUtils.getLastDateOfMonth((Date)DateUtils.stringToDate((String)"2100-12-31"));
            if (startDate.compareTo(endDate) >= 0) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u89c4\u5219\u540d\u79f0\u201c%1$s\u201d\u7b2c%2$s\u884c\u9002\u7528\u65f6\u95f4\u6b62\u4e0d\u80fd\u65e9\u4e8e\u9002\u7528\u65f6\u95f4\u8d77\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e\u65f6\u95f4\u8303\u56f4\u3002", (String)"ElementAddPlugin_22", (String)"taxc-tdm-formplugin", (Object[])new Object[0]), ruleName, index));
            }
            for (int i = 0; i < rangeDateListList.size(); ++i) {
                List existDateRange = (List)rangeDateListList.get(i);
                if (DateUtils.checkTimeRepeat((Date)startDate, (Date)endDate, (Date)((Date)existDateRange.get(0)), (Date)((Date)existDateRange.get(1)))) continue;
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u89c4\u5219\u540d\u79f0\u201c%1$s\u201d\u7b2c%2$s\u884c\u548c\u7b2c%3$s\u884c\u7684\u65f6\u95f4\u8303\u56f4\u4e0d\u80fd\u91cd\u53e0\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e\u65f6\u95f4\u8303\u56f4\u3002", (String)"ElementAddPlugin_23", (String)"taxc-tdm-formplugin", (Object[])new Object[0]), ruleName, index, i + 1));
            }
            ArrayList<Date> dateList = new ArrayList<Date>();
            dateList.add(startDate);
            dateList.add(endDate);
            rangeDateListList.add(dateList);
            String filterJson = datasourceMap.get("filterjsond");
            if (StringUtils.isEmpty((CharSequence)filterJson) || !filterJson.contains("FilterRow")) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u89c4\u5219\u540d\u79f0\u201c%1$s\u201d\uff0c\u7b2c%2$s\u884c\u6570\u636e\u6e90\u7b5b\u9009\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ElementAddPlugin_24", (String)"taxc-tdm-formplugin", (Object[])new Object[0]), ruleName, index));
            }
            ++index;
        }
    }

    private void setBottomElementJsonTag() {
        CardEntry elementCard = (CardEntry)this.getControl(KEY_CARD_ENTRY_ENTITY);
        DynamicObject[] dynamicObjects = elementCard.getEntryData().getDataEntitys();
        ArrayList<Map> ruleList = new ArrayList<Map>(dynamicObjects.length);
        for (int i = 0; i < dynamicObjects.length; ++i) {
            String ruleIndex = dynamicObjects[i].getString("idcard");
            String ruleJson = this.getPageCache().get(this.getDataSourceRuleKey(ruleIndex));
            Map map = (Map)SerializationUtils.fromJsonString((String)ruleJson, Map.class);
            ruleList.add(map);
        }
        this.getModel().setValue("json_tag", (Object)SerializationUtils.toJsonString(ruleList));
    }

    private String getCycleReferenceCurElementName(String formula, String elementCode, String elementName) {
        List elementList = FormulaModifyHelper.getFormulaElementInfo((String)formula).stream().filter(p -> StringUtils.isNotEmpty((CharSequence)p) && p.contains(EXPRESSION_ELEMENT_NAME_CODE_DELIMITER) && p.split(EXPRESSION_ELEMENT_NAME_CODE_DELIMITER_SPIT).length > 1).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(elementList)) {
            return "";
        }
        if (elementList.stream().anyMatch(p -> p.split(EXPRESSION_ELEMENT_NAME_CODE_DELIMITER_SPIT)[1].equals(elementCode))) {
            return elementName;
        }
        List elementCodeList = elementList.stream().map(p -> p.split(EXPRESSION_ELEMENT_NAME_CODE_DELIMITER_SPIT)[1]).collect(Collectors.toList());
        QFilter qFilter = new QFilter("number", "in", elementCodeList);
        DynamicObjectCollection elementObjects = QueryServiceHelper.query((String)"tdm_element_group", (String)"bottom,formula,name", (QFilter[])new QFilter[]{qFilter});
        for (DynamicObject elementObject : elementObjects) {
            String cycleReferenceElementName = this.getCycleReferenceCurElementName(elementObject.getString("formula"), elementCode, elementObject.getString("name"));
            if (!StringUtils.isNotEmpty((CharSequence)cycleReferenceElementName)) continue;
            return cycleReferenceElementName;
        }
        return "";
    }

    private String verifyFormulaElement(String formula) {
        List formulaElements = FormulaModifyHelper.getFormulaElementInfo((String)formula);
        ArrayList<String> errorElements = new ArrayList<String>(16);
        HashSet<String> elementCodeList = new HashSet<String>(formulaElements.size());
        for (String formulaElement : formulaElements) {
            String[] splits = formulaElement.split(EXPRESSION_ELEMENT_NAME_CODE_DELIMITER_SPIT);
            if (splits.length != 2) {
                StringBuilder builder = new StringBuilder(EXPRESSION_ELEMENT_PREFIX);
                builder.append(formulaElement).append(EXPRESSION_ELEMENT_SUFFIX);
                errorElements.add(builder.toString());
                continue;
            }
            elementCodeList.add(splits[1].trim());
        }
        if (errorElements.size() > 0) {
            return String.format(ResManager.loadKDString((String)"\u8868\u8fbe\u5f0f\u914d\u7f6e\u9519\u8bef\uff0c\u3010%1$s\u3011\u683c\u5f0f\u6709\u8bef\u3002", (String)"ElementEditPlugin_0", (String)"taxc-tdm-formplugin", (Object[])new Object[0]), String.join((CharSequence)"\u3001", errorElements));
        }
        if (elementCodeList.size() > 0) {
            QFilter filter = new QFilter("number", "in", elementCodeList);
            List dbElementNumberList = QueryServiceHelper.query((String)"tdm_element_group", (String)"number", (QFilter[])new QFilter[]{filter}).stream().map(p -> p.getString("number")).collect(Collectors.toList());
            if (elementCodeList.size() != dbElementNumberList.size()) {
                elementCodeList.removeAll(dbElementNumberList);
                return String.format(ResManager.loadKDString((String)"\u8868\u8fbe\u5f0f\u914d\u7f6e\u9519\u8bef\uff0c\u3010%1$s\u3011\u7f16\u53f7\u5bf9\u5e94\u5143\u7d20\u4e0d\u5b58\u5728\u3002", (String)"ElementEditPlugin_1", (String)"taxc-tdm-formplugin", (Object[])new Object[0]), String.join((CharSequence)"\u3001", elementCodeList));
            }
        }
        return "";
    }

    private Boolean verifyFormula(String formula) throws Exception {
        int index = 1;
        while (formula.indexOf(EXPRESSION_ELEMENT_PREFIX) >= 0) {
            int prefixIndex = formula.indexOf(EXPRESSION_ELEMENT_PREFIX);
            int suffixIndex = formula.substring(prefixIndex).indexOf(EXPRESSION_ELEMENT_SUFFIX) + prefixIndex + EXPRESSION_ELEMENT_SUFFIX.length();
            String replaceValue = formula.substring(prefixIndex, suffixIndex);
            formula = formula.replace(replaceValue, String.valueOf(index));
            ++index;
        }
        List<String> formulaConstants = this.splitFormulaByOperator(formula, 0);
        String regex = "[+-]?\\d+(\\.\\d+)?";
        if (formulaConstants.stream().anyMatch(p -> StringUtils.isNotEmpty((CharSequence)p.trim()) && !p.trim().matches(regex))) {
            return false;
        }
        Parser.parse((String)formula).evaluate();
        return true;
    }

    private List<String> splitFormulaByOperator(String formula, int operatorIndex) {
        String operator = (String)OPERATOR.keySet().stream().collect(Collectors.toList()).get(operatorIndex);
        ArrayList<String> result = new ArrayList<String>(16);
        List<String> values = this.strToListByDelimiter(formula, OPERATOR.get(operator));
        if (operatorIndex == OPERATOR.size() - 1) {
            return values;
        }
        for (String value : values) {
            result.addAll(this.splitFormulaByOperator(value, operatorIndex + 1));
        }
        return result;
    }

    public void setNewElementDefaultValue() {
        Object id = this.getModel().getValue("id");
        if (id == null) {
            this.getModel().setValue("preset", (Object)"0");
            this.getModel().setValue("enable", (Object)"2");
            this.getModel().setValue("creator", (Object)RequestContext.get().getCurrUserId());
            this.getModel().setValue("createtime", (Object)new Date());
            this.getModel().setValue("status", (Object)"C");
        }
    }

    public void setTimeDeviationDesc() {
        String timeDeviationType = (String)this.getModel().getValue("timedeviationtype");
        String timeDeviationDirection = (String)this.getModel().getValue("timedeviationdirection");
        String timeDeviationCount = (String)this.getModel().getValue("timedeviationcount");
        Integer deviationCount = 0;
        if (StringUtils.isNumeric((CharSequence)timeDeviationCount)) {
            deviationCount = Integer.valueOf(timeDeviationCount);
        }
        this.getModel().setValue("timedeviation", (Object)TimeDeviatedEnum.getDeviatedDesc(timeDeviationDirection, deviationCount, timeDeviationType));
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if (key.startsWith("selectorgbtn")) {
            this.showOrgTreeList(OperationStatus.EDIT, ResManager.loadKDString((String)"\u9009\u62e9\u7ec4\u7ec7", (String)"ElementAddPlugin_13", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
        } else if (key.startsWith("viewselectorgbtn")) {
            this.showOrgTreeList(OperationStatus.VIEW, ResManager.loadKDString((String)"\u5df2\u9009\u7ec4\u7ec7", (String)"ElementAddPlugin_14", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
        } else if ("elementpond".equals(key)) {
            this.showSelectElement();
        } else if ("addrulebtn".equals(key) || "addrulebtnjiahao".equals(key)) {
            this.saveFetchRuleRow(EmptyCheckUtils.isEmpty((Object)this.getPageCache().get(CACHE_CURRENT_ROW_INDEX)) ? null : Integer.valueOf(Integer.parseInt(this.getPageCache().get(CACHE_CURRENT_ROW_INDEX))));
            this.addRule();
            this.getPageCache().put(CACHE_TABLE_ENTRY_ENTITY_CURRENT_ROW, "0");
        } else if (null != ExpressionBtnEnum.getEnumByButtonKey(control.getKey())) {
            this.calculationToolOperation(control.getKey());
        }
    }

    private void showOrgTreeList(OperationStatus status, String title) {
        ListShowParameter showParameter = ShowFormHelper.createShowListForm((String)RISK_ASSIGN_ORG, (boolean)true, (int)2);
        showParameter.setCustomParam("title", (Object)title);
        showParameter.setFormId(RISK_ASSIGN_ORG);
        showParameter.setParentPageId(this.getView().getPageId());
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        StyleCss sc = new StyleCss();
        sc.setHeight("660px");
        sc.setWidth("1200px");
        showParameter.getOpenStyle().setInlineStyleCss(sc);
        showParameter.setStatus(status);
        String orgs = String.valueOf(this.getModel().getValue("orgs"));
        ListSelectedRowCollection listSelectedRowCollection = new ListSelectedRowCollection();
        if (EmptyCheckUtils.isNotEmpty((Object)orgs)) {
            List structIds = OrgUtils.getStructurePkidsByOrgId(Arrays.stream(orgs.split(",")).collect(Collectors.toList()));
            for (String orgid : structIds) {
                ListSelectedRow row = new ListSelectedRow();
                row.setPrimaryKeyValue((Object)orgid);
                listSelectedRowCollection.add((Object)row);
            }
        }
        if (OperationStatus.EDIT == status) {
            if (EmptyCheckUtils.isNotEmpty((Object)this.getPageCache().get(ORGS_BY_ALL))) {
                String[] selectedorgs = this.getPageCache().get(ORGS_BY_ALL).split(",");
                String[] currentCardSelectedOrgs = orgs.split(",");
                List currentCardSelectedOrgList = Arrays.stream(currentCardSelectedOrgs).collect(Collectors.toList());
                List notInIds = Arrays.stream(selectedorgs).filter(v -> !currentCardSelectedOrgList.contains(v)).collect(Collectors.toList());
                if (EmptyCheckUtils.isNotEmpty(notInIds)) {
                    QFilter qFilter = new QFilter("org.id", "not in", notInIds.stream().map(v -> Long.parseLong(v)).collect(Collectors.toList()));
                    showParameter.getListFilterParameter().getQFilters().add(qFilter);
                }
            }
            QFilter enableFilter = new QFilter("org.enable", "=", (Object)"1");
            showParameter.getListFilterParameter().getQFilters().add(enableFilter);
            HasPermOrgResult hasPermOrgResult = PermissionUtils.getAllPermOrgs((IFormView)this.getView());
            hasPermOrgResult.getHasPermOrgs();
            if (!hasPermOrgResult.hasAllOrgPerm()) {
                QFilter qFilter = new QFilter("org.id", "in", (Object)hasPermOrgResult.getHasPermOrgs());
                showParameter.getListFilterParameter().getQFilters().add(qFilter);
            }
        } else {
            QFilter qFilter = new QFilter("org.id", "in", EmptyCheckUtils.isEmpty((Object)orgs) ? new ArrayList() : Arrays.stream(orgs.split(",")).map(v -> Long.parseLong(v)).collect(Collectors.toList()));
            showParameter.getListFilterParameter().getQFilters().add(qFilter);
        }
        showParameter.getListFilterParameter().getQFilters().add(new QFilter("view.treetype", "=", (Object)String.valueOf(OrgServiceHelper.getDefaultViewSchemaInfoId())));
        showParameter.getListFilterParameter().getQFilters().add(new QFilter("view.number", "=", (Object)"40"));
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, RISK_ASSIGN_ORG);
        showParameter.setCloseCallBack(closeCallBack);
        showParameter.setLookUp(true);
        showParameter.setListSelectedRowCollection(listSelectedRowCollection);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void showSelectElement() {
        ListShowParameter listForm = new ListShowParameter();
        StyleCss styleCss = new StyleCss();
        styleCss.setHeight("580px");
        styleCss.setWidth("960px");
        listForm.setFormId("bos_treelistf7");
        listForm.setBillFormId("tdm_element_group");
        listForm.setMultiSelect(false);
        ListFilterParameter listFilterParameter = new ListFilterParameter();
        listFilterParameter.getQFilters().add(new QFilter("enable", "=", (Object)"1"));
        Object qushutype = this.getModel().getValue("timedeviationtype");
        Long id = (Long)this.getModel().getValue("id");
        if (null != id && !id.equals(0L)) {
            listFilterParameter.getQFilters().add(new QFilter("id", "!=", (Object)id));
        }
        listFilterParameter.getQFilters().add(new QFilter("timedeviationtype", ">=", qushutype));
        listForm.setListFilterParameter(listFilterParameter);
        listForm.getOpenStyle().setInlineStyleCss(styleCss);
        listForm.getOpenStyle().setShowType(ShowType.Modal);
        listForm.setShowTitle(false);
        listForm.setLookUp(true);
        listForm.setCloseCallBack(new CloseCallBack((IFormPlugin)this, ELEMENT_SELECT));
        this.getView().showForm((FormShowParameter)listForm);
    }

    private void addRule() {
        int row = this.getModel().createNewEntryRow(KEY_CARD_ENTRY_ENTITY);
        this.getModel().setValue("rulenamecard", (Object)ResManager.loadKDString((String)"\u65b0\u589e\u89c4\u5219", (String)"ElementAddPlugin_27", (String)"taxc-tdm-formplugin", (Object[])new Object[0]), row);
        String idCard = this.idCardAddOne();
        this.getModel().setValue("idcard", (Object)idCard, row);
        CardEntry elementCard = (CardEntry)this.getControl(KEY_CARD_ENTRY_ENTITY);
        elementCard.selectCard(Integer.valueOf(row));
        elementCard.setChildVisible(false, row, new String[]{"vectordefault"});
        elementCard.getEntryData().getDataEntitys();
        elementCard.selectRowsChanged(Collections.singletonList(row), null);
    }

    private String idCardAddOne() {
        String maxIdCard = this.getPageCache().get(CACHE_MAX_ID_CARD);
        Integer idCard = Integer.parseInt(maxIdCard);
        idCard = idCard + 1;
        String res = String.valueOf(idCard);
        this.getPageCache().put(CACHE_MAX_ID_CARD, res);
        return res;
    }

    public void calculationToolOperation(String operateKey) {
        ExpressionBtnEnum buttonEnum = ExpressionBtnEnum.getEnumByButtonKey(operateKey);
        if (buttonEnum == null) {
            return;
        }
        if (operateKey.equals(ExpressionBtnEnum.CLR.getButtonKey())) {
            this.getModel().setValue("formula", (Object)"");
            FormulaEditHelper.setCursorIndex((IFormView)this.getView(), (String)"formula", (int)0);
        } else if (operateKey.equalsIgnoreCase(ExpressionBtnEnum.BACKSPACE.getButtonKey())) {
            FormulaModifyHelper.backspaceFormula((IFormView)this.getView(), (String)operateKey, (String)"formula");
        } else if (operateKey.equalsIgnoreCase(ExpressionBtnEnum.CONSTANT.getButtonKey())) {
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId(EXPRESS_CONSTANT);
            showParameter.setParentPageId(this.getView().getPageId());
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            StyleCss css = new StyleCss();
            css.setWidth("400px");
            css.setHeight("200px");
            showParameter.getOpenStyle().setInlineStyleCss(css);
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, EXPRESS_CONSTANT);
            showParameter.setCloseCallBack(closeCallBack);
            this.getView().showForm(showParameter);
        } else {
            FormulaEditHelper.insertExpression((IFormView)this.getView(), (String)operateKey, (String)"formula", (String)buttonEnum.getContent());
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        ListSelectedRowCollection listSelectedRows;
        if (StringUtils.equals((CharSequence)closedCallBackEvent.getActionId(), (CharSequence)EXPRESS_CONSTANT)) {
            String constant = (String)closedCallBackEvent.getReturnData();
            if (StringUtils.isNotEmpty((CharSequence)constant)) {
                FormulaEditHelper.insertExpression((IFormView)this.getView(), (String)"constant", (String)"formula", (String)constant);
            }
        } else if (ELEMENT_SELECT.equals(closedCallBackEvent.getActionId())) {
            ListSelectedRowCollection listSelectedRows2 = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
            if (null != listSelectedRows2 && !listSelectedRows2.isEmpty()) {
                String number = listSelectedRows2.get(0).getNumber();
                String eleName = listSelectedRows2.get(0).getName();
                StringBuilder builder = new StringBuilder(EXPRESSION_ELEMENT_PREFIX);
                builder.append(eleName).append(EXPRESSION_ELEMENT_NAME_CODE_DELIMITER).append(number).append(EXPRESSION_ELEMENT_SUFFIX);
                FormulaEditHelper.insertExpression((IFormView)this.getView(), (String)ExpressionBtnEnum.ELEMENT_POND.getButtonKey(), (String)"formula", (String)builder.toString());
            }
        } else if (RISK_ASSIGN_ORG.equals(closedCallBackEvent.getActionId()) && null != (listSelectedRows = (ListSelectedRowCollection)closedCallBackEvent.getReturnData()) && !listSelectedRows.isEmpty()) {
            ArrayList<String> orgList = new ArrayList<String>();
            for (ListSelectedRow listSelectedRow : listSelectedRows) {
                orgList.add(String.valueOf(listSelectedRow.getPrimaryKeyValue()));
            }
            List orgs = OrgUtils.getOrgIdByStructurePkids(orgList);
            this.getModel().setValue("orgs", (Object)orgs.stream().distinct().collect(Collectors.joining(",")));
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        if (e.getEntryProp().getName().equals(KEY_TABLE_CONFIG_ENTRY_ENTITY)) {
            if (EmptyCheckUtils.isNotEmpty((Object)this.getPageCache().get("isinitdatasouce"))) {
                return;
            }
            this.saveDatasourceRowFilterValue(this.getTableCurrentSelectRow());
            int insertRow = e.getInsertRow();
            if (insertRow < 0) {
                return;
            }
            this.getPageCache().put(CACHE_TABLE_ENTRY_ENTITY_CURRENT_ROW, String.valueOf(insertRow));
            this.setDatasourceRowValue(insertRow);
            super.afterAddRow(e);
        }
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        int[] delIndexes = e.getRowIndexs();
        if (e.getEntryProp().getName().equals(KEY_TABLE_CONFIG_ENTRY_ENTITY)) {
            int delIndex = delIndexes[0];
            if (delIndex > 0) {
                this.getPageCache().put(CACHE_TABLE_ENTRY_ENTITY_CURRENT_ROW, String.valueOf(--delIndex));
                this.setDatasourceRowValue(delIndex);
            } else if (delIndex == 0) {
                this.getPageCache().put(CACHE_TABLE_ENTRY_ENTITY_CURRENT_ROW, "0");
                this.setDatasourceRowValue(0);
            }
        } else {
            if (EmptyCheckUtils.isEmpty((Object)delIndexes)) {
                return;
            }
            CardEntry elementCard = (CardEntry)this.getControl(KEY_CARD_ENTRY_ENTITY);
            DynamicObject[] dynamicObjects = elementCard.getEntryData().getDataEntitys();
            CardEntry cardEntry = (CardEntry)this.getControl(KEY_CARD_ENTRY_ENTITY);
            cardEntry.selectRows(dynamicObjects.length - 1);
            cardEntry.selectCard(Integer.valueOf(dynamicObjects.length - 1));
            cardEntry.selectRowsChanged(Collections.singletonList(dynamicObjects.length - 1), null);
        }
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs e) {
        if (e.getEntryProp().getName().equals(KEY_TABLE_CONFIG_ENTRY_ENTITY)) {
            int[] delIndexes = e.getRowIndexs();
            if (EmptyCheckUtils.isEmpty((Object)delIndexes)) {
                return;
            }
            EntryGrid entryGrid = (EntryGrid)this.getControl(KEY_TABLE_CONFIG_ENTRY_ENTITY);
            DynamicObject[] exists = entryGrid.getEntryData().getDataEntitys();
            if (exists.length == 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u89c4\u5219\u81f3\u5c11\u9700\u8981\u4e00\u6761\u6570\u636e\u6e90", (String)"ElementAddPlugin_28", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
            }
            super.beforeDeleteRow(e);
        } else {
            this.saveFetchRuleRow(Integer.parseInt(this.getPageCache().get(CACHE_CURRENT_ROW_INDEX)));
            int[] delIndexes = e.getRowIndexs();
            if (EmptyCheckUtils.isEmpty((Object)delIndexes)) {
                return;
            }
            int delIndex = delIndexes[0];
            if (0 == delIndex) {
                e.setCancel(true);
            }
            String idCard = ((DynamicObject)this.getModel().getEntryEntity(KEY_CARD_ENTRY_ENTITY).get(delIndex)).getString("idcard");
            String cacheKey = this.getDataSourceRuleKey(idCard);
            this.getPageCache().remove(cacheKey);
            String ruleJson = this.getPageCache().get(cacheKey);
            if (EmptyCheckUtils.isEmpty((Object)ruleJson)) {
                return;
            }
            Map map = (Map)SerializationUtils.fromJsonString((String)ruleJson, Map.class);
            if (EmptyCheckUtils.isEmpty((Object)map)) {
                return;
            }
            if (EmptyCheckUtils.isNotEmpty(map.get("orgs"))) {
                String[] orgs = ((String)map.get("orgs")).split(",");
                this.updateOrgsByDel(Arrays.stream(orgs).collect(Collectors.toList()));
            }
        }
    }

    private void updateOrgsByDel(List<String> orgs) {
        if (EmptyCheckUtils.isNotEmpty((Object)this.getPageCache().get(ORGS_BY_ALL))) {
            String lastOrgs = Arrays.stream(this.getPageCache().get(ORGS_BY_ALL).split(",")).filter(v -> !orgs.contains(v)).collect(Collectors.joining(","));
            this.getPageCache().put(ORGS_BY_ALL, lastOrgs);
        }
    }

    public void beforeF7Select(BeforeFilterF7SelectEvent evt) {
        if ("bd_invoicetype".equals(evt.getRefEntityId()) && kd.bos.util.StringUtils.isNotEmpty((String)invoiceType)) {
            QFilter q = new QFilter("number", "in", Arrays.asList(invoiceType.split(",")));
            evt.addCustomQFilter(q);
        }
    }

    static {
        OPERATOR.put("+", "\\+");
        OPERATOR.put("-", "\\-");
        OPERATOR.put("*", "\\*");
        OPERATOR.put("/", "\\/");
        OPERATOR.put("(", "\\(");
        OPERATOR.put(")", "\\)");
        OPERATOR.put("abs", "abs");
    }

    static enum ExpressionBtnEnum {
        PLUS("plus", "+"),
        SUBTRACT("subtract", "-"),
        MULTIPLE("multiple", "*"),
        DIVIDE("divide", "/"),
        LEFT_PARENT_THESES("leftparentheses", "("),
        RIGHT_PARENT_THESES("rightparentheses", ")"),
        ABS("abs", "abs("),
        ELEMENT_POND("elementpond", "elementpond"),
        CLR("clr", "CLR"),
        BACKSPACE("backspace", "Backspace"),
        CONSTANT("constant", "constant");

        private String buttonKey;
        private String content;

        private ExpressionBtnEnum(String buttonKey, String content) {
            this.buttonKey = buttonKey;
            this.content = content;
        }

        public String getButtonKey() {
            return this.buttonKey;
        }

        public String getContent() {
            return this.content;
        }

        public static ExpressionBtnEnum getEnumByButtonKey(String buttonKey) {
            for (ExpressionBtnEnum value : ExpressionBtnEnum.values()) {
                if (!value.getButtonKey().equals(buttonKey)) continue;
                return value;
            }
            return null;
        }
    }
}

