/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tdm.formplugin.employeeCount;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.form.plugin.impt.BatchImportPlugin;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.taxc.bdtaxr.common.helper.TaxcCombineDataServiceHelper;
import kd.taxc.bdtaxr.common.helper.bastax.taxcorg.TaxcOrgDataServiceHelper;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;

public class EmployeeCountImportPlugin
extends BatchImportPlugin {
    private static final Log log = LogFactory.getLog(EmployeeCountImportPlugin.class);

    protected void beforeSave(List<ImportBillData> billdatas, ImportLogger logger) {
        Iterator<ImportBillData> iterator = billdatas.iterator();
        HashSet<String> orgNumbers = new HashSet<String>(16);
        HashMap map = new HashMap(16);
        while (iterator.hasNext()) {
            ImportBillData billData = iterator.next();
            JSONObject org = billData.getData().getJSONObject("org");
            if (EmptyCheckUtils.isEmpty((Object)org)) continue;
            String orgNumber = org.getString("number");
            orgNumbers.add(orgNumber);
            if (EmptyCheckUtils.isEmpty(map.get(orgNumber))) {
                ArrayList<ImportBillData> list = new ArrayList<ImportBillData>();
                list.add(billData);
                map.put(orgNumber, list);
                continue;
            }
            ((List)map.get(orgNumber)).add(billData);
        }
        List actOrgs = (List)TaxcOrgDataServiceHelper.queryTaxcOrgByOrgNum(new ArrayList(orgNumbers)).getData();
        List actNumbers = actOrgs.stream().map(data -> data.getString("org.number")).collect(Collectors.toList());
        for (String orgNumber : orgNumbers) {
            if (actNumbers.contains(orgNumber)) continue;
            for (ImportBillData billData : (List)map.get(orgNumber)) {
                logger.log(Integer.valueOf(billData.getStartIndex()), ResManager.loadKDString((String)"\u7a0e\u52a1\u7ec4\u7ec7\u4e0d\u5b58\u5728\u6216\u672a\u542f\u7528\u3002", (String)"EmployeeCountImportPlugin_0", (String)"taxc-tdm-formplugin", (Object[])new Object[0])).fail();
                billdatas.remove(billData);
            }
        }
        List permOrgs = (List)TaxcCombineDataServiceHelper.queryOrgIdByViewWithPerm((Long)RequestContext.get().getCurrUserId(), (String)"tdm", (String)"tdm_employee_count", (String)"47156aff000000ac", (String)"40").getData();
        log.info("\u5f15\u5165\u6587\u4ef6\u4e2d\u53ef\u7528\u7684\u7ec4\u7ec7\uff1a" + orgNumbers);
        log.info("\u6709\u65b0\u589e\u6743\u9650\u7684\u7ec4\u7ec7\uff1a" + permOrgs);
        if (EmptyCheckUtils.isNotEmpty((Object)actOrgs)) {
            for (DynamicObject org : actOrgs) {
                if (permOrgs.contains(org.getLong("id"))) continue;
                String unqNumber = org.getString("org.number");
                for (ImportBillData billData : (List)map.get(unqNumber)) {
                    logger.log(Integer.valueOf(billData.getStartIndex()), ResManager.loadKDString((String)"\u6ca1\u6709\u7ec4\u7ec7\u7684\u65b0\u589e\u6743\u9650\u3002", (String)"EmployeeCountImportPlugin_1", (String)"taxc-tdm-formplugin", (Object[])new Object[0])).fail();
                    billdatas.remove(billData);
                }
            }
        }
    }
}

