/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tdm.formplugin.finance;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.control.Button;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.taxc.tdm.common.helper.InvokeBizServiceHelper;
import kd.taxc.tdm.common.util.AppLogUtils;
import kd.taxc.tdm.common.util.DateUtils;
import kd.taxc.tdm.common.util.PermissionUtils;

public class FinanceGlRptFormPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static Log logger = LogFactory.getLog(FinanceGlRptFormPlugin.class);
    private static final String BTNOK = "btnok";
    private static final String ORG = "org";
    private static final String PERIOD = "period";
    private static final String RPTTYPE = "rpttype";
    private static final String ACCOUNTBOOKSTYPE = "accountbookstype";
    private static final String BASEDATA_ID = "fbasedataid";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{BTNOK});
        MulBasedataEdit orgMulBaseEdit = (MulBasedataEdit)this.getView().getControl(ORG);
        orgMulBaseEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        if (beforeF7SelectEvent.getProperty().getName().startsWith(ORG)) {
            List orgs = PermissionUtils.getAccountingOrgIds((IFormView)this.getView().getParentView());
            QFilter filters = new QFilter("id", "in", (Object)orgs);
            ListShowParameter formShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            formShowParameter.getListFilterParameter().setFilter(filters);
        }
    }

    public void afterCreateNewData(EventObject e) {
        Long orgId = PermissionUtils.getAccountingDefaultOrgId((IFormView)this.getView().getParentView());
        this.getModel().setValue(ORG, (Object)Collections.singleton(orgId).toArray());
    }

    public void click(EventObject evt) {
        Object source = evt.getSource();
        if (source instanceof Button && BTNOK.equals(((Button)source).getKey())) {
            DynamicObjectCollection orgs = (DynamicObjectCollection)this.getModel().getValue(ORG);
            String accountbookstype = (String)this.getModel().getValue(ACCOUNTBOOKSTYPE);
            Date period = (Date)this.getModel().getValue(PERIOD);
            String periodStr = DateUtils.getFirstDateOfMonthStr((Date)period, (String)"yyyy-MM-dd");
            String types = (String)this.getModel().getValue(RPTTYPE);
            List typeList = Arrays.asList(types.split(",")).stream().filter(s -> StringUtils.isNotBlank((CharSequence)s)).collect(Collectors.toList());
            List orgList = orgs.stream().map(e -> e.getDynamicObject(BASEDATA_ID).getString("id")).collect(Collectors.toList());
            ArrayList params = new ArrayList();
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("orgList", orgList);
            map.put(PERIOD, periodStr);
            map.put("typeList", typeList);
            map.put("bookType", accountbookstype);
            params.add(map);
            try {
                Map resultmap;
                String resultmsg;
                Object resultobj = InvokeBizServiceHelper.invokeIscService((String)"execute", (String)"KDflow_GlRptDataSync(IERP-IERP)", params);
                if (resultobj != null && StringUtils.isNotBlank((CharSequence)(resultmsg = (String)((Map)(resultmap = (Map)JSONObject.parseObject((String)JSONObject.toJSONString((Object)resultobj), HashMap.class)).get("output")).get("resultmsg"))) && !"success".equals(resultmsg)) {
                    this.getView().showTipNotification(resultmsg);
                    return;
                }
            }
            catch (Exception ex) {
                logger.error("FinanceGlRptFormPlugin click", (Throwable)ex);
                String opName = ResManager.loadKDString((String)"\u540c\u6b65\u62a5\u8868", (String)"FinanceGlRptFormPlugin_2", (String)"taxc-tdm-formplugin", (Object[])new Object[0]);
                String opDesc = ResManager.loadKDString((String)"\u540c\u6b65\u5931\u8d25", (String)"FinanceGlRptFormPlugin_3", (String)"taxc-tdm-formplugin", (Object[])new Object[0]);
                AppLogUtils.addLog((String)"tdm_finance_main", (String)opName, (String)opDesc);
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u540c\u6b65\u5931\u8d25\uff1a%s\u3002", (String)"FinanceGlRptFormPlugin_0", (String)"taxc-tdm-formplugin", (Object[])new Object[0]), ex.getMessage()));
                return;
            }
            this.getView().setEnable(Boolean.FALSE, new String[]{BTNOK});
            String opName = ResManager.loadKDString((String)"\u540c\u6b65\u62a5\u8868", (String)"FinanceGlRptFormPlugin_2", (String)"taxc-tdm-formplugin", (Object[])new Object[0]);
            String opDesc = ResManager.loadKDString((String)"\u540c\u6b65\u6210\u529f", (String)"FinanceGlRptFormPlugin_1", (String)"taxc-tdm-formplugin", (Object[])new Object[0]);
            AppLogUtils.addLog((String)"tdm_finance_main", (String)opName, (String)opDesc);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u540c\u6b65\u6210\u529f", (String)"FinanceGlRptFormPlugin_1", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String itemKey = e.getProperty().getName();
        if (ORG.equals(itemKey) || PERIOD.equals(itemKey) || RPTTYPE.equals(itemKey) || ACCOUNTBOOKSTYPE.equals(itemKey)) {
            this.getView().setEnable(Boolean.TRUE, new String[]{BTNOK});
        }
    }
}

