/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tdm.formplugin.finance;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.exception.KDBizException;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.control.Control;
import kd.bos.form.control.Image;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.BillList;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.upload.UploadOption;
import kd.taxc.bdtaxr.common.tctb.common.util.PermissionUtils;
import kd.taxc.tdm.common.util.AppLogUtils;
import kd.taxc.tdm.common.util.DBUtils;
import kd.taxc.tdm.common.util.DateUtils;
import kd.taxc.tdm.common.util.EmptyCheckUtils;
import kd.taxc.tdm.common.util.StringUtil;
import kd.taxc.tdm.formplugin.constant.FinanceReportMappingEnum;
import kd.taxc.tdm.formplugin.utils.FinanceTemplateUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.poi.openxml4j.util.ZipSecureFile;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;

public class FinanceImportPlugin
extends AbstractFormPlugin
implements UploadListener,
HyperLinkClickListener {
    private static Log logger = LogFactory.getLog(FinanceImportPlugin.class);
    private static final String TDM_FINANCE_MAIN = "tdm_finance_main";
    private static final Map<String, String> typeToItemEntity = new HashMap<String, String>();

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"btnok", "btnupload", "btndownload", "btndel", "buttondownload"});
        Image label = (Image)this.getControl("btnupload");
        label.addUploadListener((UploadListener)this);
        BillList billList = (BillList)this.getControl("billlistap");
        billList.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        BillList billList = (BillList)this.getControl("billlistap");
        Object templatetypelist = this.getView().getFormShowParameter().getCustomParams().get("templatetypelist");
        if (ObjectUtils.isNotEmpty(templatetypelist)) {
            billList.setFilter(new QFilter("id", "in", templatetypelist));
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        if ("name".equals(hyperLinkClickEvent.getFieldName())) {
            BillList list = (BillList)hyperLinkClickEvent.getSource();
            ListSelectedRow currentSelectedRowInfo = list.getCurrentSelectedRowInfo();
            Long templateId = (Long)currentSelectedRowInfo.getPrimaryKeyValue();
            DynamicObject template = FinanceTemplateUtils.getTemplateObject(templateId);
            if (template == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5bfc\u51fa\u5931\u8d25\uff0c\u6a21\u677f\u4e0d\u5b58\u5728\u3002", (String)"FinanceImportPlugin_0", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
                return;
            }
            try {
                DynamicObjectCollection templateItems = template.getDynamicObjectCollection("entryentity");
                String name = template.getString("templatetype.name");
                String type = template.getString("templatetype.number");
                String url = FinanceTemplateUtils.downFinanceExcelFile(type, name, null, null, templateItems);
                String serviceAppId = this.getView().getFormShowParameter().getServiceAppId();
                String entityNum = "tdm_finance_template";
                PermissionUtils.putTempFilePermissionCache((String)url, (String)serviceAppId, (String)entityNum, (String)"4730fc9f000004ae");
                this.getView().openUrl(url);
            }
            catch (Exception e) {
                logger.error("\u5bfc\u51fa\u5931\u8d25\uff1a", (Throwable)e);
            }
        }
    }

    public void click(EventObject evt) {
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        Control control = (Control)evt.getSource();
        if ("btnupload".equals(control.getKey())) {
            if (selectedRows.size() <= 0) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u62a5\u8868\u6a21\u677f\u3002", (String)"FinanceImportPlugin_1", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
                return;
            }
            UploadOption opt = new UploadOption();
            opt.setMultiple(true);
            opt.setTitle(ResManager.loadKDString((String)"\u4e0a\u4f20\u6570\u636e\u6587\u4ef6", (String)"FinanceImportPlugin_2", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
            opt.setSuffix(".xlsx");
            opt.setLimitSize(0x1400000L);
            this.getView().showUpload(opt, "btnupload");
        } else if ("btnok".equals(control.getKey())) {
            if (selectedRows.size() <= 0) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u62a5\u8868\u6a21\u677f\u3002", (String)"FinanceImportPlugin_1", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
                return;
            }
            String file_list = this.getPageCache().get("_file_list_");
            if (StringUtils.isEmpty((CharSequence)file_list)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e0a\u4f20\u6587\u4ef6", (String)"FinanceImportPlugin_3", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
                return;
            }
            List filelist = (List)SerializationUtils.deSerializeFromBase64((String)file_list);
            if (filelist.size() > 3 || filelist.size() == 0) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e0d\u591a\u4e8e3\u4e2a\u6587\u4ef6\u4e0a\u4f20", (String)"FinanceImportPlugin_4", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
                return;
            }
            Long templateId = (Long)selectedRows.get(0).getPrimaryKeyValue();
            StringBuilder errorMsg = this.saveImportDatas(templateId, filelist);
            if (errorMsg.length() > 0) {
                String opName = ResManager.loadKDString((String)"\u5f15\u5165\u6570\u636e", (String)"FinanceImportPlugin_25", (String)"taxc-tdm-formplugin", (Object[])new Object[0]);
                String opDesc = errorMsg.toString();
                AppLogUtils.addLog((String)TDM_FINANCE_MAIN, (String)opName, (String)opDesc);
                this.getView().showErrorNotification(errorMsg.toString());
                return;
            }
            String opName = ResManager.loadKDString((String)"\u5f15\u5165\u6570\u636e", (String)"FinanceImportPlugin_25", (String)"taxc-tdm-formplugin", (Object[])new Object[0]);
            String opDesc = ResManager.loadKDString((String)"\u5bfc\u5165\u6210\u529f", (String)"FinanceImportPlugin_5", (String)"taxc-tdm-formplugin", (Object[])new Object[0]);
            AppLogUtils.addLog((String)TDM_FINANCE_MAIN, (String)opName, (String)opDesc);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5bfc\u5165\u6210\u529f", (String)"FinanceImportPlugin_5", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
            this.getView().returnDataToParent((Object)"success");
            this.getView().close();
        } else if ("btndel".equals(control.getKey())) {
            int index = this.getModel().getEntryCurrentRowIndex("upload_urls");
            String file_list = this.getPageCache().get("_file_list_");
            List<Map> filelist = StringUtils.isBlank((CharSequence)file_list) ? new ArrayList() : (List)SerializationUtils.deSerializeFromBase64((String)file_list);
            String url = (String)this.getModel().getValue("url", index);
            filelist.removeIf(f -> f.get("url").equals(url));
            this.getPageCache().put("_file_list_", SerializationUtils.serializeToBase64(filelist));
            this.getModel().deleteEntryRow("upload_urls", index);
        }
    }

    private StringBuilder saveImportDatas(Long templateId, List<Map<String, Object>> filelist) {
        StringBuilder message = new StringBuilder();
        DynamicObject template = FinanceTemplateUtils.getTemplateObject(templateId);
        if (template == null) {
            message.append(ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25\uff0c\u6a21\u677f\u4e0d\u5b58\u5728\u3002", (String)"FinanceImportPlugin_6", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
            return message;
        }
        FileService service = FileServiceFactory.getAttachmentFileService();
        for (int i = 0; i < filelist.size(); ++i) {
            Map<String, Object> fileMap = filelist.get(i);
            String file_url = (String)fileMap.get("url");
            String fileName = (String)fileMap.get("name1");
            if (StringUtils.isBlank((CharSequence)file_url)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u4e0a\u4f20\u5bfc\u5165\u6570\u636e", (String)"FinanceImportPlugin_7", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
            }
            InputStream inputStream = service.getInputStream(file_url);
            try {
                this.handleInputStream(inputStream, templateId, template.getString("templatetype.name"));
                continue;
            }
            catch (RuntimeException e) {
                logger.error("saveImportDatas", (Throwable)e);
                String error = e.getMessage();
                if (StringUtils.isBlank((CharSequence)error)) {
                    message.append(ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25\uff0c\u8bf7\u9009\u62e9\u6b63\u786e\u7684\u62a5\u8868\u6a21\u677f\u6570\u636e\u5bfc\u5165\u3002", (String)"FinanceImportPlugin_8", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
                    continue;
                }
                message.append(ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25\uff01\u9519\u8bef\u4fe1\u606f\uff1a", (String)"FinanceImportPlugin_9", (String)"taxc-tdm-formplugin", (Object[])new Object[0])).append(error).append("\r\n");
            }
        }
        return message;
    }

    private void handleInputStream(InputStream inputStream, Long templateId, String templateName) {
        StringBuilder errorMsg = new StringBuilder();
        Workbook workbook = null;
        try {
            ZipSecureFile.setMinInflateRatio((double)-1.0);
            workbook = WorkbookFactory.create((InputStream)inputStream);
        }
        catch (Exception e) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u4e0a\u4f20Excel\u683c\u5f0f\u6587\u4ef6", (String)"FinanceImportPlugin_10", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
        }
        Iterator it = workbook.sheetIterator();
        ArrayList<DynamicObject> saveMainList = new ArrayList<DynamicObject>();
        ArrayList<DynamicObject> saveSubList = new ArrayList<DynamicObject>();
        ArrayList<String> itemNumberList = new ArrayList<String>();
        String type = "";
        String typeName = "";
        String entityName = "";
        while (it.hasNext()) {
            Sheet sheet = (Sheet)it.next();
            Long sbbid = DBUtils.getLongId((String)TDM_FINANCE_MAIN);
            String orgNumber = "";
            String period = "";
            String isAdjust = "";
            String adjPeri = "";
            for (Row row2 : sheet) {
                int rowNum = row2.getRowNum();
                if (rowNum == 0) {
                    orgNumber = row2.getCell(1).getStringCellValue();
                }
                if (rowNum == 1) {
                    typeName = row2.getCell(1).getStringCellValue();
                    period = row2.getCell(3).getStringCellValue();
                    if (StringUtils.isBlank((CharSequence)orgNumber)) {
                        errorMsg.append(ResManager.loadKDString((String)"\u7f16\u5236\u7ec4\u7ec7\u7f16\u7801\u3001", (String)"FinanceImportPlugin_11", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
                    }
                    if (StringUtils.isBlank((CharSequence)typeName)) {
                        errorMsg.append(ResManager.loadKDString((String)"\u62a5\u8868\u7c7b\u578b\u3001", (String)"FinanceImportPlugin_12", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
                    }
                    if (StringUtils.isBlank((CharSequence)period)) {
                        errorMsg.append(ResManager.loadKDString((String)"\u62a5\u8868\u671f\u95f4\u3001", (String)"FinanceImportPlugin_13", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
                    }
                    if (errorMsg.length() > 0) {
                        String msg = errorMsg.toString().substring(0, errorMsg.lastIndexOf("\u3001"));
                        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199%s\u3002", (String)"FinanceImportPlugin_14", (String)"taxc-tdm-formplugin", (Object[])new Object[0]), msg));
                    }
                    if (!templateName.equals(typeName)) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6b63\u786e\u7684\u6a21\u677f\u5f15\u5165", (String)"FinanceImportPlugin_15", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
                    }
                }
                if (rowNum == 2) {
                    try {
                        isAdjust = row2.getCell(1).getStringCellValue();
                    }
                    catch (IllegalStateException e) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u8c03\u6574\u671f\u503c\u4e0d\u6b63\u786e\u3002", (String)"FinanceImportPlugin_16", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
                    }
                    if (EmptyCheckUtils.isEmpty((Object)isAdjust)) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u8c03\u6574\u671f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"FinanceImportPlugin_17", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
                    }
                    if (EmptyCheckUtils.isEmpty((Object)(isAdjust = FinanceTemplateUtils.convertForImport(isAdjust)))) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u8c03\u6574\u671f\u503c\u4e0d\u6b63\u786e\u3002", (String)"FinanceImportPlugin_16", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
                    }
                    adjPeri = row2.getCell(3).getStringCellValue();
                    if (adjPeri.length() > 50) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u8c03\u6574\u671f\u95f4\u8d85\u8fc7\u957f\u5ea6\u9650\u5236\u3002", (String)"FinanceImportPlugin_18", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
                    }
                    if (StringUtil.equals((CharSequence)isAdjust, (CharSequence)"0")) {
                        adjPeri = "";
                    }
                }
                if (rowNum == 3) {
                    String accountbookstype = row2.getCell(1).getStringCellValue();
                    DynamicObject org = this.queryOrgByNumber(orgNumber);
                    if (org == null) {
                        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a\uff1a%s\u7684\u6838\u7b97\u7ec4\u7ec7\u4e0d\u5b58\u5728", (String)"FinanceImportPlugin_19", (String)"taxc-tdm-formplugin", (Object[])new Object[0]), orgNumber));
                    }
                    DynamicObject typeObject = FinanceTemplateUtils.getTemplateTypeByName(typeName);
                    if (typeObject == null) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u62a5\u8868\u7c7b\u578b\u4e0d\u5b58\u5728\u3002", (String)"FinanceImportPlugin_20", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
                    }
                    type = typeObject.getString("number");
                    entityName = FinanceReportMappingEnum.getEntityNameByType(type);
                    StringBuilder message = this.checkMainTableDatas(orgNumber, org, period, type, typeName, accountbookstype, isAdjust, adjPeri);
                    if (message.length() > 0) {
                        throw new KDBizException(message.toString());
                    }
                    saveMainList.add(this.buildMainTableData(sbbid, org, period, type, accountbookstype, templateId, isAdjust, adjPeri));
                }
                if (rowNum < 5) continue;
                List<String> amountFields = FinanceReportMappingEnum.getAmountFieldByType(type);
                DynamicObject itemObj = BusinessDataServiceHelper.newDynamicObject((String)entityName);
                Long subid = DBUtils.getLongId((String)entityName);
                itemObj.set("id", (Object)subid);
                itemObj.set("sbbid", (Object)sbbid);
                itemObj.set("ewblxh", (Object)row2.getCell(0).getStringCellValue());
                itemObj.set("reportitem", (Object)row2.getCell(0).getStringCellValue());
                itemNumberList.add(row2.getCell(0).getStringCellValue());
                this.setAmountValue(amountFields, itemObj, row2);
                saveSubList.add(itemObj);
            }
        }
        if (saveMainList.size() > 0) {
            String itemEntity = typeToItemEntity.get(type);
            DynamicObjectCollection colls = QueryServiceHelper.query((String)itemEntity, (String)"id,number", (QFilter[])new QFilter[]{new QFilter("number", "in", (Object)itemNumberList.toArray(new String[0]))});
            HashMap<String, Long> itemIdMap = new HashMap<String, Long>(colls.size());
            for (DynamicObject col : colls) {
                itemIdMap.put(col.getString("number"), col.getLong("id"));
            }
            saveSubList.forEach(row -> {
                if (itemIdMap.containsKey(row.get("reportitem"))) {
                    row.set("ewblxh", itemIdMap.get(row.get("reportitem")));
                    row.set("reportitem", itemIdMap.get(row.get("reportitem")));
                }
            });
            SaveServiceHelper.save((DynamicObject[])saveMainList.toArray(new DynamicObject[0]));
            SaveServiceHelper.save((DynamicObject[])saveSubList.toArray(new DynamicObject[0]));
        }
    }

    private void setAmountValue(List<String> amountFields, DynamicObject itemObj, Row row) {
        for (int i = 0; i < amountFields.size(); ++i) {
            String field = amountFields.get(i);
            itemObj.set(field, (Object)row.getCell(i + 2).getNumericCellValue());
        }
    }

    private StringBuilder checkMainTableDatas(String orgNumber, DynamicObject org, String period, String type, String typeName, String accountbookstype, String isAdjust, String adjPeri) {
        StringBuilder msg = new StringBuilder();
        if (!org.getBoolean("fisaccounting")) {
            return msg.append(ResManager.loadKDString((String)"\u8be5\u7ec4\u7ec7\u4e0d\u662f\u6838\u7b97\u7ec4\u7ec7", (String)"FinanceImportPlugin_21", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
        }
        Date periodDate = null;
        try {
            periodDate = DateUtils.stringToDate((String)period, (String)"yyyy-MM");
        }
        catch (Exception e) {
            logger.error("FinanceImportPlugin checkMainTableDatas", (Throwable)e);
            msg.append(ResManager.loadKDString((String)"\u65e5\u671f\u683c\u5f0f\u9519\u8bef,\u6b63\u786e\u683c\u5f0f\u4e3a:yyyy-MM", (String)"FinanceImportPlugin_22", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
            return msg;
        }
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(new QFilter("org.id", "=", (Object)org.getLong("id")));
        filters.add(new QFilter("templatetype", "=", (Object)type));
        filters.add(new QFilter("skssqq", "=", (Object)DateUtils.getFirstDateOfMonth((Date)periodDate)));
        filters.add(new QFilter("accountbookstype", "=", (Object)accountbookstype));
        filters.add(new QFilter("isadjust", "=", (Object)isAdjust));
        filters.add(new QFilter("adjPeri", "=", (Object)adjPeri));
        DynamicObjectCollection mainColls = QueryServiceHelper.query((String)TDM_FINANCE_MAIN, (String)"id", (QFilter[])filters.toArray(new QFilter[filters.size()]));
        if (mainColls.size() > 0) {
            msg.append(String.format(ResManager.loadKDString((String)"%1$s%2$s%3$s\u5df2\u5b58\u5728\u540c\u4e00\u8c03\u6574\u671f\u7684%4$s\uff0c\u5982\u9700\u66f4\u65b0\uff0c\u8bf7\u5220\u9664\u540e\u518d\u5f15\u5165\u3002", (String)"FinanceImportPlugin_23", (String)"taxc-tdm-formplugin", (Object[])new Object[0]), orgNumber, org.getString("name"), DateUtils.format((Date)periodDate, (String)DateUtils.YYYYMM_CHINESE), typeName));
        }
        return msg;
    }

    private DynamicObject queryOrgByNumber(String orgNumber) {
        if (StringUtils.isBlank((CharSequence)orgNumber)) {
            return null;
        }
        return QueryServiceHelper.queryOne((String)"bos_org", (String)"id,number,name,fisaccounting", (QFilter[])new QFilter("number", "=", (Object)orgNumber).toArray());
    }

    private DynamicObject buildMainTableData(Long id, DynamicObject org, String period, String typeId, String accountbookstype, Long templateId, String isAdjust, String adjPeri) {
        Date periodDate = DateUtils.stringToDate((String)period, (String)"yyyy-MM");
        DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)TDM_FINANCE_MAIN);
        dynamicObject.set("id", (Object)id);
        dynamicObject.set("org", (Object)org.getString("id"));
        dynamicObject.set("bzorg", (Object)org.getString("name"));
        dynamicObject.set("type", (Object)typeId);
        dynamicObject.set("templatetype", (Object)typeId);
        dynamicObject.set("template", (Object)templateId);
        dynamicObject.set("peirod", (Object)DateUtils.format((Date)periodDate, (String)DateUtils.YYYYMM_CHINESE));
        dynamicObject.set("skssqq", (Object)DateUtils.getFirstDateOfMonth((Date)periodDate));
        dynamicObject.set("skssqz", (Object)DateUtils.getLastDateOfMonth((Date)periodDate));
        dynamicObject.set("isadjust", (Object)isAdjust);
        dynamicObject.set("adjperi", (Object)adjPeri);
        dynamicObject.set("datasource", (Object)"mbyr");
        dynamicObject.set("sourcesystem", (Object)"ierp");
        dynamicObject.set("accountbookstype", (Object)accountbookstype);
        return dynamicObject;
    }

    public void upload(UploadEvent evt) {
        String cacheUrls = this.getPageCache().get("_file_list_");
        List<Map> filelist = StringUtils.isBlank((CharSequence)cacheUrls) ? new ArrayList() : (List)SerializationUtils.deSerializeFromBase64((String)cacheUrls);
        Object[] urls = evt.getUrls();
        this.getModel().beginInit();
        for (int i = 0; i < urls.length; ++i) {
            if (urls[i] == null) continue;
            String urlStr = (String)((Map)urls[i]).get("url");
            String urlName = (String)((Map)urls[i]).get("name");
            if (!StringUtils.isNotBlank((CharSequence)urlStr)) continue;
            filelist.add((Map)urls[i]);
            int index = this.getModel().createNewEntryRow("upload_urls");
            this.getModel().setValue("name1", (Object)urlName, index);
            this.getModel().setValue("url", (Object)urlStr, index);
        }
        this.getModel().endInit();
        this.getView().updateView("upload_urls");
        this.getPageCache().put("_file_list_", SerializationUtils.serializeToBase64(filelist));
    }

    public void remove(UploadEvent evt) {
        String cacheUrls = this.getPageCache().get("_file_list_");
        List<Map> filelist = StringUtils.isBlank((CharSequence)cacheUrls) ? new ArrayList() : (List)SerializationUtils.deSerializeFromBase64((String)cacheUrls);
        for (Object url : evt.getUrls()) {
            filelist.removeIf(f -> f.get("uid").equals(((Map)url).get("uid")));
        }
        this.getPageCache().put("_file_list_", SerializationUtils.serializeToBase64(filelist));
    }

    static {
        typeToItemEntity.put("lrb", "tdm_item_lrb");
        typeToItemEntity.put("hblrb", "tdm_item_lrb");
        typeToItemEntity.put("zcfzb", "tdm_item_zcfzb");
        typeToItemEntity.put("hbzcfzb", "tdm_item_zcfzb");
        typeToItemEntity.put("xjllb", "tdm_item_xjllb");
        typeToItemEntity.put("hbxjllb", "tdm_item_xjllb");
        typeToItemEntity.put("syzqybdb", "tdm_item_qybdb");
        typeToItemEntity.put("hbsyzqybdb", "tdm_item_qybdb");
    }
}

