/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tdm.formplugin.finance;

import java.util.EventObject;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.IFormView;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.mvc.bill.BillView;
import kd.bos.orm.query.QFilter;
import kd.taxc.tdm.common.util.PermissionUtils;

public class FinanceItemEditPlugin
extends AbstractBasePlugIn
implements BeforeF7SelectListener {
    private static final String NUMBER = "number";
    private static final String NAME = "name";
    private static final String PARENT = "parent";
    private static final String BTNOK = "btnok";

    public void initialize() {
        super.initialize();
        BasedataEdit parentEdit = (BasedataEdit)this.getControl(PARENT);
        parentEdit.addBeforeF7SelectListener(beforeF7SelectEvent -> this.beforeF7Select(beforeF7SelectEvent));
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        Long itemId = dataEntity.getLong("id");
        if (dataEntity != null && itemId != 0L) {
            QFilter idFilter = new QFilter("id", "!=", (Object)itemId);
            QFilter parentFilter = new QFilter(PARENT, "!=", (Object)itemId).or(new QFilter(PARENT, "is null", null));
            ListShowParameter formShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            formShowParameter.getListFilterParameter().setFilter(idFilter.and(parentFilter));
        }
    }

    public void afterBindData(EventObject e) {
        BillView billView = (BillView)e.getSource();
        OperationStatus status = billView.getFormShowParameter().getStatus();
        boolean hasSpecificPerm = PermissionUtils.hasSpecificPerm((IFormView)this.getView().getParentView(), (String)"4715a0df000000ac");
        if (OperationStatus.EDIT.equals((Object)status) && !hasSpecificPerm) {
            this.getView().setEnable(Boolean.FALSE, new String[]{NUMBER, NAME, PARENT, BTNOK});
        }
    }
}

