/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tdm.formplugin.finance;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.filter.FilterParameter;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.tree.TreeNode;
import kd.bos.filter.FilterContainer;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.FilterContainerInitEvent;
import kd.bos.form.control.events.SearchClickEvent;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.taxc.bdtaxr.common.tctb.common.util.PermissionUtils;
import kd.taxc.tdm.formplugin.constant.ReportItemTreeEnum;
import kd.taxc.tdm.formplugin.utils.ExportFinanceItemUtils;
import kd.taxc.tdm.formplugin.utils.TreeUtils;

public class FinanceItemListPlugin
extends AbstractListPlugin
implements TreeNodeClickListener,
HyperLinkClickListener {
    private static final Log logger = LogFactory.getLog(FinanceItemListPlugin.class);
    private static final String TOOLBARAP = "toolbarap";
    private static final String FILTERCONTAINERAP = "filtercontainerap";
    private static final String EDIT = "edit";
    private static final String TBL_NEW = "tblnew";
    private static final String TBL_DEL = "delete";
    private static final String TBL_ENABLE = "enable";
    private static final String TBL_DISABLE = "disable";
    private static final String TBL_REFRESH = "tblrefresh";
    private static final String TREE_VIEWAP = "treeviewap";
    private static final String ENTRY_ENTITY = "entryentity";
    private static final String IMPORTDATA = "importdata";
    private static final String EXPORTDATA = "exportdata";
    private static final String CACHE_FILTERS = "cache_filters";
    private static final String CACHE_CURRENT_NODE = "cache_current_node";

    public void registerListener(EventObject e) {
        TreeView tree = (TreeView)this.getControl(TREE_VIEWAP);
        tree.addTreeNodeClickListener((TreeNodeClickListener)this);
        this.addItemClickListeners(new String[]{TOOLBARAP});
        EntryGrid entry = (EntryGrid)this.getControl(ENTRY_ENTITY);
        entry.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        if ("number".equals(hyperLinkClickEvent.getFieldName())) {
            int rowIndex = hyperLinkClickEvent.getRowIndex();
            String id = (String)this.getModel().getValue("id", rowIndex);
            this.showEditForm(id, OperationStatus.EDIT);
        }
    }

    public void initialize() {
        FilterContainer filterContainer = (FilterContainer)this.getView().getControl(FILTERCONTAINERAP);
        filterContainer.setBillFormId("tdm_item_lrb");
        filterContainer.addSearchClickListener(event -> this.filterSearchClickEvent(event));
        filterContainer.addFilterContainerInitListener(event -> this.filterContainerInit(event));
    }

    private void filterContainerInit(FilterContainerInitEvent filterContainerInitEvent) {
        filterContainerInitEvent.getSchemeFilterColumns().clear();
    }

    private void filterSearchClickEvent(SearchClickEvent searchClickEvent) {
        Map map = searchClickEvent.getFilterValues();
        List customlist = (List)map.get("customfilter");
        List schemelist = (List)map.get("schemefilter");
        List fastlist = (List)map.get("fastfilter");
        FilterParameter fastFilterParameter = searchClickEvent.getFilterModel().getFastFilterParameter(fastlist);
        List fastQFilterList = fastFilterParameter.getQFilters();
        FilterParameter commonFilterParameter = searchClickEvent.getFilterModel().getCommonFilterParameter(customlist);
        List commonQFilterList = commonFilterParameter.getQFilters();
        FilterParameter schemaFilterParameter = searchClickEvent.getFilterModel().getSchemeFilterParameter(schemelist);
        List schemaQFilterList = schemaFilterParameter.getQFilters();
        String nodeId = this.getPageCache().get(CACHE_CURRENT_NODE);
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.addAll(fastQFilterList);
        filters.addAll(commonQFilterList);
        filters.addAll(schemaQFilterList);
        this.getPageCache().put(CACHE_FILTERS, SerializationUtils.toJsonString(filters));
        this.buildList(nodeId, filters);
    }

    private List<QFilter> getQueryFilters() {
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(new QFilter(TBL_ENABLE, "=", (Object)"1"));
        return filters;
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String nodeId = this.getPageCache().get(CACHE_CURRENT_NODE);
        String itemKey = afterDoOperationEventArgs.getOperateKey();
        if (TBL_NEW.equals(itemKey)) {
            this.showEditForm(null, OperationStatus.ADDNEW);
        } else if (TBL_REFRESH.equals(itemKey)) {
            this.buildList(nodeId, null);
        } else if (TBL_DEL.equals(itemKey) || TBL_ENABLE.equals(itemKey) || TBL_DISABLE.equals(itemKey)) {
            EntryGrid entry = (EntryGrid)this.getControl(ENTRY_ENTITY);
            int[] selectRows = entry.getSelectRows();
            if (selectRows.length == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"FinanceItemListPlugin_0", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
                return;
            }
            if (TBL_DEL.equals(itemKey)) {
                String msg = String.format(ResManager.loadKDString((String)"\u5220\u9664\u9009\u4e2d\u7684%d\u6761\u8bb0\u5f55\u540e\u5c06\u65e0\u6cd5\u6062\u590d\uff0c\r\n\u786e\u5b9a\u8981\u5220\u9664\u8be5\u8bb0\u5f55\u5417\uff1f", (String)"FinanceItemListPlugin_1", (String)"taxc-tdm-formplugin", (Object[])new Object[0]), selectRows.length);
                this.showConfirmTips(TBL_DEL, msg);
                return;
            }
            this.doOprationService(itemKey, selectRows);
        } else if (IMPORTDATA.equals(itemKey)) {
            String entityId = ReportItemTreeEnum.getEntityNameById(nodeId);
            String entityName = ReportItemTreeEnum.getTextById(nodeId);
            this.importData(entityId, entityName);
        } else if (EXPORTDATA.equals(itemKey)) {
            EntryGrid entry = (EntryGrid)this.getControl(ENTRY_ENTITY);
            int[] selectRows = entry.getSelectRows();
            if (selectRows.length == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u5bfc\u51fa\u7684\u6570\u636e\u3002", (String)"FinanceItemListPlugin_2", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
                return;
            }
            DynamicObjectCollection entryEntityCollection = this.getModel().getEntryEntity(ENTRY_ENTITY);
            HashMap<String, List<String>> selectedItems = new HashMap<String, List<String>>(selectRows.length);
            for (int row : selectRows) {
                ArrayList<String> values = new ArrayList<String>(5);
                values.add(((DynamicObject)entryEntityCollection.get(row)).getString("name"));
                values.add("");
                values.add("");
                values.add(((DynamicObject)entryEntityCollection.get(row)).getString("pnumber"));
                values.add(((DynamicObject)entryEntityCollection.get(row)).getString("pname"));
                selectedItems.put(((DynamicObject)entryEntityCollection.get(row)).getString("number"), values);
            }
            try {
                String url = ExportFinanceItemUtils.downloadExcelFile(nodeId, selectedItems);
                String serviceAppId = this.getView().getFormShowParameter().getServiceAppId();
                String entityNum = this.getView().getEntityId();
                PermissionUtils.putTempFilePermissionCache((String)url, (String)serviceAppId, (String)entityNum, (String)"4730fc9f000004ae");
                this.getView().openUrl(url);
            }
            catch (Exception e) {
                logger.error("\u5bfc\u51fa\u9879\u76ee\u5931\u8d25\uff1a", (Throwable)e);
            }
        }
    }

    private void showConfirmTips(String key, String message) {
        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(key, (IFormPlugin)this);
        HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>();
        btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u53d6\u6d88", (String)"FinanceItemListPlugin_3", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
        btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u786e\u8ba4", (String)"FinanceItemListPlugin_4", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
        MessageBoxOptions options = MessageBoxOptions.OKCancel;
        this.getView().showConfirm(message, "", options, ConfirmTypes.Delete, confirmCallBacks, btnNameMaps);
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String fieldKey = messageBoxClosedEvent.getCallBackId();
        if (StringUtils.equalsIgnoreCase((CharSequence)fieldKey, (CharSequence)TBL_DEL) && messageBoxClosedEvent.getResult().equals((Object)MessageBoxResult.Yes)) {
            EntryGrid entry = (EntryGrid)this.getControl(ENTRY_ENTITY);
            this.doOprationService(TBL_DEL, entry.getSelectRows());
        }
    }

    private void doOprationService(String itemKey, int[] selectRows) {
        String nodeId = this.getPageCache().get(CACHE_CURRENT_NODE);
        DynamicObjectCollection entryEntityCollection = this.getModel().getEntryEntity(ENTRY_ENTITY);
        ArrayList<Long> idList = new ArrayList<Long>(selectRows.length);
        for (int row : selectRows) {
            String id = ((DynamicObject)entryEntityCollection.get(row)).getString("id");
            idList.add(Long.valueOf(id));
        }
        String entityName = ReportItemTreeEnum.getEntityNameById(nodeId);
        OperationResult result = OperationServiceHelper.executeOperate((String)itemKey, (String)entityName, (Object[])idList.toArray(), (OperateOption)OperateOption.create());
        if (!result.isSuccess()) {
            this.getView().showOperationResult(result);
            return;
        }
        this.buildList(nodeId, null);
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\u3002", (String)"FinanceItemListPlugin_5", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
    }

    private void importData(String entityId, String entityName) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("bos_importstart");
        showParameter.setCustomParam("BillFormId", (Object)entityId);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        ArrayList plugins = new ArrayList();
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        map.put("Enabled", Boolean.TRUE);
        plugins.add(map);
        showParameter.setCustomParam("ListName", (Object)entityName);
        showParameter.setCustomParam("plugins", plugins);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, IMPORTDATA));
        this.getView().showForm(showParameter);
    }

    private void showEditForm(String id, OperationStatus operationStatus) {
        String nodeId = this.getPageCache().get(CACHE_CURRENT_NODE);
        String entityName = ReportItemTreeEnum.getEntityNameById(nodeId);
        BillShowParameter billShowParameter = new BillShowParameter();
        billShowParameter.setFormId(entityName);
        if (StringUtils.isNotBlank((CharSequence)id)) {
            billShowParameter.setPkId((Object)id);
        }
        billShowParameter.setStatus(operationStatus);
        billShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        billShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, EDIT));
        this.getView().showForm((FormShowParameter)billShowParameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        if (EDIT.equals(closedCallBackEvent.getActionId()) || IMPORTDATA.equals(closedCallBackEvent.getActionId()) || EXPORTDATA.equals(closedCallBackEvent.getActionId())) {
            String nodeId = this.getPageCache().get(CACHE_CURRENT_NODE);
            this.buildList(nodeId, null);
        }
    }

    public void afterCreateNewData(EventObject e) {
        IPageCache pageCache = this.getPageCache();
        TreeView tree = (TreeView)this.getControl(TREE_VIEWAP);
        ArrayList<TreeNode> nodeList = new ArrayList<TreeNode>(ReportItemTreeEnum.values().length);
        for (ReportItemTreeEnum itemEnum : ReportItemTreeEnum.values()) {
            TreeNode itemRoot = new TreeNode();
            itemRoot.setId(itemEnum.getId());
            itemRoot.setParentid(itemEnum.getParentId());
            itemRoot.setText(itemEnum.getText());
            nodeList.add(itemRoot);
        }
        TreeUtils.build(tree, nodeList, pageCache, true);
        this.setDefaultNode(tree, "1");
        this.buildList("1", this.getQueryFilters());
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        String nodeId = (String)evt.getNodeId();
        if ("0".equals(nodeId)) {
            TreeView tree = (TreeView)this.getControl(TREE_VIEWAP);
            this.setDefaultNode(tree, "1");
            return;
        }
        this.buildList(nodeId, this.getQueryFilters());
    }

    private void setDefaultNode(TreeView tree, String nodeId) {
        TreeNode node = TreeUtils.getTreeNode(this.getPageCache(), tree, nodeId);
        tree.focusNode(node);
        tree.treeNodeClick(node.getParentid(), node.getId());
    }

    private void buildList(String nodeId, List<QFilter> filters) {
        if (filters == null) {
            String filterCache = this.getPageCache().get(CACHE_FILTERS);
            filters = StringUtils.isBlank((CharSequence)filterCache) ? this.getQueryFilters() : SerializationUtils.fromJsonStringToList((String)filterCache, QFilter.class);
        }
        this.getModel().deleteEntryData(ENTRY_ENTITY);
        this.getPageCache().put(CACHE_CURRENT_NODE, nodeId);
        String entityName = ReportItemTreeEnum.getEntityNameById(nodeId);
        QFilter[] qFilters = filters == null ? null : filters.toArray(new QFilter[0]);
        DynamicObjectCollection colls = QueryServiceHelper.query((String)entityName, (String)"id,number,name,parent.number,parent.name,issystem,enable", (QFilter[])qFilters, (String)"number asc");
        if (!CollectionUtils.isEmpty((Collection)colls)) {
            AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
            model.beginInit();
            TableValueSetter vs = new TableValueSetter(new String[0]);
            vs.addField("id", new Object[0]);
            vs.addField("number", new Object[0]);
            vs.addField("name", new Object[0]);
            vs.addField("type", new Object[0]);
            vs.addField("pnumber", new Object[0]);
            vs.addField("pname", new Object[0]);
            vs.addField("issystem", new Object[0]);
            vs.addField(TBL_ENABLE, new Object[0]);
            String type = ReportItemTreeEnum.getTextById(nodeId);
            for (DynamicObject obj : colls) {
                String pname;
                String id = obj.getString("id");
                String number = obj.getString("number");
                String name = obj.getString("name");
                String pnumber = obj.getString("parent.number");
                if (pnumber == null) {
                    pnumber = "";
                }
                if ((pname = obj.getString("parent.name")) == null) {
                    pname = "";
                }
                String issystem = obj.getString("issystem");
                String enable = obj.getString(TBL_ENABLE);
                vs.addRow(new Object[]{id, number, name, type, pnumber, pname, issystem, enable});
            }
            model.batchCreateNewEntryRow(ENTRY_ENTITY, vs);
            model.endInit();
        }
        this.getView().updateView(ENTRY_ENTITY);
    }
}

