/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tdm.formplugin.finance;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.control.Button;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.tdm.common.util.AppLogUtils;
import kd.taxc.tdm.common.util.DateUtils;
import kd.taxc.tdm.common.util.EmptyCheckUtils;
import kd.taxc.tdm.common.util.PermissionUtils;

public class FinanceRptAddPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final String ORG = "org";
    private static final String TYPE = "type";
    private static final String BTNOK = "btnok";
    private static final String PERIOD = "period";
    private static final String TEMPLATE = "template";
    private static final String TDM_FINANCE_MAIN = "tdm_finance_main";
    private static final String TDM_FINANCE_ATTACHMENT = "tdm_finance_attachment";
    private static final String SELECT_FIELD = "id,org,type,peirod,skssqq,skssqz";
    private static final String ISAJUST = "isadjust";
    private static final String ADJPERI = "adjperi";

    public void afterCreateNewData(EventObject e) {
        this.getModel().setValue(ORG, (Object)PermissionUtils.getAccountingDefaultOrgId((IFormView)this.getView().getParentView()));
    }

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{BTNOK});
        BasedataEdit template = (BasedataEdit)this.getView().getControl(TEMPLATE);
        template.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit org = (BasedataEdit)this.getView().getControl(ORG);
        org.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void click(EventObject evt) {
        Object source = evt.getSource();
        if (source instanceof Button && BTNOK.equals(((Button)source).getKey())) {
            DynamicObject object;
            DynamicObject org = (DynamicObject)this.getModel().getValue(ORG);
            Date period = (Date)this.getModel().getValue(PERIOD);
            DynamicObject type = (DynamicObject)this.getModel().getValue(TYPE);
            Boolean isAdjust = (Boolean)this.getModel().getValue(ISAJUST);
            String adjPeri = (String)this.getModel().getValue(ADJPERI);
            if (EmptyCheckUtils.isEmpty((Object)org) || EmptyCheckUtils.isEmpty((Object)type) || EmptyCheckUtils.isEmpty((Object)period)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5fc5\u586b\u9879\u3002", (String)"FinanceRptAddPlugin_6", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
                return;
            }
            if (!isAdjust.booleanValue()) {
                adjPeri = "";
            }
            if ((object = this.queryFinanceData(org, type, period, isAdjust, adjPeri)) != null) {
                StringBuilder msg = new StringBuilder();
                msg.append(String.format(ResManager.loadKDString((String)"%1$s %2$s%3$s\u5df2\u5b58\u5728\u540c\u4e00\u8c03\u6574\u671f\u7684%4$s", (String)"FinanceRptAddPlugin_0", (String)"taxc-tdm-formplugin", (Object[])new Object[0]), org.getString("number"), org.getString("name"), DateUtils.format((Date)period, (String)DateUtils.YYYYMM_CHINESE), type.getString("name")));
                this.getView().showErrorNotification(msg.toString());
                return;
            }
            HashMap<String, String> resultMap = new HashMap<String, String>();
            String typeId = type.getString("id");
            DynamicObject template = (DynamicObject)this.getModel().getValue(TEMPLATE);
            if (!"bbfz".equals(typeId) && !"hbbbfz".equals(typeId) && template == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u62a5\u8868\u7c7b\u578b\u4e0b\u201c\u6a21\u677f\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"FinanceRptAddPlugin_1", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
                return;
            }
            resultMap.put("id", this.saveFinanceRptData(org, period, typeId, template, isAdjust, adjPeri));
            resultMap.put("typeId", typeId);
            resultMap.put("typeName", type.getString("name"));
            resultMap.put(ISAJUST, isAdjust.toString());
            resultMap.put(ADJPERI, adjPeri);
            this.getView().returnDataToParent(resultMap);
            this.getView().close();
        }
    }

    private String saveFinanceRptData(DynamicObject org, Date period, String typeId, DynamicObject template, Boolean isAdjust, String adjPeri) {
        String id = String.valueOf(DB.genLongId((String)TDM_FINANCE_MAIN));
        DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)TDM_FINANCE_MAIN);
        dynamicObject.set("id", (Object)id);
        dynamicObject.set(TYPE, (Object)typeId);
        dynamicObject.set("templatetype", (Object)typeId);
        if (template != null) {
            dynamicObject.set(TEMPLATE, (Object)template.getString("id"));
        }
        dynamicObject.set(ORG, (Object)org.getString("id"));
        dynamicObject.set("bzorg", (Object)org.getString("name"));
        dynamicObject.set("peirod", (Object)DateUtils.format((Date)period, (String)DateUtils.YYYYMM_CHINESE));
        dynamicObject.set("skssqq", (Object)DateUtils.getFirstDateOfMonth((Date)period));
        dynamicObject.set("skssqz", (Object)DateUtils.getLastDateOfMonth((Date)period));
        dynamicObject.set("datasource", (Object)"sgxz");
        dynamicObject.set("sourcesystem", (Object)"ierp");
        dynamicObject.set(ISAJUST, (Object)isAdjust);
        dynamicObject.set(ADJPERI, (Object)adjPeri);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
        String opName = ResManager.loadKDString((String)"\u4fdd\u5b58", (String)"FinanceRptAddPlugin_4", (String)"taxc-tdm-formplugin", (Object[])new Object[0]);
        String opDesc = ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f", (String)"FinanceRptAddPlugin_7", (String)"taxc-tdm-formplugin", (Object[])new Object[0]);
        AppLogUtils.addLog((String)TDM_FINANCE_MAIN, (String)opName, (String)opDesc);
        if ("bbfz".equals(typeId) || "hbbbfz".equals(typeId)) {
            DynamicObject attachmentObject = BusinessDataServiceHelper.newDynamicObject((String)TDM_FINANCE_ATTACHMENT);
            attachmentObject.set("sbbid", (Object)id);
            attachmentObject.set("peirod", (Object)period);
            attachmentObject.set(ORG, (Object)org.getString("id"));
            attachmentObject.set("templatetype", (Object)typeId);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{attachmentObject});
            AppLogUtils.addLog((String)TDM_FINANCE_ATTACHMENT, (String)opName, (String)opDesc);
        }
        return id;
    }

    private DynamicObject queryFinanceData(DynamicObject org, DynamicObject type, Date period, Boolean isAdjust, String adjPeri) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(new QFilter("org.id", "=", (Object)org.getLong("id")));
        filters.add(new QFilter("templatetype.id", "=", (Object)type.getString("id")));
        filters.add(new QFilter("skssqq", ">=", (Object)DateUtils.getFirstDateOfMonth((Date)period)));
        filters.add(new QFilter("skssqz", "<=", (Object)DateUtils.getLastDateOfMonth((Date)period)));
        filters.add(new QFilter("accountbookstype", "is null", null).or(new QFilter("accountbookstype", "=", (Object)"")));
        filters.add(new QFilter(ISAJUST, "=", (Object)isAdjust));
        filters.add(new QFilter(ADJPERI, "=", (Object)adjPeri));
        return QueryServiceHelper.queryOne((String)TDM_FINANCE_MAIN, (String)SELECT_FIELD, (QFilter[])filters.toArray(new QFilter[filters.size()]));
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if (TYPE.equals(e.getProperty().getName())) {
            this.getModel().setValue(TEMPLATE, null);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        ListShowParameter formShowParameter;
        BasedataEdit source = (BasedataEdit)event.getSource();
        if (TEMPLATE.equals(source.getFieldKey())) {
            DynamicObject org = (DynamicObject)this.getModel().getValue(ORG);
            if (org == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u586b\u5199\u7f16\u5236\u7ec4\u7ec7\u3002", (String)"FinanceRptAddPlugin_2", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
                event.setCancel(true);
                return;
            }
            DynamicObject type = (DynamicObject)this.getModel().getValue(TYPE);
            if (type == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u62a5\u8868\u7c7b\u578b\u3002", (String)"FinanceRptAddPlugin_3", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
                event.setCancel(true);
                return;
            }
            formShowParameter = (ListShowParameter)event.getFormShowParameter();
            QFilter qFilter = new QFilter("templatetype", "=", type.get("id"));
            formShowParameter.getListFilterParameter().getQFilters().add(qFilter);
        }
        if (event.getProperty().getName().startsWith(ORG)) {
            List orgs = PermissionUtils.getAccountingOrgIds((IFormView)this.getView().getParentView());
            QFilter filters = new QFilter("id", "in", (Object)orgs);
            formShowParameter = (ListShowParameter)event.getFormShowParameter();
            formShowParameter.getListFilterParameter().setFilter(filters);
        }
    }
}

