/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tdm.formplugin.finance;

import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.Delete;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mutex.impl.DataMutexImpl;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.bos.user.UserDataServiceHelper;
import kd.taxc.bdtaxr.common.tctb.common.util.PermissionUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.tdm.common.util.JsonUtil;
import kd.taxc.tdm.formplugin.constant.FinanceReportMappingEnum;
import kd.taxc.tdm.formplugin.constant.SyncRptTypeEnum;
import kd.taxc.tdm.formplugin.utils.FinanceTemplateUtils;
import kd.taxc.tdm.formplugin.utils.SystemParamUtils;

public class FinanceRptListPlugin
extends AbstractListPlugin {
    private static final Log logger = LogFactory.getLog(FinanceRptListPlugin.class);
    private static final String TDM = "tdm";
    private static final String ADD_NEW = "addnew";
    private static final String REFRESH = "refresh";
    private static final String EDIT = "edit";
    private static final String SBBID = "sbbid";
    private static final String SYNCRPT = "syncrpt";
    private static final String DATASRC = "datasrc";
    private static final String TYPE_PRE = "templatetype.";
    private static final String IMPORT_DATA = "importdata";
    private static final String EXPORT_DATA = "exportdata";
    private static final String CACHE_DELETE_KEY = "cache_delete_key";
    private static final String TDM_FINANCE_MAIN = "tdm_finance_main";
    private static final String TDM_FINANCE_IMPORT = "tdm_finance_import";
    private static final String TDM_FINANCE_RPT_ADD = "tdm_finance_rpt_add";
    private static final String TDM_FINANCE_DETAIL = "tdm_finance_detail";
    private static final String TDM_FINANCE_ATTACHMENT = "tdm_finance_attachment";

    public void afterCreateNewData(EventObject e) {
        Object syncrpt = SystemParamUtils.getAppParameter(TDM, SYNCRPT);
        if (syncrpt instanceof Boolean && ((Boolean)syncrpt).booleanValue()) {
            Object datasrc = SystemParamUtils.getAppParameter(TDM, DATASRC);
            this.getPageCache().put(DATASRC, String.valueOf(datasrc));
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{SYNCRPT});
        }
    }

    private void exportFinanceRpt(Long id) {
        DynamicObject mainObj = BusinessDataServiceHelper.loadSingle((String)TDM_FINANCE_MAIN, (String)"id,org,skssqq,type,template,templatetype.name,accountbookstype,isadjust,adjperi", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)id)});
        if (mainObj == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5bfc\u51fa\u5931\u8d25\uff0c\u6570\u636e\u5df2\u4e0d\u5b58\u5728\u3002", (String)"FinanceRptListPlugin_0", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
            return;
        }
        String type = mainObj.getString("type");
        if ("bbfz".equals(type) || "hbbbfz".equals(type)) {
            this.exportAttachmentFile(String.valueOf(id));
            return;
        }
        Long templateId = mainObj.getLong("template.id");
        DynamicObject template = FinanceTemplateUtils.getTemplateObject(templateId);
        if (template == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5bfc\u51fa\u5931\u8d25\uff0c\u6a21\u677f\u4e0d\u5b58\u5728\u3002", (String)"FinanceRptListPlugin_1", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
            return;
        }
        Map<String, DynamicObject> reportDatas = FinanceTemplateUtils.queryReportDatas(type, id);
        try {
            DynamicObjectCollection templateItems = template.getDynamicObjectCollection("entryentity");
            String url = FinanceTemplateUtils.downFinanceExcelFile(type, mainObj.getString("template.name"), mainObj, reportDatas, templateItems);
            String serviceAppId = this.getView().getFormShowParameter().getServiceAppId();
            String entityNum = ((IListView)this.getView()).getBillFormId();
            PermissionUtils.putTempFilePermissionCache((String)url, (String)serviceAppId, (String)entityNum, (String)"4730fc9f000004ae");
            this.getView().download(url);
        }
        catch (Exception e) {
            logger.error("\u5bfc\u51fa\u62a5\u8868\u5931\u8d25\uff1a", (Throwable)e);
        }
    }

    private void exportAttachmentFile(String sbbid) {
        DynamicObject attachmentObj = BusinessDataServiceHelper.loadSingle((String)TDM_FINANCE_ATTACHMENT, (String)"id,attachment", (QFilter[])new QFilter[]{new QFilter(SBBID, "=", (Object)sbbid)});
        DynamicObjectCollection attachmentObjs = (DynamicObjectCollection)attachmentObj.get("attachment");
        if (attachmentObjs.size() <= 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5bfc\u51fa\u5931\u8d25\uff0c\u62a5\u8868\u9644\u6ce8\u4e0d\u5b58\u5728\u3002", (String)"FinanceRptListPlugin_2", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObject basedataObj = (DynamicObject)((DynamicObject)attachmentObjs.get(0)).get("fbasedataid");
        String url = basedataObj.getString("url");
        if (!url.contains("http:")) {
            url = RequestContext.get().getClientFullContextPath() + "attachment/download.do?path=" + url;
        }
        this.getView().download(url);
    }

    private void showForm(String itemKey, String formId, Map<String, Object> customParams) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId(formId);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, itemKey));
        parameter.setCustomParams(customParams);
        this.getView().showForm(parameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        if (closedCallBackEvent.getActionId().equals(ADD_NEW) && closedCallBackEvent.getReturnData() != null) {
            this.getView().invokeOperation(REFRESH);
            Map result = (Map)closedCallBackEvent.getReturnData();
            this.showRptDetail(Long.parseLong((String)result.get("id")), (String)result.get("typeId"), (String)result.get("typeName"));
        } else if (closedCallBackEvent.getActionId().equals(IMPORT_DATA)) {
            this.getView().invokeOperation(REFRESH);
            if ("success".equals(closedCallBackEvent.getReturnData())) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5bfc\u5165\u6210\u529f\u3002", (String)"FinanceRptListPlugin_3", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
            }
        } else if (closedCallBackEvent.getActionId().equals(SYNCRPT)) {
            this.getView().invokeOperation(REFRESH);
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        args.setCancel(true);
        HyperLinkClickEvent hyperEvt = args.getHyperLinkClickEvent();
        BillList list = (BillList)hyperEvt.getSource();
        ListSelectedRow currentSelectedRowInfo = list.getCurrentSelectedRowInfo();
        DynamicObject object = BusinessDataServiceHelper.loadSingle((Object)currentSelectedRowInfo.getPrimaryKeyValue(), (String)TDM_FINANCE_MAIN);
        this.showRptDetail(object.getLong("id"), object.getString("templatetype.id"), object.getString("templatetype.name"));
    }

    private void showRptDetail(Long id, String type, String captionName) {
        if ("bbfz".equals(type) || "hbbbfz".equals(type)) {
            BillShowParameter billShowParameter = new BillShowParameter();
            billShowParameter.setFormId(TDM_FINANCE_ATTACHMENT);
            billShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            billShowParameter.setCaption(captionName);
            billShowParameter.setStatus(OperationStatus.EDIT);
            billShowParameter.setCustomParam(SBBID, (Object)id);
            this.getView().showForm((FormShowParameter)billShowParameter);
        } else {
            FormShowParameter parameter = new FormShowParameter();
            parameter.setFormId(TDM_FINANCE_DETAIL);
            parameter.setCaption(captionName);
            parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, EDIT));
            parameter.setCustomParam(SBBID, (Object)id);
            this.getView().showForm(parameter);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        if (args.getSource() instanceof Delete) {
            ListSelectedRowCollection selectedRows = args.getListSelectedData();
            for (ListSelectedRow row : selectedRows) {
                if (!this.checkLock(String.valueOf(row.getPrimaryKeyValue()))) continue;
                args.setCancel(true);
                return;
            }
            if (selectedRows.size() > 0) {
                List ids = selectedRows.stream().map(r -> Long.parseLong(r.getPrimaryKeyValue().toString())).collect(Collectors.toList());
                DynamicObjectCollection colls = QueryServiceHelper.query((String)TDM_FINANCE_MAIN, (String)"id,templatetype", (QFilter[])new QFilter[]{new QFilter("id", "in", ids)});
                if (colls.size() > 0) {
                    Map deleteMap = colls.stream().collect(Collectors.groupingBy(s -> s.getString("templatetype"), Collectors.mapping(s -> s.getString("id"), Collectors.toList())));
                    this.getPageCache().put(CACHE_DELETE_KEY, SerializationUtils.toJsonString(deleteMap));
                } else {
                    this.getPageCache().put(CACHE_DELETE_KEY, null);
                }
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String itemKey;
        super.afterDoOperation(args);
        if (args.getSource() instanceof Delete && args.getOperationResult().isSuccess()) {
            ListSelectedRowCollection selectedRows = ((Delete)args.getSource()).getListSelectedData();
            String delStr = this.getPageCache().get(CACHE_DELETE_KEY);
            if (selectedRows.size() > 0 && StringUtils.isNotBlank((CharSequence)delStr)) {
                Map deleteMap = (Map)JsonUtil.fromJson((String)delStr, Map.class);
                this.deleteRptDatas(deleteMap);
            }
        }
        if (ADD_NEW.equals(itemKey = args.getOperateKey())) {
            this.showForm(itemKey, TDM_FINANCE_RPT_ADD, new HashMap<String, Object>());
        }
        if (IMPORT_DATA.equals(itemKey)) {
            this.showForm(itemKey, TDM_FINANCE_IMPORT, new HashMap<String, Object>());
        }
        if (EXPORT_DATA.equals(itemKey)) {
            BillList billList = (BillList)this.getControl("billlistap");
            ListSelectedRowCollection rows = billList.getSelectedRows();
            if (rows.size() == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u5bfc\u51fa\u7684\u6570\u636e\u3002", (String)"FinanceRptListPlugin_4", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
                return;
            }
            if (rows.size() > 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u4e0d\u652f\u6301\u5bfc\u51fa\u591a\u4efd\u8d22\u52a1\u62a5\u8868\uff0c\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e\u518d\u64cd\u4f5c\u5f15\u51fa\u3002", (String)"FinanceRptListPlugin_5", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
                return;
            }
            this.exportFinanceRpt(Long.valueOf(rows.get(0).getPrimaryKeyValue().toString()));
        }
        if (SYNCRPT.equals(itemKey)) {
            String datasrc = this.getPageCache().get(DATASRC);
            this.showForm(itemKey, SyncRptTypeEnum.getFormId(datasrc), new HashMap<String, Object>());
        }
    }

    private void deleteRptDatas(Map<String, List<String>> datas) {
        datas.forEach((type, v) -> {
            QFilter filter = new QFilter(SBBID, "in", v);
            DeleteServiceHelper.delete((String)FinanceReportMappingEnum.getEntityNameByType(type), (QFilter[])new QFilter[]{filter});
        });
    }

    public void filterColumnSetFilter(SetFilterEvent args) {
        if (args.getFieldName().startsWith(TYPE_PRE)) {
            args.getQFilters().add(this.getFilter());
        }
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        if (args.getFieldName().startsWith(TYPE_PRE)) {
            args.getQfilters().add(this.getFilter());
        }
    }

    private QFilter getFilter() {
        return new QFilter("maintable", "=", (Object)TDM_FINANCE_MAIN);
    }

    protected boolean checkLock(String sbbId) {
        if (StringUtil.isEmpty((CharSequence)sbbId)) {
            return false;
        }
        DataMutexImpl dataMutex = new DataMutexImpl();
        Map lockInfo = dataMutex.getLockInfo(sbbId, "default_netctrl", TDM_FINANCE_DETAIL);
        if (lockInfo != null && !((String)lockInfo.get("userid")).equals(String.valueOf(RequestContext.get().getCurrUserId()))) {
            String username = "";
            TaxResult result = UserDataServiceHelper.queryUserNameByIds((Long)Long.valueOf((String)lockInfo.get("userid")));
            if (result != null && result.isSuccess()) {
                username = (String)result.getData();
            }
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%s\u6b63\u5728\u7f16\u8f91\u8be5\u8bb0\u5f55\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u6216\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"FinanceRptListPlugin_6", (String)"taxc-tdm-formplugin", (Object[])new Object[0]), username));
            return true;
        }
        return false;
    }
}

