/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tdm.formplugin.finance;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.operate.MutexHelper;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mutex.impl.DataMutexImpl;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.bos.user.UserDataServiceHelper;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.tdm.common.util.DBUtils;
import kd.taxc.tdm.common.util.PermissionUtils;
import kd.taxc.tdm.formplugin.constant.FinanceReportMappingEnum;
import kd.taxc.tdm.formplugin.utils.FinanceTemplateUtils;

public class FinanceRptShowPlugin
extends AbstractFormPlugin {
    private static final Log LOGGER = LogFactory.getLog(FinanceRptShowPlugin.class);
    private static final String SBBID = "sbbid";
    private static final String BAR_SAVE = "bar_save";
    private static final String TOOL_BARAP = "toolbarap";
    private static final String ENTRY_ENTITY = "entryentity";
    private static final String ITEM_TYPE = "itemtype";
    private static final String RPT_ITEM = "item.id";
    private static final String CACHE_SBBID = "cache_sbbid";
    private static final String CACHE_TYPE_KEY = "cache_type_key";
    private static final String CACHE_ACCOUNTBOOKSTYPE = "accountbookstype";
    private static final String TDM_FINANCE_MAIN = "tdm_finance_main";
    private static final String TDM_FINANCE_TEMPLATE = "tdm_finance_template";
    private static final String TDM_FINANCE_DETAIL = "tdm_finance_detail";

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{TOOL_BARAP});
    }

    public void afterCreateNewData(EventObject e) {
        this.getView().setVisible(Boolean.FALSE, new String[]{"amount1", "amount2", "amount3", "amount4", "amount5"});
        this.setFieldShow(FinanceReportMappingEnum.getAmountFieldByType("hbsyzqybdb"), Boolean.FALSE);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (StringUtils.isNotBlank(customParams.get(SBBID))) {
            Long id = Long.parseLong(String.valueOf(customParams.get(SBBID)));
            DynamicObject object = BusinessDataServiceHelper.loadSingle((Object)id, (String)TDM_FINANCE_MAIN);
            this.getModel().setValue("org", object.get("org"));
            this.getModel().setValue("period", (Object)object.getDate("skssqq"));
            this.getModel().setValue("type", object.get("templatetype"));
            this.getModel().setValue("template", object.get("template"));
            this.getModel().setValue(CACHE_ACCOUNTBOOKSTYPE, object.get(CACHE_ACCOUNTBOOKSTYPE));
            this.getModel().setValue("isadjust", object.get("isadjust"));
            this.getModel().setValue("adjperi", object.get("adjperi"));
            String type = object.getString("templatetype.id");
            Map<String, DynamicObject> reportDatas = FinanceTemplateUtils.queryReportDatas(type, id);
            if (object.get("template") != null) {
                this.buildReportItem(type, object.getLong("template.id"), reportDatas);
            }
            this.getPageCache().put(CACHE_TYPE_KEY, type);
            this.getPageCache().put(CACHE_ACCOUNTBOOKSTYPE, object.getString(CACHE_ACCOUNTBOOKSTYPE));
            this.getPageCache().put(CACHE_SBBID, String.valueOf(id));
            if ("xttb".equals(object.getString("datasource"))) {
                this.getView().setEnable(Boolean.FALSE, new String[]{BAR_SAVE, "fs_baseinfo", ENTRY_ENTITY});
            }
        }
        this.updateHeightLimit();
    }

    public void afterBindData(EventObject e) {
        boolean hasSpecificPerm = PermissionUtils.hasSpecificPerm((IFormView)this.getView().getParentView(), (String)"4715a0df000000ac");
        if (!hasSpecificPerm) {
            this.getView().setStatus(OperationStatus.VIEW);
            this.getView().setEnable(Boolean.FALSE, new String[]{BAR_SAVE});
        }
        this.requireLock(this.getPageCache().get(CACHE_SBBID));
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRY_ENTITY);
        entryGrid.getView().getPageCache().put("BOS.setRowDataByNumberAutoAddRow", "false");
    }

    private void updateHeightLimit() {
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        map.put("heightLimit", false);
        this.getView().updateControlMetadata(ENTRY_ENTITY, map);
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String itemKey = afterDoOperationEventArgs.getOperateKey();
        if ("save".equals(itemKey)) {
            try (TXHandle tx = TX.required();){
                try {
                    String sbbid = this.getPageCache().get(CACHE_SBBID);
                    this.saveMainDatas(sbbid);
                    this.saveReportDatas(sbbid);
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"FinanceRptShowPlugin_0", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
                }
                catch (Exception e) {
                    LOGGER.error("FinanceRptShowPlugin itemClick", (Object)e.getMessage());
                    tx.markRollback();
                    this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25:%s", (String)"FinanceRptShowPlugin_1", (String)"taxc-tdm-formplugin", (Object[])new Object[0]), e.getMessage()));
                }
            }
        }
    }

    private void saveReportDatas(String sbbid) {
        DynamicObjectCollection entry = this.getModel().getEntryEntity(ENTRY_ENTITY);
        if (entry.size() > 0) {
            String type = this.getPageCache().get(CACHE_TYPE_KEY);
            String entityName = FinanceReportMappingEnum.getEntityNameByType(type);
            List<String> amountFields = FinanceReportMappingEnum.getAmountFieldByType(type);
            Map<String, DynamicObject> reportDatas = FinanceTemplateUtils.queryReportDatas(type, Long.parseLong(sbbid));
            ArrayList<DynamicObject> saveList = new ArrayList<DynamicObject>();
            ArrayList<DynamicObject> updateList = new ArrayList<DynamicObject>();
            for (DynamicObject row : entry) {
                String itemkey = row.getString(RPT_ITEM);
                DynamicObject itemObj = null;
                if (reportDatas.size() > 0 && reportDatas.containsKey(itemkey)) {
                    itemObj = reportDatas.get(itemkey);
                    this.setAmountValue(type, amountFields, itemObj, row);
                    updateList.add(itemObj);
                    continue;
                }
                itemObj = BusinessDataServiceHelper.newDynamicObject((String)entityName);
                Long id = DBUtils.getLongId((String)entityName);
                itemObj.set("id", (Object)id);
                itemObj.set(SBBID, (Object)sbbid);
                itemObj.set("ewblxh", row.get(RPT_ITEM));
                itemObj.set("reportitem", row.get(RPT_ITEM));
                this.setAmountValue(type, amountFields, itemObj, row);
                saveList.add(itemObj);
            }
            if (saveList.size() > 0) {
                SaveServiceHelper.save((DynamicObject[])saveList.toArray(new DynamicObject[0]));
            }
            if (updateList.size() > 0) {
                SaveServiceHelper.update((DynamicObject[])updateList.toArray(new DynamicObject[0]));
            }
        }
    }

    private void setAmountValue(String type, List<String> amountFields, DynamicObject itemObj, DynamicObject row) {
        for (int i = 0; i < amountFields.size(); ++i) {
            Object value;
            String field = amountFields.get(i);
            String key = "amount" + (i + 1);
            if ("syzqybdb".equals(type) || "hbsyzqybdb".equals(type)) {
                key = field;
            }
            if (!this.checkAmountValue((value = row.get(key)).toString())) {
                throw new KDBizException(ResManager.loadKDString((String)" \u91d1\u989d\u6574\u6570\u4f4d\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc713\u4f4d\u3002", (String)"FinanceRptShowPlugin_2", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
            }
            itemObj.set(field, value);
        }
    }

    private boolean checkAmountValue(String value) {
        int index = value.indexOf(46);
        return index <= 13;
    }

    private void saveMainDatas(String sbbid) {
        DynamicObject dynamicObject;
        String accountbookstype = (String)this.getModel().getValue(CACHE_ACCOUNTBOOKSTYPE);
        if (!accountbookstype.equals(this.getPageCache().get(CACHE_ACCOUNTBOOKSTYPE)) && (dynamicObject = BusinessDataServiceHelper.loadSingle((String)TDM_FINANCE_MAIN, (String)"id,accountbookstype", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.parseLong(sbbid))})) != null) {
            dynamicObject.set(CACHE_ACCOUNTBOOKSTYPE, (Object)accountbookstype);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
        }
    }

    private void buildReportItem(String type, Long templateId, Map<String, DynamicObject> reportDatas) {
        this.showAmountField(type);
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)templateId, (String)TDM_FINANCE_TEMPLATE);
        DynamicObjectCollection entryColl = dynamicObject.getDynamicObjectCollection(ENTRY_ENTITY);
        if (entryColl.size() > 0) {
            IDataModel model = this.getModel();
            model.beginInit();
            model.deleteEntryData(ENTRY_ENTITY);
            model.batchCreateNewEntryRow(ENTRY_ENTITY, entryColl.size());
            List<String> amountFields = FinanceReportMappingEnum.getAmountFieldByType(type);
            for (int i = 0; i < entryColl.size(); ++i) {
                DynamicObject itemObj = (DynamicObject)entryColl.get(i);
                this.getModel().setValue(ITEM_TYPE, itemObj.get(ITEM_TYPE), i);
                this.getModel().setValue("item", itemObj.get(RPT_ITEM), i);
                this.getModel().setValue("rownumber", itemObj.get("rownumber"), i);
                String itemkey = itemObj.getString(RPT_ITEM);
                if (!reportDatas.containsKey(itemkey)) continue;
                DynamicObject reportData = reportDatas.get(itemkey);
                for (int y = 0; y < amountFields.size(); ++y) {
                    String field = amountFields.get(y);
                    if ("syzqybdb".equals(type) || "hbsyzqybdb".equals(type)) {
                        this.getModel().setValue(field, (Object)reportData.getBigDecimal(field), i);
                        continue;
                    }
                    this.getModel().setValue("amount" + (y + 1), (Object)reportData.getBigDecimal(field), i);
                }
            }
            model.endInit();
            this.getView().updateView(ENTRY_ENTITY);
        }
    }

    private void showAmountField(String type) {
        List<String> amountFields = FinanceReportMappingEnum.getAmountFieldByType(type);
        Map<String, LocaleString> nameMap = FinanceTemplateUtils.queryEntityFieldName(type);
        EntryGrid entry = (EntryGrid)this.getControl(ENTRY_ENTITY);
        for (int i = 0; i < amountFields.size(); ++i) {
            String field = amountFields.get(i);
            if (!nameMap.containsKey(field)) continue;
            if ("syzqybdb".equals(type) || "hbsyzqybdb".equals(type)) {
                this.getView().setVisible(Boolean.TRUE, new String[]{field});
                continue;
            }
            entry.setColumnProperty("amount" + (i + 1), "header", (Object)nameMap.get(field));
            this.getView().setVisible(Boolean.TRUE, new String[]{"amount" + (i + 1)});
        }
    }

    private void setFieldShow(List<String> fileds, Boolean status) {
        if (fileds != null && fileds.size() > 0) {
            for (String field : fileds) {
                this.getView().setVisible(status, new String[]{field});
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String operateKey = ((FormOperate)args.getSource()).getOperateKey();
        if (StringUtil.equalsIgnoreCase((CharSequence)"save", (CharSequence)operateKey) && this.checkLock(this.getPageCache().get(CACHE_SBBID))) {
            args.setCancel(true);
        }
    }

    public void pageRelease(EventObject e) {
        this.releaseLock();
    }

    protected boolean checkLock(String sbbId) {
        if (StringUtil.isEmpty((CharSequence)sbbId)) {
            return false;
        }
        DataMutexImpl dataMutex = new DataMutexImpl();
        Map lockInfo = dataMutex.getLockInfo(sbbId, "default_netctrl", TDM_FINANCE_DETAIL);
        if (lockInfo != null && !((String)lockInfo.get("userid")).equals(String.valueOf(RequestContext.get().getCurrUserId()))) {
            String username = "";
            TaxResult result = UserDataServiceHelper.queryUserNameByIds((Long)Long.valueOf((String)lockInfo.get("userid")));
            if (result != null && result.isSuccess()) {
                username = (String)result.getData();
            }
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%s\u6b63\u5728\u7f16\u8f91\u8be5\u8bb0\u5f55\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u6216\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"FinanceRptShowPlugin_3", (String)"taxc-tdm-formplugin", (Object[])new Object[0]), username));
            return true;
        }
        return false;
    }

    protected void requireLock(String sbbid) {
        if (sbbid == null) {
            return;
        }
        this.releaseLock();
        boolean newMutexLocked = MutexHelper.require((String)TDM_FINANCE_DETAIL, (Object)sbbid, (String)"save", (boolean)Boolean.FALSE, (StringBuilder)new StringBuilder());
        if (!newMutexLocked) {
            if (this.checkLock(sbbid)) {
                this.getView().setEnable(Boolean.FALSE, new String[]{ENTRY_ENTITY, CACHE_ACCOUNTBOOKSTYPE});
            }
        } else {
            this.getPageCache().put("id_lock", sbbid);
            this.getView().setEnable(Boolean.TRUE, new String[]{ENTRY_ENTITY, CACHE_ACCOUNTBOOKSTYPE});
        }
    }

    protected void releaseLock() {
        DataMutexImpl dataMutex;
        Map lockInfo;
        String lockId = this.getPageCache().get("id_lock");
        if (StringUtil.isNotEmpty((CharSequence)lockId) && !"null".equalsIgnoreCase(lockId) && (lockInfo = (dataMutex = new DataMutexImpl()).getLockInfo(lockId, "default_netctrl", TDM_FINANCE_DETAIL)) != null && ((String)lockInfo.get("userid")).equals(String.valueOf(RequestContext.get().getCurrUserId()))) {
            MutexHelper.release((String)TDM_FINANCE_DETAIL, (String)"save", (String)lockId);
        }
    }
}

