/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tdm.formplugin.finance;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.control.Button;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.taxc.tdm.common.helper.BIReportServiceHelper;
import kd.taxc.tdm.common.helper.InvokeBizServiceHelper;
import kd.taxc.tdm.common.util.AppLogUtils;
import kd.taxc.tdm.common.util.DateUtils;
import kd.taxc.tdm.common.util.PermissionUtils;

public class FinanceSyncRptPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static Log logger = LogFactory.getLog(FinanceSyncRptPlugin.class);
    private static final String BTNOK = "btnok";
    private static final String ORG = "org";
    private static final String MODEL = "models";
    private static final String PERIOD = "period";
    private static final String YEAR = "year";
    private static final String TMPL = "tmpls";
    private static final String BASEDATA_ID = "fbasedataid";
    private static final String STRING_REGEX = "^,*|,*$";
    private static final String MODEL_REPORTTYPE = "model_reporttype";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{BTNOK});
        MulBasedataEdit orgMulBaseEdit = (MulBasedataEdit)this.getView().getControl(ORG);
        orgMulBaseEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        if (beforeF7SelectEvent.getProperty().getName().startsWith(ORG)) {
            List orgs = PermissionUtils.getAccountingOrgIds((IFormView)this.getView().getParentView());
            QFilter filters = new QFilter("id", "in", (Object)orgs);
            ListShowParameter formShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            formShowParameter.getListFilterParameter().setFilter(filters);
        }
    }

    public void afterCreateNewData(EventObject e) {
        Long orgId = PermissionUtils.getAccountingDefaultOrgId((IFormView)this.getView().getParentView());
        this.getModel().setValue(ORG, (Object)Collections.singleton(orgId).toArray());
        this.setModelSelect();
    }

    private void setModelSelect() {
        Map models = BIReportServiceHelper.getModels();
        if (models != null && models.size() > 0) {
            ArrayList<ComboItem> combos = new ArrayList<ComboItem>(models.size());
            HashMap reportTypeMap = new HashMap(models.size());
            for (Map.Entry entry : models.entrySet()) {
                String number = (String)entry.getKey();
                Map value = (Map)entry.getValue();
                ComboItem item = new ComboItem();
                item.setId(number);
                item.setValue(number);
                item.setCaption(new LocaleString((String)value.get("name")));
                combos.add(item);
                reportTypeMap.put(number, value.get("reporttype"));
            }
            ComboEdit comboEdit = (ComboEdit)this.getView().getControl(MODEL);
            comboEdit.setComboItems(combos);
            this.getPageCache().put(MODEL_REPORTTYPE, SerializationUtils.toJsonString(reportTypeMap));
        }
    }

    public void click(EventObject evt) {
        Object source = evt.getSource();
        if (source instanceof Button && BTNOK.equals(((Button)source).getKey())) {
            DynamicObjectCollection orgs = (DynamicObjectCollection)this.getModel().getValue(ORG);
            Date period = (Date)this.getModel().getValue(PERIOD);
            String periodStr = DateUtils.getFirstDateOfMonthStr((Date)period, (String)"yyyy-MM-dd");
            String model = (String)this.getModel().getValue(MODEL);
            String tmplstr = (String)this.getModel().getValue(TMPL);
            String tmpl = tmplstr.replaceAll(STRING_REGEX, "");
            String reportTypeStr = this.getPageCache().get(MODEL_REPORTTYPE);
            Map reportTypeMap = (Map)SerializationUtils.fromJsonString((String)reportTypeStr, Map.class);
            String reportType = (String)reportTypeMap.get(model);
            ArrayList orgList = new ArrayList(orgs.size());
            for (DynamicObject object : orgs) {
                HashMap<String, String> orgMap = new HashMap<String, String>();
                DynamicObject org = object.getDynamicObject(BASEDATA_ID);
                String number = org.getString("number");
                String id = org.getString("id");
                orgMap.put("id", id);
                orgMap.put("number", number);
                orgList.add(orgMap);
            }
            ArrayList params = new ArrayList();
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("orgList", orgList);
            map.put("model", model);
            map.put(PERIOD, periodStr);
            map.put("tmpl", tmpl);
            map.put("reportType", reportType);
            params.add(map);
            try {
                Map resultmap;
                String resultmsg;
                Object resultobj = InvokeBizServiceHelper.invokeIscService((String)"execute", (String)"KDflow_BcmRptDataSync(IERP-IERP)", params);
                if (resultobj != null && StringUtils.isNotBlank((CharSequence)(resultmsg = (String)((Map)(resultmap = (Map)JSONObject.parseObject((String)JSONObject.toJSONString((Object)resultobj), HashMap.class)).get("output")).get("resultmsg"))) && !"success".equals(resultmsg)) {
                    this.getView().showTipNotification(resultmsg);
                    return;
                }
            }
            catch (Exception ex) {
                logger.error("FinanceSyncRptPlugin click", (Throwable)ex);
                String opName = ResManager.loadKDString((String)"\u540c\u6b65\u62a5\u8868", (String)"FinanceSyncRptPlugin_2", (String)"taxc-tdm-formplugin", (Object[])new Object[0]);
                String opDesc = ResManager.loadKDString((String)"\u540c\u6b65\u5931\u8d25", (String)"FinanceSyncRptPlugin_3", (String)"taxc-tdm-formplugin", (Object[])new Object[0]);
                AppLogUtils.addLog((String)"tdm_finance_main", (String)opName, (String)opDesc);
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u540c\u6b65\u5931\u8d25\uff1a%s\u3002", (String)"FinanceSyncRptPlugin_0", (String)"taxc-tdm-formplugin", (Object[])new Object[0]), ex.getMessage()));
                return;
            }
            String opName = ResManager.loadKDString((String)"\u540c\u6b65\u62a5\u8868", (String)"FinanceSyncRptPlugin_2", (String)"taxc-tdm-formplugin", (Object[])new Object[0]);
            String opDesc = ResManager.loadKDString((String)"\u540c\u6b65\u6210\u529f", (String)"FinanceSyncRptPlugin_1", (String)"taxc-tdm-formplugin", (Object[])new Object[0]);
            AppLogUtils.addLog((String)"tdm_finance_main", (String)opName, (String)opDesc);
            this.getView().setEnable(Boolean.FALSE, new String[]{BTNOK});
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u540c\u6b65\u6210\u529f", (String)"FinanceSyncRptPlugin_1", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String itemKey = e.getProperty().getName();
        if (ORG.equals(itemKey) || MODEL.equals(itemKey) || PERIOD.equals(itemKey) || YEAR.equals(itemKey) || TMPL.equals(itemKey)) {
            if (MODEL.equals(itemKey)) {
                ChangeData changeData = e.getChangeSet()[0];
                String model = (String)changeData.getNewValue();
                this.setTemplateSelect(model);
            }
            this.getView().setEnable(Boolean.TRUE, new String[]{BTNOK});
        }
    }

    private void setTemplateSelect(String model) {
        this.getModel().setValue(TMPL, null);
        ArrayList<String> modelList = new ArrayList<String>();
        modelList.add(model);
        Map tmpls = BIReportServiceHelper.getTemplates(modelList);
        ArrayList<ComboItem> combos = new ArrayList<ComboItem>();
        if (tmpls != null && tmpls.size() > 0) {
            for (Map.Entry entry : tmpls.entrySet()) {
                Map value = (Map)entry.getValue();
                for (Map.Entry subentry : value.entrySet()) {
                    String subNumber = (String)subentry.getKey();
                    String subName = (String)subentry.getValue();
                    ComboItem subitem = new ComboItem();
                    subitem.setId(subNumber);
                    subitem.setValue(subNumber);
                    subitem.setCaption(new LocaleString(subNumber + "_" + subName));
                    combos.add(subitem);
                }
            }
        }
        ComboEdit comboEdit = (ComboEdit)this.getView().getControl(TMPL);
        comboEdit.setComboItems(combos);
    }
}

