/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tdm.formplugin.finance;

import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.mvc.bill.BillView;
import kd.taxc.tdm.formplugin.constant.FinanceReportMappingEnum;
import kd.taxc.tdm.formplugin.utils.FinanceTemplateUtils;

public class FinanceTemplateEditPlugin
extends AbstractBasePlugIn
implements BeforeF7SelectListener {
    private static final List<String> AMOUNT_LIST = Arrays.asList("amount1", "amount2", "amount3", "amount4", "amount5");
    private static final Map<String, String> typeToItemEntity = new HashMap<String, String>();

    public void afterCreateNewData(EventObject e) {
        this.updateHeightLimit();
    }

    public void afterLoadData(EventObject e) {
        this.updateHeightLimit();
    }

    private void updateHeightLimit() {
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        map.put("heightLimit", false);
        this.getView().updateControlMetadata("entryentity", map);
    }

    public void afterCopyData(EventObject e) {
        this.getModel().setValue("issystem", (Object)"0");
    }

    public void afterBindData(EventObject e) {
        BillView billView;
        OperationStatus status;
        super.afterBindData(e);
        this.setVisible(AMOUNT_LIST, Boolean.FALSE);
        this.setVisible(FinanceReportMappingEnum.getAmountFieldByType("hbsyzqybdb"), Boolean.FALSE);
        DynamicObject type = (DynamicObject)this.getModel().getValue("templatetype");
        if (type != null) {
            this.setFieldProperty(type.getString("id"));
        }
        if (OperationStatus.VIEW.equals((Object)(status = (billView = (BillView)e.getSource()).getFormShowParameter().getStatus()))) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"bar_save", "moveup", "movedown", "newentry", "deleteentry"});
        }
    }

    public void initialize() {
        BasedataEdit itemBase = (BasedataEdit)this.getControl("item");
        itemBase.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        if (beforeF7SelectEvent.getProperty().getName().equals("item")) {
            ListShowParameter formShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            formShowParameter.setMultiSelect(true);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        DynamicObject type;
        String key = e.getProperty().getName();
        if ("templatetype".equals(key) && (type = (DynamicObject)e.getChangeSet()[0].getNewValue()) != null) {
            this.getModel().deleteEntryData("entryentity");
            String id = type.getString("id");
            this.setFieldProperty(id);
        }
    }

    private void setFieldProperty(String key) {
        EntryGrid entry = (EntryGrid)this.getControl("entryentity");
        List<String> amountFields = FinanceReportMappingEnum.getAmountFieldByType(key);
        Map<String, LocaleString> nameMap = FinanceTemplateUtils.queryEntityFieldName(key);
        this.setVisible(FinanceReportMappingEnum.getAmountFieldByType("hbsyzqybdb"), Boolean.FALSE);
        this.setVisible(Arrays.asList("amount1", "amount2", "amount3", "amount4", "amount5"), Boolean.FALSE);
        for (int i = 0; i < amountFields.size(); ++i) {
            String field = amountFields.get(i);
            if (!nameMap.containsKey(field)) continue;
            if ("syzqybdb".equals(key) || "hbsyzqybdb".equals(key)) {
                this.getView().setVisible(Boolean.TRUE, new String[]{field});
                continue;
            }
            entry.setColumnProperty("amount" + (i + 1), "header", (Object)nameMap.get(field));
            this.getView().setVisible(Boolean.TRUE, new String[]{"amount" + (i + 1)});
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        DynamicObject type = (DynamicObject)this.getModel().getValue("templatetype");
        if (e.getEntryProp().getName().equals("entryentity") && type != null) {
            RowDataEntity[] rowDataEntities;
            String id = type.getString("id");
            for (RowDataEntity rowData : rowDataEntities = e.getRowDataEntities()) {
                int rowIndex = rowData.getRowIndex();
                this.getModel().setValue("itemtype", (Object)typeToItemEntity.get(id), rowIndex);
            }
        }
    }

    private void setVisible(List<String> fileds, Boolean status) {
        if (fileds != null && fileds.size() > 0) {
            for (String field : fileds) {
                this.getView().setVisible(status, new String[]{field});
            }
        }
    }

    static {
        typeToItemEntity.put("lrb", "tdm_item_lrb");
        typeToItemEntity.put("hblrb", "tdm_item_lrb");
        typeToItemEntity.put("zcfzb", "tdm_item_zcfzb");
        typeToItemEntity.put("hbzcfzb", "tdm_item_zcfzb");
        typeToItemEntity.put("xjllb", "tdm_item_xjllb");
        typeToItemEntity.put("hbxjllb", "tdm_item_xjllb");
        typeToItemEntity.put("syzqybdb", "tdm_item_qybdb");
        typeToItemEntity.put("hbsyzqybdb", "tdm_item_qybdb");
    }
}

