/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tdm.formplugin.finance;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Button;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.tdm.common.helper.InvokeBizServiceHelper;
import kd.taxc.tdm.common.util.AppLogUtils;
import kd.taxc.tdm.common.util.DateUtils;
import kd.taxc.tdm.common.util.PermissionUtils;
import kd.taxc.tdm.common.util.StringUtil;
import kd.taxc.tdm.formplugin.finance.FinanceGlRptFormPlugin;
import org.apache.commons.lang3.StringUtils;

public class MergeRptFormPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static Log logger = LogFactory.getLog(FinanceGlRptFormPlugin.class);
    private static final String BTNOK = "btnok";
    private static final String ORG = "org";
    private static final String EASTYPE = "eastype";
    private static final String ORGTREE = "orgtree";
    private static final String ORGUNIT = "orgunit";
    private static final String PERIOD = "period";
    private static final String RPTTYPE = "rpttype";
    private static final String BASEDATA_ID = "fbasedataid";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{BTNOK});
        MulBasedataEdit orgMulBaseEdit = (MulBasedataEdit)this.getView().getControl(ORG);
        orgMulBaseEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit orgUnitEdit = (BasedataEdit)this.getControl(ORGUNIT);
        orgUnitEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String name = beforeF7SelectEvent.getProperty().getName();
        if (StringUtil.equalsIgnoreCase((CharSequence)name, (CharSequence)ORG)) {
            List orgs = PermissionUtils.getAccountingOrgIds((IFormView)this.getView().getParentView());
            QFilter filters = new QFilter("id", "in", (Object)orgs);
            ListShowParameter formShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            formShowParameter.getListFilterParameter().setFilter(filters);
        } else if (StringUtil.equalsIgnoreCase((CharSequence)name, (CharSequence)ORGUNIT)) {
            DynamicObject orgtree = (DynamicObject)this.getModel().getValue(ORGTREE);
            if (orgtree == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5408\u5e76\u8303\u56f4\u3002", (String)"MergeRptFormPlugin_0", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            ListShowParameter formShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            formShowParameter.setFormId("bos_listf7");
            formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            Long orgTreeId = orgtree.getLong("id");
            List<Long> unitids = this.getOrgUnitIds(orgTreeId);
            QFilter filters = new QFilter("id", "in", unitids);
            formShowParameter.getListFilterParameter().setFilter(filters);
        }
    }

    public void afterCreateNewData(EventObject e) {
        Long orgId = PermissionUtils.getAccountingDefaultOrgId((IFormView)this.getView().getParentView());
        this.getModel().setValue(ORG, (Object)Collections.singleton(orgId).toArray());
    }

    public List<Long> getOrgUnitIds(Long orgTreeId) {
        QFilter filter = new QFilter("treeid", "=", (Object)orgTreeId);
        DynamicObjectCollection colls = QueryServiceHelper.query((String)"tdm_orgstructure_eas", (String)"id,unitid,treeid", (QFilter[])new QFilter[]{filter});
        List<Long> unitIds = colls.stream().map(o -> o.getLong("unitid")).collect(Collectors.toList());
        return unitIds;
    }

    public void click(EventObject evt) {
        Object source = evt.getSource();
        if (source instanceof Button && BTNOK.equals(((Button)source).getKey())) {
            DynamicObject orgunit;
            DynamicObjectCollection orgs = (DynamicObjectCollection)this.getModel().getValue(ORG);
            Date period = (Date)this.getModel().getValue(PERIOD);
            String periodStr = DateUtils.getFirstDateOfMonthStr((Date)period, (String)"yyyy-MM-dd");
            String types = (String)this.getModel().getValue(RPTTYPE);
            List orgList = orgs.stream().map(e -> e.getDynamicObject(BASEDATA_ID).getString("id")).collect(Collectors.toList());
            List typeList = Arrays.asList(types.split(",")).stream().filter(s -> StringUtils.isNotBlank((CharSequence)s)).collect(Collectors.toList());
            ArrayList params = new ArrayList();
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            paramMap.put("orgList", orgList);
            paramMap.put("typeList", typeList);
            paramMap.put(PERIOD, periodStr);
            String easType = (String)this.getModel().getValue(EASTYPE);
            paramMap.put("easType", easType);
            String orgTreeNumber = "";
            String orgUnitNumber = "";
            DynamicObject orgtree = (DynamicObject)this.getModel().getValue(ORGTREE);
            if (orgtree != null) {
                orgTreeNumber = orgtree.getString("number");
            }
            if ((orgunit = (DynamicObject)this.getModel().getValue(ORGUNIT)) != null) {
                orgUnitNumber = orgunit.getString("number");
            }
            paramMap.put("orgTreeNumber", orgTreeNumber);
            paramMap.put("orgUnitNumber", orgUnitNumber);
            params.add(paramMap);
            try {
                Object resultobj = InvokeBizServiceHelper.invokeIscService((String)"start", (String)"KDflow_MergeRptDataSync(EAS-IERP)", params);
                if (resultobj == null) {
                    this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u540c\u6b65\u5931\u8d25\uff1a%s\u3002", (String)"MergeRptFormPlugin_1", (String)"taxc-tdm-formplugin", (Object[])new Object[0]), "null"));
                }
            }
            catch (Exception ex) {
                logger.error("MergeRptFormPlugin click", (Throwable)ex);
                String opName = ResManager.loadKDString((String)"\u540c\u6b65\u62a5\u8868", (String)"MergeRptFormPlugin_4", (String)"taxc-tdm-formplugin", (Object[])new Object[0]);
                String opDesc = ResManager.loadKDString((String)"\u540c\u6b65\u5931\u8d25", (String)"MergeRptFormPlugin_5", (String)"taxc-tdm-formplugin", (Object[])new Object[0]);
                AppLogUtils.addLog((String)"tdm_finance_main", (String)opName, (String)opDesc);
                String errorMsg = this.getErrorMsg(ex.getMessage());
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u540c\u6b65\u5931\u8d25\uff1a%s\u3002", (String)"MergeRptFormPlugin_1", (String)"taxc-tdm-formplugin", (Object[])new Object[0]), errorMsg));
                return;
            }
            this.getView().setEnable(Boolean.FALSE, new String[]{BTNOK});
            String opName = ResManager.loadKDString((String)"\u540c\u6b65\u62a5\u8868", (String)"MergeRptFormPlugin_4", (String)"taxc-tdm-formplugin", (Object[])new Object[0]);
            String opDesc = ResManager.loadKDString((String)"\u540c\u6b65\u6210\u529f", (String)"MergeRptFormPlugin_2", (String)"taxc-tdm-formplugin", (Object[])new Object[0]);
            AppLogUtils.addLog((String)"tdm_finance_main", (String)opName, (String)opDesc);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u540c\u6b65\u6210\u529f", (String)"MergeRptFormPlugin_2", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String itemKey = e.getProperty().getName();
        if (ORG.equals(itemKey) || PERIOD.equals(itemKey) || RPTTYPE.equals(itemKey) || ORGTREE.equals(itemKey) || ORGUNIT.equals(itemKey)) {
            this.getView().setEnable(Boolean.TRUE, new String[]{BTNOK});
        }
        if (EASTYPE.equals(itemKey)) {
            this.getModel().setValue(ORGTREE, null);
            this.getModel().setValue(ORGUNIT, null);
        } else if (ORGTREE.equals(itemKey)) {
            this.getModel().setValue(ORGUNIT, null);
        }
    }

    public String getErrorMsg(String msg) {
        if (StringUtil.isNotBlank((CharSequence)msg)) {
            int msgIndex;
            int indexIsc;
            int indexEx = msg.indexOf("IscBizException:");
            if (indexEx > 0) {
                msg = msg.substring(indexEx + 16);
            }
            if ((indexIsc = msg.indexOf("kd.isc.iscb")) > 0) {
                msg = msg.substring(0, indexIsc);
            }
            if ((msgIndex = msg.indexOf(ResManager.loadKDString((String)"\u66f4\u591a\u65e5\u5fd7\u3002", (String)"MergeRptFormPlugin_3", (String)"taxc-tdm-formplugin", (Object[])new Object[0]))) > 0) {
                msg = msg.substring(0, msgIndex + 5);
            }
        }
        return msg;
    }
}

