/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tdm.formplugin.hightech;

import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.entity.datamodel.events.InitImportDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.TaxcCombineDataServiceHelper;

public class HighTechIPREditPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit taxOrg = (BasedataEdit)this.getControl("taxorg");
        taxOrg.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        this.addClickListeners(new String[]{"btn_save"});
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String getWay = (String)this.getModel().getValue("getway");
        if (getWay != null) {
            boolean flag = "B".endsWith(getWay);
            this.changeMustInput("transferor", flag);
            this.changeMustInput("transferdate", flag);
        }
    }

    public void initImportData(InitImportDataEventArgs e) {
        List sourceDataList = e.getSourceDataList();
        for (Map sourceData : sourceDataList) {
            sourceData.put("datasource", "B");
        }
    }

    public void beforeClick(BeforeClickEvent evt) {
        super.beforeClick(evt);
        String key = ((Control)evt.getSource()).getKey();
        if ("btn_save".equals(key)) {
            Date dueDate = (Date)this.getModel().getValue("duedate");
            Date curDate = new Date();
            Calendar curCa = Calendar.getInstance();
            curCa.setTime(curDate);
            curCa.set(10, 0);
            curCa.set(12, 0);
            curCa.set(13, 0);
            curCa.set(14, 0);
            if (dueDate != null) {
                if (dueDate.compareTo(curCa.getTime()) < 0) {
                    this.getModel().setValue("isvalidipr", (Object)"0");
                } else {
                    this.getModel().setValue("isvalidipr", (Object)"1");
                }
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        if ("getway".equals(name)) {
            String getWay = (String)this.getModel().getValue("getway");
            if ("B".equals(getWay)) {
                this.changeMustInput("transferor", Boolean.TRUE);
                this.changeMustInput("transferdate", Boolean.TRUE);
            } else {
                this.getModel().setValue("transferor", null);
                this.getModel().setValue("transferdate", null);
            }
        }
    }

    private void changeMustInput(String fieldKye, boolean flag) {
        FieldEdit fieldEdit = (FieldEdit)this.getView().getControl(fieldKye);
        fieldEdit.setMustInput(flag);
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        String name = event.getProperty().getName();
        if ("taxorg".equals(name)) {
            Long currUserId = RequestContext.get().getCurrUserId();
            TaxResult listTaxResult = TaxcCombineDataServiceHelper.queryTaxcOrgIdsByIsTaxpayerWithPerm((Long)currUserId);
            List data = (List)listTaxResult.getData();
            ListShowParameter formShowParameter = (ListShowParameter)event.getFormShowParameter();
            formShowParameter.getListFilterParameter().setFilter(new QFilter("id", "in", (Object)data));
        }
    }
}

