/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tdm.formplugin.invoice.constant;

import java.util.Date;
import java.util.List;
import java.util.Optional;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.orm.query.QFilter;
import kd.taxc.tdm.common.util.DateUtils;

public class InputInvoiceUtils {
    public static void setFilter(List<QFilter> qFilters) {
        Optional<QFilter> optional = qFilters.stream().filter(s -> "taxperioddate".equals(s.getProperty())).findFirst();
        if (optional.isPresent()) {
            QFilter oldQFilter = optional.get();
            QFilter[] arrQFilter = oldQFilter.recombine();
            Date start = (Date)arrQFilter[0].getValue();
            Date end = (Date)arrQFilter[1].getValue();
            qFilters.remove(oldQFilter);
            if (InputInvoiceUtils.sameMonth(start, end)) {
                qFilters.add(new QFilter("taxperioddate", "=", (Object)DateUtils.getFirstDateOfMonth((Date)start)));
            } else {
                QFilter newQFilter = new QFilter("taxperioddate", ">=", (Object)DateUtils.getFirstDateOfMonth((Date)start)).and(new QFilter("taxperioddate", "<", (Object)DateUtils.getFirstDateOfMonth((Date)end)));
                qFilters.add(newQFilter);
            }
        }
    }

    public static FormShowParameter getInvoiceSyncDialog(String type) {
        FormShowParameter parameters = new FormShowParameter();
        parameters.getOpenStyle().setShowType(ShowType.Modal);
        parameters.setFormId("tdm_invoice_sync_dialog");
        parameters.setShowTitle(true);
        parameters.setCustomParam("type", (Object)"output");
        return parameters;
    }

    private static boolean sameMonth(Date start, Date end) {
        return DateUtils.getMonthOfDate((Date)start) == DateUtils.getMonthOfDate((Date)end);
    }
}

