/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tdm.formplugin.landAppreciation;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Save;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.tdm.common.constant.ClearingUnitConstant;
import kd.taxc.tdm.common.helper.LicenseCheckServiceHelper;
import kd.taxc.tdm.common.util.DateUtils;

public class ClearingUnitBillPlugin
extends AbstractBillPlugIn
implements BeforeF7SelectListener,
ClearingUnitConstant {
    List<String> pops = Lists.newArrayList((Object[])new String[]{"org", "taxorg", "taxproject", "subbuildingtype"});

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.pops.forEach(s -> {
            BasedataEdit type = (BasedataEdit)this.getControl((String)s);
            type.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        });
    }

    public void beforeBindData(EventObject e) {
        Long orgid;
        boolean notAuthorize;
        super.afterBindData(e);
        String appId = this.getView().getFormShowParameter().getAppId();
        DynamicObject org = (DynamicObject)this.getModel().getValue("taxorg");
        if (org != null && (notAuthorize = LicenseCheckServiceHelper.check((Object)(orgid = Long.valueOf(org.getLong("id"))), (IFormView)this.getView(), (String)appId))) {
            this.getModel().setValue("taxorg", null);
            return;
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String name = evt.getProperty().getName();
        ListShowParameter formShowParameter = (ListShowParameter)evt.getFormShowParameter();
        if ("taxorg".equals(name)) {
            Object org = this.getModel().getValue("org");
            if (null == org) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"ClearingUnitBillPlugin_0", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
                evt.setCancel(Boolean.TRUE.booleanValue());
                return;
            }
            DynamicObjectCollection toorgs = this.getToorgs();
            Set toorgList = toorgs.stream().map(e -> e.getLong("toorg")).collect(Collectors.toSet());
            DynamicObject orgId = (DynamicObject)this.getModel().getValue("org");
            QFilter[] taxOrgFilter = new QFilter[]{new QFilter("org", "=", (Object)orgId.getLong("id")).and("istaxpayer", "=", (Object)"1")};
            DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"bastax_taxorg", (String)"id", (QFilter[])taxOrgFilter);
            if (null != dynamicObject) {
                toorgList.add(dynamicObject.getLong("id"));
            }
            List qFilters = formShowParameter.getListFilterParameter().getQFilters();
            qFilters.add(new QFilter("id", "in", toorgList));
            qFilters.add(new QFilter("id", "in", TaxcMainDataServiceHelper.queryTaxcMainOrgIds().getData()));
        } else if ("taxproject".equals(name)) {
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            DynamicObject taxorg = (DynamicObject)this.getModel().getValue("taxorg");
            if (null == org || null == taxorg) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u548c\u7a0e\u52a1\u7ec4\u7ec7\u3002", (String)"ClearingUnitBillPlugin_1", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
                evt.setCancel(Boolean.TRUE.booleanValue());
                return;
            }
            DynamicObjectCollection taxProjects = this.getTaxProject();
            List toorgList = taxProjects.stream().map(e -> e.getLong("id")).collect(Collectors.toList());
            List qFilters = formShowParameter.getListFilterParameter().getQFilters();
            qFilters.add(new QFilter("id", "in", toorgList));
        } else if ("subbuildingtype".equals(name)) {
            DynamicObject buildingType = (DynamicObject)this.getModel().getValue("buildingtype");
            DynamicObject taxAuthority = (DynamicObject)this.getModel().getValue("taxauthority");
            List qFilters = formShowParameter.getListFilterParameter().getQFilters();
            if (null == buildingType || null == taxAuthority) {
                qFilters.add(new QFilter("id", "=", null));
                return;
            }
            qFilters.add(new QFilter("fclxmc", "=", (Object)buildingType.getLong("id")));
            qFilters.add(new QFilter("group", "=", (Object)taxAuthority.getLong("id")));
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        DynamicObject org;
        super.beforeDoOperation(args);
        if (args.getSource() instanceof Save && (org = (DynamicObject)this.getModel().getValue("taxorg")) != null && !TaxcMainDataServiceHelper.isTaxcMainByOrgId((Long)org.getLong("id")).isSuccess()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7a0e\u52a1\u7ec4\u7ec7\u672a\u5ba1\u6838\u6216\u4e0d\u53ef\u7528\uff0c\u65e0\u6cd5\u6267\u884c\u5f53\u524d\u64cd\u4f5c\u3002", (String)"ClearingUnitBillPlugin_2", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
    }

    public void afterCreateNewData(EventObject e) {
        DynamicObjectCollection toorgs = this.getToorgs();
        if (toorgs.size() > 0) {
            this.getModel().setValue("taxorg", (Object)((DynamicObject)toorgs.get(0)).getLong("toorg"));
        }
    }

    private DynamicObjectCollection getToorgs() {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (null != org) {
            QFilter[] qFilter1 = new QFilter[]{new QFilter("number", "=", (Object)"orgunit2tax")};
            DynamicObject relationtype = QueryServiceHelper.queryOne((String)"bos_org_typerelation", (String)"id,number", (QFilter[])qFilter1);
            QFilter[] qFilter2 = new QFilter[]{new QFilter("typerelation", "=", (Object)relationtype.getLong("id")).and("fromorg", "=", (Object)org.getLong("id"))};
            DynamicObjectCollection toorgs = QueryServiceHelper.query((String)"bos_org_orgrelation", (String)"toorg", (QFilter[])qFilter2);
            return toorgs;
        }
        return new DynamicObjectCollection();
    }

    private DynamicObjectCollection getTaxProject() {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        DynamicObject taxorg = (DynamicObject)this.getModel().getValue("taxorg");
        if (null != org && null != taxorg) {
            QFilter[] qFilters = new QFilter[]{new QFilter("org", "=", (Object)org.getLong("id")).and("taxorg", "=", (Object)taxorg.getLong("id")).and("status", "=", (Object)"C")};
            DynamicObjectCollection taxprojects = QueryServiceHelper.query((String)"bastax_taxproject", (String)"id", (QFilter[])qFilters);
            return taxprojects;
        }
        return new DynamicObjectCollection();
    }

    public void beforePropertyChanged(PropertyChangedArgs e) {
        String fieldKey = e.getProperty().getName();
        if ("taxproject".equals(fieldKey)) {
            boolean modifyExistBill;
            Object oldProject = e.getChangeSet()[0].getOldValue();
            Object newProject = e.getChangeSet()[0].getNewValue();
            if (null != oldProject && null == newProject) {
                this.getModel().setValue("taxaddress", null);
                return;
            }
            String cancelFlag = this.getPageCache().get("cancelFlag");
            boolean bl = modifyExistBill = !"Boolean.TRUE".equals(cancelFlag) && oldProject != null;
            if (modifyExistBill && !newProject.equals(oldProject)) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("taxproject", ((DynamicObject)oldProject).getString("id"));
                map.put("number", this.getModel().getValue("number"));
                map.put("name", String.valueOf(this.getModel().getValue("name")));
                map.put("address", this.getModel().getValue("address"));
                String jsonString = JSON.toJSONString(map);
                String msg = ResManager.loadKDString((String)"\u4e0b\u65b9\u533a\u57df\u6240\u6709\u5185\u5bb9\u4f1a\u88ab\u6e05\u7a7a\uff0c\u662f\u5426\u7ee7\u7eed\u64cd\u4f5c\uff1f", (String)"ClearingUnitBillPlugin_3", (String)"taxc-tdm-formplugin", (Object[])new Object[0]);
                ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener(fieldKey, (IFormPlugin)this);
                this.getView().showConfirm(msg, "", MessageBoxOptions.OKCancel, ConfirmTypes.Default, confirmCallBackListener, new HashMap(), jsonString);
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String fieldKey = e.getProperty().getName();
        if ("org".equals(fieldKey)) {
            DynamicObjectCollection toorgs = this.getToorgs();
            this.getModel().setValue("taxorg", toorgs.size() > 0 ? Long.valueOf(((DynamicObject)toorgs.get(0)).getLong("toorg")) : null);
            this.getModel().setValue("taxproject", null);
        } else if ("taxorg".equals(fieldKey)) {
            this.getPageCache().put("cancelFlag", "Boolean.TRUE");
            this.getModel().setValue("taxproject", null);
            this.getPageCache().put("cancelFlag", "Boolean.FALSE");
        } else if (("startdate".equals(fieldKey) || "enddate".equals(fieldKey)) && null != this.getModel().getValue("enddate")) {
            Date startDate = (Date)this.getModel().getValue("startdate");
            Date endDate = (Date)this.getModel().getValue("enddate");
            if (null == startDate) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u9879\u76ee\u5efa\u8bbe\u5f00\u59cb\u65f6\u95f4\u201d\u5b57\u6bb5\u3002", (String)"ClearingUnitBillPlugin_4", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
                this.clearValue("enddate");
                return;
            }
            if (!DateUtils.isEffectiveDate((Date)endDate, (Date)DateUtils.addDay((Date)startDate, (int)-1), null)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u9879\u76ee\u5efa\u8bbe\u7ed3\u675f\u65f6\u95f4\u4e0d\u5f97\u65e9\u4e8e\u5f00\u59cb\u65f6\u95f4\u3002", (String)"ClearingUnitBillPlugin_5", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
                if ("startdate".equals(fieldKey)) {
                    Date oldDate = (Date)e.getChangeSet()[0].getOldValue();
                    this.getModel().setValue("startdate", (Object)oldDate);
                } else {
                    this.clearValue("enddate");
                }
                return;
            }
        } else if ("taxproject".equals(fieldKey)) {
            if (null != this.getModel().getValue("taxproject")) {
                this.setProjectInfo();
            }
        } else if ("levymethod".equals(fieldKey)) {
            String method = (String)this.getModel().getValue("levymethod");
            if ("general".equals(method)) {
                this.getModel().setValue("applyrate", (Object)"nine");
            } else if ("simple".equals(method)) {
                this.getModel().setValue("applyrate", (Object)"five");
            }
            Boolean isSimple = (Boolean)this.getModel().getValue("issimplecalculation");
            if ("general".equals(method) && Boolean.FALSE.equals(isSimple)) {
                this.visibleSwitch(true, "isallowdeductprice");
            } else {
                this.visibleSwitch(false, "isallowdeductprice");
                this.getModel().setValue("isallowdeductprice", (Object)Boolean.FALSE);
            }
        } else if ("issimplecalculation".equals(fieldKey)) {
            String method = (String)this.getModel().getValue("levymethod");
            Boolean isSimple = (Boolean)this.getModel().getValue("issimplecalculation");
            if ("general".equals(method) && Boolean.FALSE.equals(isSimple)) {
                this.visibleSwitch(true, "isallowdeductprice");
            } else {
                this.visibleSwitch(false, "isallowdeductprice");
                this.getModel().setValue("isallowdeductprice", (Object)Boolean.FALSE);
            }
        } else if ("taxauthority".equals(fieldKey)) {
            this.getModel().getEntryEntity("prepaymentinfo").stream().forEach(o -> {
                o.set("subbuildingtype", null);
                o.set("prelevyrate", null);
            });
            this.getView().updateView("prepaymentinfo");
        } else if ("buildingtype".equals(fieldKey)) {
            this.getModel().setValue("subbuildingtype", null);
            this.getModel().setValue("prelevyrate", null);
        } else if ("subbuildingtype".equals(fieldKey)) {
            DynamicObject subBuilding = (DynamicObject)this.getModel().getValue("subbuildingtype");
            if (null == subBuilding) {
                return;
            }
            this.getModel().setValue("prelevyrate", (Object)subBuilding.getBigDecimal("yzl"));
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        String callBackId = evt.getCallBackId();
        if ("taxproject".equals(callBackId)) {
            if (MessageBoxResult.Yes.equals((Object)evt.getResult())) {
                this.getModel().deleteEntryData("landinfo");
                this.getModel().deleteEntryData("transferinfo");
                this.getModel().deleteEntryData("prepaymentinfo");
                this.getModel().createNewEntryRow("prepaymentinfo");
                this.clearValue("address", "taxauthority", "location", "startdate", "enddate", "phase", "totalbudget", "unitbudget", "remark", "totallandarea", "totalbuildingarea", "transfercontractname", "paymentdeadline", "levymethod", "applyrate", "issimplecalculation", "isallowdeductprice");
                this.setProjectInfo();
            } else {
                JSONObject jsonObject;
                this.getPageCache().put("cancelFlag", "Boolean.TRUE");
                JSONObject map = jsonObject = JSONObject.parseObject((String)evt.getCustomVaule());
                this.getModel().setValue("taxproject", map.get("taxproject"));
                this.getModel().setValue("number", map.get("number"));
                this.getModel().setValue("name", map.get("name"));
                this.getModel().setValue("address", map.get("address"));
                this.getPageCache().put("cancelFlag", "Boolean.FALSE");
            }
        }
    }

    private void setProjectInfo() {
        DynamicObject taxproject = (DynamicObject)this.getModel().getValue("taxproject");
        if (null == taxproject) {
            this.getModel().setValue("number", null);
            this.getModel().setValue("name", null);
            this.getModel().setValue("taxauthority", null);
            this.getModel().setValue("address", null);
            this.getModel().setValue("taxaddress", null);
        } else {
            DynamicObject taxOrg = (DynamicObject)this.getModel().getValue("taxorg");
            if (taxOrg == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7a0e\u52a1\u7ec4\u7ec7\u3002", (String)"ClearingUnitBillPlugin_6", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
                return;
            }
            QFilter[] qFilters1 = new QFilter[]{new QFilter("orgid", "=", taxOrg.get("id"))};
            DynamicObject dynamicObject1 = QueryServiceHelper.queryOne((String)"tctb_tax_main", (String)"taxoffice", (QFilter[])qFilters1);
            if (dynamicObject1 == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u524d\u5f80\u201c\u57fa\u7840\u8d44\u6599>\u7a0e\u52a1\u7ec4\u7ec7\u7ba1\u7406\u201d\u4e2d\u5b8c\u5584\u7eb3\u7a0e\u4e3b\u4f53\u4fe1\u606f\u3002", (String)"ClearingUnitBillPlugin_7", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
                this.getModel().setValue("taxproject", null);
                return;
            }
            this.getModel().setValue("number", (Object)taxproject.getString("number"));
            this.getModel().setValue("name", taxproject.get("name"));
            this.getModel().setValue("taxauthority", dynamicObject1.get("taxoffice"));
            DynamicObject baseproject = taxproject.getDynamicObject("baseproject");
            if (null != baseproject) {
                QFilter[] qFilters2 = new QFilter[]{new QFilter("id", "=", (Object)baseproject.getLong("id"))};
                DynamicObject dynamicObject2 = QueryServiceHelper.queryOne((String)"bd_project", (String)"proaddress", (QFilter[])qFilters2);
                this.getModel().setValue("address", (Object)dynamicObject2.getString("proaddress"));
                this.getModel().setValue("taxaddress", (Object)dynamicObject2.getString("proaddress"));
            } else {
                this.getModel().setValue("address", null);
                this.getModel().setValue("taxaddress", null);
            }
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        if ("bar_save".equals(itemKey)) {
            DynamicObjectCollection infos = this.getModel().getEntryEntity("prepaymentinfo");
            if (infos.isEmpty()) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u7ef4\u62a4\u623f\u4ea7\u7c7b\u578b\u3001\u9884\u5f81\u7387\u7b49\u4fe1\u606f\u3002", (String)"ClearingUnitBillPlugin_8", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            infos.stream().forEach(e -> {
                if (null == e.get("buildingtype") || null == e.get("prelevyrate")) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5b8c\u5584\u9884\u7f34\u4fe1\u606f\u3002", (String)"ClearingUnitBillPlugin_9", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
                    evt.setCancel(true);
                    return;
                }
            });
        }
    }

    private void clearValue(String ... keys) {
        for (String key : keys) {
            this.getModel().setValue(key, null);
        }
    }

    private void visibleSwitch(boolean onOff, String ... keys) {
        for (String key : keys) {
            this.getView().setVisible(Boolean.valueOf(onOff), new String[]{key});
        }
    }
}

