/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tdm.formplugin.noise;

import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.IFormView;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.operate.New;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.tdm.common.helper.LicenseCheckServiceHelper;
import kd.taxc.tdm.common.util.StringUtil;

public class NoiseBaseDataBillListPlugin
extends AbstractListPlugin {
    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object org = customParams.get("orgid");
        if (org != null) {
            List filterColumnList = args.getFilterContainerInitEvent().getCommonFilterColumns();
            for (FilterColumn filterColumn : filterColumnList) {
                if (filterColumn.getFieldName().equals("org.name") && filterColumn instanceof CommonFilterColumn) {
                    filterColumn.setDefaultValue(org.toString());
                    continue;
                }
                if (!filterColumn.getFieldName().equals("month")) continue;
                filterColumn.setDefaultValues(new Object[]{customParams.get("skssqq"), customParams.get("skssqz")});
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        List filter;
        super.beforeDoOperation(args);
        if (args.getSource() instanceof New && (filter = this.getControlFilters().getFilter("org.id")).size() == 1 && StringUtil.isNotEmpty((CharSequence)filter.get(0).toString())) {
            Long orgid = Long.valueOf(filter.get(0).toString());
            boolean notAuthorize = LicenseCheckServiceHelper.check((Object)orgid, (IFormView)this.getView(), (String)"tcret");
            if (notAuthorize) {
                args.setCancel(true);
                return;
            }
            TaxResult hbsCard = TaxcMainDataServiceHelper.isTaxcMainHjbhsEnableByOrgId((Long)orgid);
            if (hbsCard == null || !((Boolean)hbsCard.getData()).booleanValue()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7a0e\u52a1\u7ec4\u7ec7\u5c1a\u672a\u542f\u7528\u73af\u5883\u4fdd\u62a4\u7a0e\u7a0e\u79cd\u5361\u7247\uff0c\u8bf7\u524d\u5f80\u201c\u57fa\u7840\u8bbe\u7f6e>\u7a0e\u52a1\u7ec4\u7ec7\u7ba1\u7406>\u7eb3\u7a0e\u4e3b\u4f53\u4fe1\u606f\u201d\u4e2d\u7684\u201c\u7a0e\u79cd\u4fe1\u606f\u201c\u542f\u7528\u7a0e\u79cd\u5361\u7247\u3002", (String)"NoiseBaseDataBillListPlugin_1", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
        }
    }
}

