/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tdm.formplugin.noise;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Save;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.operate.formop.NewEntry;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.utils.EmptyCheckUtils;
import kd.taxc.tdm.business.noise.NoiseCalcService;
import kd.taxc.tdm.common.helper.LicenseCheckServiceHelper;
import kd.taxc.tdm.common.helper.OrgCheckServiceHelper;
import kd.taxc.tdm.common.util.DateUtils;
import kd.taxc.tdm.common.util.PermissionUtils;
import kd.taxc.tdm.formplugin.utils.TreeUtils;

public class NoiseBaseDataBillPlugin
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    private static final String ORG = "org";
    private static final String MONTH = "month";
    private static final String ENTRYENTITY = "entryentity";
    private static final String ZYPRODUCTION = "zyproduction";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit type = (BasedataEdit)this.getControl("sourcenumber");
        type.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        AbstractOperate newEntry;
        String operateKey;
        DynamicObject org;
        super.beforeDoOperation(args);
        if (args.getSource() instanceof Save && (org = (DynamicObject)this.getModel().getValue(ORG)) != null && !TaxcMainDataServiceHelper.isTaxcMainByOrgId((Long)org.getLong("id")).isSuccess()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7a0e\u52a1\u7ec4\u7ec7\u672a\u5ba1\u6838\u6216\u4e0d\u53ef\u7528\uff0c\u65e0\u6cd5\u6267\u884c\u5f53\u524d\u64cd\u4f5c\u3002", (String)"NoiseBaseDataBillPlugin_0", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
        if (args.getSource() instanceof NewEntry && "newentry".equals(operateKey = (newEntry = (AbstractOperate)args.getSource()).getOperateKey()) && this.getModel().getValue(MONTH) == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7a0e\u6b3e\u6240\u5c5e\u6708\u4efd", (String)"NoiseBaseDataBillPlugin_13", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if ("newentry".equals(args.getOperateKey())) {
            String zyproduction = (String)this.getModel().getValue(ZYPRODUCTION);
            int entryEntity = this.getModel().getEntryRowCount(ENTRYENTITY);
            if ("0".equals(zyproduction) && entryEntity == 1 || "1".equals(zyproduction) && entryEntity == 2) {
                this.getView().setEnable(Boolean.FALSE, new String[]{"newentry", "deleteentry"});
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        this.getModel().setValue("datasource", (Object)"1");
    }

    public void afterBindData(EventObject e) {
        String billstatus;
        TaxResult hbsCard;
        Long orgid;
        boolean notAuthorize;
        DynamicObject org = (DynamicObject)this.getModel().getValue(ORG);
        if (org != null && (notAuthorize = LicenseCheckServiceHelper.check((Object)(orgid = Long.valueOf(org.getLong("id"))), (IFormView)this.getView(), (String)"tcret"))) {
            this.getModel().setValue(ORG, null);
            return;
        }
        HasPermOrgResult hasPermOrgs = PermissionUtils.getAllPermOrgs((IFormView)this.getView());
        DynamicObjectCollection col = TreeUtils.queryOrgListHasPermission(hasPermOrgs, true);
        Object object = this.getModel().getValue(ORG);
        Long orgid2 = OrgCheckServiceHelper.setDefaultOrg((IFormView)this.getView(), (Long)RequestContext.get().getOrgId(), (DynamicObjectCollection)col);
        if (null != object && this.isTaxAccount(((DynamicObject)object).getLong("id"))) {
            orgid2 = ((DynamicObject)object).getLong("id");
        }
        if ((hbsCard = TaxcMainDataServiceHelper.isTaxcMainHjbhsEnableByOrgId((Long)orgid2)) == null || !((Boolean)hbsCard.getData()).booleanValue()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7a0e\u52a1\u7ec4\u7ec7\u5c1a\u672a\u542f\u7528\u73af\u5883\u4fdd\u62a4\u7a0e\u7a0e\u79cd\u5361\u7247\uff0c\u8bf7\u524d\u5f80\u201c\u57fa\u7840\u8bbe\u7f6e>\u7a0e\u52a1\u7ec4\u7ec7\u7ba1\u7406>\u7eb3\u7a0e\u4e3b\u4f53\u4fe1\u606f\u201d\u4e2d\u7684\u201c\u7a0e\u79cd\u4fe1\u606f\u201d\u542f\u7528\u7a0e\u79cd\u5361\u7247\u3002", (String)"NoiseBaseDataBillPlugin_14", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
            this.getModel().setValue(ORG, null);
            return;
        }
        this.getModel().setValue(ORG, (Object)orgid2);
        DynamicObject sbb = (DynamicObject)this.getModel().getValue("sbbid");
        if (sbb != null && (Objects.equals("B", billstatus = sbb.getString("billstatus")) || Objects.equals("C", billstatus))) {
            this.getView().setEnable(Boolean.FALSE, new String[]{ENTRYENTITY, "fs_baseinfo", "bar_save", "newentry", "deleteentry"});
        }
    }

    private boolean isTaxAccount(Long orgid) {
        QFilter orgFilter = new QFilter(ORG, "=", (Object)orgid);
        return QueryServiceHelper.exists((String)"bastax_taxorg", (QFilter[])new QFilter[]{orgFilter});
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String name = evt.getProperty().getName();
        ListShowParameter formShowParameter = (ListShowParameter)evt.getFormShowParameter();
        if ("sourcenumber".equals(name)) {
            Object org = this.getModel().getValue(ORG);
            if (org == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7a0e\u52a1\u7ec4\u7ec7\u3002", (String)"NoiseBaseDataBillPlugin_2", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            if (null == this.getModel().getValue(MONTH)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7a0e\u6e90\u6240\u5c5e\u671f\u3002", (String)"NoiseBaseDataBillPlugin_3", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            ListFilterParameter listFilterParameter = formShowParameter.getListFilterParameter();
            List qFilters = listFilterParameter.getQFilters();
            Date effectDate = (Date)this.getModel().getValue(MONTH);
            qFilters.add(new QFilter(ORG, "=", (Object)((DynamicObject)this.getModel().getValue(ORG)).getLong("id")));
            qFilters.add(new QFilter("startdate", "<=", (Object)DateUtils.getLastDateOfMonth((Date)effectDate)).and(new QFilter("enddate", ">=", (Object)DateUtils.getFirstDateOfMonth((Date)effectDate))));
            qFilters.add(new QFilter("entryentity.wrwlb", "=", (Object)1215008151309769730L));
            formShowParameter.setCaption(ResManager.loadKDString((String)"\u7a0e\u6e90\u7f16\u53f7", (String)"NoiseBaseDataBillPlugin_4", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
        }
    }

    protected String getMsg() {
        return ResManager.loadKDString((String)"\u4fee\u6539\u3010\u663c\u591c\u4ea7\u751f\u3011\u5c06\u6e05\u7a7a\u566a\u58f0\u4fe1\u606f\u4e2d\u5df2\u586b\u5199\u7684\u6240\u6709\u6570\u636e\uff0c\u8bf7\u786e\u8ba4\uff1f", (String)"NoiseBaseDataBillPlugin_10", (String)"taxc-tdm-formplugin", (Object[])new Object[0]);
    }

    private void showConfirm() {
        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(ZYPRODUCTION, (IFormPlugin)this);
        HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>();
        btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u53d6\u6d88", (String)"NoiseBaseDataBillPlugin_11", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
        btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u786e\u8ba4", (String)"NoiseBaseDataBillPlugin_12", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
        MessageBoxOptions options = MessageBoxOptions.OKCancel;
        String msg = this.getMsg();
        this.getView().showConfirm(msg, "", options, ConfirmTypes.Save, confirmCallBacks, btnNameMaps);
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        String callBackId = e.getCallBackId();
        if (ZYPRODUCTION.equals(callBackId)) {
            if (e.getResult() == MessageBoxResult.Yes) {
                this.getView().setEnable(Boolean.TRUE, new String[]{"newentry", "deleteentry"});
                this.getModel().deleteEntryData(ENTRYENTITY);
                this.getView().updateView(ENTRYENTITY);
            } else if (e.getResult() == MessageBoxResult.Cancel) {
                String zyproduction = (String)this.getModel().getValue(ZYPRODUCTION);
                this.getModel().beginInit();
                if ("0".equals(zyproduction)) {
                    this.getModel().setValue(ZYPRODUCTION, (Object)"1");
                } else {
                    this.getModel().setValue(ZYPRODUCTION, (Object)"0");
                }
                this.getModel().endInit();
                this.getView().updateView(ZYPRODUCTION);
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        ArrayList calcKeys;
        String name;
        switch (name = e.getProperty().getName()) {
            case "zyproduction": {
                ChangeData changeData = e.getChangeSet()[0];
                if (Objects.equals(changeData.getNewValue(), changeData.getOldValue()) || this.getModel().getEntryRowCount(ENTRYENTITY) <= 0) break;
                this.showConfirm();
                break;
            }
            case "sourcenumber": {
                DynamicObject sourcenumber = (DynamicObject)this.getModel().getValue("sourcenumber");
                if (sourcenumber == null) break;
                this.getModel().setValue("taxauthority", sourcenumber.get("pfksszgswjg.id"));
                break;
            }
            case "zjstand": {
                String noisetime;
                int i;
                int rowCount = this.getModel().getEntryRowCount(ENTRYENTITY);
                for (i = 0; i < rowCount; ++i) {
                    noisetime = (String)this.getModel().getValue("zysd", i);
                    if (!"day".equals(noisetime)) continue;
                    this.getModel().setValue("cbfbs", null, i);
                    this.checkFBMonitor(i);
                }
                break;
            }
            case "yjstand": {
                String noisetime;
                int i;
                int rowCount = this.getModel().getEntryRowCount(ENTRYENTITY);
                for (i = 0; i < rowCount; ++i) {
                    noisetime = (String)this.getModel().getValue("zysd", i);
                    if (!"night".equals(noisetime)) continue;
                    this.getModel().setValue("cbfbs", null, i);
                    this.checkFBMonitor(i);
                }
                break;
            }
            case "month": {
                this.getModel().deleteEntryData(ENTRYENTITY);
                this.getView().updateView(ENTRYENTITY);
            }
        }
        if (this.getModel().getValue(MONTH) != null && EmptyCheckUtils.isNotEmpty((Object)(calcKeys = NoiseCalcService.getCalcKeys((String)name)))) {
            ChangeData changeData = e.getChangeSet()[0];
            Set dependKyes = NoiseCalcService.getCalcDependKeys((ArrayList)calcKeys);
            boolean mainChange = NoiseCalcService.MAIN_FIELDS.contains(name);
            HashMap<String, Object> valueMap = new HashMap<String, Object>(16);
            if (mainChange) {
                int rowCount = this.getModel().getEntryRowCount(ENTRYENTITY);
                for (int i = 0; i < rowCount; ++i) {
                    this.updEntryValues(calcKeys, dependKyes, valueMap, i);
                }
            } else {
                int rowIndex = changeData.getRowIndex();
                this.updEntryValues(calcKeys, dependKyes, valueMap, rowIndex);
            }
        }
    }

    private void updEntryValues(ArrayList<String> calcKeys, Set<String> dependKyes, HashMap<String, Object> valueMap, int rowIndex) {
        Date month = (Date)this.getModel().getValue(MONTH);
        for (String dependKey : dependKyes) {
            if (NoiseCalcService.MAIN_FIELDS.contains(dependKey)) {
                valueMap.put(dependKey, this.getModel().getValue(dependKey));
                continue;
            }
            valueMap.put(dependKey, this.getModel().getValue(dependKey, rowIndex));
        }
        HashMap resultMap = NoiseCalcService.calcExprByValueMap(calcKeys, valueMap, (Date)month);
        resultMap.forEach((k, v) -> {
            if (NoiseCalcService.MAIN_FIELDS.contains(k)) {
                this.getModel().setValue(k, v);
            } else {
                this.getModel().setValue(k, v, rowIndex);
                if ("cbfbs".equals(k)) {
                    this.checkFBexc(rowIndex);
                }
            }
        });
    }

    private void checkFBexc(int rowindex) {
        QFilter fstatus1;
        QFilter enddate;
        QFilter startdate;
        Object fbexc = this.getModel().getValue("cbfbs", rowindex);
        if (null == fbexc) {
            return;
        }
        int result = (Integer)fbexc;
        Date month = (Date)this.getModel().getValue(MONTH);
        QFilter f1 = new QFilter("number", "=", (Object)"zsse");
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"tpo_tcvat_assist_trees", (String)"id", (QFilter[])new QFilter[]{f1});
        if (null == dynamicObject) {
            return;
        }
        QFilter groupid = new QFilter("group", "=", (Object)dynamicObject.getLong("id"));
        DynamicObjectCollection coll = QueryServiceHelper.query((String)"tpo_tcvat_assist", (String)"name,number,entryentity.fvalue1 as fvalue1", (QFilter[])new QFilter[]{groupid, startdate = new QFilter("entryentity.startdate", "<=", (Object)DateUtils.getLastDateOfMonth((Date)month)), enddate = new QFilter("entryentity.enddate", ">=", (Object)DateUtils.getFirstDateOfMonth((Date)month)).or(QFilter.isNull((String)"entryentity.enddate")), fstatus1 = new QFilter("entryentity.fstatus1", "=", (Object)"1")});
        if (coll.size() == 0) {
            String monthstr = month == null ? "" : DateUtils.format((Date)month, (String)DateUtils.YYYYMM_CHINESE);
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7a0e\u6b3e\u6240\u5c5e\u6708\u4efd%s \u4e0d\u5728\u6709\u6548\u671f\u5185\uff0c\u8bf7\u524d\u5f80\u201c\u7a0e\u52a1\u653f\u7b56\u8fd0\u7ef4>\u5176\u4ed6\u7a0e\u8d39>\u73af\u4fdd\u7a0e>\u7a0e\u52a1\u8f85\u52a9\u6570\u636e\u201d\uff0c\u5728\u201d\u566a\u58f0\u5355\u4f4d\u7a0e\u989d\u201d\u4e2d\u68c0\u67e5\u7a0e\u6b3e\u6240\u5c5e\u6708\u4efd\u6709\u6548\u671f\u3002", (String)"NoiseBaseDataBillPlugin_5", (String)"taxc-tdm-formplugin", (Object[])new Object[0]), monthstr));
            return;
        }
        if (16 <= result) {
            this.setValue(coll, "zsse-006", rowindex);
            return;
        }
        if (13 <= result) {
            this.setValue(coll, "zsse-005", rowindex);
            return;
        }
        if (10 <= result) {
            this.setValue(coll, "zsse-004", rowindex);
            return;
        }
        if (7 <= result) {
            this.setValue(coll, "zsse-003", rowindex);
            return;
        }
        if (4 <= result) {
            this.setValue(coll, "zsse-002", rowindex);
            return;
        }
        if (1 <= result) {
            this.setValue(coll, "zsse-001", rowindex);
            return;
        }
        this.getModel().setValue("sm", (Object)" ", rowindex);
    }

    private void setValue(DynamicObjectCollection coll, String number, int rowindex) {
        Optional<DynamicObject> assist = coll.stream().filter(c -> number.equals(c.getString("number"))).findFirst();
        if (assist.isPresent()) {
            DynamicObject object = assist.get();
            this.getModel().setValue("sm", (Object)object.getString("name"), rowindex);
        }
    }

    private void checkFBMonitor(int rowindex) {
        String noisetime = (String)this.getModel().getValue("zysd", rowindex);
        Object monitor = this.getModel().getValue("jcfbs", rowindex);
        if (ObjectUtils.isEmpty((Object)noisetime)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u566a\u58f0\u65f6\u6bb5\u3002", (String)"NoiseBaseDataBillPlugin_6", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
            return;
        }
        if (ObjectUtils.isEmpty((Object)monitor)) {
            return;
        }
        Integer fbmonitor = Integer.valueOf(monitor.toString());
        switch (noisetime) {
            case "day": {
                Object standzj = this.getModel().getValue("zjstand");
                if (ObjectUtils.isEmpty((Object)standzj)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u201c\u6807\u51c6\u503c-\u663c\u95f4\u201d\u7684\u503c\u3002", (String)"NoiseBaseDataBillPlugin_7", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
                    return;
                }
                Integer zjstand = (Integer)standzj;
                if (fbmonitor <= zjstand) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u566a\u58f0\u6e90\u76d1\u6d4b\u566a\u58f0\u672a\u8d85\u8fc7\u89c4\u5b9a\u6807\u51c6\u3002", (String)"NoiseBaseDataBillPlugin_8", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
                }
                this.getModel().setValue("cbfbs", (Object)(fbmonitor - zjstand), rowindex);
                break;
            }
            case "night": {
                Object standyj = this.getModel().getValue("yjstand");
                if (ObjectUtils.isEmpty((Object)standyj)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u201c\u6807\u51c6\u503c-\u591c\u95f4\u201d\u7684\u503c\u3002", (String)"NoiseBaseDataBillPlugin_9", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
                    return;
                }
                Integer yjstand = (Integer)standyj;
                if (fbmonitor <= yjstand) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u566a\u58f0\u6e90\u76d1\u6d4b\u566a\u58f0\u672a\u8d85\u8fc7\u89c4\u5b9a\u6807\u51c6\u3002", (String)"NoiseBaseDataBillPlugin_8", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
                }
                this.getModel().setValue("cbfbs", (Object)(fbmonitor - yjstand), rowindex);
            }
        }
    }
}

