/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tdm.formplugin.pollution;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.cache.CacheFactory;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.attachment.AttachmentFieldServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.metadata.MetadataUtil;

public class AirWaterSolidPollutionAttachPlugin
extends AbstractFormPlugin
implements UploadListener {
    private static Log LOGGER = LogFactory.getLog(AirWaterSolidPollutionAttachPlugin.class);

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"btnok"});
        AttachmentPanel attachmentPanel = (AttachmentPanel)this.getView().getControl("attachmentpanelap");
        attachmentPanel.addUploadListener((UploadListener)this);
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object pkid = customParams.get("pkid");
        Object type = customParams.get("type");
        if (StringUtils.equals((CharSequence)key, (CharSequence)"btnok")) {
            if (type != null && type.equals("airwater")) {
                this.saveAttachment("tdm_pollution_air_water", pkid.toString(), type);
            } else {
                this.saveAttachment("tdm_solid_waste_info", pkid.toString(), type);
            }
        }
        this.getView().close();
    }

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object pkid = customParams.get("pkid");
        Object type = customParams.get("type");
        AttachmentPanel attachmentPanel = (AttachmentPanel)this.getControl("attachmentpanelap");
        this.showAttachment(pkid, type, attachmentPanel);
    }

    private void showAttachment(Object pkid, Object type, AttachmentPanel attachmentPanel) {
        DynamicObjectCollection attachmentFields;
        ArrayList attachments = new ArrayList();
        DynamicObject attfieldDemo1Gj = type != null && type.equals("airwater") ? BusinessDataServiceHelper.loadSingle((Object)pkid, (String)"tdm_pollution_air_water") : BusinessDataServiceHelper.loadSingle((Object)pkid, (String)"tdm_solid_waste_info");
        if (null != attfieldDemo1Gj && null != (attachmentFields = attfieldDemo1Gj.getDynamicObjectCollection("attachmentfield")) && attachmentFields.size() > 0) {
            Set fbasedataidIds = attachmentFields.stream().map(a -> a.get("fbasedataid_id")).collect(Collectors.toSet());
            DynamicObjectCollection bd_attachments = QueryServiceHelper.query((String)"bd_attachment", (String)MetadataUtil.getAllSubFieldString((String)"bd_attachment"), (QFilter[])new QFilter("id", "in", fbasedataidIds).toArray());
            for (DynamicObject attachment : bd_attachments) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("type", attachment.getString("type"));
                String url = attachment.getString("url");
                try (InputStream inputStream = FileServiceFactory.getAttachmentFileService().getInputStream(url);){
                    String tempUrl = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsFullUrl(attachment.getString("name"), (InputStream)new BufferedInputStream(inputStream), 60);
                    map.put("url", tempUrl);
                    map.put("uid", attachment.getString("uid"));
                    map.put("name", attachment.getString("name"));
                    map.put("size", attachment.get("size"));
                    map.put("fattachmentpanel", "attachmentpanel");
                    map.put("entityNum", this.getView().getEntityId());
                    map.put("lastModified", attachment.getDate("modifytime"));
                    Date createtime = attachment.getDate("createtime");
                    if (createtime != null) {
                        map.put("createdate", createtime.getTime());
                        map.put("uploadTime", createtime.getTime());
                    }
                    Object creator = attachment.get("creator");
                    Map userInfoByID = UserServiceHelper.getUserInfoByID((long)((Long)creator));
                    String name = userInfoByID.getOrDefault("name", "");
                    map.put("creator", new LocaleString(name));
                    map.put("status", "success");
                    map.put("client", "web");
                    map.put("description", attachment.getString("description"));
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                attachments.add(map);
            }
        }
        if (EmptyCheckUtils.isNotEmpty(attachments)) {
            attachmentPanel.upload(attachments);
        }
    }

    private void saveAttachment(String formname, String sbbid, Object type) {
        String tableName = type != null && type.equals("airwater") ? "t_tdm_airwater_attach" : "t_tdm_solidwaste_attach";
        AttachmentPanel attachmentPanel = (AttachmentPanel)this.getControl("attachmentpanelap");
        List attachmentData = attachmentPanel.getAttachmentData();
        if (QueryServiceHelper.exists((String)formname, (Object)Long.parseLong(sbbid))) {
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(sbbid), (String)formname);
            DynamicObjectCollection attachmentFields = dynamicObject.getDynamicObjectCollection("attachmentfield");
            try {
                this.updateAttachmentField(attachmentData, attachmentFields, "tdm", formname, tableName, Long.parseLong(sbbid));
            }
            catch (Exception e) {
                LOGGER.error("save attachments error", (Throwable)e);
                throw e;
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
        }
    }

    private void updateAttachmentField(List<Map<String, Object>> attachments, DynamicObjectCollection attCol, String appId, String formId, String tableName, Object pkId) {
        List bdAttachments = AttachmentFieldServiceHelper.saveAttachments((String)formId, (String)"", attachments);
        Set uidSet = bdAttachments.stream().map(a -> a.getString("uid")).collect(Collectors.toSet());
        DynamicObject[] dyColl = BusinessDataServiceHelper.load((String)"bd_attachment", (String)"id,name,status,sort,uid,url,creator,description,createtime,tempfile,", (QFilter[])new QFilter[]{new QFilter("uid", "in", uidSet)});
        HashMap<String, DynamicObject> uidHashMap = new HashMap<String, DynamicObject>();
        if (!EmptyCheckUtils.isEmpty((Object)dyColl)) {
            for (DynamicObject bdAttachment : dyColl) {
                String tempfile = bdAttachment.getString("tempfile");
                String uid = bdAttachment.getString("uid");
                if ("0".equalsIgnoreCase(tempfile)) {
                    String url = bdAttachment.getString("url");
                    String fileName = bdAttachment.getString("name");
                    String persistenceUrl = AttachmentServiceHelper.saveTempToFileService((String)url, (String)appId, (String)formId, (Object)pkId, (String)fileName, (boolean)false, (boolean)false);
                    bdAttachment.set("url", (Object)persistenceUrl);
                    bdAttachment.set("tempfile", (Object)1);
                } else {
                    Optional<Map> optional = attachments.stream().filter(stringObjectMap -> stringObjectMap.get("uid").equals(bdAttachment.get("uid"))).findFirst();
                    if (optional.isPresent()) {
                        bdAttachment.set("name", optional.get().get("name"));
                        bdAttachment.set("description", optional.get().get("description"));
                    }
                }
                uidHashMap.put(uid, bdAttachment);
            }
        }
        Iterator iterator = attCol.iterator();
        ArrayList<Object> deleteList = new ArrayList<Object>();
        while (iterator.hasNext()) {
            String uid;
            DynamicObject dynamicObject = (DynamicObject)iterator.next();
            DynamicObject fbasedataid = dynamicObject.getDynamicObject("fbasedataid");
            if (fbasedataid != null && !uidHashMap.containsKey(uid = fbasedataid.getString("uid"))) {
                deleteList.add(fbasedataid.get("id"));
            }
            iterator.remove();
        }
        if (!EmptyCheckUtils.isEmpty((Object)dyColl)) {
            Arrays.stream(dyColl).forEach(a -> attCol.addNew().set("fbasedataid", a.get("id")));
            if (!deleteList.isEmpty()) {
                AttachmentFieldServiceHelper.removeAttachmentsByAttPkIds((String)formId, (String)tableName, (Object[])deleteList.toArray());
            }
            SaveServiceHelper.save((DynamicObject[])dyColl);
        }
    }
}

