/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tdm.formplugin.pollution;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.coderule.api.ICodeRuleService;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.plugin.IImportPlugin;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tdm.business.taxsource.TaxsoureceImportServiceHelper;
import kd.taxc.tdm.common.util.EmptyCheckUtils;
import org.apache.commons.collections.CollectionUtils;

public class NewAirWaterPollutionImportPlugin
implements IImportPlugin {
    public static final String TDM_POLLUTION_AIR_WATER = "tdm_pollution_air_water";
    private static final Map<String, List<String>> templatefromMap = new HashMap<String, List<String>>();

    public boolean beforeImportData(Map<String, Object> data, Map<String, Object> option, List<ImportLogger.ImportLog> importlogs) {
        String templatefrom = (String)data.get("templatefrom");
        if (EmptyCheckUtils.isNotEmpty((Object)templatefrom) && EmptyCheckUtils.isNotEmpty(templatefromMap.get(templatefrom))) {
            List<String> codes;
            QFilter q6;
            String wrwzszmNumber;
            QFilter q5;
            String wrwmcNumber;
            QFilter q4;
            QFilter q3;
            QFilter q2;
            QFilter q1;
            DynamicObject object;
            Object number = data.get("number");
            String wrwlbNumber = this.getBaseDataNumber(data, "wrwlb");
            String swrzlNumber = this.getBaseDataNumber(data, "swrzl");
            if (swrzlNumber == null) {
                swrzlNumber = "408";
            }
            if ((object = QueryServiceHelper.queryOne((String)"tcret_pollution_basedata", (String)"entryentity.bzndz as bzndz", (QFilter[])new QFilter[]{q1 = new QFilter("number", "=", number), q2 = new QFilter("entryentity.wrwlb.number", "=", (Object)wrwlbNumber), q3 = new QFilter("entryentity.swrwzl.number", "=", (Object)swrzlNumber), q4 = new QFilter("entryentity.wrwmc.number", "=", (Object)(wrwmcNumber = this.getBaseDataNumber(data, "wrwmc"))), q5 = new QFilter("entryentity.zszm.number", "=", (Object)(wrwzszmNumber = this.getBaseDataNumber(data, "wrwzszm"))), q6 = new QFilter("entryentity.wrwpfljsff.number", "in", codes = templatefromMap.get(templatefrom))})) != null) {
                data.put("bzndz", object.getBigDecimal("bzndz").toString());
            }
        }
        return true;
    }

    private String getBaseDataNumber(Map<String, Object> data, String name) {
        JSONObject jsonObject = (JSONObject)data.get(name);
        if (jsonObject != null) {
            return jsonObject.getString("number");
        }
        return null;
    }

    public List<Object> importData(Map<String, Object> data, Map<String, Object> option, List<ImportLogger.ImportLog> importlogs) {
        DynamicObject tpoHbsBizdef;
        boolean exist;
        JSONObject jmxzdmhxmmc;
        DynamicObjectCollection tdmPollutionBasedataList;
        DynamicObject swrzlObject;
        String swrwzlNumber;
        DynamicObject airWaterTpObject;
        String emissions;
        JSONObject swrwzl;
        Date monthDate;
        JSONObject wrwmc;
        String number;
        JSONObject org;
        String templatefrom = (String)data.get("templatefrom");
        if (StringUtils.isEmpty((CharSequence)templatefrom)) {
            importlogs.add(new ImportLogger.ImportLog(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u9002\u7528\u6a21\u677f", (String)"NewAirWaterPollutionImportPlugin_0", (String)"taxc-tdm-formplugin", (Object[])new Object[0])));
        }
        if ((org = (JSONObject)data.get("org")) == null) {
            importlogs.add(new ImportLogger.ImportLog(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u7a0e\u52a1\u7ec4\u7ec7", (String)"NewAirWaterPollutionImportPlugin_1", (String)"taxc-tdm-formplugin", (Object[])new Object[0])));
            return super.importData(data, option, importlogs);
        }
        DynamicObject orgObject = null;
        TaxResult result = TaxcMainDataServiceHelper.queryTaxcMainByOrgNum((String)org.getString("number"));
        if (result != null && result.isSuccess() && result.getData() != null) {
            orgObject = (DynamicObject)result.getData();
        }
        if (orgObject == null) {
            importlogs.add(new ImportLogger.ImportLog(ResManager.loadKDString((String)"\u7a0e\u52a1\u7ec4\u7ec7\u4e0d\u5b58\u5728", (String)"NewAirWaterPollutionImportPlugin_2", (String)"taxc-tdm-formplugin", (Object[])new Object[0])));
            return super.importData(data, option, importlogs);
        }
        if (!TaxcMainDataServiceHelper.isTaxcMainByOrgId((Long)orgObject.getLong("orgid.id")).isSuccess()) {
            importlogs.add(new ImportLogger.ImportLog(String.format(ResManager.loadKDString((String)"\u7a0e\u52a1\u7ec4\u7ec7\u672a\u5ba1\u6838\u6216\u4e0d\u53ef\u7528\uff0c\u65e0\u6cd5\u5f15\u5165\u6570\u636e\uff1a\u7f16\u7801%s", (String)"NewAirWaterPollutionImportPlugin_62", (String)"taxc-tdm-formplugin", (Object[])new Object[0]), org.get((Object)"number"))));
        }
        if (StringUtils.isEmpty((CharSequence)(number = (String)data.get("number")))) {
            importlogs.add(new ImportLogger.ImportLog(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u7a0e\u6e90\u7f16\u7801", (String)"NewAirWaterPollutionImportPlugin_3", (String)"taxc-tdm-formplugin", (Object[])new Object[0])));
        }
        if ((wrwmc = (JSONObject)data.get("wrwmc")) == null || StringUtils.isEmpty((CharSequence)wrwmc.getString("number"))) {
            importlogs.add(new ImportLogger.ImportLog(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u6c61\u67d3\u7269\u540d\u79f0", (String)"NewAirWaterPollutionImportPlugin_4", (String)"taxc-tdm-formplugin", (Object[])new Object[0])));
            return super.importData(data, option, importlogs);
        }
        DynamicObject wrwmcObject = QueryServiceHelper.queryOne((String)"tpo_hbs_bizdef_entry", (String)"id,projectname,parent", (QFilter[])new QFilter[]{new QFilter("number", "=", wrwmc.get((Object)"number"))});
        if (wrwmcObject == null) {
            importlogs.add(new ImportLogger.ImportLog(ResManager.loadKDString((String)"\u6c61\u67d3\u7269\u540d\u79f0\u4e0d\u5b58\u5728", (String)"NewAirWaterPollutionImportPlugin_5", (String)"taxc-tdm-formplugin", (Object[])new Object[0])));
            return super.importData(data, option, importlogs);
        }
        JSONObject wrwzszm = (JSONObject)data.get("wrwzszm");
        DynamicObject wrwzszmObject = null;
        if (wrwzszm != null && (wrwzszmObject = QueryServiceHelper.queryOne((String)"tpo_hbs_bizdef_entry", (String)"id,projectname,parent", (QFilter[])new QFilter[]{new QFilter("number", "=", wrwzszm.get((Object)"number"))})) == null) {
            importlogs.add(new ImportLogger.ImportLog(ResManager.loadKDString((String)"\u5f81\u6536\u5b50\u76ee\u4e0d\u5b58\u5728", (String)"NewAirWaterPollutionImportPlugin_63", (String)"taxc-tdm-formplugin", (Object[])new Object[0])));
        }
        if ("101212301".equals(wrwmc.get((Object)"number")) && (wrwzszm == null || StringUtils.isEmpty((CharSequence)wrwzszm.getString("number")))) {
            importlogs.add(new ImportLogger.ImportLog(ResManager.loadKDString((String)"\u201c\u6c61\u67d3\u7269\u540d\u79f0\u201d\u4e3a\u201cPH\u503c\uff08\u6c34\uff09\u201d\u65f6\uff0c\u201c\u5f81\u6536\u5b50\u76ee\u201d\u4e0d\u80fd\u4e3a\u7a7a", (String)"NewAirWaterPollutionImportPlugin_64", (String)"taxc-tdm-formplugin", (Object[])new Object[0])));
            return super.importData(data, option, importlogs);
        }
        String month = (String)data.get("month");
        if (StringUtils.isEmpty((CharSequence)month)) {
            importlogs.add(new ImportLogger.ImportLog(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u7a0e\u6b3e\u6240\u5c5e\u6708\u4efd", (String)"NewAirWaterPollutionImportPlugin_6", (String)"taxc-tdm-formplugin", (Object[])new Object[0])));
        }
        try {
            monthDate = DateUtils.stringToDate2((String)month);
        }
        catch (Exception ex) {
            importlogs.add(new ImportLogger.ImportLog(ex.getMessage()));
            return super.importData(data, option, importlogs);
        }
        String dwse = (String)data.get("dwse");
        if (StringUtils.isEmpty((CharSequence)dwse)) {
            importlogs.add(new ImportLogger.ImportLog(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5355\u4f4d\u7a0e\u989d", (String)"NewAirWaterPollutionImportPlugin_9", (String)"taxc-tdm-formplugin", (Object[])new Object[0])));
        } else if (BigDecimal.ZERO.compareTo(new BigDecimal(dwse)) >= 0) {
            importlogs.add(new ImportLogger.ImportLog(ResManager.loadKDString((String)"\u201c\u5355\u4f4d\u7a0e\u989d\u201d\u5f55\u5165\u7684\u503c\u9700\u8981\u5927\u4e8e0", (String)"NewAirWaterPollutionImportPlugin_57", (String)"taxc-tdm-formplugin", (Object[])new Object[0])));
        }
        String wrwpfl = (String)data.get("wrwpfl");
        JSONObject wrwlb = (JSONObject)data.get("wrwlb");
        if (wrwlb == null) {
            importlogs.add(new ImportLogger.ImportLog(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u6c61\u67d3\u7269\u7c7b\u522b", (String)"NewAirWaterPollutionImportPlugin_45", (String)"taxc-tdm-formplugin", (Object[])new Object[0])));
        }
        if ((swrwzl = (JSONObject)data.get("swrzl")) == null) {
            swrwzl = new JSONObject();
            swrwzl.put("importprop", (Object)"number");
            swrwzl.put("number", (Object)"408");
            data.put("swrzl", swrwzl);
        }
        if (Objects.equals("1", templatefrom)) {
            String zgndz;
            String yjndz;
            String scndz;
            emissions = (String)data.get("emissions");
            if (StringUtils.isEmpty((CharSequence)emissions)) {
                importlogs.add(new ImportLogger.ImportLog(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5e9f\u6c14\uff08\u5e9f\u6c34\uff09\u6392\u653e\u91cf", (String)"NewAirWaterPollutionImportPlugin_26", (String)"taxc-tdm-formplugin", (Object[])new Object[0])));
            }
            if (StringUtils.isEmpty((CharSequence)(scndz = (String)data.get("scndz")))) {
                importlogs.add(new ImportLogger.ImportLog(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5b9e\u6d4b\u6d53\u5ea6\u503c", (String)"NewAirWaterPollutionImportPlugin_39", (String)"taxc-tdm-formplugin", (Object[])new Object[0])));
            }
            if (StringUtils.isEmpty((CharSequence)(yjndz = (String)data.get("yjndz")))) {
                importlogs.add(new ImportLogger.ImportLog(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u6708\u5747\u6d53\u5ea6\u503c", (String)"NewAirWaterPollutionImportPlugin_40", (String)"taxc-tdm-formplugin", (Object[])new Object[0])));
            }
            if (StringUtils.isEmpty((CharSequence)(zgndz = (String)data.get("zgndz")))) {
                importlogs.add(new ImportLogger.ImportLog(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u6700\u9ad8\u6d53\u5ea6\u503c", (String)"NewAirWaterPollutionImportPlugin_41", (String)"taxc-tdm-formplugin", (Object[])new Object[0])));
            }
            if (data.get("testreport") == null) {
                importlogs.add(new ImportLogger.ImportLog(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u68c0\u6d4b\u62a5\u544a", (String)"NewAirWaterPollutionImportPlugin_61", (String)"taxc-tdm-formplugin", (Object[])new Object[0])));
            }
        }
        if ((Objects.equals("1", templatefrom) || Objects.equals("3", templatefrom)) && StringUtils.isEmpty((CharSequence)wrwpfl)) {
            importlogs.add(new ImportLogger.ImportLog(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u6c61\u67d3\u7269\u6392\u653e\u91cf", (String)"NewAirWaterPollutionImportPlugin_28", (String)"taxc-tdm-formplugin", (Object[])new Object[0])));
        }
        if (Objects.equals("4", templatefrom)) {
            emissions = (String)data.get("emissions");
            if (StringUtils.isEmpty((CharSequence)emissions)) {
                importlogs.add(new ImportLogger.ImportLog(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5e9f\u6c14\uff08\u5e9f\u6c34\uff09\u6392\u653e\u91cf", (String)"NewAirWaterPollutionImportPlugin_26", (String)"taxc-tdm-formplugin", (Object[])new Object[0])));
            }
            if (swrwzl == null) {
                importlogs.add(new ImportLogger.ImportLog(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u6c34\u6c61\u67d3\u79cd\u7c7b", (String)"NewAirWaterPollutionImportPlugin_46", (String)"taxc-tdm-formplugin", (Object[])new Object[0])));
            }
        }
        if (Objects.equals("2", templatefrom)) {
            String jsjc;
            String jsjcdw;
            String wrwdw = (String)data.get("wrwdw");
            if (StringUtils.isEmpty((CharSequence)wrwdw)) {
                importlogs.add(new ImportLogger.ImportLog(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u6c61\u67d3\u7269\u5355\u4f4d", (String)"NewAirWaterPollutionImportPlugin_36", (String)"taxc-tdm-formplugin", (Object[])new Object[0])));
            }
            if (StringUtils.isEmpty((CharSequence)(jsjcdw = (String)data.get("jsjcdw")))) {
                importlogs.add(new ImportLogger.ImportLog(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u8ba1\u7a0e\u57fa\u6570\u5355\u4f4d", (String)"NewAirWaterPollutionImportPlugin_37", (String)"taxc-tdm-formplugin", (Object[])new Object[0])));
            }
            if (StringUtils.isEmpty((CharSequence)(jsjc = (String)data.get("jsjc")))) {
                importlogs.add(new ImportLogger.ImportLog(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u8ba1\u7b97\u57fa\u6570", (String)"NewAirWaterPollutionImportPlugin_38", (String)"taxc-tdm-formplugin", (Object[])new Object[0])));
            } else {
                data.put("jsjc", new BigDecimal(jsjc).setScale(8, 4));
            }
        }
        if (Objects.equals("5", templatefrom)) {
            String qcpwxs;
            String qcwrwdw = (String)data.get("qcwrwdw");
            if (StringUtils.isEmpty((CharSequence)qcwrwdw)) {
                importlogs.add(new ImportLogger.ImportLog(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u6c61\u67d3\u7269\u5355\u4f4d", (String)"NewAirWaterPollutionImportPlugin_36", (String)"taxc-tdm-formplugin", (Object[])new Object[0])));
            }
            if (StringUtils.isEmpty((CharSequence)(qcpwxs = (String)data.get("qcpwxs")))) {
                importlogs.add(new ImportLogger.ImportLog(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u6392\u6c61\u7cfb\u6570", (String)"NewAirWaterPollutionImportPlugin_53", (String)"taxc-tdm-formplugin", (Object[])new Object[0])));
            } else if (BigDecimal.ZERO.compareTo(new BigDecimal(qcpwxs)) >= 0) {
                importlogs.add(new ImportLogger.ImportLog(ResManager.loadKDString((String)"\u201c\u6392\u6c61\u7cfb\u6570\u201d\u5f55\u5165\u7684\u503c\u9700\u8981\u5927\u4e8e0", (String)"NewAirWaterPollutionImportPlugin_58", (String)"taxc-tdm-formplugin", (Object[])new Object[0])));
            }
            String tzl = (String)data.get("tzl");
            if (StringUtils.isEmpty((CharSequence)tzl)) {
                importlogs.add(new ImportLogger.ImportLog(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u7279\u5f81\u91cf", (String)"NewAirWaterPollutionImportPlugin_52", (String)"taxc-tdm-formplugin", (Object[])new Object[0])));
            } else if (BigDecimal.ZERO.compareTo(new BigDecimal(tzl)) >= 0) {
                importlogs.add(new ImportLogger.ImportLog(ResManager.loadKDString((String)"\u201c\u7279\u5f81\u91cf\u201d\u5f55\u5165\u7684\u503c\u9700\u8981\u5927\u4e8e0", (String)"NewAirWaterPollutionImportPlugin_56", (String)"taxc-tdm-formplugin", (Object[])new Object[0])));
            }
        }
        if (orgObject != null && (airWaterTpObject = QueryServiceHelper.queryOne((String)"tdm_pollute_airwater_tp", (String)"id", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)orgObject.getLong("orgid.id")), new QFilter("month", "=", (Object)DateUtils.stringToDate2((String)month))})) != null) {
            importlogs.add(new ImportLogger.ImportLog(ResManager.loadKDString((String)"\u5f15\u5165\u6570\u636e\u7684\u7ec4\u7ec7\u5c5e\u671f\u5df2\u5b58\u5728\u6682\u5b58\u6570\u636e", (String)"NewAirWaterPollutionImportPlugin_60", (String)"taxc-tdm-formplugin", (Object[])new Object[0])));
        }
        if (importlogs.size() > 0) {
            return super.importData(data, option, importlogs);
        }
        String wrwlbNumber = wrwlb != null ? wrwlb.getString("number") : "";
        String wrwmcNumber = wrwmc != null ? wrwmc.getString("number") : "";
        long wrwmcParentId = wrwmcObject != null ? wrwmcObject.getLong("parent") : 0L;
        String string = swrwzlNumber = swrwzl != null ? swrwzl.getString("number") : "";
        if (Lists.newArrayList((Object[])new String[]{"1", "2", "3"}).contains(templatefrom)) {
            if (!"101".equals(wrwlbNumber) && !"102".equals(wrwlbNumber)) {
                importlogs.add(new ImportLogger.ImportLog(ResManager.loadKDString((String)"\u5f53\u524d\u6c61\u67d3\u7269\u7c7b\u522b\u4e0d\u9002\u7528\u672c\u6a21\u677f\uff0c\u8bf7\u4fee\u6539\u3002", (String)"NewAirWaterPollutionImportPlugin_47", (String)"taxc-tdm-formplugin", (Object[])new Object[0])));
            }
            if ("101".equals(wrwlbNumber) && (swrwzl == null || !Objects.equals(swrwzlNumber, "301") && !Objects.equals(swrwzlNumber, "302"))) {
                importlogs.add(new ImportLogger.ImportLog(ResManager.loadKDString((String)"\u5f53\u6c61\u67d3\u7269\u662f\u6c34\u6c61\u67d3\u7269\u65f6\uff0c\u6c34\u6c61\u67d3\u7269\u79cd\u7c7b\u5fc5\u987b\u5f55\u5165301\u6216302\u3002", (String)"NewAirWaterPollutionImportPlugin_48", (String)"taxc-tdm-formplugin", (Object[])new Object[0])));
            }
            if ("102".equals(wrwlbNumber)) {
                if ("2".equals(templatefrom)) {
                    if (!"407".equals(wrwmcNumber) && !"405".equals(wrwmcNumber) && 1215010325099995137L != wrwmcParentId) {
                        importlogs.add(new ImportLogger.ImportLog(ResManager.loadKDString((String)"\u5f53\u524d\u6c61\u67d3\u7269\u540d\u79f0\u4e0e\u6c61\u67d3\u7269\u7c7b\u522b\u4e0d\u5339\u914d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"NewAirWaterPollutionImportPlugin_50", (String)"taxc-tdm-formplugin", (Object[])new Object[0])));
                    }
                } else if (!"407".equals(wrwmcNumber) && 1215010325099995137L != wrwmcParentId) {
                    importlogs.add(new ImportLogger.ImportLog(ResManager.loadKDString((String)"\u5f53\u524d\u6c61\u67d3\u7269\u540d\u79f0\u4e0e\u6c61\u67d3\u7269\u7c7b\u522b\u4e0d\u5339\u914d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"NewAirWaterPollutionImportPlugin_50", (String)"taxc-tdm-formplugin", (Object[])new Object[0])));
                }
            }
            if ("101".equals(wrwlbNumber) && swrwzl != null && "301".equals(swrwzlNumber)) {
                if ("2".equals(templatefrom)) {
                    if (!"407".equals(wrwmcNumber) && !"405".equals(wrwmcNumber) && 1215018534896427010L != wrwmcParentId) {
                        importlogs.add(new ImportLogger.ImportLog(ResManager.loadKDString((String)"\u5f53\u524d\u6c61\u67d3\u7269\u540d\u79f0\u4e0e\u6c61\u67d3\u7269\u7c7b\u522b\u4e0d\u5339\u914d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"NewAirWaterPollutionImportPlugin_50", (String)"taxc-tdm-formplugin", (Object[])new Object[0])));
                    }
                } else if (!"407".equals(wrwmcNumber) && 1215018534896427010L != wrwmcParentId) {
                    importlogs.add(new ImportLogger.ImportLog(ResManager.loadKDString((String)"\u5f53\u524d\u6c61\u67d3\u7269\u540d\u79f0\u4e0e\u6c61\u67d3\u7269\u7c7b\u522b\u4e0d\u5339\u914d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"NewAirWaterPollutionImportPlugin_50", (String)"taxc-tdm-formplugin", (Object[])new Object[0])));
                }
            }
            if ("101".equals(wrwlbNumber) && swrwzl != null && "302".equals(swrwzlNumber)) {
                if ("2".equals(templatefrom)) {
                    if (!"407".equals(wrwmcNumber) && !"405".equals(wrwmcNumber) && 1215020474711792640L != wrwmcParentId) {
                        importlogs.add(new ImportLogger.ImportLog(ResManager.loadKDString((String)"\u5f53\u524d\u6c61\u67d3\u7269\u540d\u79f0\u4e0e\u6c61\u67d3\u7269\u7c7b\u522b\u4e0d\u5339\u914d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"NewAirWaterPollutionImportPlugin_50", (String)"taxc-tdm-formplugin", (Object[])new Object[0])));
                    }
                } else if (!"407".equals(wrwmcNumber) && 1215020474711792640L != wrwmcParentId) {
                    importlogs.add(new ImportLogger.ImportLog(ResManager.loadKDString((String)"\u5f53\u524d\u6c61\u67d3\u7269\u540d\u79f0\u4e0e\u6c61\u67d3\u7269\u7c7b\u522b\u4e0d\u5339\u914d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"NewAirWaterPollutionImportPlugin_50", (String)"taxc-tdm-formplugin", (Object[])new Object[0])));
                }
            }
        } else if (Lists.newArrayList((Object[])new String[]{"4", "5"}).contains(templatefrom)) {
            if (!"101".equals(wrwlbNumber)) {
                importlogs.add(new ImportLogger.ImportLog(ResManager.loadKDString((String)"\u5f53\u524d\u6c61\u67d3\u7269\u7c7b\u522b\u4e0d\u9002\u7528\u672c\u6a21\u677f\uff0c\u8bf7\u4fee\u6539\u3002", (String)"NewAirWaterPollutionImportPlugin_47", (String)"taxc-tdm-formplugin", (Object[])new Object[0])));
            }
            if (!("303".equals(swrwzlNumber) && "4".equals(templatefrom) || "304".equals(swrwzlNumber) && "5".equals(templatefrom))) {
                importlogs.add(new ImportLogger.ImportLog(ResManager.loadKDString((String)"\u5f53\u524d\u6c61\u67d3\u7269\u540d\u79f0\u4e0e\u6c61\u67d3\u7269\u7c7b\u522b\u4e0d\u5339\u914d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"NewAirWaterPollutionImportPlugin_50", (String)"taxc-tdm-formplugin", (Object[])new Object[0])));
            }
        }
        if ("1".equals(templatefrom) || "2".equals(templatefrom) || "3".equals(templatefrom)) {
            if (1215018534896427010L != wrwmcParentId && 1215020474711792640L != wrwmcParentId && 1215010325099995137L != wrwmcParentId) {
                importlogs.add(new ImportLogger.ImportLog(ResManager.loadKDString((String)"\u5f53\u524d\u6c61\u67d3\u7269\u540d\u79f0\u4e0d\u9002\u7528\u672c\u6a21\u677f\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6a21\u677f\u3002", (String)"NewAirWaterPollutionImportPlugin_10", (String)"taxc-tdm-formplugin", (Object[])new Object[0])));
            }
        } else if ("4".equals(templatefrom)) {
            if (1215033989380037676L != wrwmcParentId) {
                importlogs.add(new ImportLogger.ImportLog(ResManager.loadKDString((String)"\u5f53\u524d\u6c61\u67d3\u7269\u540d\u79f0\u4e0d\u9002\u7528\u672c\u6a21\u677f\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6a21\u677f\u3002", (String)"NewAirWaterPollutionImportPlugin_10", (String)"taxc-tdm-formplugin", (Object[])new Object[0])));
            }
            if ("101212302".equals(wrwmcNumber) && StringUtils.isEmpty((CharSequence)((String)data.get("sdcbbs")))) {
                importlogs.add(new ImportLogger.ImportLog(ResManager.loadKDString((String)"\u6c61\u67d3\u7269\u4e3a\u8272\u5ea6\u65f6\uff0c\u9700\u8981\u5f55\u5165\u8272\u5ea6\u8d85\u6807\u500d\u6570\u7684\u503c\uff0c\u4e14\u4e0d\u53ef\u4e3a\u8d1f\u6570", (String)"NewAirWaterPollutionImportPlugin_11", (String)"taxc-tdm-formplugin", (Object[])new Object[0])));
            }
            if (!"101212302".equals(wrwmcNumber) && StringUtils.isNotEmpty((CharSequence)((String)data.get("sdcbbs")))) {
                importlogs.add(new ImportLogger.ImportLog(ResManager.loadKDString((String)"\u5f53\u524d\u6c61\u67d3\u7269\u4e0d\u662f\u8272\u5ea6\uff0c\u4e0d\u9700\u8981\u5f55\u5165\u8272\u5ea6\u8d85\u6807\u500d\u6570\u3002", (String)"NewAirWaterPollutionImportPlugin_12", (String)"taxc-tdm-formplugin", (Object[])new Object[0])));
            }
        } else if ("5".equals(templatefrom) && 1215035712626515976L != wrwmcParentId) {
            importlogs.add(new ImportLogger.ImportLog(ResManager.loadKDString((String)"\u5f53\u524d\u6c61\u67d3\u7269\u540d\u79f0\u4e0d\u9002\u7528\u672c\u6a21\u677f\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6a21\u677f\u3002", (String)"NewAirWaterPollutionImportPlugin_10", (String)"taxc-tdm-formplugin", (Object[])new Object[0])));
        }
        String hygcpfwrwmc = (String)data.get("hygcpfwrwmc");
        if ("407".equals(wrwmcNumber) && StringUtils.isEmpty((CharSequence)hygcpfwrwmc)) {
            importlogs.add(new ImportLogger.ImportLog(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u6d77\u6d0b\u5de5\u7a0b\u6392\u653e\u6c61\u67d3\u7269\u540d\u79f0", (String)"NewAirWaterPollutionImportPlugin_13", (String)"taxc-tdm-formplugin", (Object[])new Object[0])));
        }
        if (!"407".equals(wrwmcNumber) && !StringUtils.isEmpty((CharSequence)hygcpfwrwmc)) {
            importlogs.add(new ImportLogger.ImportLog(ResManager.loadKDString((String)"\u5f53\u524d\u6c61\u67d3\u7269\u4e0d\u9700\u8981\u586b\u5199\u201c\u6d77\u6d0b\u5de5\u7a0b\u6392\u653e\u6c61\u67d3\u7269\u540d\u79f0\u201d", (String)"NewAirWaterPollutionImportPlugin_14", (String)"taxc-tdm-formplugin", (Object[])new Object[0])));
        }
        String sbbnum = (String)data.get("sbbnum");
        if ("405".equals(wrwmcNumber) && StringUtils.isEmpty((CharSequence)sbbnum)) {
            importlogs.add(new ImportLogger.ImportLog(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u4ea7\u6392\u6c61\u7cfb\u6570\u7684\u6c61\u67d3\u7269\u540d\u79f0", (String)"NewAirWaterPollutionImportPlugin_15", (String)"taxc-tdm-formplugin", (Object[])new Object[0])));
        }
        if (!"405".equals(wrwmcNumber) && !StringUtils.isEmpty((CharSequence)sbbnum)) {
            importlogs.add(new ImportLogger.ImportLog(ResManager.loadKDString((String)"\u5f53\u524d\u6c61\u67d3\u7269\u4e0d\u9700\u8981\u586b\u5199\u201c\u4ea7\u6392\u6c61\u7cfb\u6570\u7684\u6c61\u67d3\u7269\u540d\u79f0\u201d", (String)"NewAirWaterPollutionImportPlugin_16", (String)"taxc-tdm-formplugin", (Object[])new Object[0])));
        }
        if (importlogs.size() > 0) {
            return super.importData(data, option, importlogs);
        }
        QFilter orgidFilter = new QFilter("org", "=", (Object)orgObject.getLong("orgid.id"));
        QFilter wrwmcFilter = new QFilter("entryentity.wrwmc", "=", wrwmcObject.get("id"));
        String wrwname = wrwmcObject.getString("projectname");
        if ("407".equals(wrwmcNumber)) {
            wrwname = hygcpfwrwmc;
        }
        if ("405".equals(wrwmcNumber)) {
            wrwname = sbbnum;
        }
        QFilter numberFilter = new QFilter("number", "=", (Object)number);
        DynamicObject wrwlbObject = QueryServiceHelper.queryOne((String)"tpo_hbs_bizdef_entry", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)wrwlbNumber)});
        QFilter wrwlbFilter = new QFilter("entryentity.wrwlb", "=", (Object)wrwlbObject.getLong("id"));
        if (swrwzl != null && (swrzlObject = QueryServiceHelper.queryOne((String)"tpo_hbs_bizdef_entry", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)swrwzlNumber)})) != null) {
            wrwlbFilter = new QFilter("entryentity.wrwlb", "=", (Object)wrwlbObject.getLong("id")).and(new QFilter("entryentity.swrwzl", "=", (Object)swrzlObject.getLong("id")));
        }
        if (CollectionUtils.isEmpty((Collection)(tdmPollutionBasedataList = QueryServiceHelper.query((String)"tcret_pollution_basedata", (String)"id,pfksszgswjg,number,pfknum,name,startdate,enddate,entryentity.wrwlb,entryentity.swrwzl,entryentity.wrwmc,entryentity.zszm,entryentity.wrwpfljsff,enable", (QFilter[])new QFilter[]{orgidFilter, wrwmcFilter, numberFilter, wrwlbFilter})))) {
            importlogs.add(new ImportLogger.ImportLog(ResManager.loadKDString((String)"\u5f53\u524d\u6392\u6c61\u53e3\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u5148\u5728\u3010\u6392\u6c61\u53e3\u57fa\u7840\u4fe1\u606f\u3011\u4e2d\u7ef4\u62a4\u6392\u6c61\u53e3\u6570\u636e\uff0c\u518d\u7ef4\u62a4\u6c34\u548c\u5927\u6c14\u6c61\u67d3\u7269\u7684\u7a0e\u6e90\u6570\u636e\u3002", (String)"NewAirWaterPollutionImportPlugin_21", (String)"taxc-tdm-formplugin", (Object[])new Object[0])));
            return super.importData(data, option, importlogs);
        }
        DynamicObject tdmPollutionBasedata = (DynamicObject)tdmPollutionBasedataList.get(0);
        if (!"1".equals(tdmPollutionBasedata.getString("enable"))) {
            importlogs.add(new ImportLogger.ImportLog(ResManager.loadKDString((String)"\u5f53\u524d\u6392\u6c61\u53e3\u6570\u636e\u7684\u6570\u636e\u72b6\u6001\u4e0d\u53ef\u7528\uff0c\u8bf7\u524d\u5f80\u3010\u6392\u6c61\u53e3\u57fa\u7840\u4fe1\u606f\u3011\u4e2d\u4fee\u6539\u3002", (String)"NewAirWaterPollutionImportPlugin_22", (String)"taxc-tdm-formplugin", (Object[])new Object[0])));
        }
        Date startDate = tdmPollutionBasedata.getDate("startdate");
        Date endDate = tdmPollutionBasedata.getDate("enddate");
        if (monthDate.after(endDate) || monthDate.before(startDate)) {
            importlogs.add(new ImportLogger.ImportLog(ResManager.loadKDString((String)"\u7a0e\u6b3e\u6240\u5c5e\u6708\u4efd\u4e0e\u7a0e\u6e90\u7f16\u53f7\u7684\u6709\u6548\u671f\u4e0d\u5339\u914d\uff0c\u8bf7\u68c0\u67e5\u6392\u6c61\u53e3\u57fa\u7840\u4fe1\u606f\u8d44\u6599\u3002", (String)"NewAirWaterPollutionImportPlugin_65", (String)"taxc-tdm-formplugin", (Object[])new Object[0])));
        }
        if (!"4".equals(templatefrom)) {
            if ("5".equals(templatefrom)) {
                if (1215008151309769728L != tdmPollutionBasedata.getLong("entryentity.wrwlb") || 1215009637242625028L != tdmPollutionBasedata.getLong("entryentity.swrwzl")) {
                    importlogs.add(new ImportLogger.ImportLog(ResManager.loadKDString((String)"\u5f53\u524d\u6392\u6c61\u53e3\u6570\u636e\u7684\u6c61\u67d3\u7269\u7c7b\u522b\u6c34\u6c61\u67d3\u7269\u4e2d\u7684\u79bd\u755c\u517b\u6b96\u4e1a\u3001\u5c0f\u578b\u4f01\u4e1a\u548c\u7b2c\u4e09\u4ea7\u4e1a\u6c61\u67d3\u7269\uff0c\u8bf7\u66f4\u6362\u5f15\u5165\u6a21\u677f\u6216\u524d\u5f80\u3010\u6392\u6c61\u53e3\u57fa\u7840\u4fe1\u606f\u3011\u4e2d\u4fee\u6539\u3002", (String)"NewAirWaterPollutionImportPlugin_54", (String)"taxc-tdm-formplugin", (Object[])new Object[0])));
                }
            } else if (1215008151309769729L != tdmPollutionBasedata.getLong("entryentity.wrwlb") && (1215008151309769728L != tdmPollutionBasedata.getLong("entryentity.wrwlb") || 1215009637242625025L != tdmPollutionBasedata.getLong("entryentity.swrwzl") && 1215009637242625026L != tdmPollutionBasedata.getLong("entryentity.swrwzl"))) {
                importlogs.add(new ImportLogger.ImportLog(ResManager.loadKDString((String)"\u5f53\u524d\u6392\u6c61\u53e3\u6570\u636e\u7684\u6c61\u67d3\u7269\u7c7b\u522b\u4e0d\u662f\u4e00\u7c7b\u6c34\u3001\u4e8c\u7c7b\u6c34\u6216\u5927\u6c14\u6c61\u67d3\u7269\uff0c\u8bf7\u66f4\u6362\u5f15\u5165\u6a21\u677f\u6216\u524d\u5f80\u3010\u6392\u6c61\u53e3\u57fa\u7840\u4fe1\u606f\u3011\u4e2d\u4fee\u6539\u3002", (String)"NewAirWaterPollutionImportPlugin_23", (String)"taxc-tdm-formplugin", (Object[])new Object[0])));
            }
        } else if ("4".equals(templatefrom) && (1215008151309769728L != tdmPollutionBasedata.getLong("entryentity.wrwlb") || 1215009637242625027L != tdmPollutionBasedata.getLong("entryentity.swrwzl"))) {
            importlogs.add(new ImportLogger.ImportLog(ResManager.loadKDString((String)"\u5f53\u524d\u6392\u6c61\u53e3\u6570\u636e\u7684\u6c61\u67d3\u7269\u7c7b\u522b\u4e0d\u662fPH\u503c\u3001\u8272\u5ea6\u3001\u5927\u80a0\u83cc\u7fa4\u6570\u3001\u4f59\u6c2f\u91cf\u6c34\u6c61\u67d3\u7269\uff0c\u8bf7\u66f4\u6362\u5f15\u5165\u6a21\u677f\u6216\u524d\u5f80\u3010\u6392\u6c61\u53e3\u57fa\u7840\u4fe1\u606f\u3011\u4e2d\u4fee\u6539\u3002", (String)"NewAirWaterPollutionImportPlugin_24", (String)"taxc-tdm-formplugin", (Object[])new Object[0])));
        }
        if ((jmxzdmhxmmc = (JSONObject)data.get("jmxzdmhxmmc")) != null && !(exist = TaxsoureceImportServiceHelper.isExistDeduction((String)jmxzdmhxmmc.getString("number")))) {
            importlogs.add(new ImportLogger.ImportLog(String.format(ResManager.loadKDString((String)"\u201c\u51cf\u514d\u6027\u8d28\u4ee3\u7801\u548c\u9879\u76ee\u540d\u79f0\u201d\u4e0b\u201c\u51cf\u514d\u6027\u8d28\u4ee3\u7801=%s\u201d\u5f15\u5165\u4e0d\u6210\u529f\u3002\u53ef\u80fd\u7684\u539f\u56e0\u662f\uff1a1\u3001\u51cf\u514d\u6027\u8d28\u4ee3\u7801\u4e0d\u6b63\u786e\uff1b2\u3001\u4e0d\u7b26\u5408\u57fa\u7840\u8d44\u6599\u5b57\u6bb5\u67e5\u8be2\u6761\u4ef6\u3002", (String)"NewAirWaterPollutionImportPlugin_67", (String)"taxc-tdm-formplugin", (Object[])new Object[0]), jmxzdmhxmmc.getString("number"))));
        }
        if ("1".equals(templatefrom)) {
            if (1215009051147361281L != tdmPollutionBasedata.getLong("entryentity.wrwpfljsff") && 1215009051147361282L != tdmPollutionBasedata.getLong("entryentity.wrwpfljsff")) {
                importlogs.add(new ImportLogger.ImportLog(ResManager.loadKDString((String)"\u5f53\u524d\u6392\u6c61\u53e3\u6570\u636e\u7684\u6c61\u67d3\u7269\u6392\u653e\u91cf\u8ba1\u7b97\u65b9\u6cd5\u4e0d\u662f\u76d1\u6d4b\u8ba1\u7b97\u6cd5\uff0c\u8bf7\u66f4\u6362\u5f15\u5165\u6a21\u677f\u6216\u524d\u5f80\u3010\u6392\u6c61\u53e3\u57fa\u7840\u4fe1\u606f\u3011\u4e2d\u4fee\u6539\u3002", (String)"NewAirWaterPollutionImportPlugin_27", (String)"taxc-tdm-formplugin", (Object[])new Object[0])));
            }
        } else if ("2".equals(templatefrom)) {
            if (1215009051147361283L != tdmPollutionBasedata.getLong("entryentity.wrwpfljsff")) {
                importlogs.add(new ImportLogger.ImportLog(ResManager.loadKDString((String)"\u5f53\u524d\u6392\u6c61\u53e3\u6570\u636e\u7684\u6c61\u67d3\u7269\u6392\u653e\u91cf\u8ba1\u7b97\u65b9\u6cd5\u4e0d\u662f\u4ea7\u6392\u6c61\u7cfb\u6570\u6cd5\uff0c\u8bf7\u66f4\u6362\u5f15\u5165\u6a21\u677f\u6216\u524d\u5f80\u3010\u6392\u6c61\u53e3\u57fa\u7840\u4fe1\u606f\u3011\u4e2d\u4fee\u6539\u3002", (String)"NewAirWaterPollutionImportPlugin_29", (String)"taxc-tdm-formplugin", (Object[])new Object[0])));
            }
            if (!(data.get("cwxs") != null && data.get("pwxs") == null || data.get("pwxs") != null && data.get("cwxs") == null)) {
                importlogs.add(new ImportLogger.ImportLog(ResManager.loadKDString((String)"\u201c\u4ea7\u6c61\u7cfb\u6570\u201d\u3001\u201c\u6392\u6c61\u7cfb\u6570\u201d\u4e8c\u8005\u53ea\u80fd\u6709\u4e00\u4e2a\u5b57\u6bb5\u9700\u8981\u5f55\u5165\uff08\u5fc5\u5f55\uff09\u4e0d\u4e3a\u8d1f\u6570\u7684\u6570\u503c\u3002", (String)"NewAirWaterPollutionImportPlugin_30", (String)"taxc-tdm-formplugin", (Object[])new Object[0])));
                return super.importData(data, option, importlogs);
            }
        } else if ("3".equals(templatefrom)) {
            if (1215009051147361284L != tdmPollutionBasedata.getLong("entryentity.wrwpfljsff")) {
                importlogs.add(new ImportLogger.ImportLog(ResManager.loadKDString((String)"\u5f53\u524d\u6392\u6c61\u53e3\u6570\u636e\u7684\u6c61\u67d3\u7269\u6392\u653e\u91cf\u8ba1\u7b97\u65b9\u6cd5\u4e0d\u662f\u7269\u6599\u8861\u7b97\u6cd5\uff0c\u8bf7\u66f4\u6362\u5f15\u5165\u6a21\u677f\u6216\u524d\u5f80\u3010\u6392\u6c61\u53e3\u57fa\u7840\u4fe1\u606f\u3011\u4e2d\u4fee\u6539\u3002", (String)"NewAirWaterPollutionImportPlugin_31", (String)"taxc-tdm-formplugin", (Object[])new Object[0])));
            }
        } else if ("4".equals(templatefrom)) {
            if (1215009051147361284L == tdmPollutionBasedata.getLong("entryentity.wrwpfljsff") && jmxzdmhxmmc != null) {
                importlogs.add(new ImportLogger.ImportLog(ResManager.loadKDString((String)"\u5f53\u524d\u7a0e\u6e90\u7684\u6c61\u67d3\u7269\u6392\u653e\u91cf\u8ba1\u7b97\u65b9\u6cd5\u4e3a\u7269\u6599\u8861\u7b97\u6cd5\uff0c\u4e0d\u80fd\u4eab\u53d7\u51cf\u514d\u653f\u7b56\u4f18\u60e0\u3002", (String)"NewAirWaterPollutionImportPlugin_32", (String)"taxc-tdm-formplugin", (Object[])new Object[0])));
            }
            if (1215009051147361285L == tdmPollutionBasedata.getLong("entryentity.wrwpfljsff")) {
                importlogs.add(new ImportLogger.ImportLog(ResManager.loadKDString((String)"\u5f53\u524d\u6392\u6c61\u53e3\u6570\u636e\u7684\u6c61\u67d3\u7269\u6392\u653e\u91cf\u8ba1\u7b97\u65b9\u6cd5\u4e0d\u80fd\u662f\u62bd\u6837\u6d4b\u7b97\uff0c\u8bf7\u66f4\u6362\u5f15\u5165\u6a21\u677f\u6216\u524d\u5f80\u3010\u6392\u6c61\u53e3\u57fa\u7840\u4fe1\u606f\u3011\u4e2d\u4fee\u6539\u3002", (String)"NewAirWaterPollutionImportPlugin_44", (String)"taxc-tdm-formplugin", (Object[])new Object[0])));
            }
        }
        if (!"1".equals(templatefrom) && jmxzdmhxmmc != null && ("16064006".equals(jmxzdmhxmmc.get((Object)"number")) || "16064007".equals(jmxzdmhxmmc.get((Object)"number")))) {
            importlogs.add(new ImportLogger.ImportLog(ResManager.loadKDString((String)"\u8be5\u51cf\u514d\u653f\u7b56\u4ec5\u9002\u7528\u4e8e\u81ea\u52a8\u76d1\u6d4b\u6216\u76d1\u6d4b\u673a\u6784\u76d1\u6d4b\u7684\u6c61\u67d3\u7269\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"NewAirWaterPollutionImportPlugin_33", (String)"taxc-tdm-formplugin", (Object[])new Object[0])));
        }
        if (jmxzdmhxmmc != null && "16064003".equals(jmxzdmhxmmc.get((Object)"number")) && orgObject != null && !NewAirWaterPollutionImportPlugin.isCxwsjzclcsOrshljjzclcs(orgObject.getLong("orgid.id"))) {
            importlogs.add(new ImportLogger.ImportLog(ResManager.loadKDString((String)"\u8bf7\u786e\u8ba4\u5f53\u524d\u7a0e\u52a1\u7ec4\u7ec7\u662f\u5426\u4e3a\u57ce\u4e61\u6c61\u6c34\u96c6\u4e2d\u5904\u7406\u573a\u6240\u6216\u751f\u6d3b\u5783\u573e\u96c6\u4e2d\u5904\u7406\u573a\u6240\uff0c\u8bf7\u786e\u8ba4\u7a0e\u79cd\u5361\u7247\u4fe1\u606f\u3002", (String)"NewAirWaterPollutionImportPlugin_34", (String)"taxc-tdm-formplugin", (Object[])new Object[0])));
        }
        QFilter[] qFilters = new QFilter[1];
        if (wrwzszm == null || StringUtils.isEmpty((CharSequence)wrwzszm.getString("number")) || wrwzszmObject == null) {
            if (wrwmcObject != null) {
                qFilters[0] = new QFilter("entry_detail.id", "in", (Object)wrwmcObject.getLong("id"));
            }
        } else {
            qFilters[0] = new QFilter("entry_detail.id", "in", (Object)wrwzszmObject.getLong("id"));
        }
        if ((tpoHbsBizdef = QueryServiceHelper.queryOne((String)"tpo_hbs_bizdef", (String)"entry_detail.value", (QFilter[])qFilters)) != null && tpoHbsBizdef.getBigDecimal("entry_detail.value") != null && BigDecimal.ZERO.compareTo(tpoHbsBizdef.getBigDecimal("entry_detail.value")) < 0) {
            data.put("wrwdlz", tpoHbsBizdef.getBigDecimal("entry_detail.value").setScale(10, 4).toString());
        }
        QFilter taxPeriodFilter = new QFilter("month", "=", (Object)DateUtils.getFirstDateOfMonth((Date)DateUtils.stringToDate2((String)month)));
        QFilter taxNumberFilter = new QFilter("number", "=", (Object)number);
        QFilter wrwmcnameFilter = new QFilter("wrwmc", "=", (Object)wrwmcObject.getLong("id"));
        QFilter wrwlb2Filter = new QFilter("wrwlb", "=", tdmPollutionBasedata.get("entryentity.wrwlb"));
        QFilter swrwzlFilter = new QFilter("swrzl", "=", tdmPollutionBasedata.get("entryentity.swrwzl"));
        if (!Objects.equals("override", option.get("importtype")) && QueryServiceHelper.exists((String)TDM_POLLUTION_AIR_WATER, (QFilter[])new QFilter[]{orgidFilter, taxPeriodFilter, taxNumberFilter, wrwmcnameFilter, wrwlb2Filter, swrwzlFilter})) {
            importlogs.add(new ImportLogger.ImportLog(String.format(ResManager.loadKDString((String)"%s\u5df2\u5b58\u5728\u5f53\u524d\u7a0e\u6e90\u6570\u636e\uff0c\u8bf7\u52ff\u91cd\u590d\u5f15\u5165\u3002", (String)"NewAirWaterPollutionImportPlugin_35", (String)"taxc-tdm-formplugin", (Object[])new Object[0]), month.substring(0, 7))));
        }
        if ("2".equals(templatefrom)) {
            BigDecimal cpwxs;
            String wrwdw = (String)data.get("wrwdw");
            BigDecimal jsjc = (BigDecimal)data.get("jsjc");
            if (data.get("cwxs") == null) {
                cpwxs = new BigDecimal((String)data.get("pwxs")).setScale(8, 4);
                data.put("syxs", "pwxs");
            } else {
                cpwxs = new BigDecimal((String)data.get("cwxs")).setScale(8, 4);
                data.put("syxs", "cwxs");
            }
            BigDecimal hsz = "ton".equals(wrwdw) ? BigDecimal.valueOf(1000L) : ("kg".equals(wrwdw) ? BigDecimal.ONE : ("g".equals(wrwdw) ? BigDecimal.valueOf(0.001) : BigDecimal.valueOf(1.0E-6)));
            data.put("wrwpfl", jsjc.multiply(cpwxs).multiply(hsz).setScale(9, 4).toString());
        }
        String bzndz = (String)data.get("bzndz");
        BigDecimal bzndzNumber = BigDecimal.ZERO;
        BigDecimal dwseNumber = new BigDecimal(dwse).setScale(6, 4);
        if ("4".equals(templatefrom)) {
            String emissions2 = (String)data.get("emissions");
            BigDecimal emissionsNumber = new BigDecimal(emissions2).setScale(6, 4);
            data.put("emissions", emissionsNumber);
            if ("4020307".equals(wrwmcNumber)) {
                BigDecimal sdcbbsNumber = new BigDecimal((String)data.get("sdcbbs")).setScale(8, 4);
                data.put("sdcbbs", sdcbbsNumber);
                BigDecimal wrwpfl4 = emissionsNumber.multiply(sdcbbsNumber).setScale(9, 4);
                data.put("wrwpfl", wrwpfl4.toString());
            } else {
                data.put("wrwpfl", emissionsNumber.toString());
            }
        }
        if (importlogs.size() > 0) {
            return super.importData(data, option, importlogs);
        }
        BigDecimal jmbl = BigDecimal.ZERO;
        if ("1".equals(templatefrom)) {
            String emissions3 = (String)data.get("emissions");
            String scndz = (String)data.get("scndz");
            String yjndz = (String)data.get("yjndz");
            String zgndz = (String)data.get("zgndz");
            BigDecimal emissionsNumber = new BigDecimal(emissions3).setScale(6, 4);
            data.put("emissions", emissionsNumber);
            BigDecimal scndzNumber = new BigDecimal(scndz).setScale(8, 4);
            data.put("scndz", scndzNumber);
            BigDecimal yjndzNumber = new BigDecimal(yjndz).setScale(8, 4);
            data.put("yjndz", yjndzNumber);
            BigDecimal zgndzNumber = new BigDecimal(zgndz).setScale(8, 4);
            data.put("zgndz", zgndzNumber);
            if (!StringUtils.isEmpty((CharSequence)bzndz)) {
                bzndzNumber = new BigDecimal(bzndz).setScale(8, 4);
            }
            if (jmxzdmhxmmc != null) {
                String jmxzdmhxmmcNumber = jmxzdmhxmmc.getString("number");
                if ("16064006".equals(jmxzdmhxmmcNumber)) {
                    if (bzndzNumber.compareTo(zgndzNumber) < 0 || yjndzNumber.compareTo(bzndzNumber.multiply(BigDecimal.valueOf(0.5))) < 0 || yjndzNumber.compareTo(bzndzNumber.multiply(BigDecimal.valueOf(0.7))) >= 0) {
                        importlogs.add(new ImportLogger.ImportLog(ResManager.loadKDString((String)"\u5f53\u524d\u6392\u653e\u6570\u636e\u4e0d\u6ee1\u8db3\u51cf\u514d\u7a0e\u653f\u7b56\u6761\u4ef6\uff0c\u8bf7\u786e\u8ba4\u5df2\u5f55\u5165\u7684\u4fe1\u606f\u3002", (String)"NewAirWaterPollutionImportPlugin_42", (String)"taxc-tdm-formplugin", (Object[])new Object[0])));
                        return super.importData(data, option, importlogs);
                    }
                    jmbl = BigDecimal.valueOf(0.25);
                } else if ("16064007".equals(jmxzdmhxmmcNumber)) {
                    if (bzndzNumber.compareTo(zgndzNumber) < 0 || yjndzNumber.compareTo(bzndzNumber.multiply(BigDecimal.valueOf(0.5))) >= 0) {
                        importlogs.add(new ImportLogger.ImportLog(ResManager.loadKDString((String)"\u5f53\u524d\u6392\u653e\u6570\u636e\u4e0d\u6ee1\u8db3\u51cf\u514d\u7a0e\u653f\u7b56\u6761\u4ef6\uff0c\u8bf7\u786e\u8ba4\u5df2\u5f55\u5165\u7684\u4fe1\u606f\u3002", (String)"NewAirWaterPollutionImportPlugin_42", (String)"taxc-tdm-formplugin", (Object[])new Object[0])));
                        return super.importData(data, option, importlogs);
                    }
                    jmbl = BigDecimal.valueOf(0.5);
                }
            }
            if (data.get("testreport") != null && ((Boolean)data.get("testreport")).booleanValue() && BigDecimal.ZERO.compareTo(zgndzNumber) < 0 && BigDecimal.ZERO.compareTo(bzndzNumber) < 0 && BigDecimal.ZERO.compareTo(yjndzNumber) < 0) {
                HashMap<String, String> jmxzdmhxmmcAdd = new HashMap<String, String>();
                jmxzdmhxmmcAdd.put("importprop", "number");
                if (bzndzNumber.compareTo(zgndzNumber) >= 0 && yjndzNumber.compareTo(bzndzNumber.multiply(BigDecimal.valueOf(0.5))) >= 0 && yjndzNumber.compareTo(bzndzNumber.multiply(BigDecimal.valueOf(0.7))) < 0) {
                    jmxzdmhxmmcAdd.put("number", "16064006");
                    data.put("jmxzdmhxmmc", jmxzdmhxmmcAdd);
                    jmbl = BigDecimal.valueOf(0.25);
                }
                if (bzndzNumber.compareTo(zgndzNumber) >= 0 && yjndzNumber.compareTo(bzndzNumber.multiply(BigDecimal.valueOf(0.5))) < 0) {
                    jmxzdmhxmmcAdd.put("number", "16064007");
                    data.put("jmxzdmhxmmc", jmxzdmhxmmcAdd);
                    jmbl = BigDecimal.valueOf(0.5);
                }
            }
            data.put("wrwpfl", new BigDecimal(wrwpfl).setScale(9, 4).toString());
        }
        if ("5".equals(templatefrom)) {
            data.put("wrwpfl", new BigDecimal((String)data.get("tzl")).multiply(new BigDecimal((String)data.get("qcpwxs"))).setScale(9, 4).toString());
        }
        if (jmxzdmhxmmc != null) {
            String jmxzdmhxmmcNumber = jmxzdmhxmmc.getString("number");
            if (StringUtils.isNotEmpty((CharSequence)jmxzdmhxmmcNumber) && !"16064006".equals(jmxzdmhxmmcNumber) && !"16064007".equals(jmxzdmhxmmcNumber)) {
                jmbl = BigDecimal.ONE;
            }
            if ("16064004".equals(jmxzdmhxmmcNumber)) {
                data.remove("jmxzdmhxmmc");
                jmbl = BigDecimal.ZERO;
            }
        }
        if ("6".equals(templatefrom)) {
            QFilter wrwzszmFilter;
            boolean existsWrwzszm;
            BigDecimal constructionarea = data.get("constructionarea") == null ? BigDecimal.ZERO : new BigDecimal((String)data.get("constructionarea"));
            BigDecimal characteristiccoefficien = data.get("characteristiccoefficien") == null ? BigDecimal.ZERO : new BigDecimal((String)data.get("characteristiccoefficien"));
            data.put("wrwpfl", constructionarea.multiply(characteristiccoefficien).toString());
            if (wrwzszmObject != null && !(existsWrwzszm = QueryServiceHelper.exists((String)"tcret_pollution_basedata", (QFilter[])new QFilter[]{orgidFilter, wrwmcFilter, numberFilter, wrwlbFilter, wrwzszmFilter = new QFilter("entryentity.zszm", "=", wrwzszmObject.get("id"))}))) {
                importlogs.add(new ImportLogger.ImportLog(ResManager.loadKDString((String)"\u7a0e\u6e90\u7f16\u53f7\u4e0e\u5f81\u6536\u5b50\u76ee\u4e0d\u5339\u914d\u3002", (String)"NewAirWaterPollutionImportPlugin_68", (String)"taxc-tdm-formplugin", (Object[])new Object[0])));
                return super.importData(data, option, importlogs);
            }
        }
        data.put("month", DateUtils.format((Date)DateUtils.getFirstDateOfMonth((Date)DateUtils.stringToDate2((String)month))));
        data.put("monthend", DateUtils.format((Date)DateUtils.getLastDateOfMonth1((Date)DateUtils.stringToDate2((String)month))));
        HashMap<String, Object> number1 = new HashMap<String, Object>();
        number1.put("importprop", "id");
        number1.put("id", tdmPollutionBasedata.get("id"));
        data.put("number1", number1);
        data.put("name", tdmPollutionBasedata.get("name"));
        HashMap<String, Object> pfksszgswjg = new HashMap<String, Object>();
        pfksszgswjg.put("importprop", "id");
        pfksszgswjg.put("id", tdmPollutionBasedata.get("pfksszgswjg"));
        data.put("pfksszgswjg", pfksszgswjg);
        data.put("pfknum", tdmPollutionBasedata.get("pfknum"));
        data.put("wrwname", wrwname);
        HashMap<String, Object> wrwpfljsff = new HashMap<String, Object>();
        wrwpfljsff.put("importprop", "id");
        wrwpfljsff.put("id", tdmPollutionBasedata.get("entryentity.wrwpfljsff"));
        data.put("wrwpfljsff", wrwpfljsff);
        data.put("wrwdlz", new BigDecimal((String)data.get("wrwdlz")).setScale(10, 4));
        BigDecimal wrwdls = BigDecimal.ZERO;
        if (BigDecimal.ZERO.compareTo((BigDecimal)data.get("wrwdlz")) != 0) {
            wrwdls = new BigDecimal((String)data.get("wrwpfl")).divide((BigDecimal)data.get("wrwdlz"), 6, 4);
        }
        data.put("wrwdls", wrwdls);
        dwseNumber = dwseNumber.setScale(6, 4);
        data.put("dwse", dwseNumber);
        BigDecimal ynse = wrwdls.multiply(dwseNumber).setScale(2, 4);
        data.put("ynse", ynse);
        data.put("jmbl", jmbl);
        BigDecimal jmse = ynse.multiply(jmbl).setScale(2, 4);
        data.put("jmse", jmse);
        if ("1".equals(templatefrom) && !((Boolean)data.get("testreport")).booleanValue()) {
            data.put("jmxzdmhxmmc", null);
            data.put("jmbl", BigDecimal.ZERO);
            data.put("jmse", BigDecimal.ZERO);
        }
        BigDecimal bqyjse = BigDecimal.ZERO;
        if (data.get("bqyjse") != null) {
            bqyjse = new BigDecimal((String)data.get("bqyjse")).setScale(2, 4);
        }
        data.put("bqyjse", bqyjse);
        data.put("bqybtse", ynse.subtract(jmse).subtract(bqyjse).setScale(2, 4));
        data.put("sbbbillno", ResManager.loadKDString((String)"\u672a\u751f\u6210\u7533\u62a5\u8868", (String)"NewAirWaterPollutionImportPlugin_66", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
        data.put("datasource", "2");
        data.put("enable", "1");
        data.put("billno", this.getBillNo());
        return super.importData(data, option, importlogs);
    }

    private String getBillNo() {
        DynamicObject object = BusinessDataServiceHelper.newDynamicObject((String)TDM_POLLUTION_AIR_WATER);
        ICodeRuleService codeRuleService = (ICodeRuleService)ServiceFactory.getService(ICodeRuleService.class);
        return codeRuleService.getNumber(TDM_POLLUTION_AIR_WATER, object, null);
    }

    private static boolean isCxwsjzclcsOrshljjzclcs(Long orgId) {
        TaxResult taxResult = TaxcMainDataServiceHelper.queryTaxcMainHjbhsByOrgId(Collections.singletonList(orgId));
        if (!taxResult.isSuccess() || EmptyCheckUtils.isEmpty((Object)taxResult.getData())) {
            return false;
        }
        DynamicObject taxMain = (DynamicObject)((List)taxResult.getData()).get(0);
        if (EmptyCheckUtils.isEmpty((Object)taxMain.getDynamicObjectCollection("hjbhsentity"))) {
            return false;
        }
        DynamicObject hjbhsentity = (DynamicObject)taxMain.getDynamicObjectCollection("hjbhsentity").get(0);
        return hjbhsentity.getBoolean("hjbhs_cxwsjzclcs") || hjbhsentity.getBoolean("hjbhs_shljjzclcs");
    }

    static {
        templatefromMap.put("1", Arrays.asList("201", "202"));
        templatefromMap.put("2", Collections.singletonList("203"));
        templatefromMap.put("3", Collections.singletonList("204"));
    }
}

