/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tdm.formplugin.pollution;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.column.AbstractColumnDesc;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.filter.SchemeFilterColumn;
import kd.bos.form.IFormView;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.permission.api.HasPermOrgResult;
import kd.taxc.tdm.common.helper.OrgCheckServiceHelper;
import kd.taxc.tdm.common.util.PermissionUtils;
import kd.taxc.tdm.common.util.PollutionBaseDataUtils;
import kd.taxc.tdm.formplugin.utils.TreeUtils;

public class PollutionBaseDataBillListPlugin
extends AbstractListPlugin {
    private static final String TDM_POLLUTION_BASE_BILL = "tdm_pollution_basedata";

    public void packageData(PackageDataEvent e) {
        DynamicObject data = e.getRowData();
        AbstractColumnDesc columnDesc = (AbstractColumnDesc)e.getSource();
        String name = data.getString("swrwzl.projectname");
        if ("swrwzl.projectname".equals(columnDesc.getKey()) && StringUtils.isEmpty((CharSequence)name)) {
            e.setFormatValue((Object)"-");
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        List filterColumnList = args.getCommonFilterColumns();
        CommonFilterColumn wrwlb = null;
        CommonFilterColumn wrwpfljsff = null;
        for (FilterColumn column : filterColumnList) {
            List comboItems;
            DynamicObjectCollection dynamicObjects;
            if (column.getFieldName().startsWith("org.")) {
                CommonFilterColumn typeColumn = (CommonFilterColumn)column;
                typeColumn.setDefaultValue(this.getDefaultOrgId());
            }
            if (column.getFieldName().startsWith("wrwlb.number")) {
                wrwlb = (CommonFilterColumn)column;
                dynamicObjects = PollutionBaseDataUtils.getHbsEntryLists((String)"WRWZL", (List)Lists.newArrayList((Object[])new String[]{"101", "102", "103", "104"}));
                comboItems = dynamicObjects.stream().map(s -> new ComboItem(new LocaleString(s.getString("entry_detail.projectname")), s.getString("entry_detail.id"))).collect(Collectors.toList());
                wrwlb.setComboItems(comboItems);
            }
            if (!column.getFieldName().equals("wrwpfljsff.number")) continue;
            wrwpfljsff = (CommonFilterColumn)column;
            dynamicObjects = PollutionBaseDataUtils.getHbsEntryLists((String)"WRWPFLJSFF", (List)Lists.newArrayList((Object[])new String[]{"201", "202", "203", "204", "205", "206"}));
            comboItems = dynamicObjects.stream().map(s -> new ComboItem(new LocaleString(s.getString("entry_detail.projectname")), s.getString("entry_detail.id"))).collect(Collectors.toList());
            comboItems.sort(Comparator.comparingInt(this::wrwpfljsffWeight));
            wrwpfljsff.setComboItems(comboItems);
        }
        List schemeColumnList = args.getSchemeFilterColumns();
        for (FilterColumn column : schemeColumnList) {
            if (!column.getFieldName().startsWith("org.")) continue;
            SchemeFilterColumn typeColumn = (SchemeFilterColumn)column;
            typeColumn.setDefaultValue(this.getDefaultOrgId());
        }
    }

    private int wrwpfljsffWeight(ComboItem o1) {
        switch (o1.getCaption().getLocaleValue()) {
            case "\u81ea\u52a8\u76d1\u6d4b": {
                return 0;
            }
            case "\u76d1\u6d4b\u673a\u6784\u76d1\u6d4b": {
                return 1;
            }
            case "\u4ea7\u6392\u6c61\u7cfb\u6570": {
                return 2;
            }
            case "\u62bd\u6837\u6d4b\u7b97": {
                return 3;
            }
            case "\u7269\u6599\u8861\u7b97": {
                return 4;
            }
            case "\u4e0d\u9002\u7528": {
                return 5;
            }
        }
        return 6;
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        super.filterContainerSearchClick(args);
    }

    public void setFilter(SetFilterEvent e) {
    }

    private String getDefaultOrgId() {
        HasPermOrgResult hasPermOrgs = PermissionUtils.getAllPermOrgs((IFormView)this.getView());
        DynamicObjectCollection col = TreeUtils.queryOrgListHasPermission(hasPermOrgs, true);
        Long orgId = OrgCheckServiceHelper.setDefaultOrg((IFormView)this.getView(), (Long)RequestContext.get().getOrgId(), (DynamicObjectCollection)col);
        return orgId != null ? String.valueOf(orgId) : "0";
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        String name = args.getFieldName();
        HashMap newHashMap = Maps.newHashMap();
        if ("wrwlb.id".equals(name)) {
            newHashMap.put("caption", ResManager.loadKDString((String)"\u6c61\u67d3\u7269\u79cd\u7c7b", (String)"PollutionBaseDataBillListPlugin_0", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
            newHashMap.put("number", "101,102,103,104");
            newHashMap.put("enable", "0,1");
            args.setCustomParams((Map)newHashMap);
        }
        if ("wrwpfljsff.id".equals(name)) {
            newHashMap.put("caption", ResManager.loadKDString((String)"\u6c61\u67d3\u7269\u6392\u653e\u91cf\u8ba1\u7b97\u65b9\u6cd5", (String)"PollutionBaseDataBillListPlugin_1", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
            newHashMap.put("number", "201,202,203,204,205,206");
            newHashMap.put("enable", "0,1");
            args.setCustomParams((Map)newHashMap);
        }
    }
}

