/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tdm.formplugin.pollution;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.tree.TreeFilterParameter;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.tdm.common.constant.PollutionBaseDataConstant;
import kd.taxc.tdm.common.helper.OrgCheckServiceHelper;
import kd.taxc.tdm.common.license.ExtendAbstractBillPlugin;
import kd.taxc.tdm.common.util.DateUtils;
import kd.taxc.tdm.common.util.PermissionUtils;
import kd.taxc.tdm.common.util.PollutionBaseDataUtils;
import kd.taxc.tdm.common.util.StringUtil;
import kd.taxc.tdm.formplugin.utils.TreeUtils;

public class PollutionBaseDataBillPlugin
extends ExtendAbstractBillPlugin
implements BeforeF7SelectListener,
PollutionBaseDataConstant {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        pops.forEach(s -> {
            BasedataEdit type = (BasedataEdit)this.getControl((String)s);
            type.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        });
    }

    public void afterBindData(EventObject e) {
        HasPermOrgResult hasPermOrgs = PermissionUtils.getAllPermOrgs((IFormView)this.getView());
        DynamicObjectCollection col = TreeUtils.queryOrgListHasPermission(hasPermOrgs, Boolean.TRUE);
        Object object = this.getModel().getValue("org");
        Long orgid = null;
        if (object != null) {
            orgid = this.isTaxAccount(((DynamicObject)object).getLong("id")) ? Long.valueOf(((DynamicObject)object).getLong("id")) : OrgCheckServiceHelper.setDefaultOrg((IFormView)this.getView(), (Long)RequestContext.get().getOrgId(), (DynamicObjectCollection)col);
        }
        this.getModel().setValue("org", orgid);
        DynamicObject dataEntity = this.getModel().getDataEntity();
        long id = dataEntity.getLong("id");
        if (id == 0L) {
            this.getModel().setValue("scjyszx", (Object)this.getScjyszx(orgid));
            this.getModel().setValue("pfksszgswjg", (Object)this.getPfksszgswjg(orgid));
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String name = evt.getProperty().getName();
        ListShowParameter formShowParameter = (ListShowParameter)evt.getFormShowParameter();
        switch (name) {
            case "wrwlb": {
                this.wrwlbF7(evt, formShowParameter);
                break;
            }
            case "swrwzl": {
                formShowParameter.setCaption(ResManager.loadKDString((String)"\u6c34\u6c61\u67d3\u7269\u79cd\u7c7b", (String)"PollutionBaseDataBillPlugin_0", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
                break;
            }
            case "wrwpfljsff": {
                this.wrwpfljsffF7(formShowParameter);
                break;
            }
            case "wrwmc": {
                this.wrwmcF7(evt, formShowParameter);
                break;
            }
            case "pwxkznum": {
                this.pwxkznumF7(formShowParameter);
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        Object newValue = changeSet[0].getNewValue();
        Object oldValue = changeSet[0].getOldValue();
        switch (name) {
            case "org": {
                this.orgChanged(newValue);
                break;
            }
            case "startdate": 
            case "enddate": {
                this.dateChanged(name, (Date)newValue);
                break;
            }
            case "wrwlb": {
                this.wrwlbChanged(newValue, oldValue);
                break;
            }
            case "wrwmc": {
                this.wrwmcChanged(e, newValue);
                break;
            }
            case "swrwzl": {
                if (newValue == null) break;
                this.swrwzlChanged(newValue, oldValue);
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if ("switchwrwlb".equals(callBackId)) {
            if (MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
                this.clearData();
                this.getModel().setValue("swrwzl", null);
                this.setDefaultValue();
            } else if (MessageBoxResult.Cancel.equals((Object)messageBoxClosedEvent.getResult())) {
                this.getPageCache().put("cancelFlag", "Boolean.TRUE");
                this.getModel().setValue("wrwlb", (Object)messageBoxClosedEvent.getCustomVaule());
                this.getPageCache().put("cancelFlag", "Boolean.FALSE");
            }
        }
        if ("switchswrwzl".equals(callBackId)) {
            if (MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
                this.clearData();
                this.setDefaultValue();
            } else if (MessageBoxResult.Cancel.equals((Object)messageBoxClosedEvent.getResult())) {
                this.getPageCache().put("cancelFlag", "Boolean.TRUE");
                this.getModel().setValue("wrwlb", (Object)messageBoxClosedEvent.getCustomVaule());
                this.getPageCache().put("cancelFlag", "Boolean.FALSE");
            }
        }
    }

    private boolean isTaxAccount(Long orgid) {
        QFilter orgFilter = new QFilter("org", "=", (Object)orgid);
        return QueryServiceHelper.exists((String)"bastax_taxorg", (QFilter[])new QFilter[]{orgFilter});
    }

    private void pwxkznumF7(ListShowParameter formShowParameter) {
        formShowParameter.setCaption(ResManager.loadKDString((String)"\u6392\u6c61\u8bb8\u53ef\u8bc1\u7f16\u53f7", (String)"PollutionBaseDataBillPlugin_1", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
        List qFilters = formShowParameter.getListFilterParameter().getQFilters();
        Object value = this.getModel().getValue("org");
        DynamicObject hbsCard = PollutionBaseDataUtils.getTaxTypeCard((Long)(value != null ? ((DynamicObject)value).getLong("id") : 0L), (String)"hjbhs");
        if (hbsCard == null || !hbsCard.getBoolean("enable")) {
            qFilters.add(new QFilter("id", "=", (Object)0L));
        } else {
            DynamicObjectCollection hbsEntity = PollutionBaseDataUtils.getHbsEntity((Long)(value != null ? ((DynamicObject)value).getLong("id") : 0L));
            if (!CollectionUtils.isEmpty((Collection)hbsEntity)) {
                List ids = hbsEntity.stream().filter(s -> StringUtil.isNotBlank((CharSequence)s.getString("hjbhs_number"))).map(s -> s.getLong("id")).collect(Collectors.toList());
                qFilters.add(new QFilter("id", "in", ids));
            } else {
                qFilters.add(new QFilter("id", "=", (Object)0L));
            }
        }
    }

    private void wrwmcF7(BeforeF7SelectEvent evt, ListShowParameter formShowParameter) {
        Object value = this.getModel().getValue("wrwlb");
        if (value == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6c61\u67d3\u7269\u79cd\u7c7b", (String)"PollutionBaseDataBillPlugin_2", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
            evt.setCancel(Boolean.TRUE.booleanValue());
            return;
        }
        String wrwlbNumber = ((DynamicObject)value).getString("number");
        Object swrwzl = this.getModel().getValue("swrwzl");
        if ("101".equals(wrwlbNumber) && swrwzl == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6c34\u6c61\u67d3\u7269\u79cd\u7c7b\u3002", (String)"PollutionBaseDataBillPlugin_3", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
            evt.setCancel(Boolean.TRUE.booleanValue());
            return;
        }
        formShowParameter.setCaption(ResManager.loadKDString((String)"\u6c61\u67d3\u7269\u540d\u79f0", (String)"PollutionBaseDataBillPlugin_4", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
        ListFilterParameter listFilterParameter = formShowParameter.getListFilterParameter();
        List<QFilter> qFilters = this.appendFilter(listFilterParameter.getQFilters());
        TreeFilterParameter treeFilterParameter = formShowParameter.getTreeFilterParameter();
        treeFilterParameter.setQFilters(qFilters);
        qFilters.add(new QFilter("isleaf", "=", (Object)"1"));
        String swrwzlNum = this.getF7FieldNum("swrwzl");
        if ("303".equals(swrwzlNum) || "304".equals(swrwzlNum)) {
            qFilters.add(new QFilter("number", "not in", (Object)new String[]{"405", "406", "407"}));
        }
    }

    private void wrwpfljsffF7(ListShowParameter formShowParameter) {
        ListFilterParameter listFilterParameter = formShowParameter.getListFilterParameter();
        List qFilters = listFilterParameter.getQFilters();
        String wrwmcNum = this.getF7FieldNum("wrwmc");
        String wrwlbNum = this.getF7FieldNum("wrwlb");
        if ("405".equals(wrwmcNum)) {
            qFilters.add(new QFilter("number", "in", (Object)new String[]{"203"}));
        }
        if ("103".equals(wrwlbNum)) {
            qFilters.add(new QFilter("number", "in", (Object)new String[]{"201", "202"}));
        }
        if ("406".equals(wrwmcNum) || "304".equals(this.getF7FieldNum("swrwzl"))) {
            qFilters.add(new QFilter("number", "in", (Object)new String[]{"205"}));
        }
        qFilters.add(new QFilter("number", "!=", (Object)"206"));
        formShowParameter.setCaption(ResManager.loadKDString((String)"\u6c61\u67d3\u7269\u6392\u653e\u91cf\u8ba1\u7b97\u65b9\u6cd5", (String)"PollutionBaseDataBillPlugin_5", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
    }

    private void wrwlbF7(BeforeF7SelectEvent evt, ListShowParameter formShowParameter) {
        Object org = this.getModel().getValue("org");
        if (org == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7a0e\u52a1\u7ec4\u7ec7\u3002", (String)"PollutionBaseDataBillPlugin_6", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
            evt.setCancel(Boolean.TRUE.booleanValue());
            return;
        }
        formShowParameter.setCaption(ResManager.loadKDString((String)"\u6c61\u67d3\u7269\u79cd\u7c7b", (String)"PollutionBaseDataBillPlugin_7", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
    }

    private void swrwzlChanged(Object newValue, Object oldValue) {
        boolean modifyExistBill;
        String cancelFlag = this.getPageCache().get("cancelFlag");
        boolean bl = modifyExistBill = !"Boolean.TRUE".equals(cancelFlag) && oldValue != null;
        if (modifyExistBill && !newValue.equals(oldValue)) {
            ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener("switchswrwzl", (IFormPlugin)this);
            String msg = ResManager.loadKDString((String)"\u5f53\u524d\u5207\u6362\u6c34\u6c61\u67d3\u7269\u79cd\u7c7b\u4f1a\u6e05\u7a7a\u5df2\u5f55\u5165\u6570\u636e\uff0c\u8bf7\u95ee\u662f\u5426\u5207\u6362\uff1f", (String)"PollutionBaseDataBillPlugin_8", (String)"taxc-tdm-formplugin", (Object[])new Object[0]);
            String old = ((DynamicObject)oldValue).getString("id");
            this.getView().showConfirm(msg, "", MessageBoxOptions.OKCancel, ConfirmTypes.Default, confirmCallBackListener, new HashMap(), old);
        } else {
            this.setDefaultValue();
        }
    }

    private void wrwmcChanged(PropertyChangedArgs e, Object newValue) {
        String wrwmcNumber;
        String string = wrwmcNumber = newValue != null ? ((DynamicObject)newValue).getString("number") : "";
        if ("405".equals(wrwmcNumber)) {
            this.isMustInput(Boolean.TRUE, "cpwxsdwrwmc");
            this.getModel().setValue("wrwpfljsff", (Object)this.getDefaultValue("WRWPFLJSFF", "203"));
        } else {
            this.isMustInput(Boolean.FALSE, "cpwxsdwrwmc");
        }
        if ("406".equals(wrwmcNumber)) {
            this.isMustInput(Boolean.TRUE, "cycsdwrwmc");
            this.getModel().setValue("wrwpfljsff", (Object)this.getDefaultValue("WRWPFLJSFF", "205"));
        } else {
            this.isMustInput(Boolean.FALSE, "cycsdwrwmc");
        }
        this.isMustInput("40403".equals(wrwmcNumber), "zszm");
        this.isMustInput("40404".equals(wrwmcNumber), "qtgtfw");
        if (!"40404".equals(wrwmcNumber)) {
            this.getModel().setValue("qtgtfw", (Object)"");
        }
        if ("407".equals(wrwmcNumber)) {
            Object value = this.getModel().getValue("org");
            if (value != null) {
                String wrwlbNumber;
                Predicate<DynamicObject> predicate = s -> Boolean.TRUE.equals(s.getBoolean("hjbhs_cshygc"));
                Boolean ishaiyang = PollutionBaseDataUtils.validHbsEntityBaseData((Long)((DynamicObject)value).getLong("id"), predicate);
                if (!ishaiyang.booleanValue()) {
                    this.rollbackPropertyChange(e);
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u524d\u5f80\u201c\u57fa\u7840\u8bbe\u7f6e>\u7a0e\u52a1\u7ec4\u7ec7\u7ba1\u7406>\u7eb3\u7a0e\u4e3b\u4f53\u4fe1\u606f\u201d\uff0c\u5728\u7a0e\u79cd\u5361\u7247\u201c\u73af\u5883\u4fdd\u62a4\u7a0e\u201d\u4e2d\u786e\u5b9a\u8be5\u7ec4\u7ec7\u662f\u5426\u4ece\u4e8b\u6d77\u6d0b\u5de5\u7a0b\u3002", (String)"PollutionBaseDataBillPlugin_9", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
                    return;
                }
                Object object = this.getModel().getValue("wrwlb");
                String string2 = wrwlbNumber = object != null ? ((DynamicObject)object).getString("number") : "";
                if (!Lists.newArrayList((Object[])new String[]{"101", "102"}).contains(wrwlbNumber)) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u786e\u8ba4\u5f53\u524d\u9009\u62e9\u7684\u6c61\u67d3\u7269\u79cd\u7c7b\u53ca\u6c61\u67d3\u7269\u540d\u79f0", (String)"PollutionBaseDataBillPlugin_10", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
                    this.rollbackPropertyChange(e);
                    return;
                }
            }
            this.isMustInput(Boolean.TRUE, "hygcpfwrwmc");
        } else {
            this.isMustInput(Boolean.FALSE, "hygcpfwrwmc");
        }
    }

    private void wrwlbChanged(Object newValue, Object oldValue) {
        boolean modifyExistBill;
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        Object value = this.getModel().getValue("wrwlb");
        String number = value != null ? ((DynamicObject)value).getString("number") : "";
        Predicate<DynamicObject> predicate = s -> Arrays.stream(s.getString("hjbhs_pollutanttype").split(",")).collect(Collectors.toList()).contains(number);
        if (!PollutionBaseDataUtils.validHbsEntityBaseData((Long)org.getLong("id"), predicate).booleanValue()) {
            this.getModel().setValue("wrwlb", null);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7a0e\u79cd\u5361\u7247\u4e2d\u672a\u5305\u542b\u5f53\u524d\u9009\u62e9\u7684\u6c61\u67d3\u7269\u7c7b\u522b\u3002", (String)"PollutionBaseDataBillPlugin_11", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
            return;
        }
        String cancelFlag = this.getPageCache().get("cancelFlag");
        boolean bl = modifyExistBill = !"Boolean.TRUE".equals(cancelFlag) && oldValue != null;
        if (modifyExistBill && !newValue.equals(oldValue)) {
            ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener("switchwrwlb", (IFormPlugin)this);
            String msg = ResManager.loadKDString((String)"\u5f53\u524d\u5207\u6362\u6c61\u67d3\u7269\u7c7b\u522b\u4f1a\u6e05\u7a7a\u5df2\u5f55\u5165\u6570\u636e\uff0c\u8bf7\u95ee\u662f\u5426\u5207\u6362\uff1f", (String)"PollutionBaseDataBillPlugin_12", (String)"taxc-tdm-formplugin", (Object[])new Object[0]);
            String old = ((DynamicObject)oldValue).getString("id");
            this.getView().showConfirm(msg, "", MessageBoxOptions.OKCancel, ConfirmTypes.Default, confirmCallBackListener, new HashMap(), old);
        } else {
            this.setDefaultValue();
        }
    }

    private void dateChanged(String name, Date newValue) {
        Date startdate = "startdate".equals(name) ? newValue : (Date)this.getModel().getValue("startdate");
        Date enddate = "enddate".equals(name) ? newValue : (Date)this.getModel().getValue("enddate");
        this.validStartDateOrEndDate(startdate, enddate);
    }

    private void orgChanged(Object newValue) {
        long orgId = newValue != null ? ((DynamicObject)newValue).getLong("id") : 0L;
        this.getModel().setValue("scjyszx", (Object)this.getScjyszx(orgId));
        this.getModel().setValue("pfksszgswjg", (Object)this.getPfksszgswjg(orgId));
    }

    private void isMustInput(Boolean must, String ... inputs) {
        for (String input : inputs) {
            FieldEdit control = (FieldEdit)this.getControl(input);
            control.setMustInput(must.booleanValue());
        }
    }

    private void setDefaultValue() {
        String number = this.getF7FieldNum("wrwlb");
        if ("104".equals(number)) {
            this.getModel().setValue("wrwpfljsff", (Object)this.getDefaultValue("WRWPFLJSFF", "206"));
        }
        if ("103".equals(number)) {
            this.getModel().setValue("wrwmc", (Object)this.getDefaultValue("NOTMATCH", "408"));
        }
        if ("304".equals(this.getF7FieldNum("swrwzl"))) {
            this.getModel().setValue("wrwpfljsff", (Object)this.getDefaultValue("WRWPFLJSFF", "205"));
        }
    }

    private String getF7FieldNum(String field) {
        DynamicObject dynamicObject = (DynamicObject)this.getModel().getValue(field);
        return dynamicObject != null ? dynamicObject.getString("number") : "";
    }

    private Long getDefaultValue(String parentNumebr, String number) {
        DynamicObjectCollection dynamicObjects = PollutionBaseDataUtils.getHbsEntryLists((String)parentNumebr, (List)Lists.newArrayList((Object[])new String[]{number}));
        return !CollectionUtils.isEmpty((Collection)dynamicObjects) ? Long.valueOf(((DynamicObject)dynamicObjects.get(0)).getLong("entry_detail.id")) : null;
    }

    public boolean valid405or406(Object o1, Object o2) {
        String wrwmcNumber = o1 != null ? ((DynamicObject)o1).getString("number") : "";
        String wrwpfljsffNumber = o2 != null ? ((DynamicObject)o2).getString("number") : "";
        Boolean test1 = "405".equals(wrwmcNumber) && !"203".equals(wrwpfljsffNumber);
        Boolean test2 = "406".equals(wrwmcNumber) && !"205".equals(wrwpfljsffNumber);
        return test1 != false || test2 != false;
    }

    private void validStartDateOrEndDate(Date startdate, Date enddate) {
        int dayOfDate2;
        int dayOfDate1;
        int dayOfDate;
        if (startdate != null && (dayOfDate = DateUtils.getDayOfDate((Date)startdate)) != 1) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7a0e\u6b3e\u6240\u5c5e\u671f\u8d77\u5fc5\u987b\u662f\u6708\u521d1\u53f7\u3002", (String)"PollutionBaseDataBillPlugin_13", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
            return;
        }
        if (enddate != null && (dayOfDate1 = DateUtils.getDayOfDate((Date)DateUtils.getLastDateOfMonth((Date)enddate))) != (dayOfDate2 = DateUtils.getDayOfDate((Date)enddate))) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7a0e\u6b3e\u6240\u5c5e\u671f\u6b62\u5fc5\u987b\u662f\u6708\u672b\u6700\u540e1\u5929\u3002", (String)"PollutionBaseDataBillPlugin_14", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
            return;
        }
        if (startdate == null || enddate == null) {
            return;
        }
        if (startdate.after(enddate)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7a0e\u6e90\u6709\u6548\u671f\u6b62\u7684\u65f6\u95f4\u5e94\u665a\u4e8e\u7a0e\u6e90\u6709\u6548\u671f\u8d77\u7684\u65f6\u95f4\u3002", (String)"PollutionBaseDataBillPlugin_15", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
        }
    }

    private List<QFilter> appendFilter(List<QFilter> qFilters) {
        List numbers = PollutionBaseDataUtils.getNumber((String)this.getF7FieldNum("wrwlb"), (String)this.getF7FieldNum("swrwzl"));
        if (!CollectionUtils.isEmpty((Collection)numbers)) {
            QFilter filter = new QFilter("number", "in", (Object)numbers);
            qFilters.add(filter);
        }
        return qFilters;
    }

    private void clearData() {
        this.getModel().setValue("wrwmc", null);
        this.getModel().setValue("wrwpfljsff", null);
        this.getModel().setValue("hygcpfwrwmc", (Object)"");
        this.getModel().setValue("qtgtfw", (Object)"");
        this.getModel().setValue("cpwxsdwrwmc", (Object)"");
        this.getModel().setValue("cycsdwrwmc", (Object)"");
        this.getModel().setValue("zszm", (Object)"");
        this.getModel().setValue("mark", (Object)"");
    }

    private String getScjyszx(Long orgid) {
        DynamicObject taxMain = (DynamicObject)TaxcMainDataServiceHelper.queryTaxcMainByOrgId((Long)orgid).getData();
        return taxMain != null ? taxMain.getString("actualaddress") : null;
    }

    private Long getPfksszgswjg(Long orgid) {
        DynamicObject taxMain = (DynamicObject)TaxcMainDataServiceHelper.queryTaxcMainByOrgId((Long)orgid).getData();
        if (taxMain != null) {
            if (taxMain.getDynamicObject("taxoffice") != null) {
                return taxMain.getDynamicObject("taxoffice").getLong("id");
            }
            return null;
        }
        return null;
    }

    private void rollbackPropertyChange(PropertyChangedArgs args) {
        String name = args.getProperty().getName();
        ChangeData[] changeSet = args.getChangeSet();
        int rowIndex = changeSet[0].getRowIndex();
        Object oldValue = changeSet[0].getOldValue();
        this.getModel().setValue(name, oldValue, rowIndex);
    }
}

