/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tdm.formplugin.pollution;

import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.filter.ControlFilter;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.taxc.bdtaxr.common.tctb.common.util.PermissionUtils;
import kd.taxc.bdtaxr.common.util.OperatorDialogUtils;
import kd.taxc.tdm.common.util.StringUtil;
import org.apache.commons.lang.StringUtils;

public class SolidWasteBillListPlugin
extends AbstractListPlugin {
    private static final String ADD_DIALOG_CLOSE = "add_dialog_close";
    private static final String TDM_SOILD_WASTE_INFO = "tdm_solid_waste_info";
    private static final String SOLID_WASTE_ADD = "tcret_solid_waste_add";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"edittemporary"});
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object org = customParams.get("orgid");
        if (org != null) {
            List filterColumnList = args.getFilterContainerInitEvent().getCommonFilterColumns();
            for (FilterColumn filterColumn : filterColumnList) {
                if (filterColumn.getFieldName().equals("org.id") && filterColumn instanceof CommonFilterColumn) {
                    filterColumn.setDefaultValue(org.toString());
                    continue;
                }
                if (!filterColumn.getFieldName().equals("month")) continue;
                filterColumn.setDefaultValues(new Object[]{customParams.get("skssqq"), customParams.get("skssqz")});
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        if ("batchnew".equals(evt.getItemKey())) {
            Optional<Object> first;
            FormShowParameter param = new FormShowParameter();
            HashMap<String, Object> customParams = new HashMap<String, Object>();
            param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            param.setFormId(SOLID_WASTE_ADD);
            customParams.put("status", "batchnew");
            ControlFilter controlFilter = (ControlFilter)this.getControlFilters().getFilters().get("org.id");
            if (controlFilter != null && (first = controlFilter.getValue().stream().filter(s -> StringUtil.isNotEmpty((CharSequence)s.toString())).findFirst()).isPresent()) {
                customParams.put("orgid", first.get());
            }
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, ADD_DIALOG_CLOSE);
            param.setCloseCallBack(closeCallBack);
            param.setCustomParams(customParams);
            this.getView().showForm(param);
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        if ("edittemporary".equals(evt.getItemKey())) {
            long currUserId = RequestContext.get().getCurrUserId();
            long orgId = RequestContext.get().getOrgId();
            HasPermOrgResult allPermOrgsByUserId = PermissionUtils.getAllPermOrgsByUserId((String)"tcret", (String)TDM_SOILD_WASTE_INFO, (String)"0AQ3YJ2LET+U", (Long)currUserId);
            if (allPermOrgsByUserId != null && !allPermOrgsByUserId.hasAllOrgPerm() && !allPermOrgsByUserId.getHasPermOrgs().contains(orgId)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c\u56fa\u4f53\u5e9f\u7269\u4fe1\u606f\u91c7\u96c6\u8868\u201d\u7684\u7f16\u8f91\u6743\u9650\u3002", (String)"SolidWasteBillListPlugin_0", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            ListShowParameter showParameter = new ListShowParameter();
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.setFormId("bos_listf7");
            showParameter.setBillFormId("tdm_solidwaste_tp");
            StyleCss styleCss = new StyleCss();
            styleCss.setHeight("600");
            styleCss.setWidth("1000");
            showParameter.getOpenStyle().setInlineStyleCss(styleCss);
            this.getView().showForm((FormShowParameter)showParameter);
            String operateName = ResManager.loadKDString((String)"\u7f16\u8f91\u6682\u5b58\u4fe1\u606f", (String)"SolidWasteBillListPlugin_3", (String)"taxc-tdm-formplugin", (Object[])new Object[0]);
            String operateDescription = ResManager.loadKDString((String)"\u6253\u5f00\u56fa\u4f53\u5e9f\u7269\u91c7\u96c6\u6682\u5b58\u4fe1\u606f\u9875\u9762\u6210\u529f\u3002", (String)"SolidWasteBillListPlugin_4", (String)"taxc-tdm-formplugin", (Object[])new Object[0]);
            OperatorDialogUtils.operateDialog((String)"ccxws", (String)TDM_SOILD_WASTE_INFO, (String)operateName, (String)operateDescription);
            evt.setCancel(true);
        } else if ("batchnew".equals(evt.getItemKey())) {
            long currUserId = RequestContext.get().getCurrUserId();
            long orgId = RequestContext.get().getOrgId();
            HasPermOrgResult allPermOrgsByUserId = PermissionUtils.getAllPermOrgsByUserId((String)"tcret", (String)TDM_SOILD_WASTE_INFO, (String)"47156aff000000ac", (Long)currUserId);
            if (allPermOrgsByUserId != null && !allPermOrgsByUserId.hasAllOrgPerm() && allPermOrgsByUserId.getHasPermOrgs() != null && !allPermOrgsByUserId.getHasPermOrgs().contains(orgId)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c\u56fa\u4f53\u5e9f\u7269\u4fe1\u606f\u91c7\u96c6\u8868\u201d\u7684\u201c\u65b0\u589e\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"SolidWasteBillListPlugin_2", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        args.setCancel(true);
        String fieldName = args.getFieldName();
        if ("billno".equals(fieldName)) {
            BillList list = (BillList)args.getHyperLinkClickEvent().getSource();
            ListSelectedRow currentSelectedRowInfo = list.getCurrentSelectedRowInfo();
            Object primaryKeyValue = currentSelectedRowInfo.getPrimaryKeyValue();
            DynamicObject object = BusinessDataServiceHelper.loadSingle((Object)primaryKeyValue, (String)TDM_SOILD_WASTE_INFO);
            HashMap<String, String> customParams = new HashMap<String, String>(32);
            customParams.put("sbbbillstatus", object.getString("sbbbillstatus"));
            BillShowParameter billParam = new BillShowParameter();
            billParam.setFormId(TDM_SOILD_WASTE_INFO);
            billParam.setPkId(primaryKeyValue);
            billParam.setStatus(OperationStatus.EDIT);
            billParam.getOpenStyle().setShowType(ShowType.Modal);
            billParam.setCustomParams(customParams);
            billParam.setCaption(ResManager.loadKDString((String)"\u56fa\u4f53\u5e9f\u7269\u7a0e\u6e90", (String)"SolidWasteBillListPlugin_1", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, ADD_DIALOG_CLOSE);
            billParam.setCloseCallBack(closeCallBack);
            this.getView().showForm((FormShowParameter)billParam);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey;
        super.afterDoOperation(args);
        if ("attach".equals(args.getOperateKey()) && StringUtils.equals((String)"attach", (String)(operateKey = args.getOperateKey()))) {
            BillList list = (BillList)this.getControl("billlistap");
            ListSelectedRow listSelectedRow = list.getCurrentSelectedRowInfo();
            Object primaryKeyValue = listSelectedRow.getPrimaryKeyValue();
            FormShowParameter param = new FormShowParameter();
            HashMap<String, Object> customParams = new HashMap<String, Object>();
            param.getOpenStyle().setShowType(ShowType.Modal);
            param.setFormId("tdm_airwater_attach");
            customParams.put("pkid", primaryKeyValue);
            customParams.put("type", "solidwaste");
            param.setCustomParams(customParams);
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, ADD_DIALOG_CLOSE);
            param.setCloseCallBack(closeCallBack);
            this.getView().showForm(param);
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        if (ADD_DIALOG_CLOSE.equals(evt.getActionId())) {
            BillList billList = (BillList)this.getView().getControl("billlistap");
            billList.refresh();
        }
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        args.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public DynamicObjectCollection getData(int start, int limit) {
                DynamicObjectCollection data = super.getData(start, limit);
                for (DynamicObject taxItem : data) {
                    DynamicObjectCollection attachmentFields = taxItem.getDynamicObjectCollection("attachmentfield");
                    if (attachmentFields.size() > 0) {
                        taxItem.set("maindataid", (Object)attachmentFields.size());
                        continue;
                    }
                    taxItem.set("maindataid", (Object)0);
                }
                return data;
            }
        });
    }
}

