/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tdm.formplugin.pollution;

import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.EventObject;
import java.util.Map;
import java.util.Objects;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.taxc.bdtaxr.common.tctb.common.util.OrgUtils;
import kd.taxc.tdm.common.util.StringUtil;

public class SolidWasteBillPlugin
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    private static final String[] EXCLUDE_FORMS = new String[]{"tcret_solid_waste_add"};

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit base = (BasedataEdit)this.getView().getControl("taxorg");
        if (Objects.nonNull(base)) {
            base.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void afterBindData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object sbbbillstatus = customParams.get("sbbbillstatus");
        Boolean isEdit = sbbbillstatus == null || StringUtil.isBlank((CharSequence)sbbbillstatus.toString()) || sbbbillstatus.equals("A");
        this.getView().setEnable(isEdit, new String[]{"ccqk", "czqk", "zhlyqk", "bydtfwcsl", "bygtfwccl", "bygtfwczl", "bygtfwzhlyl", "taxdeduction", "bqyjse"});
    }

    public void propertyChanged(PropertyChangedArgs e) {
        boolean testreport;
        String name = e.getProperty().getName();
        if (Sets.newHashSet((Object[])new String[]{"bydtfwcsl", "bygtfwccl", "bygtfwczl"}).contains(name)) {
            BigDecimal bydtfwcsl = (BigDecimal)this.getModel().getValue("bydtfwcsl");
            BigDecimal bygtfwccl = (BigDecimal)this.getModel().getValue("bygtfwccl");
            BigDecimal bygtfwczl = (BigDecimal)this.getModel().getValue("bygtfwczl");
            this.getModel().setValue("wrwpfl", (Object)bydtfwcsl.subtract(bygtfwccl).subtract(bygtfwczl));
        }
        if (Sets.newHashSet((Object[])new String[]{"wrwpfl", "dwse"}).contains(name)) {
            BigDecimal wrwpfl = (BigDecimal)this.getModel().getValue("wrwpfl");
            BigDecimal dwse = (BigDecimal)this.getModel().getValue("dwse");
            this.getModel().setValue("ynse", (Object)wrwpfl.multiply(dwse));
        }
        if (testreport = ((Boolean)this.getModel().getValue("testreport")).booleanValue()) {
            if ("bygtfwzhlyl".equals(name)) {
                BigDecimal bygtfwzhlyl = (BigDecimal)this.getModel().getValue("bygtfwzhlyl");
                this.getModel().setItemValueByNumber("taxdeduction", bygtfwzhlyl.compareTo(BigDecimal.ZERO) > 0 ? "16064004" : null);
            }
        } else {
            this.getModel().setValue("taxdeduction", null);
        }
        if (Sets.newHashSet((Object[])new String[]{"taxdeduction", "bygtfwzhlyl", "dwse", "testreport"}).contains(name)) {
            Object value = this.getModel().getValue("taxdeduction");
            if (value == null) {
                this.getModel().setValue("jmse", (Object)BigDecimal.ZERO);
            } else {
                BigDecimal bygtfwzhlyl = (BigDecimal)this.getModel().getValue("bygtfwzhlyl");
                BigDecimal dwse = (BigDecimal)this.getModel().getValue("dwse");
                this.getModel().setValue("jmse", (Object)bygtfwzhlyl.multiply(dwse));
            }
        }
        if (Sets.newHashSet((Object[])new String[]{"ynse", "jmse", "bqyjse"}).contains(name)) {
            BigDecimal ynse = (BigDecimal)this.getModel().getValue("ynse");
            BigDecimal jmse = (BigDecimal)this.getModel().getValue("jmse");
            BigDecimal bqyjse = (BigDecimal)this.getModel().getValue("bqyjse");
            this.getModel().setValue("bqybtse", (Object)ynse.subtract(jmse).subtract(bqyjse));
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        OrgUtils.addFilterByConditionBeforeF7Select((Object)evt, (IFormView)this.getView(), (String[])EXCLUDE_FORMS, null, null);
    }
}

