/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tdm.formplugin.pollution;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.temporal.TemporalAdjusters;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.coderule.api.ICodeRuleService;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.exception.KDBizException;
import kd.bos.form.plugin.impt.BatchImportPlugin;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.form.plugin.impt.ImportEntityMapping;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.tdm.common.helper.LicenseCheckServiceHelper;
import kd.taxc.tdm.common.util.DateUtils;
import kd.taxc.tdm.common.util.PollutionBaseDataUtils;
import kd.taxc.tdm.common.util.SolidWasteValidatorUtils;
import kd.taxc.tdm.common.util.StringUtil;

public class SolidWasteImportPlugin
extends BatchImportPlugin {
    private static final String TDM_SOLID_WASTE_INFO = "tdm_solid_waste_info";
    private static final String TCRET_POLLUTION_BASEDATA = "tcret_pollution_basedata";
    private static final Map<String, DynamicObject> bizDef = SolidWasteImportPlugin.getBizDef("GTFWWRMC");
    private static final String tabLine = "\n";
    private StringBuilder errors = null;
    private Map<String, ImportBillData> saves = new HashMap<String, ImportBillData>();

    protected boolean isForceBatch() {
        return true;
    }

    protected ApiResult save(List<ImportBillData> rowdatas, ImportLogger logger) {
        for (ImportBillData importBillData : rowdatas) {
            this.errors = new StringBuilder();
            int index = importBillData.getStartIndex();
            JSONObject rowData = importBillData.getData();
            String orgNumber = rowData.getJSONObject("org").getString("number");
            DynamicObject dynamicObject = SolidWasteImportPlugin.loadTaxMain(orgNumber);
            if (dynamicObject != null) {
                boolean notAuthorize = LicenseCheckServiceHelper.check((Object)dynamicObject.getLong("orgid"), null, (String)"tcret");
                if (notAuthorize) {
                    SolidWasteImportPlugin.sendFailMsg(this.errors, String.format(ResManager.loadKDString((String)"%s\u7ec4\u7ec7\u672a\u6fc0\u6d3b\u7a0e\u52a1\u4e91\u8bb8\u53ef", (String)"SolidWasteImportPlugin_0", (String)"taxc-tdm-formplugin", (Object[])new Object[0]), orgNumber));
                }
                if (!TaxcMainDataServiceHelper.isTaxcMainByOrgId((Long)dynamicObject.getLong("orgid")).isSuccess()) {
                    SolidWasteImportPlugin.sendFailMsg(this.errors, String.format(ResManager.loadKDString((String)"\u7a0e\u52a1\u7ec4\u7ec7\u672a\u5ba1\u6838\u6216\u4e0d\u53ef\u7528\uff0c\u65e0\u6cd5\u5f15\u5165\u6570\u636e\uff1a\u7f16\u7801%s", (String)"SolidWasteImportPlugin_1", (String)"taxc-tdm-formplugin", (Object[])new Object[0]), orgNumber));
                }
            }
            String number = rowData.getString("number");
            String wrwmcNumber = rowData.getJSONObject("wrwmc").getString("number");
            this.validWrwmcNumber(this.errors, rowData, wrwmcNumber);
            Date month = SolidWasteImportPlugin.parseDate(importBillData, "month");
            SolidWasteImportPlugin.validDate(this.errors, month);
            if (dynamicObject != null) {
                SolidWasteImportPlugin.checkTp(this.errors, dynamicObject, month);
            }
            DynamicObject pollutionBaseData = this.getPollutionBaseData(rowData);
            String key = String.format("%s_%s_%s_%s_%s", orgNumber, number, wrwmcNumber, rowData.getString("wrwname"), DateUtils.format((Date)month));
            if (this.saves.get(key) != null) {
                SolidWasteImportPlugin.sendFailMsg(this.errors, ResManager.loadKDString((String)"\u6a21\u677f\u6570\u636e\u91cd\u590d\uff0c\u8bf7\u91cd\u65b0\u68c0\u67e5\u3002", (String)"SolidWasteImportPlugin_2", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
            }
            if (pollutionBaseData == null) {
                SolidWasteImportPlugin.sendFailMsg(this.errors, ResManager.loadKDString((String)"\u5f53\u524d\u6392\u6c61\u53e3\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u5148\u5728\u3010\u6392\u6c61\u53e3\u57fa\u7840\u4fe1\u606f\u3011\u4e2d\u7ef4\u62a4\u6392\u6c61\u53e3\u6570\u636e\uff0c\u518d\u7ef4\u62a4\u56fa\u4f53\u5e9f\u7269\u7684\u7a0e\u6e90\u6570\u636e\u3002", (String)"SolidWasteImportPlugin_3", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
            } else {
                if (!pollutionBaseData.getBoolean("enable")) {
                    SolidWasteImportPlugin.sendFailMsg(this.errors, ResManager.loadKDString((String)"\u5f53\u524d\u6392\u6c61\u53e3\u6570\u636e\u7684\u6570\u636e\u72b6\u6001\u4e0d\u53ef\u7528\uff0c\u8bf7\u524d\u5f80\u3010\u6392\u6c61\u53e3\u57fa\u7840\u4fe1\u606f\u3011\u4e2d\u4fee\u6539\u3002", (String)"SolidWasteImportPlugin_4", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
                }
                if (!"104".equals(pollutionBaseData.getString("wrwlbNumber"))) {
                    SolidWasteImportPlugin.sendFailMsg(this.errors, ResManager.loadKDString((String)"\u5f53\u524d\u6392\u6c61\u53e3\u6570\u636e\u7684\u6c61\u67d3\u7269\u7c7b\u522b\u4e0d\u662f\u56fa\u4f53\u5e9f\u7269\uff0c\u4e0d\u53ef\u7ef4\u62a4\u56fa\u4f53\u5e9f\u7269\u7684\u6392\u653e\u4fe1\u606f\u3002", (String)"SolidWasteImportPlugin_5", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
                }
                if (this.getDynamicObjects(rowData).booleanValue()) {
                    SolidWasteImportPlugin.sendFailMsg(this.errors, String.format(ResManager.loadKDString((String)"%s\u5df2\u5b58\u5728\u5f53\u524d\u7a0e\u6e90\u6570\u636e\uff0c\u8bf7\u52ff\u91cd\u590d\u5f15\u5165\u3002", (String)"SolidWasteImportPlugin_6", (String)"taxc-tdm-formplugin", (Object[])new Object[0]), DateUtils.format((Date)month, (String)"yyyy-MM")));
                }
                this.validTaxxdeduction(this.errors, rowData.getJSONObject("taxdeduction"));
                SolidWasteImportPlugin.setColumnData(rowData, pollutionBaseData);
                SolidWasteValidatorUtils.saveValid((Object)rowData, (StringBuilder)this.errors);
                if (rowData.getBigDecimal("wrwpfl").compareTo(BigDecimal.ZERO) < 0) {
                    SolidWasteImportPlugin.sendFailMsg(this.errors, ResManager.loadKDString((String)"\u6c61\u67d3\u7269\u6392\u653e\u91cf=\u4ea7\u751f\u91cf-\u8d2e\u5b58\u91cf-\u5904\u7f6e\u91cf\uff0c\u4e0d\u53ef\u4e3a\u8d1f\u6570\u3002", (String)"SolidWasteImportPlugin_7", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
                }
                Date startDate = pollutionBaseData.getDate("startdate");
                Date endDate = pollutionBaseData.getDate("enddate");
                if (month == null || month.after(endDate) || month.before(startDate)) {
                    SolidWasteImportPlugin.sendFailMsg(this.errors, ResManager.loadKDString((String)"\u7a0e\u6b3e\u6240\u5c5e\u6708\u4efd\u4e0e\u7a0e\u6e90\u7f16\u53f7\u7684\u6709\u6548\u671f\u4e0d\u5339\u914d\uff0c\u8bf7\u68c0\u67e5\u6392\u6c61\u53e3\u57fa\u7840\u4fe1\u606f\u8d44\u6599\u3002", (String)"SolidWasteImportPlugin_8", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
                }
            }
            if (StringUtil.isNotBlank((CharSequence)this.errors)) {
                logger.log(Integer.valueOf(index), this.errors.toString()).fail();
                continue;
            }
            this.saves.put(key, importBillData);
        }
        List datas = this.saves.values().stream().collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(datas)) {
            rowdatas.removeIf(s -> !this.saves.containsValue(s));
            return super.save(this.saves.values().stream().collect(Collectors.toList()), logger);
        }
        return null;
    }

    private void validTaxxdeduction(StringBuilder errors, JSONObject taxdeduction) {
        String taxdeductionNumber;
        if (taxdeduction != null && StringUtil.isNotBlank((CharSequence)(taxdeductionNumber = taxdeduction.getString("number"))) && !"16064004".equals(taxdeductionNumber)) {
            SolidWasteImportPlugin.sendFailMsg(errors, ResManager.loadKDString((String)"\u56fa\u4f53\u5e9f\u7269\u4e0d\u9002\u7528\u8be5\u51cf\u514d\u6027\u8d28\u4ee3\u7801\uff0c\u8bf7\u4fee\u6539\u3002", (String)"SolidWasteImportPlugin_9", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
        }
    }

    private void validWrwmcNumber(StringBuilder errors, JSONObject rowData, String wrwmcNumber) {
        if (StringUtil.isNotBlank((CharSequence)wrwmcNumber)) {
            if (!PollutionBaseDataUtils.getNumber((String)"104", null).contains(wrwmcNumber)) {
                SolidWasteImportPlugin.sendFailMsg(errors, ResManager.loadKDString((String)"\u5f53\u524d\u6c61\u67d3\u7269\u540d\u79f0\u4e0d\u9002\u7528\u672c\u6a21\u677f\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6a21\u677f\u3002", (String)"SolidWasteImportPlugin_10", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
            } else {
                rowData.put("wrwname", (Object)bizDef.get(rowData.getJSONObject("wrwmc").getString("number")).getString("projectname"));
                rowData.put("qtgtfw", (Object)"");
            }
        }
    }

    private static void setColumnData(JSONObject rowData, DynamicObject pollutionBaseData) {
        rowData.put("status", (Object)"A");
        rowData.put("enable", (Object)"1");
        rowData.put("sbbbillno", (Object)ResManager.loadKDString((String)"\u672a\u751f\u6210\u7533\u62a5\u8868", (String)"SolidWasteImportPlugin_11", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
        rowData.put("maindataid", (Object)0L);
        rowData.put("datasource", (Object)"2");
        rowData.put("endmonth", (Object)DateUtils.trunc((Date)DateUtils.getLastDateOfMonth((Date)rowData.getDate("month"))));
        JSONObject pfksszgswjg = new JSONObject();
        pfksszgswjg.put("number", (Object)pollutionBaseData.getString("pfksszgswjgNumber"));
        rowData.put("pfksszgswjg", (Object)pfksszgswjg);
        rowData.put("pfknumber", pollutionBaseData.get("pfknum"));
        rowData.put("pfkname", pollutionBaseData.get("name"));
        JSONObject wrwlb = new JSONObject();
        wrwlb.put("number", pollutionBaseData.get("wrwlbNumber"));
        rowData.put("wrwlb", (Object)wrwlb);
        rowData.put("wrwname", (Object)rowData.getString("wrwname"));
        JSONObject pollutiondata = new JSONObject();
        pollutiondata.put("id", (Object)pollutionBaseData.getLong("id"));
        rowData.put("pollutiondataid", (Object)pollutiondata);
        rowData.put("bydtfwcsl", (Object)SolidWasteImportPlugin.getScale(SolidWasteImportPlugin.parseBigDecimal(rowData, "bydtfwcsl"), 6));
        rowData.put("bygtfwccl", (Object)SolidWasteImportPlugin.getScale(SolidWasteImportPlugin.parseBigDecimal(rowData, "bygtfwccl"), 6));
        rowData.put("bygtfwczl", (Object)SolidWasteImportPlugin.getScale(SolidWasteImportPlugin.parseBigDecimal(rowData, "bygtfwczl"), 6));
        rowData.put("bygtfwzhlyl", (Object)SolidWasteImportPlugin.getScale(SolidWasteImportPlugin.parseBigDecimal(rowData, "bygtfwzhlyl"), 6));
        rowData.put("bqyjse", (Object)SolidWasteImportPlugin.getScale(SolidWasteImportPlugin.parseBigDecimal(rowData, "bqyjse"), 2));
        if (pollutionBaseData.get("entryentity.zszm") == null || pollutionBaseData.getLong("entryentity.zszm") == 0L) {
            rowData.put("dwse", (Object)bizDef.get(rowData.getJSONObject("wrwmc").getString("number")).getBigDecimal("value"));
        } else {
            QFilter filter = new QFilter("number", "=", (Object)pollutionBaseData.getDynamicObject("entryentity.zszm").getString("number"));
            DynamicObjectCollection custConst = QueryServiceHelper.query((String)"tpo_hbs_bizdef", (String)"entry_detail.value as value", (QFilter[])new QFilter[]{filter});
            rowData.put("dwse", (Object)((DynamicObject)custConst.get(0)).getBigDecimal("value"));
        }
        rowData.put("wrwpfl", (Object)SolidWasteImportPlugin.getScale(SolidWasteImportPlugin.getWrwpfl(rowData), 6));
        rowData.put("ynse", (Object)SolidWasteImportPlugin.getScale(SolidWasteImportPlugin.getYnse(rowData), 2));
        rowData.put("jmse", (Object)SolidWasteImportPlugin.getScale(SolidWasteImportPlugin.getJmse(rowData), 2));
        rowData.put("bqybtse", (Object)SolidWasteImportPlugin.getScale(SolidWasteImportPlugin.getBqybtse(rowData), 2));
        rowData.put("billno", (Object)SolidWasteImportPlugin.getBillNo());
    }

    private static BigDecimal getWrwpfl(JSONObject rowData) {
        return SolidWasteImportPlugin.parseBigDecimal(rowData, "bydtfwcsl").subtract(SolidWasteImportPlugin.parseBigDecimal(rowData, "bygtfwccl")).subtract(SolidWasteImportPlugin.parseBigDecimal(rowData, "bygtfwczl"));
    }

    private static BigDecimal getYnse(JSONObject rowData) {
        return SolidWasteImportPlugin.parseBigDecimal(rowData, "wrwpfl").multiply(SolidWasteImportPlugin.parseBigDecimal(rowData, "dwse"));
    }

    private static BigDecimal getJmse(JSONObject rowData) {
        return SolidWasteImportPlugin.parseBigDecimal(rowData, "bygtfwzhlyl").multiply(SolidWasteImportPlugin.parseBigDecimal(rowData, "dwse"));
    }

    private static BigDecimal getBqybtse(JSONObject rowData) {
        return SolidWasteImportPlugin.parseBigDecimal(rowData, "ynse").subtract(SolidWasteImportPlugin.parseBigDecimal(rowData, "jmse")).subtract(SolidWasteImportPlugin.parseBigDecimal(rowData, "bqyjse"));
    }

    private static BigDecimal getScale(BigDecimal decimal, int newScale) {
        return decimal.setScale(newScale, 4);
    }

    private DynamicObject getPollutionBaseData(JSONObject data) {
        QFilter filter = QFilter.of((String)"org.number=? and number=? and entryentity.wrwmc.number=?", (Object[])new Object[]{data.getJSONObject("org").getString("number"), data.getString("number"), data.getJSONObject("wrwmc").getString("number")});
        String selectPros = "id,org,number,pfksszgswjg.number as pfksszgswjgNumber,pfknum,name,entryentity.wrwlb.number as wrwlbNumber,entryentity.wrwmc,entryentity.wrwmc.number as wrwmcNumber,entryentity.zszm,startdate,enddate,enable";
        DynamicObjectCollection datas = QueryServiceHelper.query((String)TCRET_POLLUTION_BASEDATA, (String)selectPros, (QFilter[])new QFilter[]{filter});
        return CollectionUtils.isEmpty((Collection)datas) ? null : (DynamicObject)datas.get(0);
    }

    private Boolean getDynamicObjects(JSONObject data) {
        try {
            if (Objects.equals(this.ctx.getOption().get("importtype"), "override")) {
                return false;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        QFilter filter = QFilter.of((String)"org.number=? and number=? and wrwmc.number=? and wrwname=? and month=?", (Object[])new Object[]{data.getJSONObject("org").getString("number"), data.getString("number"), data.getJSONObject("wrwmc").getString("number"), data.getString("wrwname"), data.getDate("month")});
        return QueryServiceHelper.exists((String)TDM_SOLID_WASTE_INFO, (QFilter[])new QFilter[]{filter});
    }

    private static BigDecimal parseBigDecimal(JSONObject rowData, String key) {
        BigDecimal bigDecimal = rowData.getBigDecimal(key);
        return bigDecimal != null ? bigDecimal : BigDecimal.ZERO;
    }

    private static Date parseDate(ImportBillData importBillData, String key) {
        Date date = null;
        String columnName = SolidWasteImportPlugin.getColumnName(importBillData, key);
        try {
            date = importBillData.getData().getDate(key);
        }
        catch (Exception e) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"%s\u586b\u5199\u6709\u8bef", (String)"SolidWasteImportPlugin_12", (String)"taxc-tdm-formplugin", (Object[])new Object[0]), columnName));
        }
        return date;
    }

    private static String getColumnName(ImportBillData importBillData, String key) {
        return ((ImportEntityMapping.ColInfo)importBillData.getEntityMapping().getCols().get(key)).getDisplayName();
    }

    public static void validDate(StringBuilder errors, Date month) {
        LocalDate taxMonth = SolidWasteImportPlugin.date2LocalDate(month);
        if (!SolidWasteImportPlugin.isFirstOrLastDay("start", taxMonth)) {
            SolidWasteImportPlugin.sendFailMsg(errors, ResManager.loadKDString((String)"\u6240\u5c5e\u7a0e\u671f\u5fc5\u987b\u4e3a\u6708\u521d1\u53f7\u3002", (String)"SolidWasteImportPlugin_13", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
        }
    }

    public static boolean startBeforeEnd(LocalDate startdate, LocalDate enddate) {
        if (startdate == null || enddate == null) {
            return true;
        }
        return startdate.isBefore(enddate);
    }

    public static boolean isFirstOrLastDay(String flag, LocalDate date) {
        int dayOfMonth;
        boolean result = false;
        if (date == null) {
            return false;
        }
        if ("start".equals(flag)) {
            dayOfMonth = date.with(TemporalAdjusters.firstDayOfMonth()).getDayOfMonth();
            boolean bl = result = date.getDayOfMonth() == dayOfMonth;
        }
        if ("end".equals(flag)) {
            dayOfMonth = date.with(TemporalAdjusters.lastDayOfMonth()).getDayOfMonth();
            result = date.getDayOfMonth() == dayOfMonth;
        }
        return result;
    }

    public static LocalDate date2LocalDate(Date date) {
        if (date == null) {
            return null;
        }
        return date.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
    }

    private static Map<String, DynamicObject> getBizDef(String number) {
        Map<String, DynamicObject> result = new HashMap<String, DynamicObject>(16);
        QFilter filter = new QFilter("number", "=", (Object)number);
        DynamicObjectCollection custConst = QueryServiceHelper.query((String)"tpo_hbs_bizdef", (String)"entry_detail.subnumber as subnumber,entry_detail.value as value, entry_detail.projectname as projectname", (QFilter[])new QFilter[]{filter});
        if (CollectionUtils.isEmpty((Collection)custConst)) {
            return result;
        }
        result = custConst.stream().collect(Collectors.toMap(e -> e.getString("subnumber"), e -> e));
        return result;
    }

    private static void sendFailMsg(StringBuilder errors, String msg) {
        errors.append(msg).append(tabLine);
    }

    public static DynamicObject loadTaxMain(String orgNumber) {
        QFilter orgFilter = new QFilter("number", "=", (Object)orgNumber);
        DynamicObject taxMain = QueryServiceHelper.queryOne((String)"tctb_tax_main", (String)"id,orgid", (QFilter[])new QFilter[]{orgFilter});
        return taxMain;
    }

    private static void checkTp(StringBuilder errors, DynamicObject dynamicObject, Date month) {
        QFilter monthFilter;
        QFilter orgFilter = new QFilter("org", "=", (Object)dynamicObject.getLong("orgid"));
        DynamicObjectCollection airWaterTp = QueryServiceHelper.query((String)"tdm_solidwaste_info_tp", (String)"id", (QFilter[])new QFilter[]{orgFilter, monthFilter = new QFilter("month", "=", (Object)month)});
        if (airWaterTp != null && airWaterTp.size() > 0) {
            SolidWasteImportPlugin.sendFailMsg(errors, ResManager.loadKDString((String)"\u5f15\u5165\u6570\u636e\u7684\u7ec4\u7ec7\u5c5e\u671f\u5df2\u5b58\u5728\u6682\u5b58\u6570\u636e", (String)"SolidWasteImportPlugin_14", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
        }
    }

    private static String getBillNo() {
        DynamicObject object = BusinessDataServiceHelper.newDynamicObject((String)TDM_SOLID_WASTE_INFO);
        ICodeRuleService codeRuleService = (ICodeRuleService)ServiceFactory.getService(ICodeRuleService.class);
        return codeRuleService.getNumber(TDM_SOLID_WASTE_INFO, object, null);
    }
}

