/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tdm.formplugin.pollution;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.BeforeImportDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.tdm.common.license.ExtendAbstractBillPlugin;

public class WaterRegisterFormPlugin
extends ExtendAbstractBillPlugin
implements BeforeF7SelectListener {
    private static final String ORG = "org";
    private static final List<String> pops = Lists.newArrayList((Object[])new String[]{"qyshy", "tsyslb", "sysedc"});

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        if ("qsxkzt".equals(key)) {
            this.setEnableBt();
            Object qsxkzt = this.getModel().getValue("qsxkzt");
            if ("0".equals(qsxkzt)) {
                this.getModel().setValue("name", null);
                this.getModel().setValue("jhnqsl", null);
                this.getModel().setValue("qsxkbh", null);
                this.getModel().setValue("startdate", null);
                this.getModel().setValue("enddate", null);
                this.getModel().setValue("qslhdjg", null);
                this.getModel().deleteEntryData("entryentity");
            }
        }
        if ("cjhbbs2".equals(key)) {
            int count = this.getModel().getEntryRowCount("entryentity");
            this.getModel().beginInit();
            for (int i = 0; i < count; ++i) {
                if (i == 0) continue;
                this.getModel().setValue("cjhbbs1", this.getModel().getValue("cjhbbs2", i - 1), i);
            }
            this.getModel().endInit();
            this.getView().updateView("entryentity");
        }
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity1");
        int row = entryGrid.getEntryState().getFocusRow();
        if ("zszm".equals(key)) {
            this.getModel().setValue("lossrate", (Object)BigDecimal.ZERO, row);
        }
    }

    public void click(EventObject evt) {
        this.setEnableBt();
        int count = this.getModel().getEntryRowCount("entryentity");
        for (int i = 0; i < count; ++i) {
            if (i == 0) continue;
            this.getModel().setValue("cjhbbs1", this.getModel().getValue("cjhbbs2", i - 1), i);
        }
    }

    private void setEnableBt() {
        Object qsxuzt = this.getModel().getValue("qsxkzt");
        int count = this.getModel().getEntryRowCount("entryentity");
        if (Objects.equals("1", qsxuzt)) {
            if (count >= 5) {
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"addentry"});
            } else {
                this.getView().setEnable(Boolean.valueOf(true), new String[]{"addentry", "deleteentry"});
            }
        } else {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"addentry", "deleteentry"});
        }
        this.getView().setEnable(Boolean.valueOf(true), 0, new String[]{"cjhbbs1"});
        for (int i = 1; i < count; ++i) {
            this.getView().setEnable(Boolean.valueOf(false), i, new String[]{"cjhbbs1"});
        }
    }

    public void afterCreateNewData(EventObject e) {
        long orgId;
        List data;
        DynamicObject org = (DynamicObject)this.getModel().getValue(ORG);
        if (org != null && EmptyCheckUtils.isNotEmpty((Object)(data = (List)TaxcMainDataServiceHelper.queryTaxcMainSzysByOrgId(Collections.singletonList(orgId = org.getLong("id"))).getData()))) {
            DynamicObject taxMain = (DynamicObject)data.get(0);
            this.getModel().setValue("taxauthority", taxMain.get("taxoffice"));
            DynamicObjectCollection categoryentryentity = taxMain.getDynamicObjectCollection("categoryentryentity");
            if (EmptyCheckUtils.isNotEmpty((Object)categoryentryentity)) {
                this.getModel().setValue("jnqx", (Object)((DynamicObject)categoryentryentity.get(0)).getString("deadline"));
            }
        }
    }

    public void afterBindData(EventObject e) {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        this.setEnableBt();
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        if (status == OperationStatus.EDIT) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"sysbb"});
            if ("1".equals(dataEntity.get("qsxkzt"))) {
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"jhnqsl"});
            }
        }
    }

    public void beforeImportData(BeforeImportDataEventArgs args) {
        DynamicObject orgObject;
        Map sourceData = args.getSourceData();
        sourceData.put("wblqszjs", BigDecimal.ONE);
        JSONObject org = (JSONObject)sourceData.get(ORG);
        if (org != null && (orgObject = QueryServiceHelper.queryOne((String)"tctb_tax_main", (String)"orgid,taxoffice", (QFilter[])new QFilter[]{new QFilter("number", "=", org.get((Object)"number"))})) != null) {
            JSONObject taxoffice = new JSONObject();
            taxoffice.put("importprop", (Object)"id");
            taxoffice.put("id", orgObject.get("taxoffice"));
            sourceData.put("taxauthority", taxoffice);
            if (!TaxcMainDataServiceHelper.isTaxcMainByOrgId((Long)orgObject.getLong("orgid")).isSuccess()) {
                args.setCancel(true);
                args.setCancelMessages(Integer.valueOf(0), Integer.valueOf(0), Collections.singletonList(String.format(ResManager.loadKDString((String)"\u7a0e\u52a1\u7ec4\u7ec7\u672a\u5ba1\u6838\u6216\u4e0d\u53ef\u7528\uff0c\u65e0\u6cd5\u5f15\u5165\u6570\u636e\uff1a\u7f16\u7801%s", (String)"WaterRegisterFormPlugin_3", (String)"taxc-tdm-formplugin", (Object[])new Object[0]), org.get((Object)"number"))));
                return;
            }
        }
    }

    public void registerListener(EventObject e) {
        pops.forEach(s -> {
            BasedataEdit type = (BasedataEdit)this.getControl((String)s);
            type.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        });
        BasedataEdit zszm = (BasedataEdit)this.getControl("zszm");
        zszm.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        this.addClickListeners(new String[]{"addentry", "deleteentry"});
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String name = evt.getProperty().getName();
        DynamicObject org = (DynamicObject)this.getModel().getValue(ORG);
        if (org == null) {
            return;
        }
        String orgid = org.getString("id");
        if (pops.contains(name)) {
            ListShowParameter formShowParameter = (ListShowParameter)evt.getFormShowParameter();
            Date now = new Date();
            formShowParameter.setCustomParam("orgid", (Object)orgid);
            formShowParameter.getListFilterParameter().getQFilters().add(new QFilter("isleaf", "=", (Object)"1"));
            formShowParameter.getListFilterParameter().getQFilters().add(new QFilter("validfrom", "<=", (Object)now).or(new QFilter("validfrom", "is null", null)));
            formShowParameter.getListFilterParameter().getQFilters().add(new QFilter("expired", ">=", (Object)now).or(new QFilter("expired", "is null", null)));
            if ("qyshy".equals(name)) {
                formShowParameter.setCaption(ResManager.loadKDString((String)"\u53d6\u7528\u6c34\u884c\u4e1a", (String)"WaterRegisterFormPlugin_4", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
            } else if ("tsyslb".equals(name)) {
                formShowParameter.setCaption(ResManager.loadKDString((String)"\u7279\u6b8a\u7528\u6c34\u7c7b\u522b", (String)"WaterRegisterFormPlugin_5", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
            } else {
                formShowParameter.setCaption(ResManager.loadKDString((String)"\u9002\u7528\u7a0e\u989d\u7b49\u6b21", (String)"WaterRegisterFormPlugin_6", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
            }
        } else if ("zszm".equals(name)) {
            ListShowParameter formShowParameter = (ListShowParameter)evt.getFormShowParameter();
            formShowParameter.setCustomParam("menu", (Object)"watersource");
            formShowParameter.setCaption(ResManager.loadKDString((String)"\u5f81\u6536\u5b50\u76ee", (String)"WaterRegisterFormPlugin_7", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
        }
    }
}

