/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tdm.formplugin.qssy;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.BeforeImportDataEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Save;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.tdm.common.license.ExtendAbstractBillPlugin;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class QiShuiSYFormPlugin
extends ExtendAbstractBillPlugin
implements BeforeF7SelectListener {
    private static final String SYNUMBER = "synumber";
    private static final List<String> NEEDKEY = Lists.newArrayList((Object[])new String[]{"qszydxej", "qszydxsj", "qszyfs", "yongtu"});
    private static final Map<String, List<String>> MAPTOLIST = new HashMap<String, List<String>>();
    private static final Map<String, String> ZHONGWENTOEN = new HashMap<String, String>();

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        DynamicObject org;
        super.beforeDoOperation(args);
        if (args.getSource() instanceof Save && (org = (DynamicObject)this.getModel().getValue("org")) != null && !TaxcMainDataServiceHelper.isTaxcMainByOrgId((Long)org.getLong("id")).isSuccess()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7a0e\u52a1\u7ec4\u7ec7\u672a\u5ba1\u6838\u6216\u4e0d\u53ef\u7528\uff0c\u65e0\u6cd5\u6267\u884c\u5f53\u524d\u64cd\u4f5c\u3002", (String)"QiShuiSYFormPlugin_0", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
    }

    public void afterBindData(EventObject e) {
        this.setChooies((String)this.getModel().getValue("qszydxyj"));
    }

    private void setChooies(String qszydxyj) {
        for (String s : NEEDKEY) {
            ComboEdit comboEdit = (ComboEdit)this.getControl(s);
            ArrayList<ComboItem> items = new ArrayList<ComboItem>();
            List<String> strings = MAPTOLIST.get(qszydxyj + s);
            if (CollectionUtils.isNotEmpty(strings)) {
                for (String string : strings) {
                    items.add(new ComboItem(new LocaleString(ZHONGWENTOEN.get(string)), string));
                }
            }
            comboEdit.setComboItems(items);
        }
    }

    public void registerListener(EventObject e) {
        BasedataEdit type = (BasedataEdit)this.getControl(SYNUMBER);
        type.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String name = evt.getProperty().getName();
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (SYNUMBER.equals(name) && org != null) {
            Long orgid = org.getLong("id");
            ListShowParameter formShowParameter = (ListShowParameter)evt.getFormShowParameter();
            formShowParameter.getListFilterParameter().getQFilters().add(new QFilter("org", "=", (Object)orgid));
            String qszydxyj = (String)this.getModel().getValue("qszydxyj");
            if (Objects.equals(qszydxyj, "tdm_tds_basic_info")) {
                formShowParameter.setCaption(ResManager.loadKDString((String)"\u571f\u5730\u7f16\u7801\u8d44\u6599", (String)"QiShuiSYFormPlugin_19", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
            } else {
                formShowParameter.setCaption(ResManager.loadKDString((String)"\u623f\u4ea7\u7f16\u7801\u8d44\u6599", (String)"QiShuiSYFormPlugin_20", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        ChangeData changeData = e.getChangeSet()[0];
        if (SYNUMBER.equals(key)) {
            DynamicObject newValue = (DynamicObject)changeData.getNewValue();
            String qszydxyj = (String)this.getModel().getValue("qszydxyj");
            if (newValue != null) {
                DynamicObject object = BusinessDataServiceHelper.loadSingle((Object)newValue.getLong("id"), (String)qszydxyj);
                this.getModel().setValue("detailaddr", object.get("detailaddr"));
                this.getModel().setValue("taxoffice", object.get("taxauthority"));
                this.getModel().setValue("number", object.get("number"));
            } else {
                this.getModel().setValue("number", (Object)"");
            }
        }
        if ("qszydxyj".equals(key)) {
            this.setChooies((String)changeData.getNewValue());
            this.getModel().setValue(SYNUMBER, null);
            this.getModel().setValue("detailaddr", null);
            this.getModel().setValue("taxoffice", null);
            this.getModel().setValue("qszydxej", null);
            this.getModel().setValue("qszydxsj", null);
            this.getModel().setValue("qszyfs", null);
            this.getModel().setValue("yongtu", null);
        }
    }

    public void beforeImportData(BeforeImportDataEventArgs args) {
        Map sourceData = args.getSourceData();
        String qszydxyj = (String)sourceData.get("qszydxyj");
        if (EmptyCheckUtils.isEmpty((Object)qszydxyj)) {
            return;
        }
        JSONObject synumber = (JSONObject)sourceData.get(SYNUMBER);
        if (synumber == null) {
            return;
        }
        QFilter qFilter = new QFilter("number", "=", (Object)synumber.getString("number"));
        DynamicObject object = QueryServiceHelper.queryOne((String)qszydxyj, (String)"taxauthority,detailaddr", (QFilter[])new QFilter[]{qFilter});
        if (object == null) {
            return;
        }
        sourceData.put("detailaddr", object.getString("detailaddr"));
        JSONObject taxoffice = new JSONObject();
        taxoffice.put("importprop", (Object)"id");
        taxoffice.put("id", object.get("taxauthority"));
        sourceData.put("taxoffice", taxoffice);
        sourceData.put("startdate", sourceData.get("htqdrq"));
        sourceData.put("enddate", sourceData.get("htqdrq"));
        sourceData.put("gyfs", "ddsy");
        JSONObject org = (JSONObject)sourceData.get("org");
        if (org != null && StringUtils.isNotEmpty((CharSequence)org.getString("number")) && !TaxcMainDataServiceHelper.isTaxcMainByOrgNum((String)org.getString("number")).isSuccess()) {
            args.setCancel(true);
            args.setCancelMessages(Integer.valueOf(0), Integer.valueOf(0), Collections.singletonList(String.format(ResManager.loadKDString((String)"\u7a0e\u52a1\u7ec4\u7ec7\u672a\u5ba1\u6838\u6216\u4e0d\u53ef\u7528\uff0c\u65e0\u6cd5\u5f15\u5165\u6570\u636e\uff1a\u7f16\u7801%s", (String)"QiShuiSYFormPlugin_21", (String)"taxc-tdm-formplugin", (Object[])new Object[0]), org.get((Object)"number"))));
            return;
        }
    }

    static {
        MAPTOLIST.put("tdm_tds_basic_infoqszydxej", Lists.newArrayList((Object[])new String[]{"gytd", "jttd"}));
        MAPTOLIST.put("tdm_tds_basic_infoqszydxsj", Lists.newArrayList((Object[])new String[]{"wu"}));
        MAPTOLIST.put("tdm_tds_basic_infoqszyfs", Lists.newArrayList((Object[])new String[]{"tucr", "tdcs", "tdzu", "tdhh"}));
        MAPTOLIST.put("tdm_tds_basic_infoyongtu", Lists.newArrayList((Object[])new String[]{"zzyd", "fzzyd"}));
        MAPTOLIST.put("tdm_fcs_basic_infoqszydxej", Lists.newArrayList((Object[])new String[]{"zlf", "clf"}));
        MAPTOLIST.put("tdm_fcs_basic_infoqszydxsj", Lists.newArrayList((Object[])new String[]{"zf", "fzf"}));
        MAPTOLIST.put("tdm_fcs_basic_infoqszyfs", Lists.newArrayList((Object[])new String[]{"fwmm", "fwzy", "fwhh"}));
        MAPTOLIST.put("tdm_fcs_basic_infoyongtu", Lists.newArrayList((Object[])new String[]{"jzyf", "fjzyf"}));
        ZHONGWENTOEN.put("gytd", ResManager.loadKDString((String)"\u56fd\u6709\u571f\u5730", (String)"QiShuiSYFormPlugin_1", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
        ZHONGWENTOEN.put("jttd", ResManager.loadKDString((String)"\u96c6\u4f53\u571f\u5730", (String)"QiShuiSYFormPlugin_2", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
        ZHONGWENTOEN.put("zlf", ResManager.loadKDString((String)"\u589e\u91cf\u623f", (String)"QiShuiSYFormPlugin_3", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
        ZHONGWENTOEN.put("clf", ResManager.loadKDString((String)"\u5b58\u91cf\u623f", (String)"QiShuiSYFormPlugin_4", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
        ZHONGWENTOEN.put("wu", ResManager.loadKDString((String)"\u65e0", (String)"QiShuiSYFormPlugin_5", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
        ZHONGWENTOEN.put("zf", ResManager.loadKDString((String)"\u4f4f\u623f", (String)"QiShuiSYFormPlugin_6", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
        ZHONGWENTOEN.put("fzf", ResManager.loadKDString((String)"\u975e\u4f4f\u623f", (String)"QiShuiSYFormPlugin_7", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
        ZHONGWENTOEN.put("tucr", ResManager.loadKDString((String)"\u571f\u5730\u4f7f\u7528\u6743\u51fa\u8ba9", (String)"QiShuiSYFormPlugin_8", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
        ZHONGWENTOEN.put("tdcs", ResManager.loadKDString((String)"\u571f\u5730\u4f7f\u7528\u6743\u51fa\u552e(\u5305\u62ec\u4f5c\u4ef7\u6295\u8d44\u5165\u80a1\u3001\u507f\u8fd8\u503a\u52a1\u7b49\u5e94\u4ea4\u4ed8\u7ecf\u6d4e\u5229\u76ca\u7684\u65b9\u5f0f)", (String)"QiShuiSYFormPlugin_9", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
        ZHONGWENTOEN.put("tdzu", ResManager.loadKDString((String)"\u571f\u5730\u4f7f\u7528\u6743\u8d60\u4e0e(\u5305\u62ec\u4ee5\u5212\u8f6c\u3001\u5956\u52b1\u3001\u7ee7\u627f\u7b49\u6ca1\u6709\u4ef7\u683c\u7684\u65b9\u5f0f)", (String)"QiShuiSYFormPlugin_10", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
        ZHONGWENTOEN.put("tdhh", ResManager.loadKDString((String)"\u571f\u5730\u4f7f\u7528\u6743\u4e92\u6362", (String)"QiShuiSYFormPlugin_11", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
        ZHONGWENTOEN.put("fwmm", ResManager.loadKDString((String)"\u623f\u5c4b\u4e70\u5356(\u5305\u62ec\u4f5c\u4ef7\u6295\u8d44\u5165\u80a1\u3001\u507f\u8fd8\u503a\u52a1\u7b49\u5e94\u4ea4\u4ed8\u7ecf\u6d4e\u5229\u76ca\u7684\u65b9\u5f0f)", (String)"QiShuiSYFormPlugin_12", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
        ZHONGWENTOEN.put("fwzy", ResManager.loadKDString((String)"\u623f\u5c4b\u8d60\u4e0e(\u5305\u62ec\u4ee5\u5212\u8f6c\u3001\u5956\u52b1\u3001\u7ee7\u627f\u7b49\u6ca1\u6709\u4ef7\u683c\u7684\u65b9\u5f0f)", (String)"QiShuiSYFormPlugin_13", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
        ZHONGWENTOEN.put("fwhh", ResManager.loadKDString((String)"\u623f\u5c4b\u4e92\u6362", (String)"QiShuiSYFormPlugin_14", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
        ZHONGWENTOEN.put("zzyd", ResManager.loadKDString((String)"\u4f4f\u5b85\u7528\u5730", (String)"QiShuiSYFormPlugin_15", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
        ZHONGWENTOEN.put("fzzyd", ResManager.loadKDString((String)"\u975e\u4f4f\u5b85\u7528\u5730", (String)"QiShuiSYFormPlugin_16", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
        ZHONGWENTOEN.put("jzyf", ResManager.loadKDString((String)"\u5c45\u4f4f\u7528\u623f", (String)"QiShuiSYFormPlugin_17", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
        ZHONGWENTOEN.put("fjzyf", ResManager.loadKDString((String)"\u975e\u5c45\u4f4f\u7528\u623f", (String)"QiShuiSYFormPlugin_18", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
    }
}

