/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tdm.formplugin.realestateRevCost;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.filter.ControlFilter;
import kd.bos.entity.operate.Delete;
import kd.bos.entity.operate.Donothing;
import kd.bos.entity.operate.StatusConvert;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ActiveViewListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RefreshNodeEvent;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.New;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.list.events.BuildTreeListFilterEvent;
import kd.bos.list.plugin.StandardTreeListPlugin;
import kd.bos.mvc.list.TreeListModel;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.taxc.tdm.business.realestateRevCost.CostItemBusiness;
import kd.taxc.tdm.common.helper.OrgCheckServiceHelper;
import kd.taxc.tdm.common.util.PermissionUtils;
import kd.taxc.tdm.formplugin.utils.TreeUtils;

public class CostItemListPlugin
extends StandardTreeListPlugin
implements TreeNodeClickListener {
    private static final String TOOLBARAP = "toolbarap";
    public static String TREE = "treeview";
    public static String ENTITY_NAME = "tdm_costitem";
    public static String BTN_COPYTO = "copyto";

    public void initialize() {
        this.presetCostItemData();
    }

    private void presetCostItemData() {
        CostItemBusiness.presetCostItemData();
    }

    public void registerListener(EventObject e) {
        BillList billList = (BillList)this.getView().getControl("billlistap");
        if (billList != null) {
            billList.addActiveViewListener((ActiveViewListener)this);
        }
        this.addItemClickListeners(new String[]{TOOLBARAP});
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        List commonFilterColumns = args.getCommonFilterColumns();
        for (FilterColumn column : commonFilterColumns) {
            if (!column.getFieldName().startsWith("org.")) continue;
            CommonFilterColumn typeColumn = (CommonFilterColumn)column;
            String defaultOrgId = this.getDefaultOrgId();
            typeColumn.setDefaultValue(defaultOrgId);
            this.filterTreeNode(defaultOrgId);
        }
    }

    public void filterContainerAfterSearchClick(FilterContainerSearchClickArgs args) {
        this.filterTreeNode(null);
    }

    private String getDefaultOrgId() {
        HasPermOrgResult hasPermOrgs = PermissionUtils.getAllPermOrgs((IFormView)this.getView());
        DynamicObjectCollection col = TreeUtils.queryOrgListHasPermission(hasPermOrgs, true);
        Long orgId = OrgCheckServiceHelper.setDefaultOrg((IFormView)this.getView(), (Long)RequestContext.get().getOrgId(), (DynamicObjectCollection)col);
        return orgId != null ? String.valueOf(orgId) : "0";
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        Object source = args.getSource();
        if (source instanceof New) {
            List selectedNodes = this.getTreeListView().getTreeView().getTreeState().getSelectedNodes();
            if (selectedNodes == null || selectedNodes.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6210\u672c\u9879\u76ee\u8282\u70b9\u3002", (String)"CostItemListPlugin_0", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            HashMap node = (HashMap)selectedNodes.get(0);
            if (StringUtils.isEmpty((CharSequence)((String)node.get("parentid")))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6210\u672c\u9879\u76ee\u8282\u70b9\u3002", (String)"CostItemListPlugin_0", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
        } else if (source instanceof Delete || source instanceof StatusConvert) {
            ListSelectedRowCollection selectedData = args.getListSelectedData();
            Object[] primaryKeyValues = selectedData.getPrimaryKeyValues();
            ArrayList<Long> longList = new ArrayList<Long>();
            if (primaryKeyValues != null && primaryKeyValues.length > 0) {
                for (Object object : primaryKeyValues) {
                    longList.add((Long)object);
                }
            }
            if (!longList.isEmpty()) {
                ArrayList<QFilter> filters = new ArrayList<QFilter>();
                filters.add(new QFilter("org", "=", (Object)Long.valueOf(this.getOrgId())));
                filters.add(new QFilter("id", "in", longList));
                DynamicObject[] costItems = CostItemBusiness.queryCostItemsByFilter(filters, (String)"id");
                if (costItems == null || costItems.length == 0) {
                    args.setListSelectedData(new ListSelectedRowCollection());
                } else {
                    HashSet<Long> currentOrgDataIds = new HashSet<Long>(costItems.length);
                    for (DynamicObject costItem : costItems) {
                        currentOrgDataIds.add(costItem.getLong("id"));
                    }
                    List list = selectedData.stream().filter(listSelectedRow -> currentOrgDataIds.contains(listSelectedRow.getPrimaryKeyValue())).collect(Collectors.toList());
                    ListSelectedRowCollection newSelectedRowCellection = new ListSelectedRowCollection();
                    newSelectedRowCellection.addAll(list);
                    args.setListSelectedData(newSelectedRowCellection);
                }
            }
        } else if (source instanceof Donothing && BTN_COPYTO.equals(operateKey = ((Donothing)source).getOperateKey())) {
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, BTN_COPYTO);
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("tdm_costitem_selectorg");
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.setCloseCallBack(closeCallBack);
            showParameter.setCustomParam("srcOrgId", (Object)this.getOrgId());
            this.getView().showForm(showParameter);
        }
    }

    public void itemClick(ItemClickEvent evt) {
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        Map returnData;
        if (BTN_COPYTO.equals(event.getActionId()) && event.getReturnData() != null && (returnData = (Map)event.getReturnData()).containsKey("didCopyTo") && returnData.containsKey("isSuccess") && ((Boolean)returnData.get("isSuccess")).booleanValue()) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5206\u914d\u6210\u529f\u3002", (String)"CostItemListPlugin_1", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
        }
    }

    public String getOrgId() {
        String currentOrgId = String.valueOf(RequestContext.get().getOrgId());
        if (this.getControlFilters() != null && this.getControlFilters().getFilters().get("org.id") != null) {
            currentOrgId = (String)((ControlFilter)this.getControlFilters().getFilters().get("org.id")).getValue().get(0);
        }
        return currentOrgId;
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        BillShowParameter billShowParameter = e.getParameter();
        OpenStyle style = new OpenStyle();
        style.setShowType(ShowType.Modal);
        billShowParameter.setOpenStyle(style);
        if (StringUtils.isNotEmpty((CharSequence)this.getOrgId())) {
            e.getParameter().getShowParameter().getCustomParams().put("tdm_costitem_orgid", this.getOrgId());
        }
    }

    public void refreshNode(RefreshNodeEvent e) {
        TreeListModel treeModel = (TreeListModel)this.getTreeModel();
        String currentOrgId = this.getOrgId();
        Object custome_filter = this.getView().getFormShowParameter().getCustomParam("custom_filter");
        if (!"1".equals(custome_filter)) {
            treeModel.getTreeFilter().clear();
            treeModel.getTreeFilter().add(new QFilter("org.id", "in", (Object)Long.valueOf(currentOrgId)));
        }
        treeModel.getQueryParas().put("order", "number asc");
    }

    public void buildTreeListFilter(BuildTreeListFilterEvent e) {
        super.buildTreeListFilter(e);
    }

    public void setFilter(SetFilterEvent e) {
        if (!this.isF7Page()) {
            e.getQFilters();
            String orgId = this.getOrgId();
            e.getQFilters().add(new QFilter("org", "=", (Object)Long.valueOf(orgId)));
        }
    }

    private boolean isF7Page() {
        ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        String formId = listShowParameter.getFormId();
        return formId.contains("f7");
    }

    public void filterTreeNode(String orgId) {
        String currentOrgId = this.getOrgId();
        if (StringUtils.isNotEmpty((CharSequence)orgId)) {
            currentOrgId = orgId;
        }
        if (StringUtils.isNotEmpty((CharSequence)currentOrgId)) {
            this.getTreeModel().getTreeFilter().clear();
            this.getTreeModel().getTreeFilter().add(new QFilter("org.id", "in", (Object)Long.valueOf(currentOrgId)));
            this.getTreeListView().focusRootNode();
            this.getTreeListView().refresh();
        }
    }

    public void search(SearchEnterEvent evt) {
    }
}

