/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tdm.formplugin.realestateRevCost;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.taxc.tdm.common.util.EmptyCheckUtils;
import kd.taxc.tdm.common.util.PermissionUtils;

public class CostItemSelectOrgPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final String BTN_OK = "btnok";
    private static final String BTN_CANCEL = "btncancel";
    private static final String F7_ORGFIELD = "orgfield";
    private static final String OPERATEPANEL = "operatepanel";

    public void initialize() {
    }

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{BTN_OK, BTN_CANCEL});
        BasedataEdit org = (BasedataEdit)this.getControl(F7_ORGFIELD);
        org.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if (BTN_OK.equalsIgnoreCase(key)) {
            this.doCopyTo();
        } else if (BTN_CANCEL.equalsIgnoreCase(key)) {
            this.getView().close();
        }
    }

    private void doCopyTo() {
        StringBuilder sb;
        OperateOption option;
        HashMap<String, Boolean> returnData = new HashMap<String, Boolean>();
        MulBasedataDynamicObjectCollection selectOrgDatas = (MulBasedataDynamicObjectCollection)this.getModel().getValue(F7_ORGFIELD);
        if (selectOrgDatas != null && !selectOrgDatas.isEmpty()) {
            List<Object> orgIdList = new ArrayList();
            orgIdList = selectOrgDatas.stream().map(orgdata -> {
                DynamicObject org = (DynamicObject)orgdata.get("fbasedataid");
                return org.getLong("id");
            }).collect(Collectors.toList());
            String srcOrgId = (String)this.getView().getFormShowParameter().getCustomParam("srcOrgId");
            option = OperateOption.create();
            option.setVariableValue("srcOrgId", srcOrgId);
            sb = new StringBuilder();
            for (int i = 0; i < orgIdList.size(); ++i) {
                if (i == 0) {
                    sb.append(orgIdList.get(i));
                    continue;
                }
                sb.append(",").append(orgIdList.get(i));
            }
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7ec4\u7ec7\u3002", (String)"CostItemSelectOrgPlugin_0", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
            return;
        }
        option.setVariableValue("destOrgId", sb.toString());
        OperationResult result = this.getView().invokeOperation("costitemcopyto", option);
        returnData.put("isSuccess", result.isSuccess());
        returnData.put("didCopyTo", true);
        this.getView().returnDataToParent(returnData);
        this.getView().close();
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        if (event.getProperty().getName().equals(F7_ORGFIELD)) {
            ListShowParameter formShowParameter = (ListShowParameter)event.getFormShowParameter();
            HasPermOrgResult hasPermOrgResult = PermissionUtils.getAllPermOrgs((IFormView)this.getView().getParentView(), (String)"47156aff000000ac");
            if (EmptyCheckUtils.isNotEmpty((Object)hasPermOrgResult) && !hasPermOrgResult.hasAllOrgPerm()) {
                List orgList = hasPermOrgResult.getHasPermOrgs();
                orgList.add(12345678L);
                QFilter idsFilter = new QFilter("id", "in", (Object)orgList);
                QFilter statusFilter = new QFilter("enable", "=", (Object)"1");
                formShowParameter.getListFilterParameter().setFilter(idsFilter.and(statusFilter));
            }
        }
    }
}

