/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tdm.formplugin.realestateRevCost;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.control.Control;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.TreeNodeCheckEvent;
import kd.bos.form.control.events.TreeNodeCheckListener;
import kd.bos.orm.query.QFilter;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.taxc.bdtaxr.common.plugin.AbstractTreePlugin;
import kd.taxc.bdtaxr.common.util.tree.TreeUtils;
import kd.taxc.tdm.business.realestateRevCost.CostItemBusiness;

public class CostItemSelectPlugin
extends AbstractTreePlugin {
    private static final String BTN_SUBMIT = "submit";
    private static final String TREE_LEFT = "tree_left";
    private static final String TREE_RIGHT = "tree_right";
    private static final String CHECKALL = "checkall";
    private static final String LEFT_ALLNODES_IDLIST = "LEFT_ALLNODES_IDLIST";

    public void initialize() {
        TreeView leftTreeView = (TreeView)this.getView().getControl(TREE_LEFT);
        leftTreeView.addTreeNodeCheckListener((TreeNodeCheckListener)this);
    }

    public void registerListener(EventObject e) {
        super.addEnterListener(new String[]{TREE_LEFT});
        this.addClickListeners(new String[]{BTN_SUBMIT});
    }

    public void afterCreateNewData(EventObject e) {
        this.loadLeftTree();
        this.loadRightTree();
    }

    public void loadLeftTree() {
        TreeNode leftRoot = this.setRootNode(TREE_LEFT);
        DynamicObject[] costItemObjects = null;
        Long orgid = null;
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (customParams.get("org") != null) {
            JSONObject org = (JSONObject)customParams.get("org");
            orgid = org.getLong("id");
        }
        if (orgid == null) {
            return;
        }
        QFilter orgFilter = new QFilter("org.id", "=", orgid);
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        DynamicObject[] filterList = new ArrayList();
        filterList.add(orgFilter);
        filterList.add(enableFilter);
        costItemObjects = CostItemBusiness.queryCostItemsByFilter(filterList, (String)"id,number,name,parent");
        if (costItemObjects == null || costItemObjects.length == 0) {
            return;
        }
        ArrayList<TreeNode> nodeList = new ArrayList<TreeNode>(costItemObjects.length + 1);
        ArrayList<String> nodeIdList = new ArrayList<String>(costItemObjects.length + 1);
        for (DynamicObject obj : costItemObjects) {
            TreeNode leftNode = new TreeNode();
            String id = obj.getString("id");
            String name = obj.getString("name");
            DynamicObject parentNode = obj.getDynamicObject("parent");
            if (parentNode != null) {
                leftNode.setParentid(parentNode.getString("id"));
            } else {
                leftNode.setParentid("-1");
            }
            leftNode.setId(id);
            leftNode.setText(name);
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("costitemname", name);
            data.put("costitemnumber", obj.getString("number"));
            leftNode.setData(data);
            nodeList.add(leftNode);
            nodeIdList.add(id);
        }
        nodeList.add(leftRoot);
        this.bind(TREE_LEFT, nodeList);
        TreeUtils.expandAll((TreeView)((TreeView)this.getView().getControl(TREE_LEFT)), (TreeNode)this.getRoot(TREE_LEFT));
        nodeIdList.add("-1");
        this.getPageCache().put(LEFT_ALLNODES_IDLIST, JSONObject.toJSONString(nodeIdList));
        if (customParams.containsKey("listNode")) {
            ArrayList<TreeNode> oldCheckedNodes = new ArrayList<TreeNode>();
            JSONArray oldCostItemJSONArray = (JSONArray)customParams.get("listNode");
            if (oldCostItemJSONArray == null || oldCostItemJSONArray.isEmpty()) {
                return;
            }
            for (Object oldCostItemJson : oldCostItemJSONArray) {
                oldCheckedNodes.add(this.getNode(TREE_LEFT, ((JSONObject)oldCostItemJson).getString("costitemid")));
            }
            if (!oldCheckedNodes.isEmpty()) {
                TreeView leftTree = (TreeView)this.getView().getControl(TREE_LEFT);
                oldCheckedNodes.add(this.getRoot(TREE_LEFT));
                leftTree.checkNodes(oldCheckedNodes);
            }
        }
    }

    public void loadRightTree() {
        TreeNode root = this.setRootNode(TREE_RIGHT);
        ArrayList<TreeNode> listNode = new ArrayList<TreeNode>();
        listNode.add(root);
        this.bind(TREE_RIGHT, listNode);
        this.refreshRightTree();
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if (key.startsWith("searchbefore_") || key.startsWith("searchnext_")) {
            super.click(evt);
        }
        if (BTN_SUBMIT.equals(key)) {
            TreeView leftTree = (TreeView)this.getView().getControl(TREE_LEFT);
            List checkedNodeIds = leftTree.getTreeState().getCheckedNodeIds();
            if (checkedNodeIds == null || checkedNodeIds.size() <= 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6210\u672c\u9879\u76ee\u3002", (String)"CostItemSelectPlugin_1", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
                return;
            }
            this.getView().returnDataToParent((Object)checkedNodeIds);
            this.getView().close();
        }
    }

    public void treeNodeCheck(TreeNodeCheckEvent event) {
        TreeView leftTree = (TreeView)this.getView().getControl(TREE_LEFT);
        if (event.getChecked().booleanValue()) {
            if (StringUtils.isEmpty((String)((String)event.getParentNodeId()))) {
                return;
            }
            String parentNodeId = (String)event.getParentNodeId();
            ArrayList<TreeNode> parentNodes = new ArrayList<TreeNode>();
            while (StringUtils.isNotEmpty((String)parentNodeId)) {
                TreeNode parentNode = this.getNode(TREE_LEFT, parentNodeId);
                if (parentNode != null) {
                    parentNodes.add(parentNode);
                    parentNodeId = parentNode.getParentid();
                    continue;
                }
                parentNodeId = "";
            }
            if (!parentNodes.isEmpty()) {
                leftTree.checkNodes(parentNodes);
            }
        } else {
            String currentNodeId = (String)event.getNodeId();
            if (StringUtils.isEmpty((String)currentNodeId)) {
                return;
            }
            ArrayList<String> nodeList = new ArrayList<String>();
            nodeList.add(currentNodeId);
            leftTree.uncheckNodes(nodeList);
        }
        this.refreshRightTree();
    }

    protected void refreshRightTree() {
        TreeView leftTree = (TreeView)this.getView().getControl(TREE_LEFT);
        TreeView rightTree = (TreeView)this.getView().getControl(TREE_RIGHT);
        rightTree.deleteAllNodes();
        List leftCheckedIds = leftTree.getTreeState().getCheckedNodeIds();
        List<Object> leftCheckedNodes = new ArrayList();
        Map leftCheckNodedMap = leftCheckedIds.stream().collect(Collectors.toMap(Function.identity(), leftId -> this.getNode(TREE_LEFT, (String)leftId)));
        if (leftCheckedIds != null && !leftCheckedIds.isEmpty()) {
            for (String leftId2 : leftCheckedIds) {
                TreeNode leftNode;
                if ("-1".equals(leftId2) || (leftNode = leftCheckNodedMap.get(leftId2)) == null || !StringUtils.isNotEmpty((String)leftNode.getParentid()) || !leftCheckNodedMap.containsKey(leftNode.getParentid())) continue;
                leftCheckNodedMap.get(leftNode.getParentid()).addChild(leftNode);
            }
        }
        leftCheckNodedMap.values().forEach(node -> {
            List nodeList = node.getChildren();
            if (nodeList != null) {
                nodeList.sort(Comparator.comparing(childNode -> ((JSONObject)childNode.getData()).getString("costitemnumber")));
                node.setChildren(nodeList);
            }
        });
        leftCheckedNodes = leftCheckNodedMap.entrySet().stream().map(entry -> (TreeNode)entry.getValue()).collect(Collectors.toList());
        rightTree.addNodes(leftCheckedNodes);
        TreeNode rightRoot = leftCheckNodedMap.get("-1");
        TreeUtils.expandAll((TreeView)((TreeView)this.getView().getControl(TREE_RIGHT)), (TreeNode)rightRoot);
    }

    public TreeNode setRootNode(String treeName) {
        TreeNode rootRight = new TreeNode();
        rootRight.setId("-1");
        rootRight.setText(ResManager.loadKDString((String)"\u6210\u672c\u9879\u76ee", (String)"CostItemSelectPlugin_0", (String)"taxc-tdm-formplugin", (Object[])new Object[0]));
        rootRight.setParentid("");
        this.setRoot(treeName, rootRight);
        return rootRight;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if (CHECKALL.equals(e.getProperty().getName())) {
            String leftAllNodesId = this.getPageCache().get(LEFT_ALLNODES_IDLIST);
            List leftAllNodeIdList = (List)JSONObject.parseObject((String)leftAllNodesId, List.class);
            TreeView leftTree = (TreeView)this.getView().getControl(TREE_LEFT);
            if (CollectionUtils.isNotEmpty((Collection)leftAllNodeIdList)) {
                if (null == e.getChangeSet()[0].getNewValue() || !((Boolean)e.getChangeSet()[0].getNewValue()).booleanValue()) {
                    leftTree.uncheckNodes(leftAllNodeIdList);
                } else if (((Boolean)e.getChangeSet()[0].getNewValue()).booleanValue()) {
                    List<Object> leftAllNodesList = new ArrayList();
                    leftAllNodesList = leftAllNodeIdList.stream().map(id -> this.getNode(TREE_LEFT, (String)id)).collect(Collectors.toList());
                    leftTree.checkNodes(leftAllNodesList);
                }
                this.refreshRightTree();
            }
        }
    }
}

